/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.ui.controls.nativewindow;

import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.andmore.android.AndroidPlugin;
import org.eclipse.andmore.android.DDMSFacade;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.preferences.DialogWithToggleUtils;
import org.eclipse.andmore.android.emulator.core.model.IAndroidEmulatorInstance;
import org.eclipse.andmore.android.emulator.core.model.IInputLogic;
import org.eclipse.andmore.android.emulator.core.skin.IAndroidSkin;
import org.eclipse.andmore.android.emulator.core.utils.TelnetAndroidInput;
import org.eclipse.andmore.android.emulator.i18n.EmulatorNLS;
import org.eclipse.andmore.android.emulator.logic.AndroidLogicUtils;
import org.eclipse.andmore.android.emulator.ui.controls.IAndroidComposite;
import org.eclipse.andmore.android.nativeos.NativeUIUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class NativeWindowComposite
extends ScrolledComposite
implements IAndroidComposite {
    private static String LOOSE_ORIGINAL_SCALE_KEY_PREFERENCE = "loose.original.scale";
    private static final double MINIMUM_ZOOM_FACTOR = 0.1;
    private static final double ZOOM_FIT = 0.0;
    private Composite contentComposite;
    private IAndroidEmulatorInstance androidInstance;
    private long windowHandle;
    private long originalParentHandle;
    private long windowProperties;
    private Point windowSize;
    private Point nativeWindowSize;
    private NativeWindowMonitor nativeWindowMonitor;
    protected boolean resizing;
    private boolean isFitToWindow;
    private double zoomFactor = 0.99;
    private double fitZoomFactor = 0.0;
    private boolean forceNativeWindowSizeUpdate;
    private boolean isOriginalScale;
    private boolean zoomLocked;

    public NativeWindowComposite(Composite parent, IAndroidSkin androidSkin, IAndroidEmulatorInstance instance) {
        super(parent, 2816);
        AndmoreLogger.info((String)("Creating Native Window Composite for " + instance.getName()));
        this.getVerticalBar().setEnabled(true);
        this.getHorizontalBar().setEnabled(true);
        this.setLayout((Layout)new FillLayout());
        this.androidInstance = instance;
        this.nativeWindowMonitor = new NativeWindowMonitor(500L);
        this.addControlListener((ControlListener)new ControlAdapter(){
            final boolean[] running = new boolean[1];

            public void controlResized(ControlEvent event) {
                if (NativeWindowComposite.this.isFitToWindow) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                    if (this.running[0]) {
                        return;
                    }
                    this.running[0] = true;
                    Display.getCurrent().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            running[0] = false;
                            if (!NativeWindowComposite.this.getShell().isDisposed()) {
                                NativeWindowComposite.this.calculateFitZoomFactor(NativeWindowComposite.this.forceNativeWindowSizeUpdate);
                                NativeWindowComposite.this.applyZoomFactor();
                            }
                        }
                    });
                }
            }
        });
        this.createContentComposite(instance);
        AndmoreLogger.info((String)("Created Native Window Composite for " + instance.getName()));
    }

    public void createContentComposite(IAndroidEmulatorInstance instance) {
        this.contentComposite = instance.getComposite();
        if (this.contentComposite != null) {
            AndmoreLogger.info((String)"Instance already has a composite");
            this.contentComposite.setParent((Composite)this);
            this.contentComposite.setVisible(true);
        } else {
            this.contentComposite = new Composite((Composite)this, 0x1040000);
        }
        this.setContent((Control)this.contentComposite);
        if (instance.getProperties().getProperty("Command_Line").contains("-scale")) {
            this.isOriginalScale = true;
        }
        this.forceNativeWindowSizeUpdate = true;
        this.zoomLocked = true;
        this.draw();
    }

    private void draw() {
        if (this.contentComposite != null) {
            this.windowHandle = this.androidInstance.getWindowHandle();
            if (this.windowHandle <= 0L) {
                int port = AndroidLogicUtils.getEmulatorPort(DDMSFacade.getSerialNumberByName((String)this.androidInstance.getName()));
                this.windowHandle = NativeUIUtils.getWindowHandle((String)this.androidInstance.getName(), (int)port);
                this.androidInstance.setWindowHandle(this.windowHandle);
            }
            if (this.windowProperties <= 0L && this.windowHandle > 0L) {
                this.windowProperties = NativeUIUtils.getWindowProperties((long)this.windowHandle);
                AndmoreLogger.info((String)("Native Window Properties:" + this.windowProperties));
            }
            if (this.windowHandle > 0L) {
                NativeUIUtils.setWindowStyle((long)this.windowHandle);
            }
            if (this.originalParentHandle <= 0L) {
                this.originalParentHandle = this.windowHandle;
            }
            if (this.windowHandle > 0L) {
                this.windowSize = NativeUIUtils.getWindowSize((long)this.originalParentHandle, (long)this.windowHandle);
            }
            if (this.originalParentHandle <= 0L || this.originalParentHandle == this.windowHandle) {
                if (this.windowHandle > 0L) {
                    this.originalParentHandle = NativeUIUtils.embedWindow((long)this.windowHandle, (Composite)this.contentComposite);
                    AndmoreLogger.info((String)("Native Window Parent:" + this.originalParentHandle));
                }
            } else {
                NativeUIUtils.embedWindow((long)this.windowHandle, (Composite)this.contentComposite);
            }
            if (this.windowSize == null) {
                this.windowSize = new Point(700, 500);
            }
            this.contentComposite.setSize(this.contentComposite.computeSize(this.windowSize.x, this.windowSize.y, true));
            this.contentComposite.redraw();
            this.update();
            this.setMinSize(this.contentComposite.computeSize(this.windowSize.x, this.windowSize.y));
            this.layout();
        } else {
            this.createContentComposite(this.androidInstance);
        }
    }

    public void changeToNextLayout() {
        this.contentComposite.setVisible(false);
        this.contentComposite.setLocation(0, 0);
        NativeUIUtils.sendNextLayoutCommand((long)this.originalParentHandle, (long)this.windowHandle);
        this.updateContentComposite();
        this.forceNativeWindowSizeUpdate = true;
        if (this.isFitToWindow) {
            this.setZoomFactor(0.0);
        }
        this.applyZoomFactor();
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {}
        this.contentComposite.setVisible(true);
    }

    public void dispose() {
        AndmoreLogger.info((String)"Disposing Native Window Composite");
        if (this.nativeWindowMonitor != null) {
            this.nativeWindowMonitor.stopMonitoring();
            this.nativeWindowMonitor = null;
            AndmoreLogger.info((String)"Disposed Native Window Monitor");
        }
        if (this.windowHandle > 0L) {
            AndmoreLogger.info((String)("Restoring original properties for window: " + this.windowHandle));
            NativeUIUtils.setWindowProperties((long)this.windowHandle, (long)this.windowProperties);
            boolean shallUnembed = AndroidPlugin.getDefault().getPreferenceStore().getBoolean("shallUnembedEmulators");
            if (this.originalParentHandle > 0L && shallUnembed) {
                AndmoreLogger.info((String)("Setting original parent: " + this.originalParentHandle + " for window" + this.windowHandle));
                NativeUIUtils.unembedWindow((long)this.windowHandle, (long)this.originalParentHandle);
                this.androidInstance.setWindowHandle(0L);
                AndmoreLogger.info((String)("Restoring window: " + this.windowHandle));
                NativeUIUtils.restoreWindow((long)this.windowHandle);
            }
        }
        if (!Platform.getOS().equals("win32")) {
            AndmoreLogger.info((String)"Trying to store the content composite in instance");
            if (this.contentComposite != null) {
                AndmoreLogger.info((String)("Is instance started? :" + this.androidInstance.isStarted()));
                if (this.androidInstance.isStarted()) {
                    try {
                        this.contentComposite.setParent((Composite)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                        this.setContent(null);
                        this.contentComposite.setVisible(true);
                        this.androidInstance.setComposite(this.contentComposite);
                    }
                    catch (Exception e) {
                        AndmoreLogger.error((String)("Error trying to store the content composite :" + e.getMessage()));
                    }
                }
            }
        }
        super.dispose();
    }

    @Override
    public void applyZoomFactor() {
        if (!this.isOriginalScale && !this.zoomLocked) {
            this.contentComposite.setLocation(0, 0);
            IInputLogic inputLogic = this.androidInstance.getInputLogic();
            TelnetAndroidInput telnetAndroidInput = (TelnetAndroidInput)inputLogic;
            NativeUIUtils.hideWindow((long)this.windowHandle);
            if (this.isFitToWindow) {
                telnetAndroidInput.sendWindowScale(this.fitZoomFactor);
            } else {
                telnetAndroidInput.sendWindowScale(this.zoomFactor);
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
            telnetAndroidInput.dispose();
            NativeUIUtils.showWindow((long)this.windowHandle);
            this.updateContentComposite();
        }
    }

    void calculateFitZoomFactor(boolean requireNativeSizeUpdate) {
        Rectangle clientArea = this.getClientArea();
        if (clientArea.width == 0 || clientArea.height == 0) {
            this.fitZoomFactor = 0.1;
        } else if (requireNativeSizeUpdate) {
            this.forceNativeWindowSizeUpdate = false;
            this.updateNativeWindowSize();
        } else {
            double widthRatio = (double)clientArea.width / (double)this.nativeWindowSize.x;
            double heightRatio = (double)clientArea.height / (double)this.nativeWindowSize.y;
            this.fitZoomFactor = Math.min(widthRatio, heightRatio) > 0.1 ? Math.min(widthRatio, heightRatio) : 0.1;
        }
    }

    private void updateNativeWindowSize() {
        AndmoreLogger.info((String)"Updating Native Window Size");
        this.setZoomFactor(1.0);
        this.applyZoomFactor();
        this.nativeWindowSize = NativeUIUtils.getWindowSize((long)this.originalParentHandle, (long)this.windowHandle);
        this.setZoomFactor(0.0);
        this.applyZoomFactor();
        AndmoreLogger.info((String)"Updated Native Window Size");
    }

    private void updateContentComposite() {
        if (!this.isDisposed()) {
            this.windowSize = NativeUIUtils.getWindowSize((long)this.originalParentHandle, (long)this.windowHandle);
            if (this.windowSize != null) {
                if (this.contentComposite != null && !this.contentComposite.isDisposed()) {
                    this.contentComposite.setSize(this.windowSize.x, this.windowSize.y);
                    this.contentComposite.redraw();
                }
                this.setMinSize(this.windowSize.x, this.windowSize.y);
                this.draw();
                this.redraw();
                AndmoreLogger.info((String)"Updated Content Composite");
            }
        }
    }

    @Override
    public double getZoomFactor() {
        if (this.isFitToWindow) {
            return this.fitZoomFactor;
        }
        return this.zoomFactor;
    }

    @Override
    public void setZoomFactor(double zoom) {
        boolean execute = true;
        this.zoomLocked = false;
        if (this.isOriginalScale) {
            execute = DialogWithToggleUtils.showQuestion((String)LOOSE_ORIGINAL_SCALE_KEY_PREFERENCE, (String)EmulatorNLS.QUESTION_NativeWindow_LooseOriginalScale_Title, (String)EmulatorNLS.QUESTION_NativeWindow_LooseOriginalScale_Text);
        }
        if (execute) {
            this.isOriginalScale = false;
            if (zoom == 0.0) {
                this.isFitToWindow = true;
                this.calculateFitZoomFactor(this.forceNativeWindowSizeUpdate);
            } else {
                this.isOriginalScale = false;
                this.isFitToWindow = false;
            }
            this.zoomFactor = zoom;
        }
    }

    public boolean setFocus() {
        NativeUIUtils.setWindowFocus((long)this.windowHandle);
        return super.setFocus();
    }

    @Override
    public void applyLayout(String layoutName) {
        this.setLayout((Layout)new FillLayout());
        this.draw();
    }

    @Override
    public KeyListener getKeyListener() {
        return null;
    }

    @Override
    public MouseListener getMouseListener() {
        return null;
    }

    @Override
    public MouseMoveListener getMouseMoveListener() {
        return null;
    }

    @Override
    public boolean isFitToWindowSelected() {
        return this.isFitToWindow;
    }

    private class NativeWindowMonitor
    extends Timer {
        private Timer timer = new Timer();
        private MonitorTask monitorTask = new MonitorTask();

        public NativeWindowMonitor(long interval) {
            this.timer.schedule((TimerTask)this.monitorTask, interval, interval);
        }

        public void stopMonitoring() {
            this.timer.cancel();
            this.timer = null;
            this.monitorTask = null;
        }

        private class MonitorTask
        extends TimerTask {
            private MonitorTask() {
            }

            @Override
            public void run() {
                Display display;
                Point newWindowSize = NativeUIUtils.getWindowSize((long)NativeWindowComposite.this.originalParentHandle, (long)NativeWindowComposite.this.windowHandle);
                if (!(NativeWindowComposite.this.windowHandle > 0L && newWindowSize.equals((Object)NativeWindowComposite.this.windowSize) || (display = Display.getDefault()).isDisposed())) {
                    try {
                        display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                NativeWindowComposite.this.updateContentComposite();
                            }
                        });
                    }
                    catch (SWTException sWTException) {}
                }
                if (NativeUIUtils.isWindowEnabled((long)NativeWindowComposite.this.windowHandle) && !(display = Display.getDefault()).isDisposed()) {
                    try {
                        display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!NativeWindowComposite.this.contentComposite.isDisposed()) {
                                    NativeWindowComposite.this.contentComposite.forceFocus();
                                }
                            }
                        });
                    }
                    catch (SWTException sWTException) {}
                }
            }
        }
    }
}

