/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.ui.controls.maindisplay;

import java.util.Properties;
import org.eclipse.andmore.android.DDMSFacade;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.emulator.core.model.IAndroidEmulatorInstance;
import org.eclipse.andmore.android.emulator.core.model.IInputLogic;
import org.eclipse.andmore.android.emulator.logic.AndroidLogicUtils;
import org.eclipse.andmore.android.emulator.skin.android.AndroidSkinTranslator;
import org.eclipse.andmore.android.emulator.ui.controls.IAndroidComposite;
import org.eclipse.andmore.android.emulator.ui.controls.UIHelper;
import org.eclipse.andmore.android.nativeos.NativeUIUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.sequoyah.vnc.vncviewer.graphics.IRemoteDisplay;
import org.eclipse.sequoyah.vnc.vncviewer.graphics.swt.SWTRemoteDisplay;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class MainDisplayComposite
extends Composite
implements IAndroidComposite {
    private double zoomFactor = 1.0;
    private double fitZoomfactor;
    private static final double MINIMUM_ZOOM_FACTOR = 1.0E-4;
    private static final double ZOOM_FIT = 0.0;
    private boolean ctrlPressed = false;
    private KeyListener keyListener;
    private MouseListener mouseListener;
    private MouseMoveListener mouseMoveListener;
    private IInputLogic androidInput;
    private boolean isMouseLeftButtonPressed;
    private boolean isFitToWindow;
    private IAndroidEmulatorInstance androidInstance;
    private Properties keyMap;

    public MainDisplayComposite(Composite parent, int style, int baseWidth, int baseHeight, IAndroidEmulatorInstance instance) {
        super(parent, style);
        this.androidInput = instance.getInputLogic();
        this.androidInstance = instance;
        this.isMouseLeftButtonPressed = false;
        this.keyMap = AndroidSkinTranslator.getQwertyKeyMap();
        this.addListener();
        if (!Platform.getOS().equals("macosx")) {
            this.hideEmulatorWindow();
        }
    }

    private void hideEmulatorWindow() {
        int port = AndroidLogicUtils.getEmulatorPort(DDMSFacade.getSerialNumberByName((String)this.androidInstance.getName()));
        long windowHandle = NativeUIUtils.getWindowHandle((String)this.androidInstance.getName(), (int)port);
        this.androidInstance.setWindowHandle(windowHandle);
        NativeUIUtils.hideWindow((long)windowHandle);
    }

    public void dispose() {
        if (this.androidInput != null) {
            this.androidInput.dispose();
        }
        this.keyListener = null;
        this.mouseListener = null;
        this.mouseMoveListener = null;
        if (!Platform.getOS().equals("macosx")) {
            long hnd = this.androidInstance.getWindowHandle();
            if (hnd > 0L) {
                NativeUIUtils.showWindow((long)hnd);
                NativeUIUtils.restoreWindow((long)hnd);
            }
            this.androidInstance.setWindowHandle(0L);
        }
        super.dispose();
    }

    @Override
    public void setZoomFactor(double zoomFactor) {
        AndmoreLogger.info((String)"Update detached view composite size");
        this.isFitToWindow = zoomFactor == 0.0;
        this.zoomFactor = zoomFactor;
    }

    @Override
    public double getZoomFactor() {
        return this.zoomFactor;
    }

    @Override
    public void applyZoomFactor() {
        int height;
        int width;
        int baseWidth;
        int baseHeight;
        SWTRemoteDisplay mainDisplay = UIHelper.getRemoteDisplayAssociatedToControl((Control)this);
        IRemoteDisplay.Rotation rotation = mainDisplay.getRotation();
        switch (rotation) {
            case ROTATION_90DEG_COUNTERCLOCKWISE: {
                baseHeight = mainDisplay.getScreenWidth();
                baseWidth = mainDisplay.getScreenHeight();
                break;
            }
            default: {
                baseHeight = mainDisplay.getScreenHeight();
                baseWidth = mainDisplay.getScreenWidth();
            }
        }
        if (this.isFitToWindow) {
            Rectangle clientArea = this.getParent().getClientArea();
            if (clientArea.width == 0 || clientArea.height == 0) {
                this.fitZoomfactor = 1.0E-4;
            } else {
                double widthRatio = (double)clientArea.width / (double)baseWidth;
                double heightRatio = (double)clientArea.height / (double)baseHeight;
                this.fitZoomfactor = Math.min(widthRatio, heightRatio);
            }
            width = new Double((double)baseWidth * this.fitZoomfactor).intValue();
            height = new Double((double)baseHeight * this.fitZoomfactor).intValue();
            if (mainDisplay != null) {
                mainDisplay.setZoomFactor(this.fitZoomfactor);
            }
        } else {
            width = new Double((double)baseWidth * this.zoomFactor).intValue();
            height = new Double((double)baseHeight * this.zoomFactor).intValue();
            if (mainDisplay != null) {
                mainDisplay.setZoomFactor(this.zoomFactor);
            }
        }
        this.setSize(width, height);
    }

    private void addListener() {
        this.keyListener = new KeyListener(){

            public void keyPressed(KeyEvent arg0) {
                int keyCode = arg0.keyCode;
                if (keyCode == 262144) {
                    MainDisplayComposite.this.ctrlPressed = true;
                } else {
                    MainDisplayComposite.this.androidInput.sendKey(arg0.character, keyCode, MainDisplayComposite.this.keyMap);
                }
            }

            public void keyReleased(KeyEvent arg0) {
                int keyCode = arg0.keyCode;
                if (keyCode == 262144) {
                    MainDisplayComposite.this.ctrlPressed = false;
                }
            }
        };
        this.addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(MouseEvent event) {
                if (MainDisplayComposite.this.ctrlPressed) {
                    if (event.count > 0 && MainDisplayComposite.this.zoomFactor < 2.0) {
                        MainDisplayComposite.this.setZoomFactor(MainDisplayComposite.this.zoomFactor + 0.25);
                        MainDisplayComposite.this.applyZoomFactor();
                    } else if (event.count < 0 && MainDisplayComposite.this.zoomFactor > 0.25) {
                        MainDisplayComposite.this.setZoomFactor(MainDisplayComposite.this.zoomFactor - 0.25);
                        MainDisplayComposite.this.applyZoomFactor();
                    }
                }
            }
        });
        this.mouseListener = new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                MainDisplayComposite.this.handleMouseUp(e);
            }

            public void mouseDown(MouseEvent e) {
                MainDisplayComposite.this.setFocus();
                MainDisplayComposite.this.handleMouseDown(e);
            }
        };
        this.mouseMoveListener = new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                MainDisplayComposite.this.handleMouseMove(e);
            }
        };
        this.getParent().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                if (MainDisplayComposite.this.isFitToWindow) {
                    MainDisplayComposite.this.applyZoomFactor();
                }
            }
        });
    }

    @Override
    public void applyLayout(String layoutName) {
    }

    @Override
    public KeyListener getKeyListener() {
        return this.keyListener;
    }

    @Override
    public MouseListener getMouseListener() {
        return this.mouseListener;
    }

    @Override
    public MouseMoveListener getMouseMoveListener() {
        return this.mouseMoveListener;
    }

    private void handleMouseUp(MouseEvent e) {
        if (e.button == 1) {
            this.isMouseLeftButtonPressed = false;
            UIHelper.ajustCoordinates(e, this);
            this.androidInput.sendMouseUp(e.x, e.y);
        }
    }

    private void handleMouseDown(MouseEvent e) {
        if (e.button == 1) {
            UIHelper.ajustCoordinates(e, this);
            this.androidInput.sendMouseDown(e.x, e.y);
            this.isMouseLeftButtonPressed = true;
        }
    }

    private void handleMouseMove(MouseEvent e) {
        if (this.isMouseLeftButtonPressed) {
            UIHelper.ajustCoordinates(e, this);
            this.androidInput.sendMouseMove(e.x, e.y);
        }
    }

    @Override
    public boolean isFitToWindowSelected() {
        return this.isFitToWindow;
    }
}

