/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.ui.controls;

import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.andmore.android.emulator.core.model.IAndroidEmulatorInstance;
import org.eclipse.andmore.android.emulator.ui.controls.UIHelper;
import org.eclipse.sequoyah.vnc.vncviewer.graphics.swt.ISWTPainter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class RemoteCLIDisplay
extends Composite {
    private Canvas canvas;
    private Image screen = null;
    private ISWTPainter painter;
    private Timer refreshTimer;
    private static long FIRST_REFRESH_DELAY_MS = 500L;
    private static long REFRESH_DELAY_PERIOD_MS = 300L;
    private boolean active = false;
    private double zoomFactor = 1.0;

    public RemoteCLIDisplay(Composite parent, ISWTPainter cliPainter) {
        super(parent, 8);
        this.painter = cliPainter;
        this.setLayout(parent.getLayout());
        this.canvas = new Canvas((Composite)this, 8);
    }

    public synchronized void start() {
        this.addRefreshTimer();
        this.setRunning(true);
    }

    public synchronized void stop() {
        this.setRunning(false);
        this.refreshTimer.cancel();
        if (!this.canvas.isDisposed()) {
            GC gc = new GC((Drawable)this.canvas);
            this.canvas.drawBackground(gc, 0, 0, this.canvas.getSize().x, this.canvas.getSize().y);
            gc.dispose();
        }
    }

    private void addRefreshTimer() {
        this.refreshTimer = new Timer();
        final IAndroidEmulatorInstance instance = UIHelper.getInstanceAssociatedToControl((Control)this);
        this.refreshTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (instance.getHasCli()) {
                    RemoteCLIDisplay.this.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            RemoteCLIDisplay.this.updateScreen();
                        }
                    });
                }
            }
        }, FIRST_REFRESH_DELAY_MS, REFRESH_DELAY_PERIOD_MS);
    }

    private void updateScreen() {
        if (this.screen != null) {
            this.screen.dispose();
        }
        if (!this.getDisplay().isDisposed() && this.isDisplayActive()) {
            if (this.painter.getImageData() != null && !this.canvas.isDisposed()) {
                this.screen = new Image((Device)this.canvas.getDisplay(), this.painter.getImageData().scaledTo((int)((double)this.painter.getImageData().width * this.zoomFactor), (int)((double)this.painter.getImageData().height * this.zoomFactor)));
                GC gc = new GC((Drawable)this.canvas);
                gc.drawImage(this.screen, 0, 0);
                gc.dispose();
            }
        } else {
            this.stop();
        }
    }

    public synchronized boolean isDisplayActive() {
        return this.active;
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public Image getScreen() {
        return this.screen;
    }

    public int getScreenWidth() {
        return this.painter.getWidth();
    }

    public int getScreenHeight() {
        return this.painter.getHeight();
    }

    private synchronized void setRunning(boolean running) {
        this.active = running;
    }

    public void dispose() {
        if (this.isDisplayActive()) {
            this.stop();
        }
        if (this.screen != null) {
            this.screen.dispose();
        }
        this.canvas.dispose();
        super.dispose();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.canvas.setBackground(color);
    }

    public double getZoomFactor() {
        return this.zoomFactor;
    }

    public void setZoomFactor(double zoomFactor) {
        this.zoomFactor = zoomFactor;
        IAndroidEmulatorInstance instance = UIHelper.getInstanceAssociatedToControl((Control)this);
        if (instance.getHasCli()) {
            this.updateScreen();
        }
    }
}

