/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.skin.android.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.nio.CharBuffer;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.Stack;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.emulator.EmulatorPlugin;
import org.eclipse.andmore.android.emulator.core.exception.SkinException;
import org.eclipse.andmore.android.emulator.i18n.EmulatorNLS;
import org.eclipse.andmore.android.emulator.skin.android.parser.ILayoutBean;
import org.eclipse.andmore.android.emulator.skin.android.parser.ILayoutConstants;
import org.eclipse.andmore.android.emulator.skin.android.parser.ImagePositionBean;
import org.eclipse.andmore.android.emulator.skin.android.parser.LayoutBean;
import org.eclipse.andmore.android.emulator.skin.android.parser.LayoutFileModel;
import org.eclipse.andmore.android.emulator.skin.android.parser.PartBean;
import org.eclipse.andmore.android.emulator.skin.android.parser.RectangleBean;

public class LayoutFileParser
implements ILayoutConstants {
    private static final String LAYOUT_FILE_NAME = "layout";
    private static final String PSEUDO_LAYOUT_FILE = "res/pseudolayout";
    private static final String SPLIT_PATTERN = "[\n\r \t]+";

    public static LayoutFileModel readLayout(File skinFilesPath) throws SkinException {
        String fileContents;
        LayoutFileModel model = new LayoutFileModel();
        File layoutPath = new File(skinFilesPath, LAYOUT_FILE_NAME);
        if (layoutPath != null && layoutPath.isFile()) {
            fileContents = LayoutFileParser.getLayoutFileContents(layoutPath);
            LayoutFileParser.parseLayoutFile(fileContents, model);
        }
        Collection<String> partNames = model.getPartNames();
        if (model.getLayoutNames().size() == 0 && partNames.size() == 1 && partNames.iterator().next().equals("___UNIQUE___")) {
            fileContents = LayoutFileParser.getPseudoLayoutFileContents();
            LayoutFileParser.parseLayoutFile(fileContents, model);
        }
        return model;
    }

    private static void parseLayoutFile(String fileContents, LayoutFileModel model) throws SkinException {
        String cleanContents;
        block25: {
            cleanContents = "";
            BufferedReader reader = null;
            try {
                try {
                    StringBuffer contentBuffer = new StringBuffer();
                    reader = new BufferedReader(new StringReader(fileContents));
                    String line = null;
                    do {
                        String lineCopy = line = reader.readLine();
                        if (line == null || lineCopy.trim().startsWith("#")) continue;
                        contentBuffer.append(String.valueOf(line) + '\n');
                    } while (line != null);
                    cleanContents = contentBuffer.toString();
                }
                catch (IOException iOException) {
                    cleanContents = fileContents;
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        AndmoreLogger.error((String)"Could not close input stream: ", (String)e.getMessage());
                    }
                    break block25;
                }
            }
            catch (Throwable throwable) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    AndmoreLogger.error((String)"Could not close input stream: ", (String)e.getMessage());
                }
                throw throwable;
            }
            try {
                reader.close();
            }
            catch (IOException e) {
                AndmoreLogger.error((String)"Could not close input stream: ", (String)e.getMessage());
            }
        }
        String[] tokens = cleanContents.split(SPLIT_PATTERN);
        Stack<Object> stack = new Stack<Object>();
        String currentTag = null;
        String key = null;
        try {
            String[] stringArray = tokens;
            int n = tokens.length;
            int n2 = 0;
            while (n2 < n) {
                String aToken = stringArray[n2];
                if ("{".equals(aToken)) {
                    if (key != null) {
                        currentTag = key;
                        key = null;
                    }
                    LayoutFileParser.addElementsToStack(stack, model, currentTag);
                } else if ("}".equals(aToken)) {
                    LayoutFileParser.removeElementsFromStack(stack);
                } else if (key == null) {
                    key = aToken;
                } else {
                    LayoutFileParser.setKeyValuePair(stack, model, currentTag, key, aToken);
                    key = null;
                }
                ++n2;
            }
        }
        catch (EmptyStackException emptyStackException) {
            throw new SkinException(EmulatorNLS.ERR_LayoutFileParser_BracketsDoNotMatch);
        }
        if (!stack.isEmpty()) {
            if (stack.size() == 1 && stack.get(0) instanceof PartBean && ((PartBean)stack.get(0)).getName().equals("___UNIQUE___")) {
                stack.pop();
            } else {
                throw new SkinException(EmulatorNLS.ERR_LayoutFileParser_BracketsDoNotMatch);
            }
        }
    }

    private static String getLayoutFileContents(File layoutPath) throws SkinException {
        int fileSize = (int)layoutPath.length();
        char[] buffer = new char[fileSize];
        FileReader fr = null;
        try {
            try {
                fr = new FileReader(layoutPath);
                fr.read(buffer);
            }
            catch (IOException e) {
                AndmoreLogger.error((String)("The file " + layoutPath.getAbsolutePath() + " could not be read. cause=" + e.getMessage()));
                throw new SkinException(EmulatorNLS.ERR_LayoutFileParser_LayoutFileCouldNotBeRead);
            }
        }
        catch (Throwable throwable) {
            try {
                if (fr != null) {
                    fr.close();
                }
            }
            catch (IOException iOException) {
                AndmoreLogger.warn((String)("The file " + layoutPath.getAbsolutePath() + " could not be closed after reading"));
            }
            throw throwable;
        }
        try {
            if (fr != null) {
                fr.close();
            }
        }
        catch (IOException iOException) {
            AndmoreLogger.warn((String)("The file " + layoutPath.getAbsolutePath() + " could not be closed after reading"));
        }
        return String.copyValueOf(buffer);
    }

    private static String getPseudoLayoutFileContents() throws SkinException {
        URL url = EmulatorPlugin.getDefault().getBundle().getResource(PSEUDO_LAYOUT_FILE);
        CharBuffer buffer = CharBuffer.allocate(1024);
        int readChars = 0;
        InputStream is = null;
        InputStreamReader isr = null;
        try {
            try {
                is = url.openStream();
                isr = new InputStreamReader(is);
                while (readChars != -1) {
                    readChars = isr.read(buffer);
                }
                buffer.flip();
            }
            catch (IOException e) {
                AndmoreLogger.error((String)("The file res/pseudolayout could not be read. cause=" + e.getMessage()));
                throw new SkinException(EmulatorNLS.ERR_LayoutFileParser_LayoutFileCouldNotBeRead);
            }
        }
        catch (Throwable throwable) {
            try {
                if (is != null) {
                    is.close();
                }
                if (isr != null) {
                    isr.close();
                }
            }
            catch (IOException iOException) {
                AndmoreLogger.warn((String)"The file res/pseudolayout could not be closed after reading");
            }
            throw throwable;
        }
        try {
            if (is != null) {
                is.close();
            }
            if (isr != null) {
                isr.close();
            }
        }
        catch (IOException iOException) {
            AndmoreLogger.warn((String)"The file res/pseudolayout could not be closed after reading");
        }
        return buffer.toString();
    }

    private static void addElementsToStack(Stack<Object> stack, LayoutFileModel model, String elementName) {
        Object bean;
        Object previousElement;
        RectangleBean display;
        int stackSizeAtStart = stack.size();
        if (stack.size() == 0) {
            if ("display".equals(elementName) || "background".equals(elementName) || "button".equals(elementName)) {
                PartBean bean2 = model.newPart();
                stack.push(bean2);
                if ("background".equals(elementName) || "button".equals(elementName)) {
                    stack.push(elementName);
                } else if ("display".equals(elementName)) {
                    display = bean2.newDisplay();
                    stack.push(display);
                }
            } else {
                stack.push(elementName);
            }
        } else if (stack.size() == 1 && (previousElement = stack.peek()) instanceof String) {
            if ("parts".equals(previousElement)) {
                bean = model.newPart(elementName);
                stack.push(bean);
            } else if ("layouts".equals(previousElement)) {
                bean = model.newLayout(elementName);
                stack.push(bean);
            }
        }
        if (stackSizeAtStart == stack.size()) {
            Object nonStringObj;
            Object stackElem = stack.peek();
            if (stackElem instanceof PartBean) {
                if ("display".equals(elementName)) {
                    display = ((PartBean)stackElem).newDisplay();
                    stack.push(display);
                } else if ("background".equals(elementName)) {
                    ImagePositionBean background = ((PartBean)stackElem).newBackground(elementName);
                    stack.push(background);
                } else {
                    stack.push(elementName);
                }
            } else if (stackElem instanceof LayoutBean) {
                bean = ((LayoutBean)stackElem).newPartRef(elementName);
                stack.push(bean);
            } else if (stackElem instanceof String && ("button".equals(stackElem) || "buttons".equals(stackElem)) && (nonStringObj = LayoutFileParser.findFirstNonStringAtStack(stack)) != null) {
                PartBean bean3 = (PartBean)nonStringObj;
                ImagePositionBean button = bean3.newButton(elementName);
                stack.push(button);
            }
        }
    }

    private static void removeElementsFromStack(Stack<Object> stack) {
        stack.pop();
    }

    private static void setKeyValuePair(Stack<Object> stack, LayoutFileModel model, String currentTag, String key, String value) {
        Object obj = stack.peek();
        if (obj instanceof String) {
            Object notStringObj = LayoutFileParser.findFirstNonStringAtStack(stack);
            if (notStringObj instanceof ILayoutBean) {
                ((ILayoutBean)notStringObj).setKeyValue(key, value);
            } else if ("network".equals(currentTag)) {
                if ("delay".equals(key)) {
                    model.setNetworkDelay(value);
                } else if ("speed".equals(key)) {
                    model.setNetworkSpeed(value);
                }
            } else if ("keyboard".equals(currentTag) && "charmap".equals(key)) {
                model.setKeyboardCharmap(value);
            }
        } else {
            ((ILayoutBean)obj).setKeyValue(key, value);
        }
    }

    private static Object findFirstNonStringAtStack(Stack<Object> stack) {
        Object firstNonString = null;
        Object tmpObj = null;
        int i = stack.size() - 1;
        while (i >= 0) {
            tmpObj = stack.get(i);
            if (!(tmpObj instanceof String)) {
                firstNonString = tmpObj;
                break;
            }
            --i;
        }
        return firstNonString;
    }
}

