/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.skin.android.parser;

import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.andmore.android.emulator.skin.android.parser.ImagePositionBean;
import org.eclipse.andmore.android.emulator.skin.android.parser.LayoutBean;
import org.eclipse.andmore.android.emulator.skin.android.parser.PartBean;
import org.eclipse.andmore.android.emulator.skin.android.parser.PartRefBean;
import org.eclipse.andmore.android.emulator.skin.android.parser.RectangleBean;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;

public class LayoutFileModel {
    private static final String ROTATE_SCREEN_EVENT = "EV_SW:0:0";
    private static final String ROTATE_SCREEN_CMD = "5 0 0";
    private static final String RETURN_TO_DEFAULT_SCREEN_CMD = "5 0 1";
    private Collection<LayoutBean> layouts;
    private Collection<PartBean> parts = new LinkedHashSet<PartBean>();
    private String keyboardCharmap;
    private String networkSpeed;
    private String networkDelay;

    void setKeyboardCharmap(String keyboardCharmap) {
        this.keyboardCharmap = keyboardCharmap;
    }

    void setNetworkSpeed(String networkSpeed) {
        this.networkSpeed = networkSpeed;
    }

    void setNetworkDelay(String networkDelay) {
        this.networkDelay = networkDelay;
    }

    PartBean newPart() {
        return this.newPart("___UNIQUE___");
    }

    PartBean newPart(String name) {
        PartBean bean = new PartBean(name);
        this.parts.add(bean);
        return bean;
    }

    LayoutBean newLayout(String name) {
        LayoutBean bean = new LayoutBean(name);
        if (this.layouts == null) {
            this.layouts = new LinkedHashSet<LayoutBean>();
        }
        this.layouts.add(bean);
        return bean;
    }

    public String getKeyboardCharmap() {
        return this.keyboardCharmap;
    }

    public String getNetworkSpeed() {
        return this.networkSpeed;
    }

    public String getNetworkDelay() {
        return this.networkDelay;
    }

    public List<String> getLayoutNames() {
        LinkedList<String> layoutNames = new LinkedList<String>();
        if (this.layouts != null) {
            for (LayoutBean bean : this.layouts) {
                layoutNames.add(bean.getName());
            }
        }
        return layoutNames;
    }

    public Collection<String> getPartNames() {
        LinkedHashSet<String> partNames = new LinkedHashSet<String>();
        for (PartBean bean : this.parts) {
            partNames.add(bean.getName());
        }
        return partNames;
    }

    public Collection<String> getLayoutPartNames(String layoutName) {
        Collection<PartRefBean> partRefs;
        LinkedHashSet<String> layoutPartNames = new LinkedHashSet<String>();
        LayoutBean bean = this.getLayoutByName(layoutName);
        if (bean != null && (partRefs = bean.getPartRefs()) != null) {
            for (PartRefBean aRef : partRefs) {
                layoutPartNames.add(aRef.getPartName());
            }
        }
        return layoutPartNames;
    }

    public Point getPartPositionAtLayout(String layoutName, String partName, File skinFilesPath) {
        Point partPosition = null;
        LayoutBean bean = this.getLayoutByName(layoutName);
        if (bean != null) {
            Collection<PartRefBean> partRefs = bean.getPartRefs();
            for (PartRefBean prBean : partRefs) {
                if (!prBean.getPartName().equals(partName)) continue;
                int x = Integer.parseInt(prBean.getX());
                String yStr = prBean.getY();
                int y = yStr == null ? this.getBackgroundWidth(partName, skinFilesPath) : Integer.parseInt(yStr);
                partPosition = new Point(x, y);
                break;
            }
        } else {
            partPosition = new Point(0, 0);
        }
        return partPosition;
    }

    public int getPartRotationAtLayout(String layoutName, String partName) {
        int partRotation = 0;
        LayoutBean bean = this.getLayoutByName(layoutName);
        if (bean != null) {
            Collection<PartRefBean> partRefs = bean.getPartRefs();
            for (PartRefBean prBean : partRefs) {
                if (!prBean.getPartName().equals(partName)) continue;
                String rotStr = prBean.getRotation();
                if (rotStr == null) break;
                partRotation = Integer.parseInt(rotStr);
                break;
            }
        }
        return partRotation;
    }

    public int getDpadRotation(String layoutName) {
        int dPadRotation = 0;
        LayoutBean bean = this.getLayoutByName(layoutName);
        if (bean != null) {
            dPadRotation = bean.getDpadRotation();
        }
        return dPadRotation;
    }

    public Collection<String> getButtonNames(String partName) {
        Collection<ImagePositionBean> buttons;
        LinkedHashSet<String> buttonNames = new LinkedHashSet<String>();
        PartBean bean = this.getPartByName(partName);
        if (bean != null && (buttons = bean.getButtons()) != null) {
            for (ImagePositionBean button : buttons) {
                buttonNames.add(button.getName());
            }
        }
        return buttonNames;
    }

    public int getLayoutWidth(String layoutName) {
        int width = 0;
        LayoutBean layout = this.getLayoutByName(layoutName);
        if (layout != null) {
            width = Integer.parseInt(layout.getWidth());
        }
        return width;
    }

    public int getLayoutHeight(String layoutName) {
        int height = 0;
        LayoutBean layout = this.getLayoutByName(layoutName);
        if (layout != null) {
            height = Integer.parseInt(layout.getHeight());
        }
        return height;
    }

    public RGB getLayoutColor(String layoutName, File skinFilesPath) {
        RGB color = null;
        LayoutBean layout = this.getLayoutByName(layoutName);
        if (layout != null) {
            color = layout.getColor();
            if (color == null) {
                String mainPart = this.getMainPartName(layoutName);
                File image = this.getBackgroundImage(mainPart, skinFilesPath);
                ImageData img = new ImageData(image.getAbsolutePath());
                int pixel = img.getPixel(0, 0);
                color = img.palette.getRGB(pixel);
                layout.setKeyValue("color", "0x" + Integer.toHexString(color.red) + Integer.toHexString(color.green) + Integer.toHexString(color.blue));
            }
        } else {
            color = new RGB(255, 255, 255);
        }
        return color;
    }

    public String getLayoutEvent(String layoutName) {
        String event = "";
        LayoutBean layout = this.getLayoutByName(layoutName);
        if (layout != null) {
            event = layout.getEvent();
        }
        return event;
    }

    public String getLayoutSwitchCommand(String layoutName) {
        LayoutBean bean = this.getLayoutByName(layoutName);
        String event = bean.getEvent();
        if (ROTATE_SCREEN_EVENT.equals(event)) {
            return ROTATE_SCREEN_CMD;
        }
        return RETURN_TO_DEFAULT_SCREEN_CMD;
    }

    public boolean isSwapWidthHeightNeededAtLayout(String layoutName) {
        return this.isSwapWidthHeightNeededAtLayout(layoutName, this.getMainPartName(layoutName));
    }

    public boolean isSwapWidthHeightNeededAtLayout(String layoutName, String partName) {
        boolean isRotated = false;
        if (partName != null) {
            int rotation = this.getPartRotationAtLayout(layoutName, partName);
            isRotated = rotation % 2 != 0;
        }
        return isRotated;
    }

    public File getBackgroundImage(String partName, File skinFilesPath) {
        ImagePositionBean backgroundBean;
        File backgroundFile = null;
        PartBean part = this.getPartByName(partName);
        if (part != null && (backgroundBean = part.getBackground()) != null) {
            backgroundFile = new File(skinFilesPath, backgroundBean.getImageLocation().getName());
        }
        return backgroundFile;
    }

    public Point getBackgroundPosition(String partName) {
        Point bgPosition = null;
        PartBean part = this.getPartByName(partName);
        if (part != null) {
            ImagePositionBean bgBean = part.getBackground();
            String xStr = null;
            String yStr = null;
            if (bgBean != null) {
                xStr = bgBean.getXPos();
                yStr = bgBean.getYPos();
            }
            bgPosition = xStr != null && yStr != null ? new Point(Integer.parseInt(xStr), Integer.parseInt(yStr)) : new Point(0, 0);
        }
        return bgPosition;
    }

    public int getBackgroundWidth(String partName, File skinFilesPath) {
        ImagePositionBean bgBean;
        int width = -1;
        PartBean part = this.getPartByName(partName);
        if (part != null && (bgBean = part.getBackground()) != null) {
            width = bgBean.getWidth(skinFilesPath);
        }
        return width;
    }

    public int getBackgroundHeight(String partName, File skinFilesPath) {
        ImagePositionBean bgBean;
        int height = -1;
        PartBean part = this.getPartByName(partName);
        if (part != null && (bgBean = part.getBackground()) != null) {
            height = bgBean.getHeight(skinFilesPath);
        }
        return height;
    }

    public File getButtonImage(String partName, String buttonName) {
        File buttonFile = null;
        ImagePositionBean button = this.getButtonByName(partName, buttonName);
        if (button != null) {
            buttonFile = button.getImageLocation();
        }
        return buttonFile;
    }

    public Point getButtonPosition(String partName, String buttonName) {
        Point buttonPos = null;
        ImagePositionBean button = this.getButtonByName(partName, buttonName);
        if (button != null) {
            buttonPos = new Point(Integer.parseInt(button.getXPos()), Integer.parseInt(button.getYPos()));
        }
        return buttonPos;
    }

    public int getButtonWidth(String partName, String buttonName, File skinFilesPath) {
        int width = -1;
        ImagePositionBean button = this.getButtonByName(partName, buttonName);
        if (button != null) {
            width = button.getWidth(skinFilesPath);
        }
        return width;
    }

    public int getButtonHeight(String partName, String buttonName, File skinFilesPath) {
        int height = -1;
        ImagePositionBean button = this.getButtonByName(partName, buttonName);
        if (button != null) {
            height = button.getHeight(skinFilesPath);
        }
        return height;
    }

    public Point getDisplayPosition(String partName) {
        Point displayPos = null;
        PartBean bean = this.getPartByName(partName);
        if (bean != null) {
            RectangleBean dispBean = bean.getDisplay();
            displayPos = new Point(Integer.parseInt(dispBean.getXPos()), Integer.parseInt(dispBean.getYPos()));
        }
        return displayPos;
    }

    public int getDisplayWidth(String partName) {
        int width = -1;
        PartBean bean = this.getPartByName(partName);
        if (bean != null) {
            RectangleBean dispBean = bean.getDisplay();
            width = Integer.parseInt(dispBean.getWidth());
        }
        return width;
    }

    public int getDisplayHeight(String partName) {
        int height = -1;
        PartBean bean = this.getPartByName(partName);
        if (bean != null) {
            RectangleBean dispBean = bean.getDisplay();
            height = Integer.parseInt(dispBean.getHeight());
        }
        return height;
    }

    private LayoutBean getLayoutByName(String layoutName) {
        LayoutBean layoutToReturn = null;
        if (this.layouts != null) {
            for (LayoutBean bean : this.layouts) {
                if (!bean.getName().equals(layoutName)) continue;
                layoutToReturn = bean;
                break;
            }
        }
        return layoutToReturn;
    }

    public PartBean getPartByName(String partName) {
        PartBean partToReturn = null;
        for (PartBean bean : this.parts) {
            if (!bean.getName().equals(partName)) continue;
            partToReturn = bean;
            break;
        }
        return partToReturn;
    }

    private ImagePositionBean getButtonByName(String partName, String buttonName) {
        Collection<ImagePositionBean> buttons;
        ImagePositionBean buttonToReturn = null;
        PartBean pBean = this.getPartByName(partName);
        if (pBean != null && (buttons = pBean.getButtons()) != null) {
            for (ImagePositionBean bBean : buttons) {
                if (!bBean.getName().equals(buttonName)) continue;
                buttonToReturn = bBean;
                break;
            }
        }
        return buttonToReturn;
    }

    public String getMainPartName(String layoutName) {
        String mainPartName = null;
        for (LayoutBean layout : this.layouts) {
            if (layout.getName().equals(layoutName)) {
                Collection<PartRefBean> allRefs = layout.getPartRefs();
                for (PartRefBean partRef : allRefs) {
                    String partName = partRef.getPartName();
                    for (PartBean aPart : this.parts) {
                        String aPartName = aPart.getName();
                        if (!aPartName.equals(partName) || aPart.getDisplay() == null) continue;
                        mainPartName = aPartName;
                        break;
                    }
                    if (mainPartName != null) break;
                }
            }
            if (mainPartName != null) break;
        }
        return mainPartName;
    }

    public boolean partHasBg(String partName) {
        PartBean part = this.getPartByName(partName);
        ImagePositionBean background = part.getBackground();
        return background != null;
    }
}

