/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.skin.android.parser;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.andmore.android.emulator.skin.android.parser.ILayoutBean;
import org.eclipse.andmore.android.emulator.skin.android.parser.ILayoutConstants;
import org.eclipse.andmore.android.emulator.skin.android.parser.PartRefBean;
import org.eclipse.swt.graphics.RGB;

public class LayoutBean
implements ILayoutConstants,
ILayoutBean {
    public static final String DEFAULT_LAYOUT_NAME = "default";
    public static final String ROTATED_LAYOUT_NAME = "rotated";
    private String name;
    private String width;
    private String height;
    private RGB color;
    private String event;
    private int dpadRotation;
    private Collection<PartRefBean> parts = new LinkedHashSet<PartRefBean>();

    LayoutBean(String name) {
        this.name = name;
    }

    PartRefBean newPartRef(String refName) {
        PartRefBean bean = new PartRefBean(refName);
        this.parts.add(bean);
        return bean;
    }

    String getWidth() {
        return this.width;
    }

    String getHeight() {
        return this.height;
    }

    RGB getColor() {
        return this.color;
    }

    String getEvent() {
        return this.event;
    }

    int getDpadRotation() {
        return this.dpadRotation;
    }

    String getName() {
        return this.name;
    }

    Collection<PartRefBean> getPartRefs() {
        return this.parts;
    }

    public String toString() {
        return "Layout: " + this.name;
    }

    @Override
    public void setKeyValue(String key, String value) {
        if ("width".equals(key)) {
            this.width = value;
        } else if ("height".equals(key)) {
            this.height = value;
        } else if ("color".equals(key)) {
            RGB rgb;
            Integer colorInt = Integer.decode(value);
            int blue = colorInt & 0xFF;
            int green = (colorInt & 0xFF00) >> 8;
            int red = (colorInt & 0xFF0000) >> 16;
            this.color = rgb = new RGB(red, green, blue);
        } else if ("event".equals(key)) {
            this.event = value;
        } else if ("dpad-rotation".equals(key)) {
            int intValue;
            try {
                intValue = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                intValue = 0;
            }
            this.dpadRotation = intValue;
        }
    }
}

