/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.skin.android.parser;

import java.io.File;
import org.eclipse.andmore.android.emulator.skin.android.parser.ILayoutBean;
import org.eclipse.andmore.android.emulator.skin.android.parser.ILayoutConstants;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.ui.PlatformUI;

public class ImagePositionBean
implements ILayoutConstants,
ILayoutBean {
    private String name;
    private File imageLocation;
    private String xPos;
    private String yPos;
    private int width = -1;
    private int height = -1;

    ImagePositionBean(String name) {
        this.name = name;
    }

    File getImageLocation() {
        return this.imageLocation;
    }

    String getXPos() {
        return this.xPos;
    }

    String getYPos() {
        return this.yPos;
    }

    int getWidth(File skinFilesPath) {
        if (this.width == -1) {
            this.populateWidthHeight(skinFilesPath);
        }
        return this.width;
    }

    int getHeight(File skinFilesPath) {
        if (this.width == -1) {
            this.populateWidthHeight(skinFilesPath);
        }
        return this.height;
    }

    String getName() {
        return this.name;
    }

    public String toString() {
        return "ImagePosition: " + this.name;
    }

    private void populateWidthHeight(final File skinFilesPath) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ImageData id = new ImageData(new File(skinFilesPath, ImagePositionBean.this.imageLocation.getName()).getAbsolutePath());
                ImagePositionBean.this.width = id.width;
                ImagePositionBean.this.height = id.height;
            }
        });
    }

    @Override
    public void setKeyValue(String key, String value) {
        if ("image".equals(key)) {
            this.imageLocation = new File(value);
        } else if ("x".equals(key)) {
            this.xPos = value;
        } else if ("y".equals(key)) {
            this.yPos = value;
        }
    }
}

