/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.service.stop;

import java.util.Map;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.emulator.EmulatorPlugin;
import org.eclipse.andmore.android.emulator.device.instance.AndroidDeviceInstance;
import org.eclipse.andmore.android.emulator.i18n.EmulatorNLS;
import org.eclipse.andmore.android.emulator.logic.stop.AndroidEmulatorStopper;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.sequoyah.device.framework.events.InstanceEvent;
import org.eclipse.sequoyah.device.framework.events.InstanceEventManager;
import org.eclipse.sequoyah.device.framework.model.IInstance;
import org.eclipse.sequoyah.device.framework.model.handler.IServiceHandler;
import org.eclipse.sequoyah.device.framework.model.handler.ServiceHandler;

public class StopEmulatorHandler
extends ServiceHandler {
    public IServiceHandler newInstance() {
        return new StopEmulatorHandler();
    }

    public IStatus runService(IInstance instance, Map<Object, Object> arguments, IProgressMonitor monitor) {
        AndmoreLogger.debug((String)("Executing the stop emulator service... Instance:" + instance + " Arguments:" + arguments));
        IStatus status = Status.OK_STATUS;
        if (!(instance instanceof AndroidDeviceInstance)) {
            AndmoreLogger.error((String)"Aborting start service. This is not an Android Emulator instance...");
            status = new Status(4, "org.eclipse.andmore.android.emulator", EmulatorNLS.ERR_StopEmulatorHandler_NotAnAndroidEmulator);
        } else {
            boolean stopPerformed;
            Object forceObj;
            boolean force = false;
            if (arguments != null && (forceObj = arguments.get("force")) instanceof Boolean) {
                force = (Boolean)forceObj;
            }
            if (!(stopPerformed = AndroidEmulatorStopper.stopInstance((AndroidDeviceInstance)instance, force, true, monitor))) {
                status = Status.CANCEL_STATUS;
            } else {
                instance.setNameSuffix(null);
                InstanceEventManager.getInstance().notifyListeners(new InstanceEvent(InstanceEvent.InstanceEventType.INSTANCE_UPDATED, instance));
            }
        }
        AndmoreLogger.debug((String)("Finished the execution of the stop emulator service: " + instance + " status: " + status));
        try {
            AndmoreLogger.collectUsageData((String)"stopped", (String)"emulator", (String)status.toString(), (String)"org.eclipse.andmore.android.emulator", (String)EmulatorPlugin.getDefault().getBundle().getVersion().toString());
        }
        catch (Throwable throwable) {}
        return status;
    }

    public IStatus updatingService(IInstance instance, IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }
}

