/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.service.repair;

import com.android.sdklib.internal.avd.AvdInfo;
import java.util.Map;
import org.eclipse.andmore.android.SdkUtils;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.emulator.device.instance.AndroidDeviceInstance;
import org.eclipse.andmore.android.emulator.device.refresh.InstancesListRefresh;
import org.eclipse.andmore.android.emulator.i18n.EmulatorNLS;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.sequoyah.device.framework.model.IInstance;
import org.eclipse.sequoyah.device.framework.model.handler.IServiceHandler;
import org.eclipse.sequoyah.device.framework.model.handler.ServiceHandler;

public class RepairAvdHandler
extends ServiceHandler {
    public IServiceHandler newInstance() {
        return new RepairAvdHandler();
    }

    public IStatus runService(IInstance instance, Map<Object, Object> argumentos, IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        if (!(instance instanceof AndroidDeviceInstance)) {
            AndmoreLogger.error((String)EmulatorNLS.RepairAvdHandler_Not_Android_Instance);
            status = new Status(4, "org.eclipse.andmore.android.emulator", EmulatorNLS.ERR_StopEmulatorHandler_NotAnAndroidEmulator);
        } else {
            AndroidDeviceInstance androidDeviceInstance = (AndroidDeviceInstance)instance;
            AvdInfo avdInfo = SdkUtils.getVm((String)androidDeviceInstance.getName());
            if (avdInfo != null && this.isAvdRepairable(avdInfo.getStatus())) {
                status = SdkUtils.repairAvd((AvdInfo)avdInfo);
                if (status.getSeverity() != 0) {
                    AndmoreLogger.error(((Object)((Object)this)).getClass(), (String)"IOException ocurred during repairAvd operation");
                }
            } else {
                status = new Status(4, "org.eclipse.andmore.android.emulator", EmulatorNLS.RepairAvdHandler_AVD_NOT_REPAIRABLE);
            }
        }
        if (status.getSeverity() == 0) {
            InstancesListRefresh.refresh();
        }
        return status;
    }

    public IStatus updatingService(IInstance arg0, IProgressMonitor arg1) {
        return Status.OK_STATUS;
    }

    private boolean isAvdRepairable(AvdInfo.AvdStatus avdStatus) {
        return avdStatus == AvdInfo.AvdStatus.ERROR_IMAGE_DIR;
    }
}

