/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.logic.stop;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.andmore.android.emulator.i18n.EmulatorNLS;
import org.eclipse.andmore.android.emulator.logic.AndroidLogicUtils;
import org.eclipse.andmore.android.emulator.logic.IAndroidLogicInstance;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sequoyah.vnc.protocol.PluginProtocolActionDelegate;
import org.eclipse.sequoyah.vnc.protocol.lib.ProtocolHandle;
import org.eclipse.sequoyah.vnc.vncviewer.registry.VNCProtocolRegistry;

public class AndroidEmulatorStopper {
    private static Lock lock = new ReentrantReadWriteLock().writeLock();
    private static final int MAX_LOCK_ATTEMPTS = 20;

    public static boolean stopInstance(IAndroidLogicInstance instance, boolean force, boolean kill, IProgressMonitor monitor) {
        if (instance == null) {
            AndmoreLogger.error((String)"Could not stop the protocol because the provided instance is null");
            return false;
        }
        boolean canProceed = true;
        if (!force) {
            canProceed = EclipseUtils.showQuestionDialog((String)EmulatorNLS.GEN_Question, (String)NLS.bind((String)EmulatorNLS.QUESTION_AndroidEmulatorStopper_StopEmulatorQuestion, (Object)instance.getName()));
        }
        if (canProceed) {
            int attempts = 0;
            boolean locked = lock.tryLock();
            while (!locked && attempts < 20) {
                try {
                    Thread.sleep(125L);
                }
                catch (InterruptedException interruptedException) {}
                locked = lock.tryLock();
                ++attempts;
            }
            if (locked) {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                try {
                    AndmoreLogger.info((String)"Stopping the Android Emulator instance");
                    monitor.beginTask(EmulatorNLS.MON_AndroidEmulatorStopper_DisposingInstance, 200);
                    monitor.setTaskName(EmulatorNLS.MON_AndroidEmulatorStopper_DisposingInstance);
                    try {
                        AndmoreLogger.info((String)"Trying to stop the protocol");
                        ProtocolHandle handle = instance.getProtocolHandle();
                        if (handle != null) {
                            PluginProtocolActionDelegate.requestStopProtocol((ProtocolHandle)handle);
                            while (PluginProtocolActionDelegate.isProtocolRunning((ProtocolHandle)handle)) {
                                Thread.sleep(250L);
                            }
                            VNCProtocolRegistry.getInstance().unregister(handle);
                            AndmoreLogger.info((String)"Protocol stopped");
                        }
                    }
                    catch (Exception exception) {
                        AndmoreLogger.error((String)"There was an error while trying to stop the protocol");
                    }
                    instance.setProtocolHandle(null);
                    monitor.worked(100);
                    monitor.setTaskName(EmulatorNLS.MON_AndroidEmulatorStopper_StopVm);
                    if (kill) {
                        AndroidLogicUtils.kill(instance);
                    }
                    AndmoreLogger.info((String)"Stopped the Android Emulator instance");
                }
                catch (Throwable throwable) {
                    monitor.done();
                    try {
                        lock.unlock();
                    }
                    catch (Exception exception) {
                        AndmoreLogger.warn((String)"The thread that is releasing the lock is not the one which has it.");
                    }
                    throw throwable;
                }
                monitor.done();
                try {
                    lock.unlock();
                }
                catch (Exception exception) {
                    AndmoreLogger.warn((String)"The thread that is releasing the lock is not the one which has it.");
                }
            } else {
                canProceed = false;
            }
        }
        return canProceed;
    }
}

