/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.logic.reset;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.emulator.i18n.EmulatorNLS;
import org.eclipse.andmore.android.emulator.logic.IAndroidLogicInstance;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class AndroidEmulatorReseter {
    static String SNAPSHOT_FILE_NAME = "snapshots.img";

    public static IStatus resetInstance(IAndroidLogicInstance instance) {
        IStatus resetStatus = Status.OK_STATUS;
        File userData = instance.getUserdata();
        List<File> stateData = instance.getStateData();
        if (userData != null || stateData != null) {
            ArrayList<File> allFiles = new ArrayList<File>();
            if (stateData != null) {
                allFiles.addAll(stateData);
            }
            if (userData != null) {
                allFiles.add(userData);
            }
            for (File file : allFiles) {
                if (!file.exists() || file.delete()) continue;
                AndmoreLogger.error((String)"There was an error when trying to remove the emulator instance user data files");
                resetStatus = new Status(4, "org.eclipse.andmore.android.emulator", NLS.bind((String)EmulatorNLS.EXC_AndroidEmulatorReseter_ErrorWhilePerformingDeleteOperation, (Object)new Path(file.getPath()).removeLastSegments(1).toString()));
                break;
            }
            if (allFiles != null && allFiles.size() > 0) {
                File snapshot = instance.getSnapshotOriginalFilePath();
                String snapshotToPath = ((File)allFiles.get(0)).getParentFile() + File.separator + SNAPSHOT_FILE_NAME;
                File snapshotToFile = new File(snapshotToPath);
                if (snapshot != null && snapshotToFile.exists()) {
                    BufferedInputStream bis = null;
                    FilterOutputStream bos = null;
                    try {
                        try {
                            int c;
                            bis = new BufferedInputStream(new FileInputStream(snapshot));
                            bos = new BufferedOutputStream(new FileOutputStream(snapshotToFile));
                            while ((c = bis.read()) >= 0) {
                                ((BufferedOutputStream)bos).write(c);
                            }
                        }
                        catch (Exception e) {
                            AndmoreLogger.error((String)("Error while copying the original snapshot file to the avd that is being reseted:" + e.getMessage()));
                            resetStatus = resetStatus.equals(Status.OK_STATUS) ? new Status(4, "org.eclipse.andmore.android.emulator", NLS.bind((String)EmulatorNLS.EXC_AndroidEmulatorReseter_ErrorWhilePerformingSnapshotCopyOperation, (Object)snapshot.getPath(), (Object)((File)allFiles.get(0)).getParentFile())) : new Status(4, "org.eclipse.andmore.android.emulator", NLS.bind((String)EmulatorNLS.EXC_AndroidEmulatorReseter_ErrorWhilePerformingDeleteSnapshotOperation, (Object)((File)allFiles.get(0)).getParentFile(), (Object)snapshot.getPath()));
                            try {
                                if (bis != null) {
                                    bis.close();
                                }
                                if (bos != null) {
                                    bos.close();
                                }
                            }
                            catch (Exception e2) {
                                AndmoreLogger.error((String)("Error while closing the snapshots file of the avd that is being reseted:" + e2.getMessage()));
                            }
                        }
                    }
                    finally {
                        try {
                            if (bis != null) {
                                bis.close();
                            }
                            if (bos != null) {
                                bos.close();
                            }
                        }
                        catch (Exception e) {
                            AndmoreLogger.error((String)("Error while closing the snapshots file of the avd that is being reseted:" + e.getMessage()));
                        }
                    }
                }
            }
        }
        return resetStatus;
    }
}

