/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.logic;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.emulator.core.exception.InstanceStartException;
import org.eclipse.andmore.android.emulator.core.exception.StartCancelledException;
import org.eclipse.andmore.android.emulator.core.exception.StartTimeoutException;
import org.eclipse.andmore.android.emulator.core.model.IAndroidEmulatorInstance;
import org.eclipse.andmore.android.emulator.logic.IAndroidLogic;
import org.eclipse.andmore.android.emulator.logic.IAndroidLogicInstance;
import org.eclipse.andmore.android.emulator.logic.VncServerJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;

public final class StartVncServerLogic
implements IAndroidLogic {
    public static final String VNC_SERVER_JOB_PREFIX = "VNC Server - ";
    public static final Object VNC_SERVER_JOB_FAMILY = new Object();
    private final Collection<String> remoteCommands = new LinkedList<String>();
    private final Collection<IJobChangeListener> listeners = new LinkedList<IJobChangeListener>();

    @Override
    public void execute(IAndroidLogicInstance instance, int timeout, IProgressMonitor monitor) throws InstanceStartException, StartTimeoutException, StartCancelledException, IOException {
        StartVncServerLogic.cancelCurrentVncServerJobs(instance);
        VncServerJob vncServerJob = new VncServerJob(instance, this.getRemoteCommands());
        for (IJobChangeListener vncServerListener : this.listeners) {
            vncServerJob.addJobChangeListener(vncServerListener);
        }
        vncServerJob.schedule();
    }

    public static void cancelCurrentVncServerJobs(IAndroidEmulatorInstance instance) {
        IJobManager manager = Job.getJobManager();
        Job[] allVncJobs = manager.find(VNC_SERVER_JOB_FAMILY);
        if (allVncJobs.length > 0) {
            Job[] jobArray = allVncJobs;
            int n = allVncJobs.length;
            int n2 = 0;
            while (n2 < n) {
                Job job = jobArray[n2];
                if (job.getName().equals(VNC_SERVER_JOB_PREFIX + instance.getName())) {
                    AndmoreLogger.info((String)("Cancel execution of the VNC Server on " + instance));
                    job.cancel();
                }
                ++n2;
            }
        }
    }

    public void addVncServerJobListener(IJobChangeListener vncServerListener) {
        this.listeners.add(vncServerListener);
    }

    public void addRemoteCommand(String remoteCommand) {
        this.remoteCommands.add(remoteCommand);
    }

    public Collection<String> getRemoteCommands() {
        return this.remoteCommands;
    }
}

