/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.logic;

import java.io.IOException;
import org.eclipse.andmore.android.DDMSFacade;
import org.eclipse.andmore.android.ISerialNumbered;
import org.eclipse.andmore.android.common.exception.AndroidException;
import org.eclipse.andmore.android.emulator.core.exception.InstanceStartException;
import org.eclipse.andmore.android.emulator.logic.AndroidLogicUtils;
import org.eclipse.andmore.android.emulator.logic.IAndroidLogic;
import org.eclipse.andmore.android.emulator.logic.IAndroidLogicInstance;
import org.eclipse.core.runtime.IProgressMonitor;

public class ForwardVncPortLogic
implements IAndroidLogic {
    @Override
    public void execute(IAndroidLogicInstance instance, int timeout, IProgressMonitor monitor) throws IOException, InstanceStartException {
        int port = AndroidLogicUtils.getVncServerPortFoward(instance.getInstanceIdentifier());
        if (instance instanceof ISerialNumbered) {
            String serialNumber = ((ISerialNumbered)instance).getSerialNumber();
            try {
                AndroidLogicUtils.testDeviceStatus(serialNumber);
            }
            catch (AndroidException e) {
                throw new InstanceStartException(e.getMessage());
            }
            boolean forwardOk = DDMSFacade.createForward((String)serialNumber, (int)port, (int)5901);
            if (!forwardOk) {
                throw new IOException("Could not forward VNC port 5901 to " + port + " on " + instance.getName());
            }
        }
    }
}

