/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.device.ui;

import java.util.List;
import org.eclipse.andmore.android.emulator.core.skin.IAndroidSkin;
import org.eclipse.andmore.android.emulator.device.instance.options.IStartupOptionsConstants;
import org.eclipse.andmore.android.emulator.device.instance.options.StartupOption;
import org.eclipse.andmore.android.emulator.device.instance.options.StartupOptionsGroup;
import org.eclipse.andmore.android.emulator.device.instance.options.StartupOptionsMgt;
import org.eclipse.andmore.android.emulator.device.ui.AbstractPropertiesComposite;
import org.eclipse.andmore.android.emulator.device.ui.DpiScaleCalculatorDialog;
import org.eclipse.andmore.android.emulator.i18n.EmulatorNLS;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class StartupOptionsComposite
extends AbstractPropertiesComposite
implements IStartupOptionsConstants {
    private Text commandLine;
    private final IAndroidSkin skin;
    private final int TABFOLDER_HEIGHT_HINT = 350;
    private boolean canCalculateScale = true;

    public StartupOptionsComposite(Composite parent, String startupOptions, IAndroidSkin skin, boolean canCalculateScale) {
        super(parent);
        this.skin = skin;
        this.canCalculateScale = canCalculateScale;
        StartupOptionsMgt.loadFromCommandLine(startupOptions);
        this.createUI();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.andmore.android.emulator.newdevstartup");
    }

    private void createUI() {
        StartupOptionsComposite mainComposite = this;
        GridLayout mainLayout = new GridLayout();
        mainComposite.setLayout((Layout)mainLayout);
        List<StartupOptionsGroup> startupOptionsGroupsList = StartupOptionsMgt.getStartupOptionsGroupsList();
        List<StartupOption> startupOptions = null;
        TabFolder tabFolder = new TabFolder((Composite)mainComposite, 0);
        GridData data = new GridData(4, 4, true, false);
        data.heightHint = 350;
        tabFolder.setLayoutData((Object)data);
        for (StartupOptionsGroup startupOptionGroup : startupOptionsGroupsList) {
            TabItem tabItem = new TabItem(tabFolder, 0);
            tabItem.setText(startupOptionGroup.getTitle());
            Composite group = new Composite((Composite)tabFolder, 0);
            group.setLayout((Layout)new GridLayout(3, false));
            group.setLayoutData((Object)new GridData(4, 4, true, false));
            tabItem.setControl((Control)group);
            startupOptions = startupOptionGroup.getStartupOptions();
            for (final StartupOption startupOption : startupOptions) {
                Button checkbox = new Button(group, 32);
                checkbox.setSelection(startupOption.isChecked());
                checkbox.setText(startupOption.getUserFriendlyName());
                checkbox.setToolTipText(String.valueOf(startupOption.getName()) + ": " + startupOption.getDescription());
                startupOption.setCheckedWidget((Widget)checkbox);
                checkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        boolean checkedStatus = ((Button)e.widget).getSelection();
                        startupOption.setChecked(checkedStatus);
                        StartupOptionsComposite.this.notifyCompositeChangeListeners();
                    }
                });
                GridData checkboxData = new GridData(0, 4, false, false);
                checkbox.setLayoutData((Object)checkboxData);
                switch (startupOption.getType()) {
                    case 0: {
                        checkboxData.widthHint = -1;
                        checkboxData.horizontalSpan = 3;
                        checkbox.setLayoutData((Object)checkboxData);
                        break;
                    }
                    case 1: 
                    case 3: {
                        this.createWidgetsForTextOrNumberType(group, startupOption);
                        break;
                    }
                    case 2: {
                        this.createWidgetsForPathType(group, startupOption);
                    }
                }
            }
        }
        Composite commandLineArea = new Composite((Composite)mainComposite, 0);
        commandLineArea.setLayout((Layout)new GridLayout(2, false));
        data = new GridData(4, 4, true, true);
        commandLineArea.setLayoutData((Object)data);
        Label commandLineLabel = new Label(commandLineArea, 0);
        commandLineLabel.setText("");
        data = new GridData(4, 4, false, true);
        commandLineLabel.setLayoutData((Object)data);
        this.commandLine = new Text(commandLineArea, 2626);
        data = new GridData(4, 4, true, true);
        commandLineArea.pack();
        data.widthHint = commandLineArea.getBounds().width - commandLineLabel.getBounds().width;
        data.heightHint = commandLineArea.getBounds().height;
        this.commandLine.setLayoutData((Object)data);
        this.commandLine.setText(StartupOptionsMgt.getParamList());
        this.commandLine.setEditable(false);
    }

    private void createWidgetsForTextOrNumberType(final Composite parent, final StartupOption startupOption) {
        if (startupOption.getName().equals("-scale")) {
            final Text inputText = new Text(parent, 2052);
            inputText.setText(startupOption.getValue());
            startupOption.setValueWidget((Widget)inputText);
            inputText.setLayoutData((Object)new GridData(4, 0, true, false));
            inputText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    startupOption.setValue(inputText.getText());
                    StartupOptionsComposite.this.notifyCompositeChangeListeners();
                }
            });
            Button calc = new Button(parent, 8);
            calc.setText(EmulatorNLS.UI_DpiScale_Calculator);
            GridData calcData = new GridData(0, 0, false, false);
            calc.setLayoutData((Object)calcData);
            calc.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DpiScaleCalculatorDialog dialog = new DpiScaleCalculatorDialog(new Shell(parent.getShell()), StartupOptionsComposite.this.skin);
                    if (dialog.open() == 0) {
                        for (StartupOptionsGroup group : StartupOptionsMgt.getStartupOptionsGroupsList()) {
                            for (StartupOption startupOption : group.getStartupOptions()) {
                                if (!startupOption.getName().equals("-scale")) continue;
                                startupOption.setChecked(true);
                                startupOption.setValue(dialog.getResultScaleValue());
                                startupOption.updateUI();
                            }
                        }
                    }
                }
            });
            calc.setEnabled(this.canCalculateScale);
            if (!this.canCalculateScale) {
                ControlDecoration controlDecoration = new ControlDecoration((Control)inputText, 16512);
                controlDecoration.setDescriptionText(EmulatorNLS.StartupOptionsComposite_Error_Loading_Skin_Cant_Calculate_Scale);
                FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING");
                controlDecoration.setImage(fieldDecoration.getImage());
            }
        } else if (startupOption.getPreDefinedValues() == null || startupOption.getPreDefinedValues().size() == 0) {
            final Text inputText = new Text(parent, 2052);
            inputText.setText(startupOption.getValue());
            startupOption.setValueWidget((Widget)inputText);
            inputText.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            inputText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    startupOption.setValue(inputText.getText());
                    StartupOptionsComposite.this.notifyCompositeChangeListeners();
                }
            });
        } else {
            final Combo combo = new Combo(parent, 8);
            startupOption.setValueWidget((Widget)combo);
            int selectedIndex = 0;
            for (String preDefinedValue : startupOption.getPreDefinedValues()) {
                combo.add(preDefinedValue);
                if (startupOption.getValue().equals(preDefinedValue)) {
                    combo.select(selectedIndex);
                    continue;
                }
                ++selectedIndex;
            }
            combo.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            combo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    startupOption.setValue(combo.getText());
                    StartupOptionsComposite.this.notifyCompositeChangeListeners();
                }
            });
        }
    }

    private void createWidgetsForPathType(Composite parent, final StartupOption startupOption) {
        final Text pathText = new Text(parent, 2052);
        pathText.setText(startupOption.getValue());
        startupOption.setValueWidget((Widget)pathText);
        pathText.setLayoutData((Object)new GridData(4, 0, true, false));
        pathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                startupOption.setValue(pathText.getText());
                StartupOptionsComposite.this.notifyCompositeChangeListeners();
            }
        });
        Button pathBrowseButton = new Button(parent, 8);
        pathBrowseButton.setText(EmulatorNLS.UI_General_BrowseButtonLabel);
        GridData data = new GridData(0, 0, false, false);
        pathBrowseButton.setLayoutData((Object)data);
        pathBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selectedPath = null;
                if (startupOption.getTypeDetails().equalsIgnoreCase("dir")) {
                    DirectoryDialog directoryDialog = new DirectoryDialog(StartupOptionsComposite.this.getShell(), 4096);
                    selectedPath = directoryDialog.open();
                } else {
                    FileDialog fileDialog = new FileDialog(StartupOptionsComposite.this.getShell(), 4096);
                    String[] filterExtensions = new String[]{"*" + startupOption.getTypeDetails()};
                    fileDialog.setFilterExtensions(filterExtensions);
                    selectedPath = fileDialog.open();
                }
                if (selectedPath != null) {
                    pathText.setText(selectedPath);
                }
            }
        });
    }

    @Override
    protected void notifyCompositeChangeListeners() {
        this.commandLine.setText(StartupOptionsMgt.getParamList());
        super.notifyCompositeChangeListeners();
    }

    @Override
    public String getErrorMessage() {
        String errMsg = null;
        Status status = StartupOptionsMgt.validate();
        if (status.getSeverity() == 4) {
            errMsg = status.getMessage();
        }
        return errMsg;
    }

    public void reloadValues(String commandLine) {
        StartupOptionsMgt.loadFromCommandLine(commandLine);
    }
}

