/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.device.ui;

import java.util.Properties;
import org.eclipse.andmore.android.SdkUtils;
import org.eclipse.andmore.android.emulator.device.IDevicePropertiesConstants;
import org.eclipse.andmore.android.emulator.device.ui.AbstractPropertiesComposite;
import org.eclipse.andmore.android.emulator.device.ui.PropertiesMainComposite;
import org.eclipse.andmore.android.emulator.i18n.EmulatorNLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class InfoComposite
extends AbstractPropertiesComposite
implements IDevicePropertiesConstants {
    private boolean showEmulatorDefNotFoundMsg = false;
    private Properties emuPropertiesWorkingCopy;
    private String emuName;
    private PropertiesMainComposite mainComposite;
    private AbstractPropertiesComposite.PropertyCompositeChangeListener listener = new AbstractPropertiesComposite.PropertyCompositeChangeListener(){

        @Override
        public void compositeChanged(AbstractPropertiesComposite.PropertyCompositeChangeEvent e) {
            if (e.getSource() instanceof PropertiesMainComposite) {
                InfoComposite.this.emuPropertiesWorkingCopy.setProperty("Timeout", InfoComposite.this.mainComposite.getTimeout());
                InfoComposite.this.emuPropertiesWorkingCopy.setProperty("Skin_Plugin_Id", InfoComposite.this.mainComposite.getSkinId());
                InfoComposite.this.emuPropertiesWorkingCopy.setProperty("UseVnc", InfoComposite.this.mainComposite.getUseVnc());
                InfoComposite.this.emuPropertiesWorkingCopy.setProperty("UseProxy", InfoComposite.this.mainComposite.getUseProxy());
                InfoComposite.this.emuPropertiesWorkingCopy.setProperty("startFromSnapshot", InfoComposite.this.mainComposite.getstartFromSnapshot());
                InfoComposite.this.emuPropertiesWorkingCopy.setProperty("SaveSnapshot", InfoComposite.this.mainComposite.getSaveSnapshot());
                InfoComposite.this.emuPropertiesWorkingCopy.setProperty("Abi_Type", InfoComposite.this.mainComposite.getAbiType());
                InfoComposite.this.notifyCompositeChangeListeners();
            }
        }
    };

    public InfoComposite(Composite parent, Properties emuProperties, String emuName, boolean areOtherFieldsEditable) {
        super(parent);
        this.emuPropertiesWorkingCopy = (Properties)emuProperties.clone();
        this.emuName = emuName;
        this.createUI(areOtherFieldsEditable);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                AbstractPropertiesComposite.removeCompositeChangeListener(InfoComposite.this.listener);
                InfoComposite.this.dispose();
            }
        });
    }

    private void createUI(boolean editable) {
        GridLayout mainLayout = new GridLayout(1, false);
        mainLayout.marginWidth = 0;
        mainLayout.marginHeight = 0;
        this.setLayout((Layout)mainLayout);
        this.mainComposite = new PropertiesMainComposite(this, this.emuName, this.getProperty("Emulator_Type"), this.getProperty("Timeout"), Boolean.parseBoolean(this.getProperty("UseVnc")), Boolean.parseBoolean(this.getProperty("UseProxy")), Boolean.parseBoolean(this.getProperty("UseSnapshot")), Boolean.parseBoolean(this.getProperty("SaveSnapshot")), Boolean.parseBoolean(this.getProperty("startFromSnapshot")), SdkUtils.getTargetByName((String)this.getProperty("Vm_Target")), this.getProperty("Vm_Skin"), this.getProperty("Vm_Path"), this.getProperty("Abi_Type"), true, false, editable);
        this.mainComposite.setLayoutData(new GridData(4, 4, true, true));
        AbstractPropertiesComposite.addCompositeChangeListener(this.listener);
    }

    private String getProperty(String propertyName) {
        String emuProperty = this.emuPropertiesWorkingCopy.getProperty(propertyName);
        if (emuProperty == null) {
            emuProperty = "";
        }
        return emuProperty;
    }

    public Properties getPropertiesWorkingCopy() {
        return this.emuPropertiesWorkingCopy;
    }

    @Override
    public String getErrorMessage() {
        String errorMessage = this.mainComposite.getErrorMessage();
        return errorMessage;
    }

    public String getInfoMessage() {
        String infoMessage = null;
        if (this.showEmulatorDefNotFoundMsg) {
            infoMessage = EmulatorNLS.INFO_InfoComposite_EmulatorDefinitionNotFound;
        }
        return infoMessage;
    }
}

