/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.device.refresh;

import java.util.Collection;
import java.util.Properties;
import org.eclipse.andmore.android.SdkUtils;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.emulator.core.devfrm.DeviceFrameworkManager;
import org.eclipse.andmore.android.emulator.core.model.IAndroidEmulatorInstance;
import org.eclipse.andmore.android.emulator.device.AndroidDeviceUtils;
import org.eclipse.andmore.android.emulator.device.instance.AndroidDevInstBuilder;
import org.eclipse.andmore.android.emulator.device.instance.AndroidDeviceInstance;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.sequoyah.device.common.utilities.exception.SequoyahException;
import org.eclipse.sequoyah.device.framework.factory.DeviceTypeRegistry;
import org.eclipse.sequoyah.device.framework.manager.InstanceManager;
import org.eclipse.sequoyah.device.framework.model.IDeviceType;
import org.eclipse.sequoyah.device.framework.model.IInstanceBuilder;

public class InstancesListRefresh {
    public static synchronized void refresh() {
        SdkUtils.reloadAvds();
        DeviceFrameworkManager devFramework = DeviceFrameworkManager.getInstance();
        if (SdkUtils.getCurrentSdk() != null) {
            Collection vmInstances = SdkUtils.getAllVmNames();
            Collection validVmInstances = SdkUtils.getAllValidVmNames();
            Collection<String> emulatorInstances = devFramework.getAllInstanceNames();
            InstancesListRefresh.createAndUpdateEmulatorInstances(vmInstances, validVmInstances, emulatorInstances);
        }
    }

    public static void createAndUpdateEmulatorInstances(Collection<String> vmInstances, Collection<String> validVmInstances, Collection<String> emulatorInstances) {
        IDeviceType device = DeviceTypeRegistry.getInstance().getDeviceTypeById("org.eclipse.andmore.android.emulator.androidDevice");
        for (String instanceName : vmInstances) {
            if (emulatorInstances.contains(instanceName)) continue;
            Properties instanceProperties = new Properties();
            AndroidDeviceInstance.populateWithVMInfo(instanceName, instanceProperties);
            AndroidDeviceInstance.populateWithDefaultProperties(instanceProperties);
            AndroidDevInstBuilder projectBuilder = new AndroidDevInstBuilder(instanceName, instanceProperties);
            try {
                InstanceManager.createProject((IDeviceType)device, (IInstanceBuilder)projectBuilder, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (SequoyahException e) {
                AndmoreLogger.error((String)("There was an error while creating an emulator instance: " + instanceName + ". Message: " + e.getMessage()));
            }
            InstancesListRefresh.refreshStatus(validVmInstances, instanceName);
            AndmoreLogger.info((String)("Added instance " + instanceName + " using default emulator definitions "));
        }
        for (String emulatorInstance : emulatorInstances) {
            InstancesListRefresh.refreshStatus(validVmInstances, emulatorInstance);
        }
    }

    public static void refreshStatus(Collection<String> vmInstances, String instanceName) {
        IAndroidEmulatorInstance instance = DeviceFrameworkManager.getInstance().getInstanceByName(instanceName);
        AndroidDeviceInstance androidDeviceInstance = (AndroidDeviceInstance)instance;
        AndroidDeviceInstance.populateWithVMInfo(androidDeviceInstance.getName(), androidDeviceInstance.getProperties());
        String currentStatus = androidDeviceInstance.getStatus();
        if (androidDeviceInstance.hasDevice()) {
            if ((androidDeviceInstance.getStatus().equals("org.eclipse.andmore.android.emulator.status.notavailable") || androidDeviceInstance.getStatus().equals("OFF")) && !"org.eclipse.andmore.android.emulator.status.offlineNoData".equals(currentStatus)) {
                androidDeviceInstance.setNameSuffix(null);
                androidDeviceInstance.setStatus("org.eclipse.andmore.android.emulator.status.offlineNoData");
            }
            AndroidDeviceUtils.fireDummyStartTransition(androidDeviceInstance, androidDeviceInstance.getSerialNumber());
        } else if (vmInstances.contains(androidDeviceInstance.getName())) {
            if (androidDeviceInstance.isClean()) {
                if (!"org.eclipse.andmore.android.emulator.status.offlineNoData".equals(currentStatus)) {
                    androidDeviceInstance.setNameSuffix(null);
                    androidDeviceInstance.setStatus("org.eclipse.andmore.android.emulator.status.offlineNoData");
                }
            } else if (!"org.eclipse.andmore.android.emulator.status.offline".equals(currentStatus)) {
                androidDeviceInstance.setNameSuffix(null);
                androidDeviceInstance.setStatus("org.eclipse.andmore.android.emulator.status.offline");
            }
        } else if (!"org.eclipse.andmore.android.emulator.status.notavailable".equals(currentStatus)) {
            androidDeviceInstance.setNameSuffix(null);
            androidDeviceInstance.setStatus("org.eclipse.andmore.android.emulator.status.notavailable");
        }
    }
}

