/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.device.instance.options;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.emulator.EmulatorPlugin;
import org.eclipse.andmore.android.emulator.device.instance.options.IStartupOptionsConstants;
import org.eclipse.andmore.android.emulator.device.instance.options.StartupOption;
import org.eclipse.andmore.android.emulator.device.instance.options.StartupOptionsGroup;
import org.eclipse.andmore.android.emulator.i18n.EmulatorNLS;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class StartupOptionsMgt
implements IStartupOptionsConstants {
    private static List<StartupOptionsGroup> startupOptionsGroupsList = null;
    private static Map<String, StartupOption> startupOptionsMap = new HashMap<String, StartupOption>();

    static {
        StartupOptionsMgt.load();
    }

    public static List<StartupOptionsGroup> getStartupOptionsGroupsList() {
        return startupOptionsGroupsList;
    }

    public static void load() {
        try {
            startupOptionsGroupsList = new ArrayList<StartupOptionsGroup>();
            InputStream xmlStream = EmulatorPlugin.getDefault().getBundle().getEntry("resource/startup_options.xml").openStream();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(xmlStream);
            Element rootNode = document.getDocumentElement();
            NodeList startupOptionsGroups = rootNode.getElementsByTagName("group");
            int i = 0;
            while (i < startupOptionsGroups.getLength()) {
                Element group = (Element)startupOptionsGroups.item(i);
                String strKey = group.getAttributeNode("id").getNodeValue();
                strKey = Platform.getResourceString((Bundle)EmulatorPlugin.getDefault().getBundle(), (String)strKey);
                StartupOptionsGroup startupOptionsGroup = new StartupOptionsGroup(strKey);
                startupOptionsGroup.setTitle(startupOptionsGroup.getId());
                NodeList startupOptions = group.getElementsByTagName("startupOption");
                startupOptionsGroup.setStartupOptions(new ArrayList<StartupOption>());
                int j = 0;
                while (j < startupOptions.getLength()) {
                    Element option = (Element)startupOptions.item(j);
                    StartupOption startupOption = new StartupOption(option.getAttributeNode("name").getNodeValue(), StartupOptionsMgt.getStartupOptionType(option.getAttributeNode("type").getNodeValue()));
                    strKey = option.getAttributeNode("fName").getNodeValue();
                    strKey = Platform.getResourceString((Bundle)EmulatorPlugin.getDefault().getBundle(), (String)strKey);
                    startupOption.setUserFriendlyName(strKey);
                    strKey = option.getElementsByTagName("description").item(0).getTextContent();
                    strKey = Platform.getResourceString((Bundle)EmulatorPlugin.getDefault().getBundle(), (String)strKey);
                    startupOption.setDescription(strKey);
                    if (option.getAttributeNode("typeDetails") != null) {
                        startupOption.setTypeDetails(option.getAttributeNode("typeDetails").getNodeValue());
                    }
                    NodeList preDefinedValuesContainer = option.getElementsByTagName("values");
                    startupOption.setPreDefinedValues(new ArrayList<String>());
                    if (preDefinedValuesContainer.getLength() > 0) {
                        NodeList preDefinedValues = ((Element)preDefinedValuesContainer.item(0)).getElementsByTagName("value");
                        int k = 0;
                        while (k < preDefinedValues.getLength()) {
                            Element preDefinedValue = (Element)preDefinedValues.item(k);
                            startupOption.getPreDefinedValues().add(preDefinedValue.getTextContent());
                            ++k;
                        }
                    }
                    startupOptionsGroup.getStartupOptions().add(startupOption);
                    startupOptionsMap.put(startupOption.getName(), startupOption);
                    ++j;
                }
                startupOptionsGroupsList.add(startupOptionsGroup);
                ++i;
            }
        }
        catch (Exception exception) {
            AndmoreLogger.error((String)"Failed to load startup options");
        }
    }

    public static Status validate() {
        Status status = (Status)Status.OK_STATUS;
        String msg = null;
        block5: for (StartupOptionsGroup group : StartupOptionsMgt.getStartupOptionsGroupsList()) {
            for (StartupOption startupOption : group.getStartupOptions()) {
                if (!startupOption.isChecked() || !status.isOK()) continue;
                String name = startupOption.getName();
                String ufname = startupOption.getUserFriendlyName();
                String value = startupOption.getValue();
                String typeDetails = startupOption.getTypeDetails();
                if (!startupOption.getName().equals("other") && value.indexOf("\"") >= 0) {
                    msg = NLS.bind((String)EmulatorNLS.ERR_PropertiesMainComposite_StartupOpt_NoQuotes, (Object)ufname);
                } else {
                    switch (startupOption.getType()) {
                        case 1: {
                            msg = StartupOptionsMgt.validateTextField(name, ufname, value, typeDetails);
                            break;
                        }
                        case 3: {
                            msg = StartupOptionsMgt.validadeNumberField(name, ufname, value, typeDetails);
                            break;
                        }
                        case 2: {
                            msg = StartupOptionsMgt.validadePathField(name, ufname, value, typeDetails);
                        }
                    }
                }
                if (msg == null) continue;
                status = new Status(4, "org.eclipse.andmore.android.emulator", msg);
                continue block5;
            }
        }
        return status;
    }

    private static String validateTextField(String name, String ufName, String value, String typeDetails) {
        String msg = null;
        if (value == null || value.equals("")) {
            msg = NLS.bind((String)EmulatorNLS.ERR_PropertiesMainComposite_StartupOpt_TextBlank, (Object)ufName);
        }
        return msg;
    }

    private static String validadeNumberField(String name, String ufName, String value, String typeDetails) {
        String msg = null;
        if (value == null || value.equals("")) {
            msg = NLS.bind((String)EmulatorNLS.ERR_PropertiesMainComposite_StartupOpt_NumberRequired, (Object)ufName);
        } else {
            try {
                String[] valueRange;
                int intValue = Integer.parseInt(value);
                if (intValue < 0) {
                    msg = NLS.bind((String)EmulatorNLS.ERR_PropertiesMainComposite_StartupOpt_NumberMustBePositiveInteger, (Object)ufName);
                } else if (typeDetails != null && (intValue < Integer.parseInt((valueRange = typeDetails.split(";"))[0]) || intValue > Integer.parseInt(valueRange[1]))) {
                    msg = NLS.bind((String)EmulatorNLS.ERR_PropertiesMainComposite_StartupOpt_NumberIntRange, (Object[])new String[]{ufName, valueRange[0], valueRange[1]});
                }
            }
            catch (NumberFormatException numberFormatException) {
                msg = NLS.bind((String)EmulatorNLS.ERR_PropertiesMainComposite_StartupOpt_NumberMustBeInteger, (Object)ufName);
            }
        }
        return msg;
    }

    private static String validadePathField(String name, String ufName, String value, String typeDetails) {
        String msg = null;
        if (value == null || value.equals("")) {
            msg = NLS.bind((String)EmulatorNLS.ERR_PropertiesMainComposite_StartupOpt_PathRequired, (Object)ufName);
        } else {
            File file = new File(value);
            if (typeDetails.equals("dir")) {
                if (!file.exists()) {
                    msg = NLS.bind((String)EmulatorNLS.ERR_PropertiesMainComposite_StartupOpt_PathDirNotExist, (Object)ufName);
                } else if (file.isFile()) {
                    msg = NLS.bind((String)EmulatorNLS.ERR_PropertiesMainComposite_StartupOpt_PathMustBeDir, (Object)ufName);
                }
            } else if (!file.exists()) {
                msg = NLS.bind((String)EmulatorNLS.ERR_PropertiesMainComposite_StartupOpt_PathFileNotExist, (Object)ufName);
            } else if (file.isDirectory()) {
                msg = NLS.bind((String)EmulatorNLS.ERR_PropertiesMainComposite_StartupOpt_PathMustBeFile, (Object)ufName);
            } else if (!typeDetails.equals("." + new Path(value).getFileExtension())) {
                msg = NLS.bind((String)EmulatorNLS.ERR_PropertiesMainComposite_StartupOpt_PathIncorrectFileType, (Object[])new String[]{ufName, typeDetails});
            }
        }
        return msg;
    }

    public static String getParamList() {
        String paramList = "";
        for (StartupOptionsGroup group : StartupOptionsMgt.getStartupOptionsGroupsList()) {
            for (StartupOption startupOption : group.getStartupOptions()) {
                int startupOptionType = startupOption.getType();
                if (!startupOption.isChecked()) continue;
                if (startupOptionType == 0) {
                    paramList = String.valueOf(paramList) + (paramList.equals("") ? "" : " ") + startupOption.getName();
                    continue;
                }
                if (startupOption.getName().equals("other")) {
                    paramList = String.valueOf(paramList) + (paramList.equals("") ? "" : " ") + startupOption.getValue();
                    continue;
                }
                String value = startupOption.getValue();
                if (Platform.getOS().equals("win32")) {
                    if (value.contains(" ")) {
                        value = "\"" + value + "\"";
                    }
                } else {
                    if (value.contains("\\")) {
                        value = value.replace("\\", "\\\\");
                    }
                    if (value.contains(" ")) {
                        value = value.replace(" ", "\\ ");
                    }
                }
                paramList = String.valueOf(paramList) + (paramList.equals("") ? "" : " ") + startupOption.getName() + (value.trim().length() > 0 ? " " + value : "");
            }
        }
        return paramList;
    }

    private static void loadValues(Properties properties) {
        for (StartupOptionsGroup group : StartupOptionsMgt.getStartupOptionsGroupsList()) {
            String soValue = "";
            for (StartupOption startupOption : group.getStartupOptions()) {
                soValue = properties.getProperty(startupOption.getName());
                if (soValue != null) {
                    startupOption.setChecked(true);
                    startupOption.setValue(soValue);
                } else {
                    startupOption.setChecked(false);
                    startupOption.setValue("");
                }
                startupOption.updateUI();
            }
        }
    }

    public static Properties parseCommandLine(String commandLine) {
        Properties properties = new Properties();
        if (!commandLine.equals("")) {
            for (StartupOptionsGroup group : StartupOptionsMgt.getStartupOptionsGroupsList()) {
                String soValue = "";
                int shift = 0;
                for (StartupOption startupOption : group.getStartupOptions()) {
                    String soName = startupOption.getName();
                    int soType = startupOption.getType();
                    if (!commandLine.startsWith(soName)) continue;
                    if (soType == 0) {
                        soValue = new Boolean(true).toString();
                        shift = soName.length() + 1;
                    } else {
                        commandLine = commandLine.substring(soName.length() + 1, commandLine.length());
                        ParameterBean param = StartupOptionsMgt.getNextParameterValue(commandLine);
                        soValue = param.getValue();
                        shift = param.getLastPosition() + 1;
                    }
                    properties.put(startupOption.getName(), soValue);
                    commandLine = shift < commandLine.length() - 1 ? commandLine.substring(shift, commandLine.length()) : "";
                }
            }
            if (!commandLine.equals("")) {
                properties.put("other", commandLine);
            }
        }
        return properties;
    }

    public static void loadFromCommandLine(String commandLine) {
        StartupOptionsMgt.loadValues(StartupOptionsMgt.parseCommandLine(commandLine));
    }

    private static int getStartupOptionType(String type) {
        return (Integer)TYPE_MAP.get(type);
    }

    private static ParameterBean getNextParameterValue(String commandLine) {
        boolean isWin32 = Platform.getOS().equals("win32");
        boolean escaped = false;
        boolean quoted = false;
        String value = "";
        int i = 0;
        while (i < commandLine.length()) {
            char c = commandLine.charAt(i);
            if (escaped) {
                value = String.valueOf(value) + c;
                escaped = false;
            } else if (c == '\\' && !isWin32) {
                escaped = true;
            } else if (c == '\"' && isWin32) {
                if (value.length() == 0) {
                    quoted = true;
                } else {
                    if (quoted) break;
                    value = String.valueOf(value) + c;
                }
            } else {
                if (c == ' ' && !quoted) break;
                value = String.valueOf(value) + c;
            }
            ++i;
        }
        return new ParameterBean(value, quoted ? i + 1 : i);
    }

    private static class ParameterBean {
        private final String value;
        private final int lastPosition;

        public ParameterBean(String value, int lastPosition) {
            this.value = value;
            this.lastPosition = lastPosition;
        }

        public String getValue() {
            return this.value;
        }

        public int getLastPosition() {
            return this.lastPosition;
        }
    }
}

