/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.device.init;

import java.util.List;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.emulator.logic.IAndroidLogicInstance;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.sequoyah.device.framework.events.InstanceEvent;
import org.eclipse.sequoyah.device.framework.events.InstanceEventManager;
import org.eclipse.sequoyah.device.framework.model.IInstance;
import org.eclipse.sequoyah.device.framework.model.IService;
import org.eclipse.sequoyah.device.framework.model.handler.IServiceHandler;

public class InitServiceHandler
implements IServiceHandler {
    private IServiceHandler parent;
    private IService service;

    public void run(IInstance instance) {
        if (instance instanceof IAndroidLogicInstance) {
            instance.setStatus("org.eclipse.andmore.android.emulator.status.notavailable");
            InstanceEventManager.getInstance().notifyListeners(new InstanceEvent(InstanceEvent.InstanceEventType.INSTANCE_TRANSITIONED, instance));
        }
    }

    public IServiceHandler newInstance() {
        return new InitServiceHandler();
    }

    public void setParent(IServiceHandler handler) {
        this.parent = handler;
    }

    public void setService(IService service) {
        this.service = service;
    }

    public void updatingService(IInstance instance) {
        AndmoreLogger.info((String)"Updating init emulator service");
    }

    public Object clone() {
        IServiceHandler newHandler = this.newInstance();
        newHandler.setParent(this.parent);
        newHandler.setService(this.service);
        return newHandler;
    }

    public IServiceHandler getParent() {
        return this.parent;
    }

    public IService getService() {
        return this.service;
    }

    public IStatus singleInit(List<IInstance> instances) {
        return Status.OK_STATUS;
    }
}

