/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.core.skin;

import java.util.HashMap;
import java.util.Map;

public class AndroidSkinBean {
    private final Map<String, Integer> skinPropertiesMap = new HashMap<String, Integer>();

    public void addSkinPropertyValue(String key, int value) {
        this.skinPropertiesMap.put(key, value);
    }

    public int getSkinPropertyValue(String key) {
        if (this.skinPropertiesMap.get(key) != null) {
            return this.skinPropertiesMap.get(key);
        }
        return 0;
    }

    public boolean isOpenExternalDisplayAvailable() {
        boolean result = true;
        Integer testObj1 = this.skinPropertiesMap.get("openExternalViewWidth");
        Integer testObj2 = this.skinPropertiesMap.get("openExternalViewHeight");
        if (testObj1 == null || testObj2 == null) {
            result = false;
        }
        return result;
    }

    public boolean isExternalDisplayAvailable() {
        boolean result = true;
        Integer testObj1 = this.skinPropertiesMap.get("externalViewWidth");
        Integer testObj2 = this.skinPropertiesMap.get("externalViewHeight");
        if (testObj1 == null || testObj2 == null) {
            result = false;
        }
        return result;
    }

    public double getEmbeddedViewScale() {
        Integer testObj1 = this.skinPropertiesMap.get("embeddedViewScale");
        return (double)testObj1.intValue() / 10.0;
    }
}

