/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.core.emulationui;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.emulator.core.devfrm.DeviceFrameworkManager;
import org.eclipse.andmore.android.emulator.core.emulationui.EmuViewerNode;
import org.eclipse.andmore.android.emulator.core.emulationui.EmuViewerRootNode;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IViewSite;

public abstract class AbstractEmuCtProvider
implements ITreeContentProvider {
    public static final String SENT_TO_EMULATOR_ID = "sent_to";
    public static final String RECEIVE_FROM_EMULATOR_ID = "received_from";
    private static IViewSite treeParent;

    public Object getParent(Object element) {
        Object parent = null;
        if (element instanceof EmuViewerNode) {
            EmuViewerNode nodeElement = (EmuViewerNode)element;
            parent = nodeElement instanceof EmuViewerRootNode ? treeParent : nodeElement.getParent();
        } else {
            AndmoreLogger.warn((String)"Tried to get parent of an object that is not an emulation tree node");
        }
        return parent;
    }

    public boolean hasChildren(Object object) {
        boolean hasChildren = false;
        if (object instanceof EmuViewerNode) {
            EmuViewerNode nodeObject = (EmuViewerNode)object;
            hasChildren = nodeObject.getChildren().size() > 0;
        } else {
            AndmoreLogger.warn((String)"Tried to test if an object that is not an emulation tree node has children");
        }
        return hasChildren;
    }

    public Object[] getElements(Object parent) {
        Object[] elements;
        if (parent instanceof IViewSite) {
            if (treeParent == null) {
                treeParent = (IViewSite)parent;
            }
            HashSet<EmuViewerRootNode> emuNodeCollection = new HashSet<EmuViewerRootNode>();
            Set<String> hostSet = DeviceFrameworkManager.getInstance().getAllStartedInstancesHosts();
            for (String host : hostSet) {
                EmuViewerRootNode node = new EmuViewerRootNode(host);
                emuNodeCollection.add(node);
                this.addChildrenToRootNode(node);
            }
            Object[] emuNodeArray = emuNodeCollection.toArray(new Object[emuNodeCollection.size()]);
            elements = emuNodeArray;
        } else {
            elements = this.getChildren(parent);
        }
        return elements;
    }

    public Object[] getChildren(Object parent) {
        Object[] returnArray;
        if (parent instanceof EmuViewerNode) {
            EmuViewerNode parentNode = (EmuViewerNode)parent;
            Set<EmuViewerNode> childrenCollection = parentNode.getChildren();
            if (parentNode instanceof EmuViewerRootNode) {
                String host = ((EmuViewerRootNode)parentNode).getEmulatorIdentifier();
                for (EmuViewerNode child : childrenCollection) {
                    if (child.getChildren().size() != 0) continue;
                    this.addChildrenToLeafParentNode(child, host);
                }
            }
            returnArray = childrenCollection.toArray(new EmuViewerNode[childrenCollection.size()]);
        } else {
            AndmoreLogger.warn((String)"Tried to get children of an object that is not an emulation tree node");
            returnArray = new Object[]{};
        }
        return returnArray;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
    }

    protected void addChildrenToRootNode(EmuViewerRootNode root) {
        root.addChild(new EmuViewerNode(root, RECEIVE_FROM_EMULATOR_ID));
        root.addChild(new EmuViewerNode(root, SENT_TO_EMULATOR_ID));
    }

    protected abstract void addChildrenToLeafParentNode(EmuViewerNode var1, String var2);
}

