/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.devices.services.lang.model;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.devices.services.DeviceServicesPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Country {
    private static final String FILE_PATH = "resources/iso_3166-1_list_en.xml";
    private static final String COUNTRY_NODE = "ISO_3166-1_Entry";
    private static final String COUNTRY_NAME = "ISO_3166-1_Country_name";
    private static final String COUNTRY_ID = "ISO_3166-1_Alpha-2_Code_element";
    private static List<Country> countryList = null;
    private static Map<String, Country> countryMap = null;
    private String name;
    private String id;

    public static List<Country> getCountryList() {
        if (countryList == null) {
            Country.loadCountries();
        }
        return countryList;
    }

    private static void loadCountries() {
        countryList = new ArrayList<Country>();
        countryMap = new HashMap<String, Country>();
        URL countriesURL = DeviceServicesPlugin.getDefault().getBundle().getResource(FILE_PATH);
        try {
            InputStream countriesIS = countriesURL.openStream();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(countriesIS);
            NodeList list = document.getDocumentElement().getElementsByTagName(COUNTRY_NODE);
            int i = 0;
            while (i < list.getLength()) {
                Element countryNode = (Element)list.item(i);
                String name = countryNode.getElementsByTagName(COUNTRY_NAME).item(0).getChildNodes().item(0).getNodeValue();
                String ID = countryNode.getElementsByTagName(COUNTRY_ID).item(0).getChildNodes().item(0).getNodeValue();
                if (ID != null && !ID.equals("") && name != null && !name.equals("")) {
                    Country country = new Country(name, ID);
                    countryList.add(country);
                    countryMap.put(name, country);
                }
                ++i;
            }
        }
        catch (Exception exception) {
            AndmoreLogger.error((String)"Change Language TmL Service: could not load countries list");
        }
    }

    public static String getIdFromName(String countryName) {
        String id = null;
        Country country = countryMap.get(countryName);
        if (country != null) {
            id = country.getId();
        }
        return id;
    }

    public Country(String name, String id) {
        this.name = name;
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

