/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.hierarchyviewer.views;

import com.android.hierarchyviewerlib.actions.InspectScreenshotAction;
import com.android.hierarchyviewerlib.actions.LoadViewHierarchyAction;
import com.android.hierarchyviewerlib.actions.RefreshWindowsAction;
import com.android.hierarchyviewerlib.ui.DeviceSelector;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.part.ViewPart;

public class DeviceSelectorView
extends ViewPart
implements IPerspectiveListener {
    public static final String ID = "org.eclipse.andmore.hierarchyviewer.views.DeviceSelectorView";
    private DeviceSelector mDeviceSelector;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        IPerspectiveDescriptor perspective = this.getViewSite().getPage().getPerspective();
        boolean doTreeViewStuff = true;
        boolean doPixelPerfectStuff = true;
        if (perspective.getId().equals("org.eclipse.andmore.hierarchyviewer.PixelPerfectPespective")) {
            doTreeViewStuff = false;
        } else if (perspective.getId().equals("org.eclipse.andmore.hierarchyviewer.TreeViewPerspective")) {
            doPixelPerfectStuff = false;
        }
        this.mDeviceSelector = new DeviceSelector(parent, doTreeViewStuff, doPixelPerfectStuff);
        this.placeActions(doTreeViewStuff, doPixelPerfectStuff);
        this.getViewSite().getWorkbenchWindow().addPerspectiveListener((IPerspectiveListener)this);
    }

    public void dispose() {
        super.dispose();
        this.getViewSite().getWorkbenchWindow().removePerspectiveListener((IPerspectiveListener)this);
    }

    private void placeActions(boolean doTreeViewStuff, boolean doPixelPerfectStuff) {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IMenuManager mm = actionBars.getMenuManager();
        mm.removeAll();
        mm.add((IAction)RefreshWindowsAction.getAction());
        IToolBarManager tm = actionBars.getToolBarManager();
        tm.removeAll();
        tm.add((IAction)RefreshWindowsAction.getAction());
        if (doTreeViewStuff) {
            mm.add((IAction)LoadViewHierarchyAction.getAction());
            tm.add((IAction)LoadViewHierarchyAction.getAction());
        }
        if (doPixelPerfectStuff) {
            mm.add((IAction)InspectScreenshotAction.getAction());
            tm.add((IAction)InspectScreenshotAction.getAction());
        }
        mm.updateAll(true);
        tm.update(true);
        actionBars.updateActionBars();
    }

    public void setFocus() {
        this.mDeviceSelector.setFocus();
    }

    public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        if (perspective.getId().equals("org.eclipse.andmore.hierarchyviewer.PixelPerfectPespective")) {
            this.mDeviceSelector.setMode(false, true);
            this.placeActions(false, true);
        } else if (perspective.getId().equals("org.eclipse.andmore.hierarchyviewer.TreeViewPerspective")) {
            this.mDeviceSelector.setMode(true, false);
            this.placeActions(true, false);
        } else {
            this.mDeviceSelector.setMode(true, true);
            this.placeActions(true, true);
        }
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
    }
}

