local BB = LibStub("LibBabble-Boss-3.0"):GetLookupTable()
local BZ = LibStub("LibBabble-Zone-3.0"):GetLookupTable()
local L = LibStub("AceLocale-3.0"):GetLocale("Mendeleev")

local classes = {}
FillLocalizedClassList(classes, false)

MENDELEEV_SETS = {
	{
		name = L["Gathering skills"],
		setindex = "Tradeskill.Gather",
		colour = "|cff8470FF",
		header = L["Gathering skills"],
		quality = 1,
		sets = {
			["Tradeskill.Gather.Disenchant"] = GetSpellInfo(13262),
			["Tradeskill.Gather.Fishing"] = GetSpellInfo(13615),
			["Tradeskill.Gather.Herbalism"] = GetSpellInfo(9134),
			["Tradeskill.Gather.Milling"] = GetSpellInfo(51005),
			["Tradeskill.Gather.Mining"] = GetSpellInfo(12560),
			["Tradeskill.Gather.Pickpocketing"] = GetSpellInfo(5167),
			["Tradeskill.Gather.Prospecting"] = GetSpellInfo(32177),
			["Tradeskill.Gather.Skinning"] = GetSpellInfo(13697),
		},
	},
	{
		name = L["Crafted by"],
		setindex = "Tradeskill.Crafted",
		colour = "|cff8470ff",
		header = L["Crafted by"],
		useval = function (v) return " ("..v..")" end,
		quality = 1,
		sets = {
			["Tradeskill.Crafted.Alchemy"] = GetSpellInfo(2259),
			["Tradeskill.Crafted.Archaeology"]= GetSpellInfo(78670),
			["Tradeskill.Crafted.Blacksmithing"] = GetSpellInfo(2018),
			["Tradeskill.Crafted.Cooking"] = GetSpellInfo(2550),
			["Tradeskill.Crafted.Enchanting"] = GetSpellInfo(7411),
			["Tradeskill.Crafted.Engineering.Basic"] = GetSpellInfo(4036),
			["Tradeskill.Crafted.Engineering.Gnomish"] = GetSpellInfo(20220),
			["Tradeskill.Crafted.Engineering.Goblin"] = GetSpellInfo(20221),
			["Tradeskill.Crafted.First Aid"] = GetSpellInfo(3273),
			["Tradeskill.Crafted.Inscription"] = GetSpellInfo(45357),
			["Tradeskill.Crafted.Jewelcrafting"] = GetSpellInfo(25229),
			["Tradeskill.Crafted.Leatherworking"] = GetSpellInfo(2108),
			["Tradeskill.Crafted.Smelting"] = GetSpellInfo(2656),
			["Tradeskill.Crafted.Tailoring"] = GetSpellInfo(3908),
		},
	},
	{
		name = L["Mine Gems"],
		setindex = "Tradeskill.Gather.GemsInNodes",
		colour = "|cffB0C4DE",
		header = L["Found in"],
		quality = 1,
		sets = {
			["Tradeskill.Gather.GemsInNodes.Copper Vein"] = L["Copper Vein"],
			["Tradeskill.Gather.GemsInNodes.Incendicite Mineral Vein"] = L["Incendicite Mineral Vein"],
			["Tradeskill.Gather.GemsInNodes.Tin Vein"] = L["Tin Vein"],
			["Tradeskill.Gather.GemsInNodes.Lesser Bloodstone Deposit"] = L["Lesser Bloodstone Deposit"],
			["Tradeskill.Gather.GemsInNodes.Ooze Covered Silver Vein"] = L["Ooze Covered Silver Vein"],
			["Tradeskill.Gather.GemsInNodes.Silver Vein"] = L["Silver Vein"],
			["Tradeskill.Gather.GemsInNodes.Iron Deposit"] = L["Iron Deposit"],
			["Tradeskill.Gather.GemsInNodes.Indurium Mineral Vein"] = L["Indurium Mineral Vein"],
			["Tradeskill.Gather.GemsInNodes.Gold Vein"] = L["Gold Vein"],
			["Tradeskill.Gather.GemsInNodes.Ooze Covered Gold Vein"] = L["Ooze Covered Gold Vein"],
			["Tradeskill.Gather.GemsInNodes.Mithril Deposit"] = L["Mithril Deposit"],
			["Tradeskill.Gather.GemsInNodes.Ooze Covered Mithril Deposit"] = L["Ooze Covered Mithril Deposit"],
			["Tradeskill.Gather.GemsInNodes.Ooze Covered Truesilver Deposit"] = L["Ooze Covered Truesilver Deposit"],
			["Tradeskill.Gather.GemsInNodes.Truesilver Deposit"] = L["Truesilver Deposit"],
			["Tradeskill.Gather.GemsInNodes.Dark Iron Deposit"] = L["Dark Iron Deposit"],
			["Tradeskill.Gather.GemsInNodes.Ooze Covered Thorium Vein"] = L["Ooze Covered Thorium Vein"],
			["Tradeskill.Gather.GemsInNodes.Small Thorium Vein"] = L["Small Thorium Vein"],
			["Tradeskill.Gather.GemsInNodes.Ooze Covered Rich Thorium Vein"] = L["Ooze Covered Rich Thorium Vein"],
			["Tradeskill.Gather.GemsInNodes.Rich Thorium Vein"] = L["Rich Thorium Vein"],
			["Tradeskill.Gather.GemsInNodes.Fel Iron Deposit"] = L["Fel Iron Deposit"],
			["Tradeskill.Gather.GemsInNodes.Nethercite Deposit"] = L["Nethercite Deposit"],
			["Tradeskill.Gather.GemsInNodes.Large Obsidian Chunk"] = L["Large Obsidian Chunk"],
			["Tradeskill.Gather.GemsInNodes.Small Obsidian Chunk"] = L["Small Obsidian Chunk"],
			["Tradeskill.Gather.GemsInNodes.Adamantite Deposit"] = L["Adamantite Deposit"],
			["Tradeskill.Gather.GemsInNodes.Cobalt Deposit"] = L["Cobalt Deposit"],
			["Tradeskill.Gather.GemsInNodes.Rich Adamantite Deposit"] = L["Rich Adamantite Deposit"],
			["Tradeskill.Gather.GemsInNodes.Ancient Gem Vein"] = L["Ancient Gem Vein"],
			["Tradeskill.Gather.GemsInNodes.Khorium Vein"] = L["Khorium Vein"],
			["Tradeskill.Gather.GemsInNodes.Rich Cobalt Deposit"] = L["Rich Cobalt Deposit"],
			["Tradeskill.Gather.GemsInNodes.Saronite Deposit"] = L["Saronite Deposit"],
			["Tradeskill.Gather.GemsInNodes.Obsidium Deposit"] = L["Obsidium Deposit"],
			["Tradeskill.Gather.GemsInNodes.Rich Saronite Deposit"] = L["Rich Saronite Deposit"],
			["Tradeskill.Gather.GemsInNodes.Pure Saronite Deposit"] = L["Pure Saronite Deposit"],
			["Tradeskill.Gather.GemsInNodes.Rich Obsidium Deposit"] = L["Rich Obsidium Deposit"],
			["Tradeskill.Gather.GemsInNodes.Titanium Vein"] = L["Titanium Vein"],
			["Tradeskill.Gather.GemsInNodes.Elementium Vein"] = L["Elementium Vein"],
			["Tradeskill.Gather.GemsInNodes.Rich Elementium Vein"] = L["Rich Elementium Vein"],
			["Tradeskill.Gather.GemsInNodes.Pyrite Deposit"] = L["Pyrite Deposit"],
			["Tradeskill.Gather.GemsInNodes.Rich Pyrite Deposit"] = L["Rich Pyrite Deposit"],
			["Tradeskill.Gather.GemsInNodes.Ghost Iron Deposit"] = L["Ghost Iron Deposit"],
			["Tradeskill.Gather.GemsInNodes.Rich Ghost Iron Deposit"] = L["Rich Ghost Iron Deposit"],
			["Tradeskill.Gather.GemsInNodes.Kyparite Deposit"] = L["Kyparite Deposit"],
			["Tradeskill.Gather.GemsInNodes.Rich Kyparite Deposit"] = L["Rich Kyparite Deposit"],
			["Tradeskill.Gather.GemsInNodes.Trillium Vein"] = L["Trillium Vein"],
			["Tradeskill.Gather.GemsInNodes.Rich Trillium Vein"] = L["Rich Trillium Vein"],
		},
	},
	{
		name = L["Trade skills"],
		setindex = "Tradeskill.Mat.ByProfession",
		colour = "|cffF5DEB3",
		header = L["Component in"],
		quality = 1,
		descfunc = function(skill, reagent) return Mendeleev:GetLinesForTradeskillReagent(skill, reagent) end,
		sets = {
			["Tradeskill.Mat.ByProfession.Alchemy"] = "Alchemy",
			["Tradeskill.Mat.ByProfession.Archaeology"] = "Archaeology",
			["Tradeskill.Mat.ByProfession.Blacksmithing"] = "Blacksmithing",
			["Tradeskill.Mat.ByProfession.Cooking"] = "Cooking",
			["Tradeskill.Mat.ByProfession.Enchanting"] = "Enchanting",
			["Tradeskill.Mat.ByProfession.Engineering.Basic"] = "Engineering.Basic",
			["Tradeskill.Mat.ByProfession.Engineering.Gnomish"] = "Engineering.Gnomish",
			["Tradeskill.Mat.ByProfession.Engineering.Goblin"] = "Engineering.Goblin",
			["Tradeskill.Mat.ByProfession.First Aid"] = "First Aid",
			["Tradeskill.Mat.ByProfession.Inscription"] = "Inscription",
			["Tradeskill.Mat.ByProfession.Jewelcrafting"] = "Jewelcrafting",
			["Tradeskill.Mat.ByProfession.Leatherworking"] = "Leatherworking",
			["Tradeskill.Mat.ByProfession.Smelting"] = "Smelting",
			["Tradeskill.Mat.ByProfession.Tailoring"] = "Tailoring",
		},
	},
	{
		name = L["Class Reagents"],
		setindex = "Misc.Reagent.Class",
		colour = "|cffff00ff",
		header = L["Classes"],
		quality = 1,
		sets = {
			["Misc.Reagent.Class.Death Knight"] = classes["DEATHKNIGHT"],
			["Misc.Reagent.Class.Druid"] = classes["DRUID"],
			["Misc.Reagent.Class.Hunter"] = classes["HUNTER"],
			["Misc.Reagent.Class.Mage"] = classes["MAGE"],
			["Misc.Reagent.Class.Monk"] = classes["MONK"],
			["Misc.Reagent.Class.Paladin"] = classes["PALADIN"],
			["Misc.Reagent.Class.Priest"] = classes["PRIEST"],
			["Misc.Reagent.Class.Rogue"] = classes["ROGUE"],
			["Misc.Reagent.Class.Shaman"] = classes["SHAMAN"],
			["Misc.Reagent.Class.Warlock"] = classes["WARLOCK"],
			["Misc.Reagent.Class.Warrior"] = classes["WARRIOR"],
		},
	},
	{
		name = L["Food type"],
		setindex = "Consumable.Food",
		colour = "|cff87CEFA",
		header = L["Food type"],
		quality = 1,
		sets = {
			["Consumable.Food.Bread"] = L["Bread"],
			["Consumable.Food.Fish"] = L["Fish"],
			["Consumable.Food.Meat"] = L["Meat"],
			["Consumable.Food.Cheese"] = L["Cheese"],
			["Consumable.Food.Fruit"] = L["Fruit"],
			["Consumable.Food.Fungus"] = L["Fungus"],
			["Consumable.Food.Misc"] = L["Misc"],
		},
	},
	{
		name = L["Recipe source"],
		setindex = "Tradeskill.Recipe",
		colour = "|cff8470FF",
		header = L["Recipe source"],
		useval = function (v) return " ("..v..")" end,
		--PT3's value is minimum skill and not price
		--[[useval = function (v)
			v = math.floor(v)
			if v == 0 then return "" end
			local g = v > 9999 and floor(v/10000) or 0
			v = v-(g*10000)
			local s = v > 99 and floor(v/100) or 0
			v = v-(s*100)
			local c = v
			return " ("..(g>0 and (g.."g ") or "").. (((g+s)>0) and (s.."s ") or "").. c.. "c)"
		end, ]]
		quality = 1,
		sets = {
			["Tradeskill.Recipe.Vendor"] = L["Vendor"],
			["Tradeskill.Recipe.Drop"] = L["Drop"],
			["Tradeskill.Recipe.Quest"] = L["Quest"],
			["Tradeskill.Recipe.Crafted"] = L["Crafted"],
		},
	},
	{
		name = L["Booze"],
		setindex = "Misc",
		colour = "|cffB0C4DE",
		header = " ",
		useval = function (v) return string.format(L["%d%% alc/vol (%d proof)"], v, v*2) end,
		quality = 1,
		sets = {
			["Misc.Booze"] = L["Booze"],
		},
	},
	{
		name = L["Darkmoon Faire"],
		setindex = "QuestMats.Darkmoon Faire.Turnin",
		colour = "|cffFFFF00",
		header = L["Darkmoon Faire"],
		useval = function (v) return string.format(L[" (%d tickets)"], v) end,
		quality = 1,
		sets = {
			["Misc.QuestMats.Darkmoon Faire.Turnin.Engineering"] = GetSpellInfo(4036),
			["Misc.QuestMats.Darkmoon Faire.Turnin.Greys"] = L["Junk Items"],
			["Misc.QuestMats.Darkmoon Faire.Turnin.Leather"] = L["Leather"],
			["Misc.QuestMats.Darkmoon Faire.Turnin.Blacksmithing"] = GetSpellInfo(2018),
		},
	},
	{
		name = L["Darkmoon Faire Card"],
		setindex = "Misc.QuestMats.Darkmoon Faire.Deck",
		colour = "|cffFFFF00",
		header = L["Darkmoon Faire Card"],
		quality = 1,
		sets = {
			["Misc.QuestMats.Darkmoon Faire.Deck.Beasts"] = L["Blue Dragon Card"],
			["Misc.QuestMats.Darkmoon Faire.Deck.Elementals"] = L["Maelstrom Card"],
			["Misc.QuestMats.Darkmoon Faire.Deck.Portals"] = L["Twisting Nether Card"],
			["Misc.QuestMats.Darkmoon Faire.Deck.Warlords"] = L["Heroism Card"],
			["Misc.QuestMats.Darkmoon Faire.Deck.Blessings"] = L["Crusade Card"],
			["Misc.QuestMats.Darkmoon Faire.Deck.Furies"] = L["Vengeance Card"],
			["Misc.QuestMats.Darkmoon Faire.Deck.Lunacy"] = L["Madness Card"],
			["Misc.QuestMats.Darkmoon Faire.Deck.Storms"] = L["Wrath Card"],
			["Misc.QuestMats.Darkmoon Faire.Deck.Chaos"] = L["Berserker! Card"],
			["Misc.QuestMats.Darkmoon Faire.Deck.Nobles"] = L["Greatness Card"],
			["Misc.QuestMats.Darkmoon Faire.Deck.Prisms"] = L["Illusion Card"],
			["Misc.QuestMats.Darkmoon Faire.Deck.Undeath"] = L["Death Card"],
			["Misc.QuestMats.Darkmoon Faire.Deck.Volcanic"] = L["Volcano Card"],
			["Misc.QuestMats.Darkmoon Faire.Deck.Tsunami"] = L["Tsunami Card"],
			["Misc.QuestMats.Darkmoon Faire.Deck.Hurricane"] = L["Hurricane Card"],
			["Misc.QuestMats.Darkmoon Faire.Deck.Earthquake"] = L["Earthquake Card"],
		},
	},
	{
		name = L["Lockpicking"],
		setindex = "Misc",
		colour = "|cffFFFF00",
		header = " ",
		useval = function (v) return string.format(" (%d)", v) end,
		quality = 1,
		sets = {
			["Misc.Unlock.Skeleton Keys"] = L["Lockpicking"],
			["Misc.Lockboxes"] = L["Lockpicking"],
			["Misc.Unlock.Seaforium Charges"] = L["Lockpicking"],
		}
	},
	{
		name = L["Fits special bag"],
		setindex = "Misc.Container.ItemsInType",
		colour = "|cff00ff9a",
		header = L["Fits special bag"],
		quality = 1,
		sets = {
			["Misc.Container.ItemsInType.Herb"] = L["SPECIALBAG_HERB"],
			["Misc.Container.ItemsInType.Enchanting"] = L["SPECIALBAG_ENCHANTING"],
			["Misc.Container.ItemsInType.Engineering"] = L["SPECIALBAG_ENGINEERING"],
			["Misc.Container.ItemsInType.Gem"] = L["SPECIALBAG_GEM"],
			["Misc.Container.ItemsInType.Inscription"] = L["SPECIALBAG_INSCRIPTION"],
			["Misc.Container.ItemsInType.Leatherworking"] = L["SPECIALBAG_LEATHERWORKING"],
			["Misc.Container.ItemsInType.Mining"] = L["SPECIALBAG_MINING"],
			["Misc.Container.ItemsInType.Tackle"] = L["SPECIALBAG_TACKLE"],
		},
	},
	{
		name = L["Tier token"],
		setindex = "Misc.Currency.Tier Sets",
		colour = "|cffB0C4DE",
		header = L["Tier token"],
		quality = 1,
		sets = {
			["Misc.Currency.Tier Sets.Tier 4"] = L["Tier 4 Set"],
			["Misc.Currency.Tier Sets.Tier 5"] = L["Tier 5 Set"],
			["Misc.Currency.Tier Sets.Tier 6"] = L["Tier 6 Set"],
			["Misc.Currency.Tier Sets.Tier 7.10"] = L["Tier 7.10 Set"],
			["Misc.Currency.Tier Sets.Tier 7.25"] = L["Tier 7.25 Set"],
			["Misc.Currency.Tier Sets.Tier 8.10"] = L["Tier 8.10 Set"],
			["Misc.Currency.Tier Sets.Tier 8.25"] = L["Tier 8.25 Set"],
			["Misc.Currency.Tier Sets.Tier 9.25"] = L["Tier 9.245 Set"],
			["Misc.Currency.Tier Sets.Tier 9.25H"] = L["Tier 9.258 Set"],
			["Misc.Currency.Tier Sets.Tier 10.264"] = L["Tier 10.264 Set"],
			["Misc.Currency.Tier Sets.Tier 10.277"] = L["Tier 10.277 Set"],
			["Misc.Currency.Tier Sets.Tier 11.359"] = L["Tier 11.359 Set"],
			["Misc.Currency.Tier Sets.Tier 11.372"] = L["Tier 11.372 Set"],
			["Misc.Currency.Tier Sets.Tier 12.378"] = L["Tier 12.378 Set"],
			["Misc.Currency.Tier Sets.Tier 12.391"] = L["Tier 12.391 Set"],
			["Misc.Currency.Tier Sets.Tier 13.384"] = L["Tier 13.384 Set"],
			["Misc.Currency.Tier Sets.Tier 13.397"] = L["Tier 13.397 Set"],
			["Misc.Currency.Tier Sets.Tier 13.410"] = L["Tier 13.410 Set"],
			["Misc.Currency.Tier Sets.Tier 14.483"] = L["Tier 14.483 Set"],
			["Misc.Currency.Tier Sets.Tier 14.496"] = L["Tier 14.496 Set"],
			["Misc.Currency.Tier Sets.Tier 14.509"] = L["Tier 14.509 Set"],
			["Misc.Currency.Tier Sets.Tier 15.502"] = L["Tier 15.502 Set"],
			["Misc.Currency.Tier Sets.Tier 15.522"] = L["Tier 15.522 Set"],
			["Misc.Currency.Tier Sets.Tier 15.535"] = L["Tier 15.535 Set"],
			["Misc.Currency.Tier Sets.Tier 16.528"] = L["Tier 16.528 Set"],
			["Misc.Currency.Tier Sets.Tier 16.540"] = L["Tier 16.540 Set"],
			["Misc.Currency.Tier Sets.Tier 16.553"] = L["Tier 16.553 Set"],
			["Misc.Currency.Tier Sets.Tier 16.566"] = L["Tier 16.566 Set"],
		},
	},
	{
		name = L["Gifts"],
		setindex = "Misc.Gift",
		colour = "|cffFFFF00",
		header = L["Gift for"],
		quality = 1,
		sets = {
			["Misc.Gift.Chee Chee"] = L["Chee Chee"],
			["Misc.Gift.Ella"] = L["Ella"],
			["Misc.Gift.Farmer Fung"] = L["Farmer Fung"],
			["Misc.Gift.Fish Fellreed"] = L["Fish Fellreed"],
			["Misc.Gift.Gina Mudclaw"] = L["Gina Mudclaw"],
			["Misc.Gift.Haohan Mudclaw"] = L["Haohan Mudclaw"],
			["Misc.Gift.Jogu the Drunk"] = L["Jogu the Drunk"],
			["Misc.Gift.Old Hillpaw"] = L["Old Hillpaw"],
			["Misc.Gift.Sho"] = L["Sho"],
			["Misc.Gift.Tina Mudclaw"] = L["Tina Mudclaw"],
		},
	},
}

table.insert(MENDELEEV_SETS, {
	name = L["Bought for"],
	setindex = "CurrencyItems",
	colour = "|cffB0C4DE",
	header = L["Bought for"],
	descfunc = function(desc, item, val) return string.format("%d |T%s:18|t", val, desc > 0 and GetItemIcon(desc) or (select(3, GetCurrencyInfo(-desc)))) end,
	quality = 1,
	sets = {
		["CurrencyItems.Justice Points"] = -395,
		["CurrencyItems.Valor Points"] = -396,
		["CurrencyItems.Honor Points"] = -392,
		["CurrencyItems.Conquest Points"] = -390,
		
		["CurrencyItems.Apexis Crystal"] = 32572,
		["CurrencyItems.Apexis Shard"] = 32569,
		["CurrencyItems.Arcane Rune"] = 29736,
		["CurrencyItems.Champion's Seal"] = -241,
		["CurrencyItems.Coilfang Armaments"] = 24368,
		["CurrencyItems.Frozen Orb"] = 43102,
		["CurrencyItems.Glowcap"] = 24245,
		["CurrencyItems.Halaa Battle Token"] = 26045,
		["CurrencyItems.Halaa Research Token"] = 26044,
		["CurrencyItems.Holy Dust"] = 29735,
		["CurrencyItems.Mark of Honor Hold"] = 24579,
		["CurrencyItems.Mark of the Illidari"] = 32897,
		["CurrencyItems.Mark of Thrallmar"] = 24581,
		["CurrencyItems.Mark of the World Tree"] = -416,
		["CurrencyItems.Spirit Shard"] = 28558,
		["CurrencyItems.Sunmote"] = 34664,
		["CurrencyItems.Tol Barad Commendation"] = -391,
		["CurrencyItems.Winterfin Clam"] = 34597,

-- PROFESSIONS
--   Blacksmithing
		["CurrencyItems.Elementium Bar"] = 52186,
		["CurrencyItems.Hardened Elementium Bar"] = 53039,
		["CurrencyItems.Pyrium Bar"] = 51950,
		["CurrencyItems.Kyparite"] = 72093,
--   Cooking
		["CurrencyItems.Epicurean's Award"] = -81,
		["CurrencyItems.Ironpaw Token"] = -402,
--   Enchanting
		["CurrencyItems.Dream Shard"] = 34052,
		["CurrencyItems.Abyss Crystal"] = 34057,
		["CurrencyItems.Hypnotic Dust"] = 52555,
		["CurrencyItems.Heavenly Shard"] = 52721,
		["CurrencyItems.Maelstrom Crystal"] = 52722,
--   Jewelcrafting
		["CurrencyItems.Dalaran Jewelcrafter's Token"] = -61,
		["CurrencyItems.Illustrious Jewelcrafter's Token"] = -361,
		["CurrencyItems.Zen Jewelcrafter's Token"] = -698,
--   Leatherworking
		["CurrencyItems.Heavy Borean Leather"] = 38425,
		["CurrencyItems.Arctic Fur"] = 44128,
		["CurrencyItems.Heavy Savage Leather"] = 56516,
--   Tailoring
		["CurrencyItems.Bolt of Embersilk Cloth"] = 53643,
		["CurrencyItems.Dreamcloth"] = 54440,

-- SEASONAL
		["CurrencyItems.Darkmoon Prize Ticket"] = -515,
		["CurrencyItems.Brewfest Prize Token"] = 37829,
		["CurrencyItems.Burning Blossom"] = 23247,
		["CurrencyItems.Coin of Ancestry"] = 21100,
		["CurrencyItems.Noblegarden Chocolate"] = 44791,
	},
})

