local _;
local mod = Fizzle:NewModule("Inspect", "AceHook-3.0", "AceEvent-3.0", "AceTimer-3.0")
local _G = _G
local enable
local ipairs, smatch, tonumber = ipairs, string.match, tonumber
local slots = {
	"Head",
	"Shoulder",
	"Chest",
	"Waist",
	"Legs",
	"Feet",
	"Wrist",
	"Hands",
	"MainHand",
	"SecondaryHand",
	"Ranged",
	"Ammo",
	"Neck",
	"Back",
	"Finger0",
	"Finger1",
	"Trinket0",
	"Trinket1",
	"Relic",
	"Tabard",
}
local booted = false
-- Make some blizz functions more local
local UnitIsPlayer = UnitIsPlayer
local GetItemInfo = GetItemInfo
local GetItemQualityColor = GetItemQualityColor
local GetInventoryItemLink = GetInventoryItemLink
local L = LibStub("AceLocale-3.0"):GetLocale("Fizzle")
mod.modName = L["Inspect"]

function mod:OnInitialize()
	self.db = Fizzle.db:RegisterNamespace("Inspect")
end

function mod:OnEnable()	
	enable = true
	if IsAddOnLoaded("Blizzard_InspectUI") then
		self:SecureHookScript(InspectFrame, "OnShow", "InspectFrame_OnShow")
		self:SecureHookScript(InspectFrame, "OnHide", "InspectFrame_OnHide")
		self:InspectFrame_OnShow()
	else
		self:RegisterEvent("ADDON_LOADED")
	end
end

function mod:OnDisable()
	-- Hide all borders if we get disabled.
	enable = false
	for _, item in ipairs(slots) do
		local border = _G[item .."FizzspectB"]
		if border then
			border:Hide()
		end
	end
end

function mod:CreateBorders()
	for _, item in ipairs(slots) do
		-- Create borders
		Fizzle:CreateBorder("Inspect", item, "Fizzspect", false)
	end
	booted = true
end

local function GetItemID(link)
	return tonumber(smatch(link, "item:(%d+)") or smatch(link, "%d+"))
end

function mod:UpdateBorders()
	if not InspectFrame:IsVisible() then return end
	if not UnitIsPlayer("target") then return end
	-- Now colour the borders.
	for _, item in ipairs(slots) do
		local id
		if _G["Character".. item .."Slot"] then
			id = _G["Character".. item .."Slot"]:GetID()
		end
		if id then			
			local link = GetInventoryItemLink("target", id)
			local border = _G[item .."FizzspectB"]
			if link then
				local itemID = GetItemID(link)
				local quality = select(3, GetItemInfo(itemID))
				
				if quality then
					local r, g, b = GetItemQualityColor(quality)
					border:SetVertexColor(r, g, b)
					border:Show()
				else
					border:Hide()
				end
			else
				if border then
					border:Hide()
				end
			end
		end
	end
end

function mod:ADDON_LOADED(event, arg1)
	-- If the Blizzard InspectUI is loading, fire up the addon!
	if arg1 == "Blizzard_InspectUI" then
		self:SecureHookScript(InspectFrame, "OnShow", "InspectFrame_OnShow")
		self:SecureHookScript(InspectFrame, "OnHide", "InspectFrame_OnHide")
		self:UnregisterEvent("ADDON_LOADED")
	end
end

function mod:InspectFrame_OnShow()
	if (not enable) then
		return;
	end
	-- Create the borders if we're just loading.
	if not booted then
		self:CreateBorders()
	end
	-- Update the borders
	self:UpdateBorders()
	self:ScheduleTimer("UpdateBorders", 0.5);	-- ¼һ
	-- Watch for inventory changes
	self:RegisterEvent("UNIT_INVENTORY_CHANGED", "UpdateBorders")
	-- Watch for target changes.
	if not self:IsHooked("InspectFrame_UnitChanged") then
		self:SecureHook("InspectFrame_UnitChanged", "UpdateBorders")
	end
end

function mod:InspectFrame_OnHide()
	self:Unhook("InspectFrame_UnitChanged")
	self:UnregisterEvent("UNIT_INVENTORY_CHANGED")
end
