/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableProperties;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.JoinStrategy;
import org.apache.derby.iapi.sql.compile.OptimizerFactory;
import org.apache.derby.iapi.sql.compile.OptimizerPlan;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataTypeUtilities;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.types.XML;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.AggregateWindowFunctionNode;
import org.apache.derby.impl.sql.compile.AllResultColumn;
import org.apache.derby.impl.sql.compile.AlterTableNode;
import org.apache.derby.impl.sql.compile.AndNode;
import org.apache.derby.impl.sql.compile.BetweenOperatorNode;
import org.apache.derby.impl.sql.compile.BinaryArithmeticOperatorNode;
import org.apache.derby.impl.sql.compile.BinaryOperatorNode;
import org.apache.derby.impl.sql.compile.BinaryRelationalOperatorNode;
import org.apache.derby.impl.sql.compile.BooleanConstantNode;
import org.apache.derby.impl.sql.compile.CachedValueNode;
import org.apache.derby.impl.sql.compile.CallStatementNode;
import org.apache.derby.impl.sql.compile.CastNode;
import org.apache.derby.impl.sql.compile.CharConstantNode;
import org.apache.derby.impl.sql.compile.CharStream;
import org.apache.derby.impl.sql.compile.CoalesceFunctionNode;
import org.apache.derby.impl.sql.compile.CollectNodesVisitor;
import org.apache.derby.impl.sql.compile.ColumnDefinitionNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.CompilerContextImpl;
import org.apache.derby.impl.sql.compile.ConcatenationOperatorNode;
import org.apache.derby.impl.sql.compile.ConditionalNode;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ConstraintDefinitionNode;
import org.apache.derby.impl.sql.compile.CountAggregateDefinition;
import org.apache.derby.impl.sql.compile.CreateAliasNode;
import org.apache.derby.impl.sql.compile.CreateIndexNode;
import org.apache.derby.impl.sql.compile.CreateRoleNode;
import org.apache.derby.impl.sql.compile.CreateSchemaNode;
import org.apache.derby.impl.sql.compile.CreateSequenceNode;
import org.apache.derby.impl.sql.compile.CreateTableNode;
import org.apache.derby.impl.sql.compile.CreateTriggerNode;
import org.apache.derby.impl.sql.compile.CreateViewNode;
import org.apache.derby.impl.sql.compile.CurrentDatetimeOperatorNode;
import org.apache.derby.impl.sql.compile.CurrentOfNode;
import org.apache.derby.impl.sql.compile.CursorNode;
import org.apache.derby.impl.sql.compile.DB2LengthOperatorNode;
import org.apache.derby.impl.sql.compile.DMLModStatementNode;
import org.apache.derby.impl.sql.compile.DefaultNode;
import org.apache.derby.impl.sql.compile.DeleteNode;
import org.apache.derby.impl.sql.compile.DropAliasNode;
import org.apache.derby.impl.sql.compile.DropIndexNode;
import org.apache.derby.impl.sql.compile.DropRoleNode;
import org.apache.derby.impl.sql.compile.DropSchemaNode;
import org.apache.derby.impl.sql.compile.DropSequenceNode;
import org.apache.derby.impl.sql.compile.DropTableNode;
import org.apache.derby.impl.sql.compile.DropTriggerNode;
import org.apache.derby.impl.sql.compile.DropViewNode;
import org.apache.derby.impl.sql.compile.ExecSPSNode;
import org.apache.derby.impl.sql.compile.ExtractOperatorNode;
import org.apache.derby.impl.sql.compile.FKConstraintDefinitionNode;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromSubquery;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.GenerationClauseNode;
import org.apache.derby.impl.sql.compile.GetCurrentConnectionNode;
import org.apache.derby.impl.sql.compile.GrantNode;
import org.apache.derby.impl.sql.compile.GrantRoleNode;
import org.apache.derby.impl.sql.compile.GroupByColumn;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.HalfOuterJoinNode;
import org.apache.derby.impl.sql.compile.HasNodeVisitor;
import org.apache.derby.impl.sql.compile.HashJoinStrategy;
import org.apache.derby.impl.sql.compile.InListOperatorNode;
import org.apache.derby.impl.sql.compile.InsertNode;
import org.apache.derby.impl.sql.compile.IntersectOrExceptNode;
import org.apache.derby.impl.sql.compile.IsNullNode;
import org.apache.derby.impl.sql.compile.JavaToSQLValueNode;
import org.apache.derby.impl.sql.compile.JoinNode;
import org.apache.derby.impl.sql.compile.LengthOperatorNode;
import org.apache.derby.impl.sql.compile.LikeEscapeOperatorNode;
import org.apache.derby.impl.sql.compile.LockTableNode;
import org.apache.derby.impl.sql.compile.MatchingClauseNode;
import org.apache.derby.impl.sql.compile.MaxMinAggregateDefinition;
import org.apache.derby.impl.sql.compile.MergeNode;
import org.apache.derby.impl.sql.compile.MethodCallNode;
import org.apache.derby.impl.sql.compile.ModifyColumnNode;
import org.apache.derby.impl.sql.compile.NOPStatementNode;
import org.apache.derby.impl.sql.compile.NestedLoopJoinStrategy;
import org.apache.derby.impl.sql.compile.NewInvocationNode;
import org.apache.derby.impl.sql.compile.NextSequenceNode;
import org.apache.derby.impl.sql.compile.NonStaticMethodCallNode;
import org.apache.derby.impl.sql.compile.NotNode;
import org.apache.derby.impl.sql.compile.NumericConstantNode;
import org.apache.derby.impl.sql.compile.OrNode;
import org.apache.derby.impl.sql.compile.OrderByColumn;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.impl.sql.compile.ParseException;
import org.apache.derby.impl.sql.compile.PrivilegeNode;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.QueryTreeNodeVector;
import org.apache.derby.impl.sql.compile.RenameNode;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.RevokeNode;
import org.apache.derby.impl.sql.compile.RevokeRoleNode;
import org.apache.derby.impl.sql.compile.RoutineDesignator;
import org.apache.derby.impl.sql.compile.RowNumberFunctionNode;
import org.apache.derby.impl.sql.compile.RowResultSetNode;
import org.apache.derby.impl.sql.compile.SQLParserConstants;
import org.apache.derby.impl.sql.compile.SQLParserTokenManager;
import org.apache.derby.impl.sql.compile.SQLToJavaValueNode;
import org.apache.derby.impl.sql.compile.SavepointNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.SetConstraintsNode;
import org.apache.derby.impl.sql.compile.SetRoleNode;
import org.apache.derby.impl.sql.compile.SetSchemaNode;
import org.apache.derby.impl.sql.compile.SetTransactionIsolationNode;
import org.apache.derby.impl.sql.compile.SimpleStringOperatorNode;
import org.apache.derby.impl.sql.compile.SpecialFunctionNode;
import org.apache.derby.impl.sql.compile.StatementNode;
import org.apache.derby.impl.sql.compile.StaticClassFieldReferenceNode;
import org.apache.derby.impl.sql.compile.StaticMethodCallNode;
import org.apache.derby.impl.sql.compile.SubqueryNode;
import org.apache.derby.impl.sql.compile.SumAvgAggregateDefinition;
import org.apache.derby.impl.sql.compile.TableElementList;
import org.apache.derby.impl.sql.compile.TableElementNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.TableOperatorNode;
import org.apache.derby.impl.sql.compile.TablePrivilegesNode;
import org.apache.derby.impl.sql.compile.TernaryOperatorNode;
import org.apache.derby.impl.sql.compile.TimestampOperatorNode;
import org.apache.derby.impl.sql.compile.Token;
import org.apache.derby.impl.sql.compile.TransactionStatementNode;
import org.apache.derby.impl.sql.compile.TriggerReferencingStruct;
import org.apache.derby.impl.sql.compile.UnaryArithmeticOperatorNode;
import org.apache.derby.impl.sql.compile.UnaryDateTimestampOperatorNode;
import org.apache.derby.impl.sql.compile.UnaryOperatorNode;
import org.apache.derby.impl.sql.compile.UnionNode;
import org.apache.derby.impl.sql.compile.UntypedNullConstantNode;
import org.apache.derby.impl.sql.compile.UpdateNode;
import org.apache.derby.impl.sql.compile.UserTypeConstantNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.ValueNodeList;
import org.apache.derby.impl.sql.compile.VarbitConstantNode;
import org.apache.derby.impl.sql.compile.WindowDefinitionNode;
import org.apache.derby.impl.sql.compile.WindowList;
import org.apache.derby.impl.sql.compile.WindowNode;
import org.apache.derby.impl.sql.compile.WindowReferenceNode;

class SQLParser
implements SQLParserConstants {
    private static final String[] SAVEPOINT_CLAUSE_NAMES = new String[]{"UNIQUE", "ON ROLLBACK RETAIN LOCKS", "ON ROLLBACK RETAIN CURSORS"};
    private static final String[] ROUTINE_CLAUSE_NAMES = new String[]{null, "SPECIFIC", "RESULT SET", "LANGUAGE", "EXTERNAL NAME", "PARAMETER STYLE", "SQL", "DETERMINISTIC", "ON NULL INPUT", "RETURN TYPE", "EXTERNAL SECURITY", null};
    private static final int[] JAVA_ROUTINE_CLAUSES = new int[]{3, 4, 5};
    private static final String[] TEMPORARY_TABLE_CLAUSE_NAMES = new String[]{"NOT LOGGED", "ON COMMIT", "ON ROLLBACK"};
    private static final int DEFAULT_STRING_COLUMN_LENGTH = 1;
    private static final int ON_OR_USING_CLAUSE_SIZE = 2;
    private static final int ON_CLAUSE = 0;
    private static final int USING_CLAUSE = 1;
    private static final int OPTIONAL_TABLE_CLAUSES_SIZE = 3;
    private static final int OPTIONAL_TABLE_CLAUSES_TABLE_PROPERTIES = 0;
    private static final int OPTIONAL_TABLE_CLAUSES_DERIVED_RCL = 1;
    private static final int OPTIONAL_TABLE_CLAUSES_CORRELATION_NAME = 2;
    private static final int MAX_UTF8_LENGTH = 65535;
    private static final int NO_SET_OP = 0;
    private static final int UNION_OP = 1;
    private static final int UNION_ALL_OP = 2;
    private static final int EXCEPT_OP = 3;
    private static final int EXCEPT_ALL_OP = 4;
    private static final int INTERSECT_OP = 5;
    private static final int INTERSECT_ALL_OP = 6;
    private static final int IDX_DATA_TYPE = 0;
    private static final int IDX_START_WITH_OPTION = 1;
    private static final int IDX_INCREMENT_BY_OPTION = 2;
    private static final int IDX_MAX_VALUE_OPTION = 3;
    private static final int IDX_MIN_VALUE_OPTION = 4;
    private static final int IDX_CYCLE_OPTION = 5;
    private static final int IDX_OPTION_COUNT = 6;
    private static final int OFFSET_CLAUSE = 0;
    private static final int FETCH_FIRST_CLAUSE = 1;
    private static final int OFFSET_CLAUSE_COUNT = 2;
    private Object[] paramDefaults;
    private String statementSQLText;
    private OptimizerFactory optimizerFactory;
    private ContextManager cm;
    private CompilerContext compilerContext;
    private int parameterNumber;
    private ArrayList<ParameterNode> parameterList;
    private boolean lastTokenDelimitedIdentifier = false;
    private boolean nextToLastTokenDelimitedIdentifier = false;
    private Token lastIdentifierToken;
    private Token nextToLastIdentifierToken;
    private Token thirdToLastIdentifierToken;
    static final String SINGLEQUOTES = "''";
    static final String DOUBLEQUOTES = "\"\"";
    static final String DEFAULT_INDEX_TYPE = "BTREE";
    private static final String[] ESCAPED_SYSFUN_FUNCTIONS = new String[]{"ACOS", "ASIN", "ATAN", "ATAN2", "COS", "SIN", "TAN", "PI", "DEGREES", "RADIANS", "EXP", "LOG", "LOG10", "CEILING", "FLOOR", "SIGN", "RAND", "COT"};
    public SQLParserTokenManager token_source;
    public Token token;
    public Token jj_nt;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[379];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private static int[] jj_la1_4;
    private static int[] jj_la1_5;
    private static int[] jj_la1_6;
    private static int[] jj_la1_7;
    private static int[] jj_la1_8;
    private static int[] jj_la1_9;
    private static int[] jj_la1_10;
    private static int[] jj_la1_11;
    private static int[] jj_la1_12;
    private static int[] jj_la1_13;
    private static int[] jj_la1_14;
    private static int[] jj_la1_15;
    private final JJCalls[] jj_2_rtns = new JJCalls[94];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector<int[]> jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    final void setCompilerContext(CompilerContext compilerContext) {
        this.compilerContext = compilerContext;
        this.cm = compilerContext.getContextManager();
    }

    private final OptimizerFactory getOptimizerFactory() throws StandardException {
        if (this.optimizerFactory == null) {
            this.optimizerFactory = this.getCompilerContext().getOptimizerFactory();
        }
        return this.optimizerFactory;
    }

    private final CompilerContext getCompilerContext() {
        return this.compilerContext;
    }

    private DataTypeDescriptor getDataTypeServices(int n, int n2, int n3, int n4) throws StandardException {
        return new DataTypeDescriptor(TypeId.getBuiltInTypeId(n), n2, n3, true, n4);
    }

    private DataTypeDescriptor getJavaClassDataTypeDescriptor(TableName tableName) throws StandardException {
        return new DataTypeDescriptor(TypeId.getUserDefinedTypeId(tableName.getSchemaName(), tableName.getTableName(), null), true);
    }

    private LanguageConnectionContext getLanguageConnectionContext() {
        return (LanguageConnectionContext)this.getContextManager().getContext("LanguageConnectionContext");
    }

    private boolean checkVersion(int n, String string) throws StandardException {
        return this.getLanguageConnectionContext().getDataDictionary().checkVersion(n, string);
    }

    private void checkSqlStandardAccess(String string) throws StandardException {
        if (this.getLanguageConnectionContext().usesSqlAuthorization()) {
            return;
        }
        throw StandardException.newException("42Z60", string, "derby.database.sqlAuthorization", "TRUE");
    }

    private void forbidNextValueFor() {
        CompilerContext compilerContext = this.getCompilerContext();
        compilerContext.setReliability(compilerContext.getReliability() | 0x4000);
    }

    private void checkInternalFeature(String string) throws StandardException {
        CompilerContext compilerContext = this.getCompilerContext();
        if ((compilerContext.getReliability() & 0x400) != 0) {
            throw StandardException.newException("42X01", string);
        }
    }

    private void checkTypeLimits(int n, int n2) throws StandardException {
        boolean bl = true;
        switch (n) {
            case -2: 
            case 1: {
                if (n2 <= 254) break;
                bl = false;
                break;
            }
            case -3: 
            case 12: {
                if (n2 <= 32672) break;
                bl = false;
                break;
            }
        }
        if (!bl) {
            DataTypeDescriptor dataTypeDescriptor = DataTypeDescriptor.getBuiltInDataTypeDescriptor(n, n2);
            throw StandardException.newException("42611", dataTypeDescriptor.getSQLstring());
        }
    }

    private final ContextManager getContextManager() {
        return this.cm;
    }

    private static void verifyImageLength(String string) throws StandardException {
        if (string.length() > 65535) {
            throw StandardException.newException("42Z99", new Object[0]);
        }
    }

    private static String normalizeDelimitedID(String string) {
        string = StringUtil.compressQuotes(string, DOUBLEQUOTES);
        return string;
    }

    private static boolean isDATETIME(int n) {
        return n == 285 || n == 350 || n == 351;
    }

    ValueNode multOp(ValueNode valueNode, ValueNode valueNode2, int n) throws StandardException {
        if (valueNode == null) {
            return valueNode2;
        }
        switch (n) {
            case 3: {
                return new BinaryArithmeticOperatorNode(3, valueNode, valueNode2, this.getContextManager());
            }
            case 4: {
                return new BinaryArithmeticOperatorNode(0, valueNode, valueNode2, this.getContextManager());
            }
            case 5: {
                return new ConcatenationOperatorNode(valueNode, valueNode2, this.getContextManager());
            }
        }
        return null;
    }

    private void setUpAndLinkParameters() throws StandardException {
        CompilerContextImpl compilerContextImpl = (CompilerContextImpl)this.getCompilerContext();
        compilerContextImpl.setParameterList(this.parameterList);
        DataTypeDescriptor[] dataTypeDescriptorArray = compilerContextImpl.getParameterTypes();
        int n = -1;
        int n2 = this.parameterList.size();
        for (int i = 0; i < n2; ++i) {
            ++n;
            ParameterNode parameterNode = this.parameterList.get(i);
            parameterNode.setDescriptors(dataTypeDescriptorArray);
        }
    }

    void initUnnamedParameterList() {
        this.parameterList = new ArrayList();
    }

    ParameterNode makeParameterNode() throws StandardException {
        DataValueDescriptor dataValueDescriptor = null;
        if (this.paramDefaults != null && this.parameterNumber < this.paramDefaults.length) {
            dataValueDescriptor = (DataValueDescriptor)this.paramDefaults[this.parameterNumber];
        }
        ParameterNode parameterNode = new ParameterNode(this.parameterNumber, dataValueDescriptor, this.getContextManager());
        ++this.parameterNumber;
        this.parameterList.add(parameterNode);
        return parameterNode;
    }

    NumericConstantNode getNumericNode(String string, boolean bl) throws StandardException {
        ContextManager contextManager = this.getContextManager();
        try {
            return new NumericConstantNode(TypeId.getBuiltInTypeId(4), Integer.valueOf(string), contextManager);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return new NumericConstantNode(TypeId.getBuiltInTypeId(-5), Long.valueOf(string), contextManager);
            }
            catch (NumberFormatException numberFormatException2) {
                if (bl) {
                    throw numberFormatException2;
                }
                return new NumericConstantNode(TypeId.getBuiltInTypeId(3), new BigDecimal(string), contextManager);
            }
        }
    }

    private boolean isBuiltInAlias() {
        boolean bl = false;
        switch (this.token.kind) {
            case 271: 
            case 272: 
            case 311: 
            case 376: 
            case 403: 
            case 404: 
            case 438: 
            case 444: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    boolean commonDatatypeName(boolean bl) {
        return this.commonDatatypeName(1, bl);
    }

    boolean dataTypeCheck(int n) {
        if (this.commonDatatypeName(n, false)) {
            return true;
        }
        boolean bl = true;
        switch (this.getToken((int)n).kind) {
            case 453: 
            case 454: 
            case 458: {
                bl = false;
            }
        }
        return bl;
    }

    boolean commonDatatypeName(int n, boolean bl) {
        boolean bl2 = false;
        switch (this.getToken((int)n).kind) {
            case 80: 
            case 81: 
            case 88: 
            case 89: 
            case 116: 
            case 117: 
            case 128: 
            case 143: 
            case 167: 
            case 168: 
            case 187: 
            case 193: 
            case 214: 
            case 228: 
            case 261: 
            case 275: 
            case 278: 
            case 285: 
            case 318: 
            case 350: 
            case 351: 
            case 360: 
            case 368: 
            case 377: 
            case 411: {
                bl2 = true;
                break;
            }
            case 369: {
                if (bl) {
                    switch (this.getToken((int)(n + 1)).kind) {
                        case 80: 
                        case 81: 
                        case 260: 
                        case 261: 
                        case 411: {
                            bl2 = true;
                        }
                    }
                    break;
                }
                bl2 = true;
                break;
            }
            case 185: {
                if (bl) {
                    switch (this.getToken((int)(n + 1)).kind) {
                        case 88: 
                        case 89: {
                            bl2 = true;
                        }
                    }
                    break;
                }
                bl2 = true;
            }
        }
        return bl2;
    }

    private StatementNode getDeleteNode(FromTable fromTable, TableName tableName, ValueNode valueNode) throws StandardException {
        FromList fromList = new FromList(this.getContextManager());
        fromList.addFromTable(fromTable);
        SelectNode selectNode = new SelectNode(null, fromList, valueNode, null, null, null, null, this.getContextManager());
        DeleteNode deleteNode = new DeleteNode(tableName, selectNode, null, this.getContextManager());
        this.setUpAndLinkParameters();
        return deleteNode;
    }

    private StatementNode getUpdateNode(FromTable fromTable, TableName tableName, ResultColumnList resultColumnList, ValueNode valueNode) throws StandardException {
        FromList fromList = new FromList(this.getContextManager());
        fromList.addFromTable(fromTable);
        SelectNode selectNode = new SelectNode(resultColumnList, fromList, valueNode, null, null, null, null, this.getContextManager());
        UpdateNode updateNode = new UpdateNode(tableName, selectNode, null, this.getContextManager());
        this.setUpAndLinkParameters();
        return updateNode;
    }

    private ValueNode getTrimOperatorNode(Integer n, ValueNode valueNode, ValueNode valueNode2, ContextManager contextManager) throws StandardException {
        if (valueNode == null) {
            valueNode = new CharConstantNode(" ", this.getContextManager());
        }
        return new TernaryOperatorNode(valueNode2, valueNode, null, 0, n, contextManager == null ? this.getContextManager() : contextManager);
    }

    private boolean ansiTrimSpecFollows() {
        return this.getToken((int)2).kind == 176 || this.getToken((int)2).kind == 247 || this.getToken((int)2).kind == 82;
    }

    private boolean remainingPredicateFollows() {
        boolean bl = false;
        switch (this.getToken((int)1).kind) {
            case 79: 
            case 160: 
            case 171: 
            case 178: 
            case 465: 
            case 466: 
            case 467: 
            case 468: 
            case 469: 
            case 470: 
            case 471: {
                bl = true;
                break;
            }
            case 190: {
                switch (this.getToken((int)2).kind) {
                    case 79: 
                    case 160: 
                    case 178: {
                        bl = true;
                    }
                }
            }
        }
        return bl;
    }

    private boolean dropFollows() {
        return this.getToken((int)1).kind == 129;
    }

    private boolean escapedValueFunctionFollows() {
        if (this.getToken((int)1).kind != 451) {
            return false;
        }
        return this.getToken((int)2).kind == 399;
    }

    private String getEscapedSYSFUN(String string) {
        string = StringUtil.SQLToUpperCase(string);
        for (int i = 0; i < ESCAPED_SYSFUN_FUNCTIONS.length; ++i) {
            if (!ESCAPED_SYSFUN_FUNCTIONS[i].equals(string)) continue;
            return string;
        }
        return null;
    }

    private boolean columnMethodInvocationFollows() {
        int n = this.getToken((int)1).kind;
        if (n == 0) {
            return false;
        }
        if (this.getToken((int)1).image.charAt(0) == '?') {
            return false;
        }
        if (n == 109 || n == 110 || n == 111 || n == 108 && SQLParser.isDATETIME(this.getToken((int)2).kind)) {
            return false;
        }
        if (this.getToken((int)2).kind != 460) {
            return false;
        }
        n = this.getToken((int)4).kind;
        if (n == 453) {
            return true;
        }
        if (n != 460) {
            return false;
        }
        n = this.getToken((int)6).kind;
        if (n == 453) {
            return true;
        }
        if (n != 460) {
            return false;
        }
        n = this.getToken((int)8).kind;
        return n == 453;
    }

    private boolean aggregateFollows() {
        boolean bl = false;
        switch (this.getToken((int)1).kind) {
            case 77: 
            case 181: 
            case 182: 
            case 236: {
                bl = true;
                break;
            }
            case 105: {
                if (this.getToken((int)2).kind == 453) {
                    bl = true;
                }
            }
            default: {
                if (this.getToken((int)2).kind != 453 || this.getToken((int)3).kind != 127) break;
                bl = true;
            }
        }
        return bl;
    }

    private boolean builtinAggregateFollows() {
        switch (this.getToken((int)1).kind) {
            case 77: 
            case 105: 
            case 181: 
            case 182: 
            case 236: {
                return true;
            }
        }
        return false;
    }

    private boolean distinctUDAFollows() {
        if (this.builtinAggregateFollows()) {
            return false;
        }
        if (this.getToken((int)2).kind == 453 && this.getToken((int)3).kind == 127) {
            return true;
        }
        return this.getToken((int)2).kind == 460 && this.getToken((int)4).kind == 453 && this.getToken((int)5).kind == 127;
    }

    private boolean windowOrAggregateFunctionFollows() {
        if (this.distinctUDAFollows()) {
            return false;
        }
        boolean bl = false;
        switch (this.getToken((int)1).kind) {
            case 374: {
                bl = true;
                break;
            }
            default: {
                bl = this.aggregateFollows();
            }
        }
        return bl;
    }

    private boolean miscBuiltinFollows() {
        boolean bl = false;
        int n = this.getToken((int)1).kind;
        if (this.getToken((int)0).kind == 361) {
            bl = true;
        }
        switch (n) {
            case 109: 
            case 110: 
            case 111: 
            case 366: {
                bl = true;
                break;
            }
            case 108: {
                if (!SQLParser.isDATETIME(this.getToken((int)2).kind)) break;
                bl = true;
                break;
            }
            case 87: 
            case 453: {
                bl = false;
                break;
            }
            default: {
                if (this.getToken((int)2).kind != 453) break;
                bl = true;
            }
        }
        return bl;
    }

    private boolean subqueryFollows() {
        boolean bl = false;
        int n = 1;
        while (true) {
            int n2;
            if ((n2 = this.getToken((int)n).kind) != 453) {
                if (n2 != 225 && n2 != 259) break;
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    private boolean seeingOffsetClause() {
        boolean bl = false;
        int n = 2;
        int n2 = this.getToken((int)n).kind;
        if (n2 == 457 || n2 == 459 ? (n2 = this.getToken((int)(++n)).kind) == 487 : n2 == 487 || n2 == 472) {
            n2 = this.getToken((int)(++n)).kind;
            return n2 == 332 || n2 == 221;
        }
        return false;
    }

    private boolean rowValueConstructorListFollows() {
        boolean bl = false;
        if (this.getToken((int)1).kind == 453) {
            int n = 1;
            int n2 = 2;
            while (true) {
                int n3 = this.getToken((int)n2).kind;
                if (n2 == 2 && (n3 == 191 || n3 == 119)) {
                    bl = true;
                    break;
                }
                if (n == 1 && n3 == 458) {
                    bl = true;
                    break;
                }
                if (n3 == 0) break;
                if (n3 == 453) {
                    ++n;
                } else if (n3 == 454) {
                    --n;
                }
                if (n == 0) break;
                ++n2;
            }
        }
        return bl;
    }

    private boolean derbyPropertiesListFollows() {
        return this.getToken((int)1).kind == 59;
    }

    private boolean newInvocationFollows(int n) {
        boolean bl = false;
        if (this.getToken((int)n).kind == 409) {
            int n2 = 2 + n;
            while (true) {
                int n3;
                if ((n3 = this.getToken((int)n2).kind) == 453) {
                    bl = true;
                    break;
                }
                if (n3 != 460) break;
                n2 += 2;
            }
        }
        return bl;
    }

    boolean javaClassFollows() {
        boolean bl = false;
        int n = 2;
        while (true) {
            int n2;
            if ((n2 = this.getToken((int)n).kind) == 463) {
                bl = true;
                break;
            }
            if (n2 != 460) break;
            n += 2;
        }
        return bl;
    }

    private boolean fromNewInvocationFollows() {
        boolean bl = false;
        return this.getToken((int)1).kind == 147 && this.newInvocationFollows(2);
    }

    private boolean joinedTableExpressionFollows() {
        boolean bl = false;
        int n = this.getToken((int)1).kind;
        int n2 = this.getToken((int)2).kind;
        if (n == 173) {
            bl = true;
        } else if (n == 163 && n2 == 173) {
            bl = true;
        } else if (n == 107 && n2 == 173) {
            bl = true;
        } else if (n == 186) {
            bl = true;
        } else if ((n == 177 || n == 219) && n2 == 201) {
            if (this.getToken((int)3).kind == 173) {
                bl = true;
            }
        } else if ((n == 177 || n == 219) && n2 == 173) {
            bl = true;
        }
        return bl;
    }

    private static String aggName(Token token) {
        String string = null;
        switch (token.kind) {
            case 181: {
                string = "MAX";
                break;
            }
            case 77: {
                string = "AVG";
                break;
            }
            case 182: {
                string = "MIN";
                break;
            }
            case 236: {
                string = "SUM";
                break;
            }
            case 105: {
                string = "COUNT";
                break;
            }
        }
        return string;
    }

    private static Class aggClass(Token token) {
        Class clazz = null;
        switch (token.kind) {
            case 181: 
            case 182: {
                clazz = MaxMinAggregateDefinition.class;
                break;
            }
            case 77: 
            case 236: {
                clazz = SumAvgAggregateDefinition.class;
                break;
            }
            case 105: {
                clazz = CountAggregateDefinition.class;
                break;
            }
        }
        return clazz;
    }

    private boolean anotherPropertyFollows() {
        boolean bl = false;
        if (this.getToken((int)1).kind == 458) {
            int n;
            int n2 = 3;
            do {
                if ((n = this.getToken((int)n2).kind) == 467) {
                    bl = true;
                    break;
                }
                n2 += 2;
            } while (n == 460);
        }
        return bl;
    }

    StatementNode getCreateAliasNode(TableName tableName, Object object, Object object2, char c) throws StandardException {
        String string = null;
        if (c != 'S' && c != 'A' && c != 'G') {
            String string2 = (String)object;
            int n = string2.indexOf(40);
            int n2 = n == -1 ? string2.lastIndexOf(46) : string2.substring(0, n).lastIndexOf(46);
            if (n2 == -1 || n2 == string2.length() - 1) {
                throw StandardException.newException("42Y04", string2);
            }
            String string3 = string2.substring(0, n2);
            string = string2.substring(n2 + 1);
            object = string3;
        }
        return new CreateAliasNode(tableName, object, string, object2, c, this.cm);
    }

    StatementNode dropAliasNode(TableName tableName, char c) throws StandardException {
        return new DropAliasNode(tableName, c, this.getContextManager());
    }

    ValueNode getSubstringNode(ValueNode valueNode, ValueNode valueNode2, ValueNode valueNode3) throws StandardException {
        return new TernaryOperatorNode(valueNode, valueNode2, valueNode3, 2, -1, this.getContextManager());
    }

    private void initStatement(String string, Object[] objectArray) throws StandardException {
        this.parameterNumber = 0;
        this.statementSQLText = string;
        this.paramDefaults = objectArray;
        this.optimizerFactory = this.getOptimizerFactory();
        this.initUnnamedParameterList();
    }

    private ValueNode getJdbcIntervalNode(int n) throws StandardException {
        return new NumericConstantNode(TypeId.getBuiltInTypeId(4), ReuseFactory.getInteger(n), this.getContextManager());
    }

    void checkRequiredRoutineClause(int[] nArray, Object[] objectArray) throws StandardException {
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (objectArray[n] != null) continue;
            throw StandardException.newException("42X01", ROUTINE_CLAUSE_NAMES[n]);
        }
    }

    boolean isPrivilegeKeywordExceptTrigger(int n) {
        return n == 225 || n == 122 || n == 166 || n == 254 || n == 215 || n == 137 || n == 357 || n == 66;
    }

    TableElementNode wrapAlterColumnDefaultValue(ValueNode valueNode, String string, long[] lArray) throws StandardException {
        if (lArray[2] == 0L) {
            lArray = null;
        }
        return new ModifyColumnNode(1, string, valueNode, null, lArray, this.getContextManager());
    }

    private boolean isTableValueConstructor(ResultSetNode resultSetNode) throws StandardException {
        return resultSetNode instanceof RowResultSetNode || resultSetNode instanceof UnionNode && ((UnionNode)resultSetNode).tableConstructor();
    }

    private JoinNode newJoinNode(ResultSetNode resultSetNode, ResultSetNode resultSetNode2, ValueNode valueNode, ResultColumnList resultColumnList, int n) throws StandardException {
        switch (n) {
            case 1: {
                return new JoinNode(resultSetNode, resultSetNode2, valueNode, resultColumnList, null, null, null, this.getContextManager());
            }
            case 3: {
                return new HalfOuterJoinNode(resultSetNode, resultSetNode2, valueNode, resultColumnList, false, null, this.getContextManager());
            }
            case 4: {
                return new HalfOuterJoinNode(resultSetNode, resultSetNode2, valueNode, resultColumnList, true, null, this.getContextManager());
            }
        }
        return null;
    }

    private static boolean hasQueryExpressionSuffix(OrderByList orderByList, ValueNode[] valueNodeArray) {
        return orderByList != null || valueNodeArray[0] != null || valueNodeArray[1] != null;
    }

    public final StatementNode Statement(String string, Object[] objectArray) throws ParseException, StandardException {
        this.initStatement(string, objectArray);
        StatementNode statementNode = this.StatementPart(null);
        this.jj_consume_token(0);
        statementNode.setBeginOffset(0);
        statementNode.setEndOffset(string.length() - 1);
        return statementNode;
    }

    public final ValueNode SearchCondition(String string) throws ParseException, StandardException {
        this.initStatement(string, null);
        ValueNode valueNode = this.valueExpression();
        this.jj_consume_token(0);
        valueNode.setBeginOffset(0);
        valueNode.setEndOffset(string.length() - 1);
        return valueNode;
    }

    public final StatementNode proceduralStatement(Token[] tokenArray) throws ParseException, StandardException {
        StatementNode statementNode;
        tokenArray[0] = this.getToken(1);
        switch (this.jj_nt.kind) {
            case 166: {
                statementNode = this.insertStatement();
                break;
            }
            case 254: {
                statementNode = this.preparableUpdateStatement();
                break;
            }
            case 122: {
                statementNode = this.preparableDeleteStatement();
                break;
            }
            case 225: 
            case 259: 
            case 453: {
                statementNode = this.preparableSelectStatement(true);
                break;
            }
            case 309: {
                statementNode = this.mergeStatement();
                break;
            }
            case 361: 
            case 451: 
            case 472: {
                statementNode = this.callStatement();
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return statementNode;
    }

    public final StatementNode StatementPart(Token[] tokenArray) throws ParseException, StandardException {
        if (tokenArray != null) {
            tokenArray[0] = this.getToken(1);
        }
        switch (this.jj_nt.kind) {
            case 405: 
            case 424: {
                StatementNode statementNode;
                switch (this.jj_nt.kind) {
                    case 424: {
                        statementNode = this.spsRenameStatement();
                        break;
                    }
                    case 405: {
                        statementNode = this.lockStatement();
                        break;
                    }
                    default: {
                        this.jj_la1[1] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return statementNode;
            }
        }
        this.jj_la1[5] = this.jj_gen;
        if (this.jj_2_4(1)) {
            StatementNode statementNode;
            block7 : switch (this.jj_nt.kind) {
                case 106: {
                    statementNode = this.createStatements();
                    break;
                }
                case 129: {
                    statementNode = this.dropStatements();
                    break;
                }
                case 68: {
                    statementNode = this.spsAlterStatement();
                    break;
                }
                case 118: {
                    statementNode = this.globalTemporaryTableDeclaration();
                    break;
                }
                case 122: 
                case 166: 
                case 220: 
                case 225: 
                case 254: 
                case 259: 
                case 309: 
                case 327: 
                case 333: 
                case 361: 
                case 451: 
                case 453: 
                case 472: {
                    statementNode = this.preparableSQLDataStatement();
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    if (this.jj_2_1(1)) {
                        statementNode = this.spsSetStatement();
                        break;
                    }
                    switch (this.jj_nt.kind) {
                        case 354: {
                            statementNode = this.truncateTableStatement();
                            break block7;
                        }
                    }
                    this.jj_la1[3] = this.jj_gen;
                    if (this.jj_2_2(1)) {
                        statementNode = this.grantStatement();
                        break;
                    }
                    if (this.jj_2_3(1)) {
                        statementNode = this.revokeStatement();
                        break;
                    }
                    switch (this.jj_nt.kind) {
                        case 137: {
                            statementNode = this.execStatement();
                            break block7;
                        }
                    }
                    this.jj_la1[4] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            return statementNode;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode createStatements() throws ParseException, StandardException {
        StatementNode statementNode;
        Token token = this.jj_consume_token(106);
        block0 : switch (this.jj_nt.kind) {
            case 222: 
            case 263: 
            case 348: 
            case 373: 
            case 432: 
            case 442: {
                switch (this.jj_nt.kind) {
                    case 222: {
                        statementNode = this.schemaDefinition();
                        break block0;
                    }
                    case 263: {
                        statementNode = this.viewDefinition(token);
                        break block0;
                    }
                    case 442: {
                        statementNode = this.triggerDefinition();
                        break block0;
                    }
                    case 348: {
                        statementNode = this.synonymDefinition();
                        break block0;
                    }
                    case 373: {
                        statementNode = this.roleDefinition();
                        break block0;
                    }
                    case 432: {
                        statementNode = this.sequenceDefinition();
                        break block0;
                    }
                }
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 239: {
                statementNode = this.tableDefinition();
                break;
            }
            case 211: {
                statementNode = this.procedureDefinition();
                break;
            }
            case 149: {
                statementNode = this.functionDefinition();
                break;
            }
            case 391: {
                statementNode = this.aggregateDefinition();
                break;
            }
            case 355: {
                statementNode = this.udtDefinition();
                break;
            }
            case 252: 
            case 400: {
                statementNode = this.indexDefinition();
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return statementNode;
    }

    public final StatementNode dropStatements() throws ParseException, StandardException {
        StatementNode statementNode;
        this.jj_consume_token(129);
        switch (this.jj_nt.kind) {
            case 222: {
                statementNode = this.dropSchemaStatement();
                break;
            }
            case 239: {
                statementNode = this.dropTableStatement();
                break;
            }
            case 400: {
                statementNode = this.dropIndexStatement();
                break;
            }
            case 149: 
            case 211: 
            case 348: 
            case 355: 
            case 391: {
                statementNode = this.dropAliasStatement();
                break;
            }
            case 263: {
                statementNode = this.dropViewStatement();
                break;
            }
            case 442: {
                statementNode = this.dropTriggerStatement();
                break;
            }
            case 373: {
                statementNode = this.dropRoleStatement();
                break;
            }
            case 432: {
                statementNode = this.dropSequenceStatement();
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return statementNode;
    }

    public final StatementNode spsAlterStatement() throws ParseException, StandardException {
        this.jj_consume_token(68);
        StatementNode statementNode = this.alterTableStatement();
        return statementNode;
    }

    public final StatementNode spsSetStatement() throws ParseException, StandardException {
        if (this.getToken((int)1).kind == 227 && this.getToken((int)2).kind != 108) {
            StatementNode statementNode;
            this.jj_consume_token(227);
            if (this.jj_2_5(1)) {
                statementNode = this.setIsolationStatement();
            } else if (this.jj_2_6(1)) {
                statementNode = this.setSchemaStatement();
            } else {
                switch (this.jj_nt.kind) {
                    case 406: {
                        statementNode = this.setMessageLocaleStatement();
                        break;
                    }
                    case 373: {
                        statementNode = this.setRoleStatement();
                        break;
                    }
                    case 101: {
                        statementNode = this.setConstraintsStatement();
                        break;
                    }
                    default: {
                        this.jj_la1[9] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            return statementNode;
        }
        if (this.getToken((int)1).kind == 227 && this.getToken((int)2).kind == 108) {
            StatementNode statementNode;
            this.jj_consume_token(227);
            if (this.jj_2_7(1)) {
                statementNode = this.setSchemaStatement();
            } else if (this.jj_2_8(1)) {
                statementNode = this.setIsolationStatement();
            } else {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            return statementNode;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void constraintsReference(List<TableName> list) throws ParseException, StandardException {
        TableName tableName = this.qualifiedName(128);
        list.add(tableName);
    }

    public final StatementNode setConstraintsStatement() throws ParseException, StandardException {
        boolean bl;
        ArrayList<TableName> arrayList;
        block12: {
            arrayList = new ArrayList<TableName>();
            this.jj_consume_token(101);
            if (this.jj_2_9(1)) {
                this.constraintsReference(arrayList);
                while (true) {
                    switch (this.jj_nt.kind) {
                        case 458: {
                            break;
                        }
                        default: {
                            this.jj_la1[10] = this.jj_gen;
                            break block12;
                        }
                    }
                    this.jj_consume_token(458);
                    this.constraintsReference(arrayList);
                }
            }
            switch (this.jj_nt.kind) {
                case 66: {
                    this.jj_consume_token(66);
                    arrayList = null;
                    break;
                }
                default: {
                    this.jj_la1[11] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        switch (this.jj_nt.kind) {
            case 121: {
                this.jj_consume_token(121);
                bl = true;
                break;
            }
            case 159: {
                this.jj_consume_token(159);
                bl = false;
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.checkVersion(230, "DEFERRED CONSTRAINTS");
        return new SetConstraintsNode(arrayList, bl, this.cm);
    }

    public final StatementNode preparableSQLDataStatement() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 122: {
                StatementNode statementNode = this.preparableDeleteStatement();
                return statementNode;
            }
            case 225: 
            case 259: 
            case 453: {
                CursorNode cursorNode = this.preparableSelectStatement(true);
                return cursorNode;
            }
            case 166: {
                StatementNode statementNode = this.insertStatement();
                return statementNode;
            }
            case 309: {
                StatementNode statementNode = this.mergeStatement();
                return statementNode;
            }
            case 254: {
                StatementNode statementNode = this.preparableUpdateStatement();
                return statementNode;
            }
            case 361: 
            case 451: 
            case 472: {
                StatementNode statementNode = this.callStatement();
                return statementNode;
            }
            case 220: 
            case 327: 
            case 333: {
                StatementNode statementNode = this.savepointStatement();
                return statementNode;
            }
        }
        this.jj_la1[13] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode preparableDeleteStatement() throws ParseException, StandardException {
        this.jj_consume_token(122);
        StatementNode statementNode = this.deleteBody();
        return statementNode;
    }

    public final StatementNode deleteBody() throws ParseException, StandardException {
        JavaToSQLValueNode javaToSQLValueNode = null;
        String string = null;
        TableName tableName = null;
        ValueNode valueNode = null;
        FromTable fromTable = null;
        Properties properties = null;
        Token token = null;
        if (this.fromNewInvocationFollows()) {
            this.jj_consume_token(147);
            javaToSQLValueNode = this.newInvocation();
            switch (this.jj_nt.kind) {
                case 265: {
                    token = this.jj_consume_token(265);
                    valueNode = this.whereClause(token);
                    break;
                }
                default: {
                    this.jj_la1[14] = this.jj_gen;
                }
            }
            fromTable = new FromVTI((MethodCallNode)javaToSQLValueNode.getJavaValueNode(), null, null, null, this.getContextManager());
            return this.getDeleteNode(fromTable, tableName, valueNode);
        }
        switch (this.jj_nt.kind) {
            case 147: {
                this.jj_consume_token(147);
                tableName = this.qualifiedName(128);
                if (this.getToken((int)1).kind != 0 && this.getToken((int)1).kind != 265 && !this.derbyPropertiesListFollows()) {
                    switch (this.jj_nt.kind) {
                        case 72: {
                            this.jj_consume_token(72);
                            break;
                        }
                        default: {
                            this.jj_la1[15] = this.jj_gen;
                        }
                    }
                    string = this.identifier(128, true);
                }
                switch (this.jj_nt.kind) {
                    case 59: {
                        properties = this.propertyList(false);
                        this.jj_consume_token(64);
                        break;
                    }
                    default: {
                        this.jj_la1[16] = this.jj_gen;
                    }
                }
                switch (this.jj_nt.kind) {
                    case 265: {
                        token = this.jj_consume_token(265);
                        if (this.getToken((int)1).kind == 108 && this.getToken((int)2).kind == 194) {
                            fromTable = this.currentOfClause(string);
                            break;
                        }
                        if (this.jj_2_10(1)) {
                            valueNode = this.whereClause(token);
                            break;
                        }
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[17] = this.jj_gen;
                    }
                }
                if (fromTable == null) {
                    fromTable = new FromBaseTable(tableName, string, 2, null, this.getContextManager());
                }
                if (properties != null) {
                    ((FromBaseTable)fromTable).setTableProperties(properties);
                }
                return this.getDeleteNode(fromTable, tableName, valueNode);
            }
        }
        this.jj_la1[18] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final FromTable currentOfClause(String string) throws ParseException, StandardException {
        String string2 = null;
        this.jj_consume_token(108);
        this.jj_consume_token(194);
        string2 = this.identifier(128, true);
        return new CurrentOfNode(string, string2, null, this.getContextManager());
    }

    public final CursorNode preparableSelectStatement(boolean bl) throws ParseException, StandardException {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        int n2 = 0;
        OrderByList orderByList = null;
        ValueNode[] valueNodeArray = new ValueNode[2];
        boolean bl2 = false;
        ResultSetNode resultSetNode = this.queryExpression(null, 0);
        switch (this.jj_nt.kind) {
            case 200: {
                orderByList = this.orderByClause(resultSetNode);
                break;
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
            }
        }
        bl2 = this.offsetFetchFirstClause(valueNodeArray);
        switch (this.jj_nt.kind) {
            case 144: {
                this.jj_consume_token(144);
                n = this.forUpdateClause(arrayList);
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 267: {
                n2 = this.atIsolationLevel();
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
            }
        }
        CursorNode cursorNode = new CursorNode("SELECT", resultSetNode, null, orderByList, valueNodeArray[0], valueNodeArray[1], bl2, n, n == 1 ? null : arrayList.toArray(new String[arrayList.size()]), false, this.getContextManager());
        if (bl) {
            this.setUpAndLinkParameters();
        }
        if (n2 != 0) {
            this.getCompilerContext().setScanIsolationLevel(n2);
        }
        return cursorNode;
    }

    public final StatementNode insertStatement() throws ParseException, StandardException {
        this.jj_consume_token(166);
        this.jj_consume_token(170);
        QueryTreeNode queryTreeNode = this.targetTable();
        StatementNode statementNode = this.insertColumnsAndSource(queryTreeNode);
        this.setUpAndLinkParameters();
        return statementNode;
    }

    public final QueryTreeNode targetTable() throws ParseException, StandardException {
        JavaToSQLValueNode javaToSQLValueNode = null;
        String string = null;
        if (this.newInvocationFollows(1)) {
            javaToSQLValueNode = this.newInvocation();
            return new FromVTI((MethodCallNode)javaToSQLValueNode.getJavaValueNode(), string, null, null, this.getContextManager());
        }
        if (this.jj_2_11(1)) {
            TableName tableName = this.qualifiedName(128);
            return tableName;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode preparableUpdateStatement() throws ParseException, StandardException {
        this.jj_consume_token(254);
        StatementNode statementNode = this.updateBody();
        return statementNode;
    }

    public final boolean tableOrIndex() throws ParseException {
        switch (this.jj_nt.kind) {
            case 239: {
                this.jj_consume_token(239);
                return true;
            }
            case 400: {
                this.jj_consume_token(400);
                return false;
            }
        }
        this.jj_la1[22] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode updateBody() throws ParseException, StandardException {
        String string = null;
        JavaToSQLValueNode javaToSQLValueNode = null;
        TableName tableName = null;
        ValueNode valueNode = null;
        FromTable fromTable = null;
        Properties properties = null;
        Token token = null;
        if (this.newInvocationFollows(1)) {
            javaToSQLValueNode = this.newInvocation();
            this.jj_consume_token(227);
            ResultColumnList resultColumnList = this.setClauseList();
            switch (this.jj_nt.kind) {
                case 265: {
                    token = this.jj_consume_token(265);
                    valueNode = this.whereClause(token);
                    break;
                }
                default: {
                    this.jj_la1[23] = this.jj_gen;
                }
            }
            fromTable = new FromVTI((MethodCallNode)javaToSQLValueNode.getJavaValueNode(), null, null, null, this.getContextManager());
            return this.getUpdateNode(fromTable, tableName, resultColumnList, valueNode);
        }
        if (this.jj_2_13(1)) {
            tableName = this.qualifiedName(128);
            if (this.getToken((int)1).kind != 227 && !this.derbyPropertiesListFollows()) {
                switch (this.jj_nt.kind) {
                    case 72: {
                        this.jj_consume_token(72);
                        break;
                    }
                    default: {
                        this.jj_la1[24] = this.jj_gen;
                    }
                }
                string = this.identifier(128, true);
            }
            switch (this.jj_nt.kind) {
                case 59: {
                    properties = this.propertyList(false);
                    this.jj_consume_token(64);
                    break;
                }
                default: {
                    this.jj_la1[25] = this.jj_gen;
                }
            }
            this.jj_consume_token(227);
            ResultColumnList resultColumnList = this.setClauseList();
            block9 : switch (this.jj_nt.kind) {
                case 265: {
                    token = this.jj_consume_token(265);
                    if (this.jj_2_12(1)) {
                        valueNode = this.whereClause(token);
                        break;
                    }
                    switch (this.jj_nt.kind) {
                        case 108: {
                            fromTable = this.currentOfClause(string);
                            break block9;
                        }
                    }
                    this.jj_la1[26] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[27] = this.jj_gen;
                }
            }
            if (fromTable == null) {
                fromTable = new FromBaseTable(tableName, string, 1, null, this.getContextManager());
            }
            if (properties != null) {
                ((FromBaseTable)fromTable).setTableProperties(properties);
            }
            return this.getUpdateNode(fromTable, tableName, resultColumnList, valueNode);
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode callStatement() throws ParseException, StandardException {
        StatementNode statementNode;
        switch (this.jj_nt.kind) {
            case 361: 
            case 472: {
                statementNode = this.bareCallStatement();
                break;
            }
            case 451: {
                this.jj_consume_token(451);
                statementNode = this.bareCallStatement();
                this.jj_consume_token(452);
                break;
            }
            default: {
                this.jj_la1[28] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return statementNode;
    }

    public final StatementNode bareCallStatement() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 361: {
                this.jj_consume_token(361);
                ValueNode valueNode = this.primaryExpression();
                if (!(valueNode instanceof JavaToSQLValueNode) || !(((JavaToSQLValueNode)valueNode).getJavaValueNode() instanceof MethodCallNode)) {
                    throw StandardException.newException("42X74", new Object[0]);
                }
                CallStatementNode callStatementNode = new CallStatementNode((JavaToSQLValueNode)valueNode, this.getContextManager());
                this.setUpAndLinkParameters();
                return callStatementNode;
            }
            case 472: {
                ParameterNode parameterNode = this.dynamicParameterSpecification();
                this.getCompilerContext().setReturnParameterFlag();
                this.jj_consume_token(467);
                this.jj_consume_token(361);
                ResultSetNode resultSetNode = this.rowValueConstructor(null);
                ResultColumnList resultColumnList = resultSetNode.getResultColumns();
                if (resultColumnList == null || resultColumnList.size() > 1) {
                    throw StandardException.newException("42X74", new Object[0]);
                }
                ValueNode valueNode = ((ResultColumn)resultColumnList.elementAt(0)).getExpression();
                if (!(valueNode instanceof JavaToSQLValueNode) || !(((JavaToSQLValueNode)valueNode).getJavaValueNode() instanceof MethodCallNode)) {
                    throw StandardException.newException("42X74", new Object[0]);
                }
                CursorNode cursorNode = new CursorNode("SELECT", resultSetNode, null, null, null, null, false, 1, null, false, this.getContextManager());
                parameterNode.setReturnOutputParam(valueNode);
                this.setUpAndLinkParameters();
                return cursorNode;
            }
        }
        this.jj_la1[29] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode mergeStatement() throws ParseException, StandardException {
        this.jj_consume_token(309);
        this.jj_consume_token(170);
        FromTable fromTable = this.tableFactor();
        this.jj_consume_token(257);
        FromTable fromTable2 = this.tableFactor();
        ValueNode valueNode = this.joinCondition();
        QueryTreeNodeVector<MatchingClauseNode> queryTreeNodeVector = this.matchingClauseList();
        this.checkVersion(230, "MERGE");
        this.setUpAndLinkParameters();
        return new MergeNode(fromTable, fromTable2, valueNode, queryTreeNodeVector, this.getContextManager());
    }

    public final QueryTreeNodeVector<MatchingClauseNode> matchingClauseList() throws ParseException, StandardException {
        QueryTreeNodeVector<MatchingClauseNode> queryTreeNodeVector = new QueryTreeNodeVector<MatchingClauseNode>(MatchingClauseNode.class, this.getContextManager());
        this.matchingClause(queryTreeNodeVector);
        while (this.jj_2_14(1)) {
            this.matchingClause(queryTreeNodeVector);
        }
        return queryTreeNodeVector;
    }

    public final void matchingClause(QueryTreeNodeVector<MatchingClauseNode> queryTreeNodeVector) throws ParseException, StandardException {
        ValueNode valueNode = null;
        ResultColumnList resultColumnList = null;
        ResultColumnList resultColumnList2 = null;
        ResultColumnList resultColumnList3 = new ResultColumnList(this.getContextManager());
        if (this.getToken((int)1).kind == 358 && this.getToken((int)2).kind != 190) {
            this.jj_consume_token(358);
            this.jj_consume_token(307);
            switch (this.jj_nt.kind) {
                case 69: {
                    this.jj_consume_token(69);
                    valueNode = this.valueExpression();
                    break;
                }
                default: {
                    this.jj_la1[30] = this.jj_gen;
                }
            }
            this.jj_consume_token(349);
            switch (this.jj_nt.kind) {
                case 122: {
                    this.jj_consume_token(122);
                    break;
                }
                case 254: {
                    this.jj_consume_token(254);
                    this.jj_consume_token(227);
                    resultColumnList = this.setClauseList();
                    break;
                }
                default: {
                    this.jj_la1[31] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            MatchingClauseNode matchingClauseNode = resultColumnList != null ? MatchingClauseNode.makeUpdateClause(valueNode, resultColumnList, this.getContextManager()) : MatchingClauseNode.makeDeleteClause(valueNode, this.getContextManager());
            queryTreeNodeVector.addElement(matchingClauseNode);
        } else if (this.getToken((int)1).kind == 358 && this.getToken((int)2).kind == 190) {
            this.jj_consume_token(358);
            this.jj_consume_token(190);
            this.jj_consume_token(307);
            switch (this.jj_nt.kind) {
                case 69: {
                    this.jj_consume_token(69);
                    valueNode = this.valueExpression();
                    break;
                }
                default: {
                    this.jj_la1[32] = this.jj_gen;
                }
            }
            this.jj_consume_token(349);
            this.jj_consume_token(166);
            switch (this.jj_nt.kind) {
                case 453: {
                    this.jj_consume_token(453);
                    resultColumnList2 = this.insertColumnList();
                    this.jj_consume_token(454);
                    break;
                }
                default: {
                    this.jj_la1[33] = this.jj_gen;
                }
            }
            this.jj_consume_token(259);
            this.jj_consume_token(453);
            this.rowValueConstructorList(resultColumnList3);
            this.jj_consume_token(454);
            MatchingClauseNode matchingClauseNode = MatchingClauseNode.makeInsertClause(valueNode, resultColumnList2, resultColumnList3, this.getContextManager());
            queryTreeNodeVector.addElement(matchingClauseNode);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final ValueNode primaryExpression() throws ParseException, StandardException {
        ValueNode valueNode = null;
        if (this.getToken((int)2).kind == 460 && this.getToken((int)4).kind == 453) {
            valueNode = this.routineInvocation();
            return valueNode;
        }
        if (this.jj_2_15(1)) {
            valueNode = this.primaryExpressionXX();
            return valueNode;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode savepointStatement() throws ParseException, StandardException {
        int n;
        String string = null;
        Object[] objectArray = new Object[3];
        switch (this.jj_nt.kind) {
            case 333: {
                this.jj_consume_token(333);
                string = this.identifier(128, true);
                block14: while (true) {
                    this.savepointStatementClause(objectArray);
                    switch (this.jj_nt.kind) {
                        case 195: 
                        case 252: {
                            continue block14;
                        }
                    }
                    break;
                }
                this.jj_la1[34] = this.jj_gen;
                if (objectArray[2] == null) {
                    throw StandardException.newException("42X01", "MISSING ON ROLLBACK RETAIN CURSORS");
                }
                n = 1;
                break;
            }
            case 220: {
                this.jj_consume_token(220);
                switch (this.jj_nt.kind) {
                    case 268: {
                        this.jj_consume_token(268);
                        break;
                    }
                    default: {
                        this.jj_la1[35] = this.jj_gen;
                    }
                }
                this.jj_consume_token(243);
                this.jj_consume_token(333);
                if (this.jj_2_16(1)) {
                    string = this.identifier(128, true);
                }
                n = 2;
                break;
            }
            case 327: {
                this.jj_consume_token(327);
                switch (this.jj_nt.kind) {
                    case 243: {
                        this.jj_consume_token(243);
                        break;
                    }
                    default: {
                        this.jj_la1[36] = this.jj_gen;
                    }
                }
                this.jj_consume_token(333);
                string = this.identifier(128, true);
                n = 3;
                break;
            }
            default: {
                this.jj_la1[37] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new SavepointNode(string, n, this.getContextManager());
    }

    public final void savepointStatementClause(Object[] objectArray) throws ParseException, StandardException {
        int n = -1;
        switch (this.jj_nt.kind) {
            case 252: {
                this.jj_consume_token(252);
                n = 0;
                break;
            }
            case 195: {
                this.jj_consume_token(195);
                this.jj_consume_token(220);
                this.jj_consume_token(427);
                n = this.LocksOrCursors();
                break;
            }
            default: {
                this.jj_la1[38] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (n != -1) {
            if (objectArray[n] != null) {
                String string = SAVEPOINT_CLAUSE_NAMES[n];
                throw StandardException.newException("42613", string);
            }
            objectArray[n] = Boolean.TRUE;
        }
    }

    public final int LocksOrCursors() throws ParseException {
        switch (this.jj_nt.kind) {
            case 304: {
                this.jj_consume_token(304);
                return 1;
            }
            case 389: {
                this.jj_consume_token(389);
                return 2;
            }
        }
        this.jj_la1[39] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode globalTemporaryTableDeclaration() throws ParseException, StandardException {
        Object[] objectArray = new Object[3];
        this.jj_consume_token(118);
        this.jj_consume_token(151);
        this.jj_consume_token(240);
        this.jj_consume_token(239);
        TableName tableName = this.qualifiedName(128);
        TableElementList tableElementList = this.tableElementList();
        do {
            this.declareTableClause(objectArray);
        } while (this.jj_2_17(1));
        if (objectArray[0] == null) {
            throw StandardException.newException("42X01", "MISSING NOT LOGGED");
        }
        if (objectArray[1] == null) {
            objectArray[1] = Boolean.TRUE;
        }
        if (objectArray[2] == null) {
            objectArray[2] = Boolean.TRUE;
        }
        return new CreateTableNode(tableName, tableElementList, null, (Boolean)objectArray[1], (Boolean)objectArray[2], this.getContextManager());
    }

    public final void declareTableClause(Object[] objectArray) throws ParseException, StandardException {
        int n = -1;
        Boolean bl = null;
        switch (this.jj_nt.kind) {
            case 190: {
                this.jj_consume_token(190);
                this.jj_consume_token(306);
                bl = Boolean.TRUE;
                n = 0;
                break;
            }
            default: {
                this.jj_la1[40] = this.jj_gen;
                if (this.getToken((int)1).kind == 195 && this.getToken((int)2).kind == 97) {
                    this.jj_consume_token(195);
                    this.jj_consume_token(97);
                    bl = this.onCommit();
                    this.jj_consume_token(221);
                    n = 1;
                    break;
                }
                if (this.getToken((int)1).kind == 195 && this.getToken((int)2).kind == 220) {
                    this.jj_consume_token(195);
                    this.jj_consume_token(220);
                    this.jj_consume_token(122);
                    this.jj_consume_token(221);
                    bl = Boolean.TRUE;
                    n = 2;
                    break;
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (n != -1) {
            if (objectArray[n] != null) {
                String string = TEMPORARY_TABLE_CLAUSE_NAMES[n];
                throw StandardException.newException("42613", string);
            }
            objectArray[n] = bl;
        }
    }

    public final Boolean onCommit() throws ParseException {
        switch (this.jj_nt.kind) {
            case 207: {
                this.jj_consume_token(207);
                return Boolean.FALSE;
            }
            case 122: {
                this.jj_consume_token(122);
                return Boolean.TRUE;
            }
        }
        this.jj_la1[41] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final TableElementList tableElementList() throws ParseException, StandardException {
        TableElementList tableElementList = new TableElementList(this.getContextManager());
        this.jj_consume_token(453);
        this.tableElement(tableElementList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 458: {
                    break;
                }
                default: {
                    this.jj_la1[42] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(458);
            this.tableElement(tableElementList);
        }
        this.jj_consume_token(454);
        return tableElementList;
    }

    public final void tableElement(TableElementList tableElementList) throws ParseException, StandardException {
        if (this.jj_2_18(1)) {
            TableElementNode tableElementNode = this.columnDefinition(tableElementList);
            tableElementList.addTableElement(tableElementNode);
        } else {
            switch (this.jj_nt.kind) {
                case 91: 
                case 100: 
                case 145: 
                case 208: 
                case 252: {
                    TableElementNode tableElementNode = this.tableConstraintDefinition();
                    tableElementList.addTableElement(tableElementNode);
                    break;
                }
                default: {
                    this.jj_la1[43] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final TableElementNode columnDefinition(TableElementList tableElementList) throws ParseException, StandardException {
        DataTypeDescriptor[] dataTypeDescriptorArray = new DataTypeDescriptor[1];
        ValueNode valueNode = null;
        long[] lArray = new long[4];
        String string = this.identifier(128, true);
        if (this.jj_2_19(1)) {
            dataTypeDescriptorArray[0] = this.dataTypeDDL();
        }
        switch (this.jj_nt.kind) {
            case 91: 
            case 100: 
            case 119: 
            case 190: 
            case 208: 
            case 215: 
            case 252: 
            case 267: 
            case 292: {
                valueNode = this.defaultAndConstraints(dataTypeDescriptorArray, tableElementList, string, lArray);
                break;
            }
            default: {
                this.jj_la1[44] = this.jj_gen;
            }
        }
        if (lArray[2] == 0L) {
            lArray = null;
        }
        return new ColumnDefinitionNode(string, valueNode, dataTypeDescriptorArray[0], lArray, this.getContextManager());
    }

    public final ValueNode defaultAndConstraints(DataTypeDescriptor[] dataTypeDescriptorArray, TableElementList tableElementList, String string, long[] lArray) throws ParseException, StandardException {
        ValueNode valueNode = null;
        switch (this.jj_nt.kind) {
            case 91: 
            case 100: 
            case 190: 
            case 208: 
            case 215: 
            case 252: {
                this.columnConstraintDefinition(dataTypeDescriptorArray, tableElementList, string);
                block16: while (true) {
                    switch (this.jj_nt.kind) {
                        case 91: 
                        case 100: 
                        case 190: 
                        case 208: 
                        case 215: 
                        case 252: {
                            break;
                        }
                        default: {
                            this.jj_la1[45] = this.jj_gen;
                            break block16;
                        }
                    }
                    this.columnConstraintDefinition(dataTypeDescriptorArray, tableElementList, string);
                }
                block7 : switch (this.jj_nt.kind) {
                    case 119: 
                    case 267: 
                    case 292: {
                        valueNode = this.defaultClause(lArray, string);
                        while (true) {
                            switch (this.jj_nt.kind) {
                                case 91: 
                                case 100: 
                                case 190: 
                                case 208: 
                                case 215: 
                                case 252: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[46] = this.jj_gen;
                                    break block7;
                                }
                            }
                            this.columnConstraintDefinition(dataTypeDescriptorArray, tableElementList, string);
                        }
                    }
                    default: {
                        this.jj_la1[47] = this.jj_gen;
                    }
                }
                return valueNode;
            }
            case 119: 
            case 267: 
            case 292: {
                valueNode = this.defaultClause(lArray, string);
                block18: while (true) {
                    switch (this.jj_nt.kind) {
                        case 91: 
                        case 100: 
                        case 190: 
                        case 208: 
                        case 215: 
                        case 252: {
                            break;
                        }
                        default: {
                            this.jj_la1[48] = this.jj_gen;
                            break block18;
                        }
                    }
                    this.columnConstraintDefinition(dataTypeDescriptorArray, tableElementList, string);
                }
                return valueNode;
            }
        }
        this.jj_la1[49] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final DataTypeDescriptor dataTypeDDL() throws ParseException, StandardException {
        if (this.commonDatatypeName(false)) {
            DataTypeDescriptor dataTypeDescriptor = this.dataTypeCommon();
            return dataTypeDescriptor;
        }
        if (this.getToken((int)1).kind != 292) {
            DataTypeDescriptor dataTypeDescriptor = this.javaType(new TableName[1]);
            return dataTypeDescriptor;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final TypeDescriptor catalogType() throws ParseException, StandardException {
        DataTypeDescriptor dataTypeDescriptor = this.dataTypeDDL();
        return dataTypeDescriptor.getCatalogType();
    }

    public final DataTypeDescriptor dataTypeCast(TableName[] tableNameArray) throws ParseException, StandardException {
        if (this.commonDatatypeName(true)) {
            DataTypeDescriptor dataTypeDescriptor = this.dataTypeCommon();
            return dataTypeDescriptor;
        }
        if (this.jj_2_20(1)) {
            DataTypeDescriptor dataTypeDescriptor = this.javaType(tableNameArray);
            return dataTypeDescriptor;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final DataTypeDescriptor dataTypeCommon() throws ParseException, StandardException {
        DataTypeDescriptor dataTypeDescriptor;
        boolean bl = false;
        if (this.jj_2_21(1)) {
            if (this.getToken((int)2).kind == 300) {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            dataTypeDescriptor = this.characterStringType();
        } else if (this.jj_2_22(1)) {
            if (this.getToken((int)3).kind == 300) {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            dataTypeDescriptor = this.nationalCharacterStringType();
        } else if (this.jj_2_23(1)) {
            dataTypeDescriptor = this.numericType();
        } else {
            switch (this.jj_nt.kind) {
                case 285: 
                case 350: 
                case 351: {
                    dataTypeDescriptor = this.datetimeType();
                    break;
                }
                case 360: {
                    this.jj_consume_token(360);
                    if ((this.getCompilerContext().getReliability() & 0x400) != 0) {
                        this.checkVersion(190, "BOOLEAN");
                    }
                    dataTypeDescriptor = new DataTypeDescriptor(TypeId.BOOLEAN_ID, true);
                    break;
                }
                case 369: {
                    dataTypeDescriptor = this.longType();
                    break;
                }
                case 80: 
                case 88: 
                case 89: 
                case 185: 
                case 275: 
                case 278: 
                case 318: {
                    dataTypeDescriptor = this.LOBType();
                    break;
                }
                case 377: {
                    dataTypeDescriptor = this.XMLType();
                    break;
                }
                default: {
                    this.jj_la1[50] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return dataTypeDescriptor;
    }

    public final DataTypeDescriptor characterStringType() throws ParseException, StandardException {
        int n;
        int n2 = 1;
        Token token = null;
        switch (this.jj_nt.kind) {
            case 261: {
                this.jj_consume_token(261);
                n2 = this.charLength();
                n = 12;
                break;
            }
            case 88: 
            case 89: {
                this.charOrCharacter();
                block4 : switch (this.jj_nt.kind) {
                    case 262: {
                        token = this.jj_consume_token(262);
                        n2 = this.charLength();
                        break;
                    }
                    default: {
                        this.jj_la1[52] = this.jj_gen;
                        switch (this.jj_nt.kind) {
                            case 453: {
                                n2 = this.charLength();
                                break block4;
                            }
                        }
                        this.jj_la1[51] = this.jj_gen;
                    }
                }
                n = token == null ? 1 : 12;
                break;
            }
            default: {
                this.jj_la1[53] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_nt.kind) {
            case 144: {
                n = this.forBitData(n);
                break;
            }
            default: {
                this.jj_la1[54] = this.jj_gen;
            }
        }
        this.checkTypeLimits(n, n2);
        DataTypeDescriptor dataTypeDescriptor = DataTypeDescriptor.getBuiltInDataTypeDescriptor(n, n2);
        return dataTypeDescriptor;
    }

    public final void charOrCharacter() throws ParseException {
        switch (this.jj_nt.kind) {
            case 88: {
                this.jj_consume_token(88);
                break;
            }
            case 89: {
                this.jj_consume_token(89);
                break;
            }
            default: {
                this.jj_la1[55] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final int charLength() throws ParseException, StandardException {
        this.jj_consume_token(453);
        int n = this.length();
        this.jj_consume_token(454);
        return n;
    }

    public final int forBitData(int n) throws ParseException {
        this.jj_consume_token(144);
        this.jj_consume_token(81);
        this.jj_consume_token(284);
        if (n == 1) {
            n = -2;
        } else if (n == 12) {
            n = -3;
        } else if (n == -1) {
            n = -4;
        }
        return n;
    }

    public final DataTypeDescriptor nationalCharacterStringType() throws ParseException, StandardException {
        int n = 1;
        String string = null;
        Token token = null;
        switch (this.jj_nt.kind) {
            case 185: {
                this.jj_consume_token(185);
                this.charOrCharacter();
                block5 : switch (this.jj_nt.kind) {
                    case 262: {
                        token = this.jj_consume_token(262);
                        n = this.charLength();
                        break;
                    }
                    default: {
                        this.jj_la1[57] = this.jj_gen;
                        switch (this.jj_nt.kind) {
                            case 453: {
                                n = this.charLength();
                                break block5;
                            }
                        }
                        this.jj_la1[56] = this.jj_gen;
                    }
                }
                string = token == null ? "NATIONAL CHAR" : "NATIONAL CHAR VARYING";
                break;
            }
            case 187: {
                this.jj_consume_token(187);
                block11 : switch (this.jj_nt.kind) {
                    case 262: {
                        token = this.jj_consume_token(262);
                        n = this.charLength();
                        break;
                    }
                    default: {
                        this.jj_la1[59] = this.jj_gen;
                        switch (this.jj_nt.kind) {
                            case 453: {
                                n = this.charLength();
                                break block11;
                            }
                        }
                        this.jj_la1[58] = this.jj_gen;
                    }
                }
                string = token == null ? "NATIONAL CHAR" : "NATIONAL CHAR VARYING";
                break;
            }
            case 411: {
                this.jj_consume_token(411);
                n = this.charLength();
                string = "NATIONAL CHAR VARYING";
                break;
            }
            default: {
                this.jj_la1[60] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw StandardException.newException("0A000.S", string);
    }

    public final DataTypeDescriptor LOBType() throws ParseException, StandardException {
        String string;
        int n = Integer.MAX_VALUE;
        switch (this.jj_nt.kind) {
            case 275: {
                this.jj_consume_token(275);
                switch (this.jj_nt.kind) {
                    case 453: {
                        n = this.lengthAndModifier();
                        break;
                    }
                    default: {
                        this.jj_la1[61] = this.jj_gen;
                    }
                }
                string = "BLOB";
                break;
            }
            case 278: {
                this.jj_consume_token(278);
                switch (this.jj_nt.kind) {
                    case 453: {
                        n = this.lengthAndModifier();
                        break;
                    }
                    default: {
                        this.jj_la1[62] = this.jj_gen;
                    }
                }
                string = "CLOB";
                break;
            }
            case 318: {
                this.jj_consume_token(318);
                n = this.lengthAndModifier();
                String string2 = "NCLOB";
                throw StandardException.newException("0A000.S", string2);
            }
            case 80: {
                this.jj_consume_token(80);
                this.jj_consume_token(300);
                this.jj_consume_token(322);
                switch (this.jj_nt.kind) {
                    case 453: {
                        n = this.lengthAndModifier();
                        break;
                    }
                    default: {
                        this.jj_la1[63] = this.jj_gen;
                    }
                }
                string = "BLOB";
                break;
            }
            case 88: 
            case 89: {
                this.charOrCharacter();
                this.jj_consume_token(300);
                this.jj_consume_token(322);
                switch (this.jj_nt.kind) {
                    case 453: {
                        n = this.lengthAndModifier();
                        break;
                    }
                    default: {
                        this.jj_la1[64] = this.jj_gen;
                    }
                }
                string = "CLOB";
                break;
            }
            case 185: {
                this.jj_consume_token(185);
                this.jj_consume_token(89);
                this.jj_consume_token(300);
                this.jj_consume_token(322);
                n = this.lengthAndModifier();
                String string3 = "NCLOB";
                throw StandardException.newException("0A000.S", string3);
            }
            default: {
                this.jj_la1[65] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        DataTypeDescriptor dataTypeDescriptor = DataTypeDescriptor.getBuiltInDataTypeDescriptor(string, n);
        return dataTypeDescriptor;
    }

    public final DataTypeDescriptor numericType() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 116: 
            case 117: 
            case 167: 
            case 168: 
            case 193: 
            case 228: 
            case 368: {
                DataTypeDescriptor dataTypeDescriptor = this.exactNumericType();
                return dataTypeDescriptor;
            }
        }
        this.jj_la1[66] = this.jj_gen;
        if (this.jj_2_24(1)) {
            DataTypeDescriptor dataTypeDescriptor = this.approximateNumericType();
            return dataTypeDescriptor;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final DataTypeDescriptor exactNumericType() throws ParseException, StandardException {
        int n = 5;
        int n2 = 0;
        int n3 = 3;
        String string = "DECIMAL";
        DataTypeDescriptor dataTypeDescriptor = null;
        switch (this.jj_nt.kind) {
            case 116: 
            case 117: 
            case 193: {
                switch (this.jj_nt.kind) {
                    case 193: {
                        this.jj_consume_token(193);
                        n3 = 2;
                        string = "NUMERIC";
                        break;
                    }
                    case 117: {
                        this.jj_consume_token(117);
                        break;
                    }
                    case 116: {
                        this.jj_consume_token(116);
                        break;
                    }
                    default: {
                        this.jj_la1[67] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_nt.kind) {
                    case 453: {
                        this.jj_consume_token(453);
                        n = this.precision();
                        switch (this.jj_nt.kind) {
                            case 458: {
                                this.jj_consume_token(458);
                                n2 = this.scale();
                                break;
                            }
                            default: {
                                this.jj_la1[68] = this.jj_gen;
                            }
                        }
                        this.jj_consume_token(454);
                        break;
                    }
                    default: {
                        this.jj_la1[69] = this.jj_gen;
                    }
                }
                if (n <= 0 || n > 31) {
                    throw StandardException.newException("42X48", string, String.valueOf(n));
                }
                if (n2 < 0 || n2 > 31) {
                    throw StandardException.newException("42Y42", string, String.valueOf(n2));
                }
                if (n2 > n) {
                    throw StandardException.newException("42Y43", String.valueOf(n2), String.valueOf(n));
                }
                int n4 = DataTypeUtilities.computeMaxWidth(n, n2);
                return this.getDataTypeServices(n3, n, n2, n4);
            }
            case 167: 
            case 168: 
            case 228: 
            case 368: {
                dataTypeDescriptor = this.exactIntegerType();
                return dataTypeDescriptor;
            }
        }
        this.jj_la1[70] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final DataTypeDescriptor exactIntegerType() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 167: 
            case 168: {
                switch (this.jj_nt.kind) {
                    case 168: {
                        this.jj_consume_token(168);
                        break;
                    }
                    case 167: {
                        this.jj_consume_token(167);
                        break;
                    }
                    default: {
                        this.jj_la1[71] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return DataTypeDescriptor.getBuiltInDataTypeDescriptor(4);
            }
            case 228: {
                this.jj_consume_token(228);
                return DataTypeDescriptor.getBuiltInDataTypeDescriptor(5);
            }
            case 368: {
                this.jj_consume_token(368);
                return DataTypeDescriptor.getBuiltInDataTypeDescriptor(-5);
            }
        }
        this.jj_la1[72] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final DataTypeDescriptor approximateNumericType() throws ParseException, StandardException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = -1;
        DataTypeDescriptor dataTypeDescriptor = null;
        switch (this.jj_nt.kind) {
            case 143: {
                this.jj_consume_token(143);
                switch (this.jj_nt.kind) {
                    case 453: {
                        this.jj_consume_token(453);
                        n4 = this.precision();
                        this.jj_consume_token(454);
                        break;
                    }
                    default: {
                        this.jj_la1[73] = this.jj_gen;
                    }
                }
                if (n4 == -1) {
                    n4 = 52;
                }
                if (n4 > 0 && n4 <= 23) {
                    n = 7;
                    n4 = 23;
                    n2 = 0;
                    n3 = 4;
                } else if (n4 > 23 && n4 <= 52) {
                    n = 8;
                    n4 = 52;
                    n2 = 0;
                    n3 = 8;
                } else {
                    throw StandardException.newException("42X48", "FLOAT", String.valueOf(n4));
                }
                return this.getDataTypeServices(n, n4, n2, n3);
            }
            case 214: {
                this.jj_consume_token(214);
                return DataTypeDescriptor.getBuiltInDataTypeDescriptor(7);
            }
        }
        this.jj_la1[74] = this.jj_gen;
        if (this.jj_2_25(1)) {
            dataTypeDescriptor = this.doubleType();
            return dataTypeDescriptor;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final DataTypeDescriptor doubleType() throws ParseException, StandardException {
        if (this.getToken((int)2).kind == 326) {
            this.jj_consume_token(128);
            this.jj_consume_token(326);
        } else {
            switch (this.jj_nt.kind) {
                case 128: {
                    this.jj_consume_token(128);
                    break;
                }
                default: {
                    this.jj_la1[75] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return DataTypeDescriptor.getBuiltInDataTypeDescriptor(8);
    }

    public final DataTypeDescriptor longType() throws ParseException, StandardException {
        this.jj_consume_token(369);
        DataTypeDescriptor dataTypeDescriptor = this.longSubType();
        return dataTypeDescriptor;
    }

    public final DataTypeDescriptor longSubType() throws ParseException, StandardException {
        int n = -1;
        switch (this.jj_nt.kind) {
            case 261: {
                this.jj_consume_token(261);
                switch (this.jj_nt.kind) {
                    case 144: {
                        n = this.forBitData(n);
                        break;
                    }
                    default: {
                        this.jj_la1[76] = this.jj_gen;
                    }
                }
                return DataTypeDescriptor.getBuiltInDataTypeDescriptor(n);
            }
            case 411: {
                this.jj_consume_token(411);
                throw StandardException.newException("0A000.S", "LONG NVARCHAR");
            }
        }
        this.jj_la1[77] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final DataTypeDescriptor XMLType() throws ParseException, StandardException {
        this.jj_consume_token(377);
        this.checkVersion(130, "XML");
        return DataTypeDescriptor.getBuiltInDataTypeDescriptor(2009);
    }

    public final void xmlDocOrContent() throws ParseException, StandardException {
        if (this.getToken((int)1).kind != 395 && this.getToken((int)1).kind != 387) {
            throw StandardException.newException("42Z72", "DOCUMENT", ReuseFactory.getInteger(this.getToken((int)1).beginLine), ReuseFactory.getInteger(this.getToken((int)1).beginColumn));
        }
        if (this.getToken((int)1).kind == 387) {
            this.jj_consume_token(387);
            throw StandardException.newException("42Z74", "CONTENT");
        }
        if (this.getToken((int)1).kind == 395) {
            this.jj_consume_token(395);
            return;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final DataTypeDescriptor javaType(TableName[] tableNameArray) throws ParseException, StandardException {
        TableName tableName;
        tableNameArray[0] = tableName = this.qualifiedName(128);
        return this.getJavaClassDataTypeDescriptor(tableName);
    }

    public final String javaDSL() throws ParseException {
        String string = this.caseSensitiveIdentifierPlusReservedWords();
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 460: {
                    break;
                }
                default: {
                    this.jj_la1[78] = this.jj_gen;
                    break block3;
                }
            }
            string = this.javaDSLNameExtender(string);
        }
        return string;
    }

    public final String javaClassName() throws ParseException {
        String string = this.javaDSL();
        return string;
    }

    public final String javaDSLNameExtender(String string) throws ParseException {
        this.jj_consume_token(460);
        String string2 = this.caseSensitiveIdentifierPlusReservedWords();
        return string + "." + string2;
    }

    public final int lengthAndModifier() throws ParseException, StandardException {
        Token token;
        Token token2 = null;
        this.jj_consume_token(453);
        block1 : switch (this.jj_nt.kind) {
            case 489: {
                token = this.jj_consume_token(489);
                break;
            }
            case 487: {
                token = this.jj_consume_token(487);
                switch (this.jj_nt.kind) {
                    case 480: {
                        token2 = this.jj_consume_token(480);
                        break block1;
                    }
                }
                this.jj_la1[79] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[80] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(454);
        String string = token.image + (token2 == null ? "" : token2.image);
        try {
            long l;
            char c = string.charAt(string.length() - 1);
            String string2 = string.substring(0, string.length() - 1);
            switch (c) {
                case 'G': 
                case 'g': {
                    l = 0x40000000L;
                    break;
                }
                case 'M': 
                case 'm': {
                    l = 0x100000L;
                    break;
                }
                case 'K': 
                case 'k': {
                    l = 1024L;
                    break;
                }
                default: {
                    l = 1L;
                    string2 = string;
                }
            }
            long l2 = Long.parseLong(string2) * l;
            if (l2 > 0L && l2 <= Integer.MAX_VALUE) {
                return (int)l2;
            }
            if (l != 1L && l2 == 0x80000000L) {
                return Integer.MAX_VALUE;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw StandardException.newException("42X44", string);
    }

    public final int length() throws ParseException, StandardException {
        Token token = this.jj_consume_token(487);
        try {
            int n = Integer.parseInt(token.image);
            if (n > 0) {
                return n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw StandardException.newException("42X44", token.image);
    }

    public final long exactNumber() throws ParseException, StandardException {
        String string = "";
        switch (this.jj_nt.kind) {
            case 457: 
            case 459: {
                string = this.sign();
                break;
            }
            default: {
                this.jj_la1[81] = this.jj_gen;
            }
        }
        Token token = this.jj_consume_token(487);
        try {
            if (string.equals("-")) {
                return Long.parseLong("-" + token.image);
            }
            return Long.parseLong(token.image);
        }
        catch (NumberFormatException numberFormatException) {
            throw StandardException.newException("42X49", token.image);
        }
    }

    public final int precision() throws ParseException, StandardException {
        int n = this.uint_value();
        return n;
    }

    public final int uint_value() throws ParseException, StandardException {
        Token token = this.jj_consume_token(487);
        try {
            return Integer.parseInt(token.image);
        }
        catch (NumberFormatException numberFormatException) {
            throw StandardException.newException("42X49", token.image);
        }
    }

    public final int scale() throws ParseException, StandardException {
        int n = this.uint_value();
        return n;
    }

    public final DataTypeDescriptor datetimeType() throws ParseException, StandardException {
        Object var1_1 = null;
        int n = -1;
        switch (this.jj_nt.kind) {
            case 285: {
                this.jj_consume_token(285);
                return DataTypeDescriptor.getBuiltInDataTypeDescriptor(91);
            }
            case 350: {
                this.jj_consume_token(350);
                return DataTypeDescriptor.getBuiltInDataTypeDescriptor(92);
            }
            case 351: {
                this.jj_consume_token(351);
                return DataTypeDescriptor.getBuiltInDataTypeDescriptor(93);
            }
        }
        this.jj_la1[82] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final TableName qualifiedName(int n) throws ParseException, StandardException {
        String string;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        Token token = null;
        string3 = this.identifier(128, false);
        if (this.getToken((int)1).kind == 460 && this.getToken((int)2).kind != 455) {
            this.jj_consume_token(460);
            string4 = this.identifier(128, false);
        }
        if (string4 == null) {
            string = string3;
            token = this.lastIdentifierToken;
        } else {
            string2 = string3;
            string = string4;
            token = this.nextToLastIdentifierToken;
        }
        IdUtil.checkIdentifierLengthLimit(string, n);
        if (string2 != null) {
            IdUtil.checkIdentifierLengthLimit(string2, 128);
        }
        return new TableName(string2, string, token.beginOffset, this.lastIdentifierToken.endOffset, this.getContextManager());
    }

    public final ResultSetNode queryExpression(ResultSetNode resultSetNode, int n) throws ParseException, StandardException {
        ResultSetNode resultSetNode2 = this.nonJoinQueryTerm(resultSetNode, n);
        switch (this.jj_nt.kind) {
            case 134: 
            case 251: {
                resultSetNode2 = this.unionOrExcept(resultSetNode2);
                break;
            }
            default: {
                this.jj_la1[83] = this.jj_gen;
            }
        }
        return resultSetNode2;
    }

    public final ResultSetNode unionOrExcept(ResultSetNode resultSetNode) throws ParseException, StandardException {
        Token token = null;
        switch (this.jj_nt.kind) {
            case 251: {
                this.jj_consume_token(251);
                block4 : switch (this.jj_nt.kind) {
                    case 66: 
                    case 127: {
                        switch (this.jj_nt.kind) {
                            case 66: {
                                token = this.jj_consume_token(66);
                                break block4;
                            }
                            case 127: {
                                this.jj_consume_token(127);
                                break block4;
                            }
                        }
                        this.jj_la1[84] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[85] = this.jj_gen;
                    }
                }
                ResultSetNode resultSetNode2 = this.queryExpression(resultSetNode, token != null ? 2 : 1);
                if (token != null && token.kind == 127) {
                    this.forbidNextValueFor();
                }
                return resultSetNode2;
            }
            case 134: {
                this.jj_consume_token(134);
                block11 : switch (this.jj_nt.kind) {
                    case 66: 
                    case 127: {
                        switch (this.jj_nt.kind) {
                            case 66: {
                                token = this.jj_consume_token(66);
                                break block11;
                            }
                            case 127: {
                                this.jj_consume_token(127);
                                break block11;
                            }
                        }
                        this.jj_la1[86] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[87] = this.jj_gen;
                    }
                }
                ResultSetNode resultSetNode3 = this.queryExpression(resultSetNode, token != null ? 4 : 3);
                if (token != null && token.kind == 127) {
                    this.forbidNextValueFor();
                }
                return resultSetNode3;
            }
        }
        this.jj_la1[88] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ResultSetNode nonJoinQueryTerm(ResultSetNode resultSetNode, int n) throws ParseException, StandardException {
        ResultSetNode resultSetNode2 = this.nonJoinQueryPrimary();
        switch (this.jj_nt.kind) {
            case 169: {
                resultSetNode2 = this.intersect(resultSetNode2);
                break;
            }
            default: {
                this.jj_la1[89] = this.jj_gen;
            }
        }
        switch (n) {
            case 0: {
                return resultSetNode2;
            }
            case 1: {
                return new UnionNode(resultSetNode, resultSetNode2, false, false, null, this.getContextManager());
            }
            case 2: {
                return new UnionNode(resultSetNode, resultSetNode2, true, false, null, this.getContextManager());
            }
            case 3: {
                return new IntersectOrExceptNode(2, resultSetNode, resultSetNode2, false, null, this.getContextManager());
            }
            case 4: {
                return new IntersectOrExceptNode(2, resultSetNode, resultSetNode2, true, null, this.getContextManager());
            }
            case 5: {
                return new IntersectOrExceptNode(1, resultSetNode, resultSetNode2, false, null, this.getContextManager());
            }
            case 6: {
                return new IntersectOrExceptNode(1, resultSetNode, resultSetNode2, true, null, this.getContextManager());
            }
        }
        return null;
    }

    public final ResultSetNode intersect(ResultSetNode resultSetNode) throws ParseException, StandardException {
        Token token = null;
        this.jj_consume_token(169);
        block0 : switch (this.jj_nt.kind) {
            case 66: 
            case 127: {
                switch (this.jj_nt.kind) {
                    case 66: {
                        token = this.jj_consume_token(66);
                        break block0;
                    }
                    case 127: {
                        this.jj_consume_token(127);
                        break block0;
                    }
                }
                this.jj_la1[90] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[91] = this.jj_gen;
            }
        }
        ResultSetNode resultSetNode2 = this.nonJoinQueryTerm(resultSetNode, token != null ? 6 : 5);
        if (token != null && token.kind == 127) {
            this.forbidNextValueFor();
        }
        return resultSetNode2;
    }

    public final ResultSetNode nonJoinQueryPrimary() throws ParseException, StandardException {
        boolean bl = false;
        OrderByList orderByList = null;
        ValueNode[] valueNodeArray = new ValueNode[2];
        switch (this.jj_nt.kind) {
            case 225: 
            case 259: {
                ResultSetNode resultSetNode = this.simpleTable();
                return resultSetNode;
            }
            case 453: {
                this.jj_consume_token(453);
                ResultSetNode resultSetNode = this.queryExpression(null, 0);
                switch (this.jj_nt.kind) {
                    case 200: {
                        orderByList = this.orderByClause(resultSetNode);
                        break;
                    }
                    default: {
                        this.jj_la1[92] = this.jj_gen;
                    }
                }
                bl = this.offsetFetchFirstClause(valueNodeArray);
                this.jj_consume_token(454);
                if (SQLParser.hasQueryExpressionSuffix(orderByList, valueNodeArray)) {
                    if (resultSetNode instanceof SelectNode || resultSetNode instanceof UnionNode || resultSetNode instanceof RowResultSetNode) {
                        resultSetNode.pushQueryExpressionSuffix();
                        resultSetNode.pushOrderByList(orderByList);
                        resultSetNode.pushOffsetFetchFirst(valueNodeArray[0], valueNodeArray[1], bl);
                    } else {
                        String string = orderByList != null ? "ORDER BY" : (bl ? "LIMIT" : (valueNodeArray[0] != null ? "OFFSET" : "FETCH"));
                        throw StandardException.newException("42X01", string);
                    }
                }
                return resultSetNode;
            }
        }
        this.jj_la1[93] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ResultSetNode simpleTable() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 225: {
                ResultSetNode resultSetNode = this.querySpecification();
                return resultSetNode;
            }
            case 259: {
                ResultSetNode resultSetNode = this.tableValueConstructor();
                return resultSetNode;
            }
        }
        this.jj_la1[94] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ResultSetNode querySpecification() throws ParseException, StandardException {
        boolean bl = false;
        this.jj_consume_token(225);
        if (this.jj_2_26(1)) {
            bl = this.setQuantifier();
        }
        ResultColumnList resultColumnList = this.selectList();
        SelectNode selectNode = this.tableExpression(resultColumnList);
        if (bl) {
            selectNode.makeDistinct();
        }
        return selectNode;
    }

    public final boolean setQuantifier() throws ParseException {
        if (this.getToken((int)1).kind == 127 && this.getToken((int)2).kind != 460 && this.getToken((int)2).kind != 463) {
            this.jj_consume_token(127);
            this.forbidNextValueFor();
            return true;
        }
        if (this.getToken((int)1).kind == 66 && this.getToken((int)2).kind != 460 && this.getToken((int)2).kind != 463) {
            this.jj_consume_token(66);
            return false;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ResultColumnList selectList() throws ParseException, StandardException {
        ResultColumnList resultColumnList = new ResultColumnList(this.getContextManager());
        switch (this.jj_nt.kind) {
            case 455: {
                this.jj_consume_token(455);
                AllResultColumn allResultColumn = new AllResultColumn(null, this.getContextManager());
                resultColumnList.addResultColumn(allResultColumn);
                return resultColumnList;
            }
        }
        this.jj_la1[95] = this.jj_gen;
        if (this.jj_2_27(1)) {
            this.selectColumnList(resultColumnList);
            return resultColumnList;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void selectColumnList(ResultColumnList resultColumnList) throws ParseException, StandardException {
        this.selectSublist(resultColumnList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 458: {
                    break;
                }
                default: {
                    this.jj_la1[96] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(458);
            this.selectSublist(resultColumnList);
        }
    }

    public final void selectSublist(ResultColumnList resultColumnList) throws ParseException, StandardException {
        if (this.getToken((int)2).kind == 460 && (this.getToken((int)3).kind == 455 || this.getToken((int)4).kind == 460 && this.getToken((int)5).kind == 455)) {
            TableName tableName = this.qualifiedName(128);
            this.jj_consume_token(460);
            this.jj_consume_token(455);
            AllResultColumn allResultColumn = new AllResultColumn(tableName, this.getContextManager());
            resultColumnList.addResultColumn(allResultColumn);
        } else if (this.jj_2_28(1)) {
            ResultColumn resultColumn = this.derivedColumn(resultColumnList);
            resultColumnList.addResultColumn(resultColumn);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final ResultColumn derivedColumn(ResultColumnList resultColumnList) throws ParseException, StandardException {
        String string = null;
        ValueNode valueNode = this.valueExpression();
        if (this.jj_2_29(1)) {
            string = this.asClause();
        }
        if (string == null && valueNode instanceof ColumnReference) {
            string = ((ColumnReference)valueNode).getColumnName();
        }
        return new ResultColumn(string, valueNode, this.getContextManager());
    }

    public final String asClause() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 72: {
                this.jj_consume_token(72);
                break;
            }
            default: {
                this.jj_la1[97] = this.jj_gen;
            }
        }
        String string = this.identifier(128, true);
        return string;
    }

    public final ValueNode valueExpression() throws ParseException, StandardException {
        ValueNode valueNode = this.orExpression(null);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 199: {
                    break;
                }
                default: {
                    this.jj_la1[98] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(199);
            valueNode = this.orExpression(valueNode);
        }
        return valueNode;
    }

    public final ValueNode orExpression(ValueNode valueNode) throws ParseException, StandardException {
        ValueNode valueNode2 = this.andExpression(null);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 69: {
                    break;
                }
                default: {
                    this.jj_la1[99] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(69);
            valueNode2 = this.andExpression(valueNode2);
        }
        if (valueNode == null) {
            return valueNode2;
        }
        return new OrNode(valueNode, valueNode2, this.getContextManager());
    }

    public final ValueNode andExpression(ValueNode valueNode) throws ParseException, StandardException {
        Token token = null;
        if (this.getToken((int)1).kind == 190 && this.getToken((int)2).kind != 460 && this.getToken((int)2).kind != 463) {
            token = this.jj_consume_token(190);
        }
        ValueNode valueNode2 = this.isSearchCondition();
        if (token != null) {
            valueNode2 = new NotNode(valueNode2, this.getContextManager());
        }
        if (valueNode != null) {
            valueNode2 = new AndNode(valueNode, valueNode2, this.getContextManager());
        }
        return valueNode2;
    }

    public final ValueNode isSearchCondition() throws ParseException, StandardException {
        ValueNode valueNode = this.booleanPrimary();
        return valueNode;
    }

    public final ValueNode booleanPrimary() throws ParseException, StandardException {
        ValueNode valueNode = this.predicate();
        return valueNode;
    }

    public final ValueNode predicate() throws ParseException, StandardException {
        ValueNode valueNode;
        if (this.jj_2_30(1)) {
            valueNode = this.additiveExpression(null, 0);
        } else {
            switch (this.jj_nt.kind) {
                case 138: {
                    valueNode = this.existsExpression();
                    break;
                }
                default: {
                    this.jj_la1[100] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        while (this.remainingPredicateFollows()) {
            valueNode = this.remainingPredicate(valueNode);
        }
        return valueNode;
    }

    public final ValueNode remainingPredicate(ValueNode valueNode) throws ParseException, StandardException {
        Token token = null;
        switch (this.jj_nt.kind) {
            case 465: 
            case 466: 
            case 467: 
            case 468: 
            case 469: 
            case 470: 
            case 471: {
                valueNode = this.remainingNonNegatablePredicate(valueNode);
                return valueNode;
            }
            case 79: 
            case 160: 
            case 171: 
            case 178: 
            case 190: {
                switch (this.jj_nt.kind) {
                    case 190: {
                        token = this.jj_consume_token(190);
                        break;
                    }
                    default: {
                        this.jj_la1[101] = this.jj_gen;
                    }
                }
                valueNode = this.remainingNegatablePredicate(valueNode);
                if (token != null) {
                    valueNode = new NotNode(valueNode, this.getContextManager());
                }
                return valueNode;
            }
        }
        this.jj_la1[102] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode remainingNonNegatablePredicate(ValueNode valueNode) throws ParseException, StandardException {
        Object var4_2 = null;
        Object var5_3 = null;
        int n = this.compOp();
        if ((this.getToken((int)1).kind == 66 || this.getToken((int)1).kind == 70 || this.getToken((int)1).kind == 229) && this.getToken((int)2).kind == 453) {
            n = this.quantifier(n);
            this.jj_consume_token(453);
            valueNode = this.tableSubquery(n, valueNode);
            this.jj_consume_token(454);
        } else if (this.jj_2_31(1)) {
            valueNode = this.additiveExpression(valueNode, n);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return valueNode;
    }

    public final ValueNode remainingNegatablePredicate(ValueNode valueNode) throws ParseException, StandardException {
        ValueNode valueNode2 = null;
        ValueNode valueNode3 = null;
        Token token = null;
        switch (this.jj_nt.kind) {
            case 160: {
                this.jj_consume_token(160);
                valueNode2 = this.inPredicateValue(valueNode);
                return valueNode2;
            }
            case 171: {
                this.jj_consume_token(171);
                switch (this.jj_nt.kind) {
                    case 190: {
                        token = this.jj_consume_token(190);
                        break;
                    }
                    default: {
                        this.jj_la1[103] = this.jj_gen;
                    }
                }
                this.jj_consume_token(191);
                return new IsNullNode(valueNode, token != null, this.getContextManager());
            }
            case 178: {
                this.jj_consume_token(178);
                ValueNode valueNode4 = this.additiveExpression(null, 0);
                if (this.jj_2_32(1)) {
                    switch (this.jj_nt.kind) {
                        case 133: {
                            this.jj_consume_token(133);
                            valueNode3 = this.additiveExpression(null, 0);
                            break;
                        }
                        default: {
                            this.jj_la1[104] = this.jj_gen;
                            if (this.getToken((int)1).kind == 451 && this.getToken((int)2).kind != 303) {
                                this.jj_consume_token(451);
                                this.jj_consume_token(133);
                                valueNode3 = this.additiveExpression(null, 0);
                                this.jj_consume_token(452);
                                break;
                            }
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                }
                valueNode2 = new LikeEscapeOperatorNode(valueNode, valueNode4, valueNode3, this.getContextManager());
                return valueNode2;
            }
            case 79: {
                this.jj_consume_token(79);
                ValueNode valueNode5 = this.additiveExpression(null, 0);
                this.jj_consume_token(69);
                ValueNode valueNode6 = this.additiveExpression(null, 0);
                ValueNodeList valueNodeList = new ValueNodeList(this.getContextManager());
                valueNodeList.addElement(valueNode5);
                valueNodeList.addElement(valueNode6);
                valueNode2 = new BetweenOperatorNode(valueNode, valueNodeList, this.getContextManager());
                return valueNode2;
            }
        }
        this.jj_la1[105] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int compOp() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 467: {
                this.jj_consume_token(467);
                return 6;
            }
            case 468: {
                this.jj_consume_token(468);
                return 7;
            }
            case 469: {
                this.jj_consume_token(469);
                return 7;
            }
            case 465: {
                this.jj_consume_token(465);
                return 10;
            }
            case 470: {
                this.jj_consume_token(470);
                return 8;
            }
            case 466: {
                this.jj_consume_token(466);
                return 11;
            }
            case 471: {
                this.jj_consume_token(471);
                return 9;
            }
        }
        this.jj_la1[106] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode additiveExpression(ValueNode valueNode, int n) throws ParseException, StandardException {
        int n2;
        ValueNode valueNode2 = this.multiplicativeExpression(null, 0);
        block11: while (true) {
            switch (this.jj_nt.kind) {
                case 457: 
                case 459: {
                    break;
                }
                default: {
                    this.jj_la1[107] = this.jj_gen;
                    break block11;
                }
            }
            int n3 = this.additiveOperator();
            valueNode2 = this.multiplicativeExpression(valueNode2, n3);
        }
        if (valueNode == null) {
            return valueNode2;
        }
        switch (n) {
            case 6: {
                n2 = 0;
                break;
            }
            case 7: {
                n2 = 5;
                break;
            }
            case 10: {
                n2 = 4;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
            case 11: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 1;
                break;
            }
            default: {
                n2 = -1;
            }
        }
        return new BinaryRelationalOperatorNode(n2, valueNode, valueNode2, false, this.getContextManager());
    }

    public final int additiveOperator() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 457: {
                Token token = this.jj_consume_token(457);
                return 1;
            }
            case 459: {
                Token token = this.jj_consume_token(459);
                return 2;
            }
        }
        this.jj_la1[108] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode multiplicativeExpression(ValueNode valueNode, int n) throws ParseException, StandardException {
        ValueNode valueNode2 = this.unaryExpression(null, 0);
        block7: while (true) {
            switch (this.jj_nt.kind) {
                case 455: 
                case 461: 
                case 477: {
                    break;
                }
                default: {
                    this.jj_la1[109] = this.jj_gen;
                    break block7;
                }
            }
            int n2 = this.multiplicativeOperator();
            valueNode2 = this.unaryExpression(valueNode2, n2);
        }
        if (valueNode == null) {
            return valueNode2;
        }
        switch (n) {
            case 1: {
                return new BinaryArithmeticOperatorNode(2, valueNode, valueNode2, this.getContextManager());
            }
            case 2: {
                return new BinaryArithmeticOperatorNode(1, valueNode, valueNode2, this.getContextManager());
            }
        }
        return null;
    }

    public final int multiplicativeOperator() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 455: {
                this.jj_consume_token(455);
                return 3;
            }
            case 461: {
                this.jj_consume_token(461);
                return 4;
            }
            case 477: {
                this.jj_consume_token(477);
                return 5;
            }
        }
        this.jj_la1[110] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode unaryExpression(ValueNode valueNode, int n) throws ParseException, StandardException {
        int n2;
        String string = null;
        int n3 = this.getToken((int)1).kind;
        if ((n3 == 457 || n3 == 459) && (n2 = this.getToken((int)2).kind) != 487 && n2 != 492) {
            string = this.sign();
        }
        ValueNode valueNode2 = this.primaryExpression();
        if ("-".equals(string)) {
            valueNode2 = new UnaryArithmeticOperatorNode(valueNode2, 1, this.getContextManager());
        } else if ("+".equals(string)) {
            valueNode2 = new UnaryArithmeticOperatorNode(valueNode2, 0, this.getContextManager());
        }
        return this.multOp(valueNode, valueNode2, n);
    }

    public final String sign() throws ParseException {
        switch (this.jj_nt.kind) {
            case 457: {
                Token token = this.jj_consume_token(457);
                return token.image;
            }
            case 459: {
                Token token = this.jj_consume_token(459);
                return token.image;
            }
        }
        this.jj_la1[111] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode primaryExpressionXX() throws ParseException, StandardException {
        ValueNode valueNode = this.primary();
        while (this.jj_2_33(1)) {
            valueNode = this.nonStaticMethodCallOrFieldAccess(valueNode);
        }
        return valueNode;
    }

    public final ValueNode nonStaticMethodCallOrFieldAccess(ValueNode valueNode) throws ParseException, StandardException {
        ValueNode valueNode2 = this.nonStaticMethodInvocation(valueNode);
        return valueNode2;
    }

    public final ValueNode nonStaticMethodInvocation(ValueNode valueNode) throws ParseException, StandardException {
        ArrayList<ValueNode> arrayList = new ArrayList<ValueNode>();
        if (this.getToken((int)3).kind == 453) {
            switch (this.jj_nt.kind) {
                case 478: {
                    this.jj_consume_token(478);
                    break;
                }
                case 460: {
                    this.jj_consume_token(460);
                    break;
                }
                default: {
                    this.jj_la1[112] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            MethodCallNode methodCallNode = this.methodName(valueNode);
            this.methodCallParameterList(arrayList);
            if (valueNode instanceof ParameterNode) {
                throw StandardException.newException("42X54", methodCallNode.getMethodName());
            }
            methodCallNode.addParms(arrayList);
            return new JavaToSQLValueNode(methodCallNode, this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 460: {
                this.jj_consume_token(460);
                MethodCallNode methodCallNode = this.methodName(valueNode);
                if (valueNode instanceof ParameterNode) {
                    throw StandardException.newException("42X54", methodCallNode.getMethodName());
                }
                methodCallNode.addParms(arrayList);
                return new JavaToSQLValueNode(methodCallNode, this.getContextManager());
            }
        }
        this.jj_la1[113] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final MethodCallNode methodName(ValueNode valueNode) throws ParseException, StandardException {
        String string = this.caseSensitiveIdentifierPlusReservedWords();
        return new NonStaticMethodCallNode(string, valueNode, this.getContextManager());
    }

    public final MethodCallNode staticMethodName(String string) throws ParseException, StandardException {
        String string2 = this.caseSensitiveIdentifierPlusReservedWords();
        return new StaticMethodCallNode(string2, string, this.getContextManager());
    }

    public final void methodParameter(List<ValueNode> list) throws ParseException, StandardException {
        if (this.jj_2_34(1)) {
            ValueNode valueNode = this.valueExpression();
            list.add(valueNode);
        } else {
            switch (this.jj_nt.kind) {
                case 191: {
                    ValueNode valueNode = this.nullSpecification();
                    list.add(valueNode);
                    break;
                }
                default: {
                    this.jj_la1[114] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final ValueNode primary() throws ParseException, StandardException {
        if (this.javaClassFollows()) {
            ValueNode valueNode = this.staticClassReference();
            return valueNode;
        }
        if (this.jj_2_35(1)) {
            ValueNode valueNode = this.valueExpressionPrimary();
            return valueNode;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode staticClassReference() throws ParseException, StandardException {
        String string = this.javaClass();
        this.jj_consume_token(463);
        ValueNode valueNode = this.staticClassReferenceType(string);
        return valueNode;
    }

    public final ValueNode staticClassReferenceType(String string) throws ParseException, StandardException {
        if (this.getToken((int)2).kind == 453) {
            ValueNode valueNode = this.staticMethodInvocation(string);
            return valueNode;
        }
        if (this.jj_2_36(1)) {
            ValueNode valueNode = this.staticClassFieldReference(string);
            return valueNode;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode staticClassFieldReference(String string) throws ParseException, StandardException {
        String string2 = null;
        string2 = this.caseSensitiveIdentifierPlusReservedWords();
        return new JavaToSQLValueNode(new StaticClassFieldReferenceNode(string, string2, this.nextToLastTokenDelimitedIdentifier, this.getContextManager()), this.getContextManager());
    }

    public final int nonSecondDatetimeField() throws ParseException {
        switch (this.jj_nt.kind) {
            case 270: {
                this.jj_consume_token(270);
                return 0;
            }
            case 314: {
                this.jj_consume_token(314);
                return 1;
            }
            case 286: {
                this.jj_consume_token(286);
                return 2;
            }
            case 157: {
                this.jj_consume_token(157);
                return 3;
            }
            case 183: {
                this.jj_consume_token(183);
                return 4;
            }
        }
        this.jj_la1[115] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode escapedValueFunction() throws ParseException, StandardException {
        ValueNode valueNode = null;
        if (this.jj_2_37(1)) {
            ValueNode valueNode2 = this.miscBuiltinsCore(true);
            return valueNode2;
        }
        switch (this.jj_nt.kind) {
            case 235: {
                this.jj_consume_token(235);
                this.jj_consume_token(453);
                ValueNode valueNode3 = this.additiveExpression(null, 0);
                this.jj_consume_token(458);
                ValueNode valueNode4 = this.additiveExpression(null, 0);
                switch (this.jj_nt.kind) {
                    case 458: {
                        this.jj_consume_token(458);
                        valueNode = this.additiveExpression(null, 0);
                        break;
                    }
                    default: {
                        this.jj_la1[116] = this.jj_gen;
                    }
                }
                this.jj_consume_token(454);
                return this.getSubstringNode(valueNode3, valueNode4, valueNode);
            }
            case 362: {
                this.jj_consume_token(362);
                this.jj_consume_token(453);
                this.jj_consume_token(454);
                return new CurrentDatetimeOperatorNode(0, this.getContextManager());
            }
            case 364: {
                this.jj_consume_token(364);
                this.jj_consume_token(453);
                this.jj_consume_token(454);
                return new CurrentDatetimeOperatorNode(1, this.getContextManager());
            }
            case 281: {
                this.jj_consume_token(281);
                this.jj_consume_token(453);
                ValueNode valueNode5 = this.additiveExpression(null, 0);
                this.jj_consume_token(458);
                ValueNode valueNode6 = this.additiveExpression(null, 0);
                this.jj_consume_token(454);
                return new ConcatenationOperatorNode(valueNode5, valueNode6, this.getContextManager());
            }
            case 112: 
            case 226: 
            case 256: {
                ValueNode valueNode7 = this.userNode();
                this.jj_consume_token(453);
                this.jj_consume_token(454);
                return valueNode7;
            }
            case 352: 
            case 353: {
                ValueNode valueNode8 = this.timestampArithmeticFuncion();
                return valueNode8;
            }
        }
        this.jj_la1[117] = this.jj_gen;
        if (this.getEscapedSYSFUN(this.getToken((int)1).image) != null) {
            ValueNode valueNode9 = this.escapedSYSFUNFunction();
            return valueNode9;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode escapedSYSFUNFunction() throws ParseException, StandardException {
        ArrayList<ValueNode> arrayList = new ArrayList<ValueNode>();
        Token token = this.jj_consume_token(480);
        this.methodCallParameterList(arrayList);
        String string = this.getEscapedSYSFUN(token.image);
        TableName tableName = new TableName("SYSFUN", string, this.getContextManager());
        StaticMethodCallNode staticMethodCallNode = new StaticMethodCallNode(tableName, null, this.getContextManager());
        staticMethodCallNode.addParms(arrayList);
        return new JavaToSQLValueNode(staticMethodCallNode, this.getContextManager());
    }

    public final ValueNode timestampArithmeticFuncion() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 352: {
                this.jj_consume_token(352);
                this.jj_consume_token(453);
                ValueNode valueNode = this.jdbcIntervalType();
                this.jj_consume_token(458);
                ValueNode valueNode2 = this.additiveExpression(null, 0);
                this.jj_consume_token(458);
                ValueNode valueNode3 = this.additiveExpression(null, 0);
                this.jj_consume_token(454);
                return new TernaryOperatorNode(valueNode3, valueNode, valueNode2, 4, -1, this.getContextManager());
            }
            case 353: {
                this.jj_consume_token(353);
                this.jj_consume_token(453);
                ValueNode valueNode = this.jdbcIntervalType();
                this.jj_consume_token(458);
                ValueNode valueNode4 = this.additiveExpression(null, 0);
                this.jj_consume_token(458);
                ValueNode valueNode5 = this.additiveExpression(null, 0);
                this.jj_consume_token(454);
                return new TernaryOperatorNode(valueNode5, valueNode, valueNode4, 5, -1, this.getContextManager());
            }
        }
        this.jj_la1[118] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode jdbcIntervalType() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 337: {
                this.jj_consume_token(337);
                return this.getJdbcIntervalNode(0);
            }
            case 338: {
                this.jj_consume_token(338);
                return this.getJdbcIntervalNode(1);
            }
            case 339: {
                this.jj_consume_token(339);
                return this.getJdbcIntervalNode(2);
            }
            case 340: {
                this.jj_consume_token(340);
                return this.getJdbcIntervalNode(3);
            }
            case 341: {
                this.jj_consume_token(341);
                return this.getJdbcIntervalNode(4);
            }
            case 342: {
                this.jj_consume_token(342);
                return this.getJdbcIntervalNode(5);
            }
            case 343: {
                this.jj_consume_token(343);
                return this.getJdbcIntervalNode(6);
            }
            case 344: {
                this.jj_consume_token(344);
                return this.getJdbcIntervalNode(7);
            }
            case 345: {
                this.jj_consume_token(345);
                return this.getJdbcIntervalNode(8);
            }
        }
        this.jj_la1[119] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode numericValueFunction() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 271: {
                this.jj_consume_token(271);
                ValueNode valueNode = this.absFunction();
                return valueNode;
            }
            case 272: {
                this.jj_consume_token(272);
                ValueNode valueNode = this.absFunction();
                return valueNode;
            }
            case 438: {
                this.jj_consume_token(438);
                this.jj_consume_token(453);
                ValueNode valueNode = this.additiveExpression(null, 0);
                this.jj_consume_token(454);
                return new UnaryArithmeticOperatorNode(valueNode, 2, this.getContextManager());
            }
            case 311: {
                this.jj_consume_token(311);
                ValueNode valueNode = this.modFunction();
                return valueNode;
            }
            case 293: {
                this.jj_consume_token(293);
                this.jj_consume_token(453);
                this.jj_consume_token(454);
                return new SpecialFunctionNode(0, this.getContextManager());
            }
        }
        this.jj_la1[120] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode coalesceFunction(String string) throws ParseException, StandardException {
        ValueNodeList valueNodeList = new ValueNodeList(this.getContextManager());
        this.jj_consume_token(453);
        this.coalesceExpression(valueNodeList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 458: {
                    break;
                }
                default: {
                    this.jj_la1[121] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(458);
            this.coalesceExpression(valueNodeList);
        }
        this.jj_consume_token(454);
        return new CoalesceFunctionNode(string, valueNodeList, this.getContextManager());
    }

    public final void coalesceExpression(ValueNodeList valueNodeList) throws ParseException, StandardException {
        ValueNode valueNode = this.additiveExpression(null, 0);
        valueNodeList.addElement(valueNode);
    }

    public final ValueNode absFunction() throws ParseException, StandardException {
        this.jj_consume_token(453);
        ValueNode valueNode = this.additiveExpression(null, 0);
        this.jj_consume_token(454);
        return new UnaryArithmeticOperatorNode(valueNode, 3, this.getContextManager());
    }

    public final ValueNode modFunction() throws ParseException, StandardException {
        this.jj_consume_token(453);
        ValueNode valueNode = this.additiveExpression(null, 0);
        this.jj_consume_token(458);
        ValueNode valueNode2 = this.additiveExpression(null, 0);
        this.jj_consume_token(454);
        return new BinaryArithmeticOperatorNode(4, valueNode, valueNode2, this.getContextManager());
    }

    public final int datetimeField() throws ParseException {
        switch (this.jj_nt.kind) {
            case 157: 
            case 183: 
            case 270: 
            case 286: 
            case 314: {
                int n = this.nonSecondDatetimeField();
                return n;
            }
            case 224: {
                this.jj_consume_token(224);
                return 5;
            }
        }
        this.jj_la1[122] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode characterValueFunction() throws ParseException, StandardException {
        ValueNode valueNode = null;
        Token token = null;
        Token token2 = null;
        ValueNode valueNode2 = null;
        switch (this.jj_nt.kind) {
            case 376: {
                this.jj_consume_token(376);
                this.jj_consume_token(453);
                valueNode = this.additiveExpression(null, 0);
                this.jj_consume_token(458);
                ValueNode valueNode3 = this.additiveExpression(null, 0);
                switch (this.jj_nt.kind) {
                    case 458: {
                        this.jj_consume_token(458);
                        valueNode2 = this.additiveExpression(null, 0);
                        break;
                    }
                    default: {
                        this.jj_la1[123] = this.jj_gen;
                    }
                }
                this.jj_consume_token(454);
                return this.getSubstringNode(valueNode, valueNode3, valueNode2);
            }
            case 179: 
            case 255: {
                switch (this.jj_nt.kind) {
                    case 255: {
                        token = this.jj_consume_token(255);
                        break;
                    }
                    case 179: {
                        token2 = this.jj_consume_token(179);
                        break;
                    }
                    default: {
                        this.jj_la1[124] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(453);
                valueNode = this.additiveExpression(null, 0);
                this.jj_consume_token(454);
                return new SimpleStringOperatorNode(valueNode, token != null ? "upper" : "lower", this.getContextManager());
            }
            case 403: 
            case 444: {
                switch (this.jj_nt.kind) {
                    case 444: {
                        token = this.jj_consume_token(444);
                        break;
                    }
                    case 403: {
                        token2 = this.jj_consume_token(403);
                        break;
                    }
                    default: {
                        this.jj_la1[125] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(453);
                valueNode = this.additiveExpression(null, 0);
                this.jj_consume_token(454);
                return new SimpleStringOperatorNode(valueNode, token != null ? "upper" : "lower", this.getContextManager());
            }
            case 248: 
            case 370: 
            case 375: {
                valueNode = this.trimFunction();
                return valueNode;
            }
            case 404: {
                this.jj_consume_token(404);
                this.jj_consume_token(453);
                ValueNode valueNode4 = this.additiveExpression(null, 0);
                this.jj_consume_token(458);
                ValueNode valueNode5 = this.additiveExpression(null, 0);
                switch (this.jj_nt.kind) {
                    case 458: {
                        this.jj_consume_token(458);
                        valueNode = this.additiveExpression(null, 0);
                        break;
                    }
                    default: {
                        this.jj_la1[126] = this.jj_gen;
                    }
                }
                this.jj_consume_token(454);
                return new TernaryOperatorNode(valueNode4, valueNode5, valueNode == null ? new NumericConstantNode(TypeId.getBuiltInTypeId(4), ReuseFactory.getInteger(1), this.getContextManager()) : valueNode, 1, -1, this.getContextManager());
            }
        }
        this.jj_la1[127] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode trimFunction() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 370: 
            case 375: {
                Integer n = this.trimType();
                this.jj_consume_token(453);
                ValueNode valueNode = this.additiveExpression(null, 0);
                this.jj_consume_token(454);
                return this.getTrimOperatorNode(n, null, valueNode, null);
            }
            case 248: {
                this.jj_consume_token(248);
                ValueNode valueNode = this.ansiTrim();
                return valueNode;
            }
        }
        this.jj_la1[128] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode ansiTrim() throws ParseException, StandardException {
        Integer n = ReuseFactory.getInteger(0);
        ValueNode valueNode = null;
        ValueNode valueNode2 = null;
        if (this.ansiTrimSpecFollows()) {
            this.jj_consume_token(453);
            n = this.ansiTrimSpec();
            if (this.jj_2_38(Integer.MAX_VALUE)) {
                this.jj_consume_token(147);
                valueNode2 = this.additiveExpression(null, 0);
                this.jj_consume_token(454);
                return this.getTrimOperatorNode(n, valueNode, valueNode2, null);
            }
            if (this.jj_2_39(1)) {
                valueNode = this.additiveExpression(null, 0);
                this.jj_consume_token(147);
                valueNode2 = this.additiveExpression(null, 0);
                this.jj_consume_token(454);
                return this.getTrimOperatorNode(n, valueNode, valueNode2, null);
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        if (!this.ansiTrimSpecFollows()) {
            this.jj_consume_token(453);
            valueNode = this.additiveExpression(null, 0);
            switch (this.jj_nt.kind) {
                case 147: {
                    this.jj_consume_token(147);
                    valueNode2 = this.additiveExpression(null, 0);
                    this.jj_consume_token(454);
                    return this.getTrimOperatorNode(n, valueNode, valueNode2, null);
                }
                case 454: {
                    this.jj_consume_token(454);
                    return this.getTrimOperatorNode(n, null, valueNode, null);
                }
            }
            this.jj_la1[129] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Integer ansiTrimSpec() throws ParseException {
        switch (this.jj_nt.kind) {
            case 247: {
                this.jj_consume_token(247);
                return ReuseFactory.getInteger(1);
            }
            case 176: {
                this.jj_consume_token(176);
                return ReuseFactory.getInteger(2);
            }
            case 82: {
                this.jj_consume_token(82);
                return ReuseFactory.getInteger(0);
            }
        }
        this.jj_la1[130] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Integer trimType() throws ParseException {
        switch (this.jj_nt.kind) {
            case 375: {
                this.jj_consume_token(375);
                return ReuseFactory.getInteger(1);
            }
            case 370: {
                this.jj_consume_token(370);
                return ReuseFactory.getInteger(2);
            }
        }
        this.jj_la1[131] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode valueExpressionPrimary() throws ParseException, StandardException {
        if (this.escapedValueFunctionFollows()) {
            this.jj_consume_token(451);
            this.jj_consume_token(399);
            ValueNode valueNode = this.escapedValueFunction();
            this.jj_consume_token(452);
            return valueNode;
        }
        if (this.getToken((int)2).kind == 222 || this.getToken((int)2).kind == 436) {
            this.jj_consume_token(108);
            switch (this.jj_nt.kind) {
                case 222: {
                    this.jj_consume_token(222);
                    break;
                }
                case 436: {
                    this.jj_consume_token(436);
                    break;
                }
                default: {
                    this.jj_la1[132] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            return new SpecialFunctionNode(2, this.getContextManager());
        }
        if (this.getToken((int)2).kind == 172) {
            this.jj_consume_token(108);
            this.jj_consume_token(172);
            return new SpecialFunctionNode(1, this.getContextManager());
        }
        if (this.jj_2_41(1)) {
            ValueNode valueNode = this.valueSpecification();
            return valueNode;
        }
        if (this.newInvocationFollows(1)) {
            JavaToSQLValueNode javaToSQLValueNode = this.newInvocation();
            return javaToSQLValueNode;
        }
        if (this.windowOrAggregateFunctionFollows()) {
            ValueNode valueNode = this.windowOrAggregateFunctionNode();
            return valueNode;
        }
        if (this.miscBuiltinFollows()) {
            ValueNode valueNode = this.miscBuiltins();
            return valueNode;
        }
        if (this.jj_2_42(1)) {
            ColumnReference columnReference = this.columnReference();
            return columnReference;
        }
        switch (this.jj_nt.kind) {
            case 453: {
                ValueNode valueNode;
                this.jj_consume_token(453);
                if (this.getToken((int)1).kind == 225 || this.getToken((int)1).kind == 259) {
                    valueNode = this.subquery(17, null);
                } else if (this.jj_2_40(1)) {
                    valueNode = this.valueExpression();
                } else {
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                this.jj_consume_token(454);
                return valueNode;
            }
            case 87: {
                ValueNode valueNode = this.castSpecification();
                return valueNode;
            }
            case 188: {
                ValueNode valueNode = this.nextValueExpression();
                return valueNode;
            }
        }
        this.jj_la1[133] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode miscBuiltins() throws ParseException, StandardException {
        if ((this.getToken((int)1).kind == 366 || this.getToken((int)1).kind == 271 || this.getToken((int)1).kind == 272 || this.getToken((int)1).kind == 438 || this.getToken((int)1).kind == 311 || this.getToken((int)1).kind == 93 || this.getToken((int)1).kind == 258 || this.getToken((int)1).kind == 293 || this.getToken((int)1).kind == 235 || this.getToken((int)1).kind == 376 || this.getToken((int)1).kind == 255 || this.getToken((int)1).kind == 179 || this.getToken((int)1).kind == 444 || this.getToken((int)1).kind == 403 || this.getToken((int)1).kind == 370 || this.getToken((int)1).kind == 375 || this.getToken((int)1).kind == 248 || this.getToken((int)1).kind == 285 || this.getToken((int)1).kind == 350 || this.getToken((int)1).kind == 351 || this.getToken((int)1).kind == 128 || this.getToken((int)1).kind == 88 || this.getToken((int)1).kind == 261 || this.getToken((int)1).kind == 168 || this.getToken((int)1).kind == 167 || this.getToken((int)1).kind == 228 || this.getToken((int)1).kind == 368 || this.getToken((int)1).kind == 270 || this.getToken((int)1).kind == 314 || this.getToken((int)1).kind == 286 || this.getToken((int)1).kind == 157 || this.getToken((int)1).kind == 183 || this.getToken((int)1).kind == 224 || this.getToken((int)1).kind == 301 || this.getToken((int)1).kind == 404 || this.getToken((int)1).kind == 379 || this.getToken((int)1).kind == 381 || this.getToken((int)1).kind == 378 || this.getToken((int)1).kind == 380) && this.getToken((int)2).kind == 453) {
            ValueNode valueNode = this.miscBuiltinsCore(false);
            return valueNode;
        }
        if (this.jj_2_43(1)) {
            ValueNode valueNode = this.datetimeValueFunction();
            return valueNode;
        }
        if (this.jj_2_44(1)) {
            ValueNode valueNode = this.routineInvocation();
            return valueNode;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode miscBuiltinsCore(boolean bl) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 366: {
                this.jj_consume_token(366);
                this.jj_consume_token(453);
                this.jj_consume_token(454);
                ContextManager contextManager = this.getContextManager();
                this.checkInternalFeature("GETCURRENTCONNECTION()");
                return new JavaToSQLValueNode(new GetCurrentConnectionNode(contextManager), contextManager);
            }
            case 271: 
            case 272: 
            case 293: 
            case 311: 
            case 438: {
                ValueNode valueNode = this.numericValueFunction();
                return valueNode;
            }
            case 179: 
            case 248: 
            case 255: 
            case 370: 
            case 375: 
            case 376: 
            case 403: 
            case 404: 
            case 444: {
                ValueNode valueNode = this.characterValueFunction();
                return valueNode;
            }
        }
        this.jj_la1[134] = this.jj_gen;
        if (this.jj_2_45(1)) {
            ValueNode valueNode = this.dataTypeScalarFunction();
            return valueNode;
        }
        switch (this.jj_nt.kind) {
            case 93: {
                this.jj_consume_token(93);
                ValueNode valueNode = this.coalesceFunction("COALESCE");
                return valueNode;
            }
            case 258: {
                this.jj_consume_token(258);
                ValueNode valueNode = this.coalesceFunction("VALUE");
                return valueNode;
            }
            case 301: {
                this.jj_consume_token(301);
                this.jj_consume_token(453);
                ValueNode valueNode = this.additiveExpression(null, 0);
                this.jj_consume_token(454);
                ContextManager contextManager = this.getContextManager();
                if (bl) {
                    return new LengthOperatorNode(this.getTrimOperatorNode(ReuseFactory.getInteger(1), null, valueNode, contextManager), contextManager);
                }
                return new DB2LengthOperatorNode(valueNode, contextManager);
            }
            case 378: 
            case 379: 
            case 380: 
            case 381: {
                ValueNode valueNode = this.xmlFunction();
                return valueNode;
            }
        }
        this.jj_la1[135] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode dataTypeScalarFunction() throws ParseException, StandardException {
        int n = -1;
        switch (this.jj_nt.kind) {
            case 157: 
            case 183: 
            case 224: 
            case 270: 
            case 285: 
            case 286: 
            case 314: 
            case 350: 
            case 351: {
                ValueNode valueNode = this.dateTimeScalarFunction();
                return valueNode;
            }
        }
        this.jj_la1[137] = this.jj_gen;
        if (this.jj_2_46(1)) {
            DataTypeDescriptor dataTypeDescriptor = this.numericFunctionType();
            this.jj_consume_token(453);
            ValueNode valueNode = this.additiveExpression(null, 0);
            this.jj_consume_token(454);
            CastNode castNode = new CastNode(valueNode, dataTypeDescriptor, this.getContextManager());
            castNode.setForDataTypeFunction(true);
            castNode.setForExternallyGeneratedCASTnode();
            return castNode;
        }
        switch (this.jj_nt.kind) {
            case 88: 
            case 261: {
                int n2 = this.charOrVarchar();
                this.jj_consume_token(453);
                ValueNode valueNode = this.additiveExpression(null, 0);
                switch (this.jj_nt.kind) {
                    case 458: {
                        this.jj_consume_token(458);
                        n = this.length();
                        break;
                    }
                    default: {
                        this.jj_la1[136] = this.jj_gen;
                    }
                }
                this.jj_consume_token(454);
                this.checkTypeLimits(n2, n);
                CastNode castNode = new CastNode(valueNode, n2, n, this.getContextManager());
                castNode.setForDataTypeFunction(true);
                castNode.setForExternallyGeneratedCASTnode();
                return castNode;
            }
        }
        this.jj_la1[138] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode xmlFunction() throws ParseException, StandardException {
        this.checkVersion(130, "XML");
        XML.checkXMLRequirements();
        switch (this.jj_nt.kind) {
            case 379: {
                this.jj_consume_token(379);
                this.jj_consume_token(453);
                this.xmlDocOrContent();
                ValueNode valueNode = this.xmlParseValue();
                this.jj_consume_token(454);
                return valueNode;
            }
            case 381: {
                this.jj_consume_token(381);
                this.jj_consume_token(453);
                ValueNode valueNode = this.xmlSerializeValue();
                this.jj_consume_token(454);
                return valueNode;
            }
            case 378: {
                this.jj_consume_token(378);
                this.jj_consume_token(453);
                ValueNode valueNode = this.xmlQueryValue(true);
                this.jj_consume_token(454);
                return valueNode;
            }
            case 380: {
                this.jj_consume_token(380);
                this.jj_consume_token(453);
                ValueNode valueNode = this.xmlQueryValue(false);
                this.jj_consume_token(454);
                return valueNode;
            }
        }
        this.jj_la1[139] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode xmlParseValue() throws ParseException, StandardException {
        ValueNode valueNode = this.additiveExpression(null, 0);
        boolean bl = this.xmlPreserveWhitespace();
        return new UnaryOperatorNode(valueNode, 0, null, bl, this.getContextManager());
    }

    public final boolean xmlPreserveWhitespace() throws ParseException, StandardException {
        if (this.getToken((int)1).kind != 440 && this.getToken((int)1).kind != 207) {
            throw StandardException.newException("42Z72", "PRESERVE WHITESPACE", ReuseFactory.getInteger(this.getToken((int)1).beginLine), ReuseFactory.getInteger(this.getToken((int)1).beginColumn));
        }
        switch (this.jj_nt.kind) {
            case 440: {
                this.jj_consume_token(440);
                this.jj_consume_token(446);
                throw StandardException.newException("42Z74", "STRIP WHITESPACE");
            }
            case 207: {
                this.jj_consume_token(207);
                this.jj_consume_token(446);
                return true;
            }
        }
        this.jj_la1[140] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode xmlSerializeValue() throws ParseException, StandardException {
        ValueNode valueNode = this.additiveExpression(null, 0);
        DataTypeDescriptor dataTypeDescriptor = this.xmlSerializeTargetType();
        return new UnaryOperatorNode(valueNode, 1, dataTypeDescriptor, false, this.getContextManager());
    }

    public final DataTypeDescriptor xmlSerializeTargetType() throws ParseException, StandardException {
        if (this.getToken((int)1).kind != 72) {
            throw StandardException.newException("42Z72", "AS", ReuseFactory.getInteger(this.getToken((int)1).beginLine), ReuseFactory.getInteger(this.getToken((int)1).beginColumn));
        }
        switch (this.jj_nt.kind) {
            case 72: {
                this.jj_consume_token(72);
                DataTypeDescriptor dataTypeDescriptor = this.dataTypeDDL();
                return dataTypeDescriptor;
            }
        }
        this.jj_la1[141] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode xmlQueryValue(boolean bl) throws ParseException, StandardException {
        ValueNode valueNode = null;
        ValueNode valueNode2 = null;
        int n = -1;
        valueNode = this.additiveExpression(null, 0);
        this.jj_consume_token(418);
        n = this.xmlPassingMechanism();
        valueNode2 = this.xqVarList();
        if (!bl) {
            if (this.jj_2_48(1)) {
                this.xqReturningClause();
                if (this.jj_2_47(1)) {
                    this.xmlPassingMechanism();
                }
            }
            this.xqEmptyHandlingClause();
        } else if (!bl) {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        BinaryOperatorNode binaryOperatorNode = new BinaryOperatorNode(valueNode, valueNode2, bl ? 0 : 1, this.getContextManager());
        return binaryOperatorNode;
    }

    public final ValueNode xqVarList() throws ParseException, StandardException {
        ValueNode[] valueNodeArray = new ValueNode[]{null};
        this.xqVariable(valueNodeArray);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 458: {
                    break;
                }
                default: {
                    this.jj_la1[142] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(458);
            this.xqVariable(valueNodeArray);
        }
        return valueNodeArray[0];
    }

    public final void xqVariable(ValueNode[] valueNodeArray) throws ParseException, StandardException {
        String string = null;
        int n = -1;
        ValueNode valueNode = this.additiveExpression(null, 0);
        if (this.getToken((int)1).kind == 72) {
            this.jj_consume_token(72);
            string = this.identifier(128, true);
            throw StandardException.newException("42Z74", "PASSING ... AS");
        }
        if (this.jj_2_49(1)) {
            n = this.xmlPassingMechanism();
        }
        if (string == null) {
            if (valueNodeArray[0] != null) {
                throw StandardException.newException("42Z76", new Object[0]);
            }
            valueNodeArray[0] = valueNode;
        }
    }

    public final short xmlPassingMechanism() throws ParseException, StandardException {
        if (this.getToken((int)2).kind == 422) {
            this.jj_consume_token(83);
            this.jj_consume_token(422);
            return 1;
        }
        switch (this.jj_nt.kind) {
            case 83: {
                this.jj_consume_token(83);
                this.jj_consume_token(258);
                throw StandardException.newException("42Z74", "BY VALUE");
            }
        }
        this.jj_la1[143] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final short xqReturningClause() throws ParseException, StandardException {
        if (this.getToken((int)2).kind == 432) {
            this.jj_consume_token(428);
            this.jj_consume_token(432);
            return 3;
        }
        switch (this.jj_nt.kind) {
            case 428: {
                this.jj_consume_token(428);
                this.jj_consume_token(387);
                throw StandardException.newException("42Z74", "RETURNING CONTENT");
            }
        }
        this.jj_la1[144] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final short xqEmptyHandlingClause() throws ParseException, StandardException {
        if (this.getToken((int)1).kind == 397) {
            this.jj_consume_token(397);
            this.jj_consume_token(195);
            this.jj_consume_token(397);
            return 5;
        }
        switch (this.jj_nt.kind) {
            case 191: {
                this.jj_consume_token(191);
                this.jj_consume_token(195);
                this.jj_consume_token(397);
                throw StandardException.newException("42Z74", "NULL ON EMPTY");
            }
        }
        this.jj_la1[145] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final DataTypeDescriptor numericFunctionType() throws ParseException, StandardException {
        if (this.jj_2_50(1)) {
            DataTypeDescriptor dataTypeDescriptor = this.doubleType();
            return dataTypeDescriptor;
        }
        switch (this.jj_nt.kind) {
            case 167: 
            case 168: 
            case 228: 
            case 368: {
                DataTypeDescriptor dataTypeDescriptor = this.exactIntegerType();
                return dataTypeDescriptor;
            }
        }
        this.jj_la1[146] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode dateTimeScalarFunction() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 350: {
                this.jj_consume_token(350);
                this.jj_consume_token(453);
                ValueNode valueNode = this.additiveExpression(null, 0);
                this.jj_consume_token(454);
                CastNode castNode = new CastNode(valueNode, DataTypeDescriptor.getBuiltInDataTypeDescriptor(92), this.getContextManager());
                castNode.setForExternallyGeneratedCASTnode();
                return castNode;
            }
            case 285: {
                this.jj_consume_token(285);
                this.jj_consume_token(453);
                ValueNode valueNode = this.additiveExpression(null, 0);
                this.jj_consume_token(454);
                return new UnaryDateTimestampOperatorNode(valueNode, 0, this.getContextManager());
            }
            case 351: {
                this.jj_consume_token(351);
                this.jj_consume_token(453);
                ValueNode valueNode = this.additiveExpression(null, 0);
                ValueNode valueNode2 = this.timestampFunctionCompletion(valueNode);
                return valueNode2;
            }
            case 157: 
            case 183: 
            case 224: 
            case 270: 
            case 286: 
            case 314: {
                int n = this.datetimeField();
                this.jj_consume_token(453);
                ValueNode valueNode = this.additiveExpression(null, 0);
                this.jj_consume_token(454);
                return new ExtractOperatorNode(ReuseFactory.getInteger(n), valueNode, this.getContextManager());
            }
        }
        this.jj_la1[147] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode timestampFunctionCompletion(ValueNode valueNode) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 454: {
                this.jj_consume_token(454);
                return new UnaryDateTimestampOperatorNode(valueNode, 1, this.getContextManager());
            }
            case 458: {
                this.jj_consume_token(458);
                ValueNode valueNode2 = this.additiveExpression(null, 0);
                this.jj_consume_token(454);
                return new TimestampOperatorNode(valueNode, valueNode2, this.getContextManager());
            }
        }
        this.jj_la1[148] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Token booleanLiteral() throws ParseException {
        switch (this.jj_nt.kind) {
            case 249: {
                Token token = this.jj_consume_token(249);
                return token;
            }
            case 140: {
                Token token = this.jj_consume_token(140);
                return token;
            }
        }
        this.jj_la1[149] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode generalValueSpecification() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 472: {
                ParameterNode parameterNode = this.dynamicParameterSpecification();
                return parameterNode;
            }
            case 112: 
            case 226: 
            case 256: {
                ValueNode valueNode = this.userNode();
                return valueNode;
            }
            case 363: {
                ValueNode valueNode = this.currentRoleNode();
                return valueNode;
            }
        }
        this.jj_la1[150] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode userNode() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 256: {
                this.jj_consume_token(256);
                return new SpecialFunctionNode(3, this.getContextManager());
            }
            case 112: {
                this.jj_consume_token(112);
                return new SpecialFunctionNode(4, this.getContextManager());
            }
            case 226: {
                this.jj_consume_token(226);
                return new SpecialFunctionNode(5, this.getContextManager());
            }
        }
        this.jj_la1[151] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode currentRoleNode() throws ParseException, StandardException {
        this.jj_consume_token(363);
        this.checkVersion(170, "ROLES");
        this.checkSqlStandardAccess("CURRENT_ROLE");
        return new SpecialFunctionNode(7, this.getContextManager());
    }

    public final JavaToSQLValueNode newInvocation() throws ParseException, StandardException {
        ArrayList<ValueNode> arrayList = new ArrayList<ValueNode>();
        this.jj_consume_token(409);
        String string = this.javaClassName();
        this.methodCallParameterList(arrayList);
        if (!(string.startsWith("org.apache.derby.diag.") || string.startsWith("org.apache.derby.catalog.") || string.startsWith("com.ibm.db2j."))) {
            this.checkInternalFeature(string);
        }
        NewInvocationNode newInvocationNode = new NewInvocationNode(string, arrayList, this.lastTokenDelimitedIdentifier, this.getContextManager());
        return new JavaToSQLValueNode(newInvocationNode, this.getContextManager());
    }

    public final JavaToSQLValueNode vtiTableConstruct() throws ParseException, StandardException {
        NewInvocationNode newInvocationNode = null;
        MethodCallNode methodCallNode = null;
        ArrayList<ValueNode> arrayList = new ArrayList<ValueNode>();
        TableName tableName = null;
        this.jj_consume_token(239);
        this.jj_consume_token(453);
        tableName = this.qualifiedName(128);
        this.methodCallParameterList(arrayList);
        this.jj_consume_token(454);
        newInvocationNode = new NewInvocationNode(tableName, null, arrayList, this.lastTokenDelimitedIdentifier, this.getContextManager());
        if (newInvocationNode.isBuiltinVTI()) {
            methodCallNode = newInvocationNode;
        } else {
            StaticMethodCallNode staticMethodCallNode = new StaticMethodCallNode(tableName, null, this.getContextManager());
            staticMethodCallNode.addParms(arrayList);
            methodCallNode = staticMethodCallNode;
        }
        return new JavaToSQLValueNode(methodCallNode, this.getContextManager());
    }

    public final ValueNode staticMethodInvocation(String string) throws ParseException, StandardException {
        ArrayList<ValueNode> arrayList = new ArrayList<ValueNode>();
        MethodCallNode methodCallNode = this.staticMethodName(string);
        this.methodCallParameterList(arrayList);
        methodCallNode.addParms(arrayList);
        return new JavaToSQLValueNode(methodCallNode, this.getContextManager());
    }

    public final void methodCallParameterList(List<ValueNode> list) throws ParseException, StandardException {
        this.jj_consume_token(453);
        if (this.jj_2_51(1)) {
            this.methodParameter(list);
            block3: while (true) {
                switch (this.jj_nt.kind) {
                    case 458: {
                        break;
                    }
                    default: {
                        this.jj_la1[152] = this.jj_gen;
                        break block3;
                    }
                }
                this.jj_consume_token(458);
                this.methodParameter(list);
            }
        }
        this.jj_consume_token(454);
    }

    public final ValueNode routineInvocation() throws ParseException, StandardException {
        if (!this.distinctUDAFollows()) {
            ValueNode valueNode = this.routineExpression();
            return valueNode;
        }
        if (this.distinctUDAFollows()) {
            ValueNode valueNode = this.distinctUDA();
            return valueNode;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode routineExpression() throws ParseException, StandardException {
        ArrayList<ValueNode> arrayList = new ArrayList<ValueNode>();
        TableName tableName = this.qualifiedName(128);
        this.methodCallParameterList(arrayList);
        StaticMethodCallNode staticMethodCallNode = new StaticMethodCallNode(tableName, null, this.getContextManager());
        staticMethodCallNode.addParms(arrayList);
        return new JavaToSQLValueNode(staticMethodCallNode, this.getContextManager());
    }

    public final ValueNode distinctUDA() throws ParseException, StandardException {
        TableName tableName = this.qualifiedName(128);
        this.jj_consume_token(453);
        this.jj_consume_token(127);
        ValueNode valueNode = this.additiveExpression(null, 0);
        this.jj_consume_token(454);
        return new AggregateNode(valueNode, tableName, true, "", this.getContextManager());
    }

    public final String javaClass() throws ParseException, StandardException {
        String string = this.javaClassName();
        return string;
    }

    public final ValueNode columnMethodInvocation() throws ParseException, StandardException {
        ValueNode valueNode = this.columnNameForInvocation();
        ValueNode valueNode2 = this.nonStaticMethodInvocation(valueNode);
        return valueNode2;
    }

    public final ValueNode columnNameForInvocation() throws ParseException, StandardException {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        TableName tableName = null;
        String string6 = this.identifier(128, true);
        if (this.getToken((int)1).kind == 460 && this.getToken((int)3).kind == 460) {
            this.jj_consume_token(460);
            string = this.identifier(128, true);
            if (this.getToken((int)1).kind == 460 && this.getToken((int)3).kind == 460) {
                this.jj_consume_token(460);
                string2 = this.identifier(128, true);
            }
        }
        if (string2 == null) {
            if (string == null) {
                string3 = string6;
            } else {
                string4 = string6;
                string3 = string;
            }
        } else {
            string5 = string6;
            string4 = string;
            string3 = string2;
        }
        if (string4 != null) {
            tableName = new TableName(string5, string4, (string2 == null ? this.nextToLastIdentifierToken : this.thirdToLastIdentifierToken).beginOffset, this.nextToLastIdentifierToken.endOffset, this.getContextManager());
        }
        ColumnReference columnReference = new ColumnReference(string3, tableName, this.lastIdentifierToken.beginOffset, this.lastIdentifierToken.endOffset, this.getContextManager());
        return columnReference;
    }

    public final ColumnReference columnReference() throws ParseException, StandardException {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        TableName tableName = null;
        String string6 = this.identifier(128, false);
        if (this.getToken((int)1).kind == 460 && this.getToken((int)3).kind != 453) {
            this.jj_consume_token(460);
            string = this.identifier(128, false);
            if (this.getToken((int)1).kind == 460 && this.getToken((int)3).kind != 453) {
                this.jj_consume_token(460);
                string2 = this.identifier(128, false);
            }
        }
        if (string2 == null) {
            if (string == null) {
                string3 = string6;
            } else {
                string4 = string6;
                string3 = string;
            }
        } else {
            string5 = string6;
            string4 = string;
            string3 = string2;
        }
        IdUtil.checkIdentifierLengthLimit(string3, 128);
        if (string5 != null) {
            IdUtil.checkIdentifierLengthLimit(string5, 128);
        }
        if (string4 != null) {
            IdUtil.checkIdentifierLengthLimit(string4, 128);
        }
        if (string4 != null) {
            tableName = new TableName(string5, string4, (string2 == null ? this.nextToLastIdentifierToken : this.thirdToLastIdentifierToken).beginOffset, this.nextToLastIdentifierToken.endOffset, this.getContextManager());
        }
        return new ColumnReference(string3, tableName, this.lastIdentifierToken.beginOffset, this.lastIdentifierToken.endOffset, this.getContextManager());
    }

    public final OrderByList orderByClause(ResultSetNode resultSetNode) throws ParseException, StandardException {
        this.jj_consume_token(200);
        this.jj_consume_token(83);
        OrderByList orderByList = this.sortSpecificationList(resultSetNode);
        this.forbidNextValueFor();
        return orderByList;
    }

    public final int atIsolationLevel() throws ParseException, StandardException {
        this.jj_consume_token(267);
        int n = this.isolationLevelDB2Abbrev();
        return n;
    }

    public final OrderByList sortSpecificationList(ResultSetNode resultSetNode) throws ParseException, StandardException {
        OrderByList orderByList = new OrderByList(resultSetNode, this.getContextManager());
        this.sortSpecification(orderByList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 458: {
                    break;
                }
                default: {
                    this.jj_la1[153] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(458);
            this.sortSpecification(orderByList);
        }
        return orderByList;
    }

    public final void sortSpecification(OrderByList orderByList) throws ParseException, StandardException {
        OrderByColumn orderByColumn = this.sortKey();
        switch (this.jj_nt.kind) {
            case 73: 
            case 123: {
                this.orderingSpecification(orderByColumn);
                break;
            }
            default: {
                this.jj_la1[154] = this.jj_gen;
            }
        }
        if (this.jj_2_52(1)) {
            this.nullOrdering(orderByColumn);
        }
        orderByList.addOrderByColumn(orderByColumn);
    }

    public final OrderByColumn sortKey() throws ParseException, StandardException {
        ValueNode valueNode = this.additiveExpression(null, 0);
        return new OrderByColumn(valueNode, this.getContextManager());
    }

    public final void orderingSpecification(OrderByColumn orderByColumn) throws ParseException {
        switch (this.jj_nt.kind) {
            case 73: {
                this.jj_consume_token(73);
                break;
            }
            case 123: {
                this.jj_consume_token(123);
                orderByColumn.setDescending();
                break;
            }
            default: {
                this.jj_la1[155] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void nullOrdering(OrderByColumn orderByColumn) throws ParseException {
        if (this.getToken((int)2).kind == 175) {
            this.jj_consume_token(320);
            this.jj_consume_token(175);
            if (!orderByColumn.isAscending()) {
                orderByColumn.setNullsOrderedLow();
            }
        } else {
            switch (this.jj_nt.kind) {
                case 320: {
                    this.jj_consume_token(320);
                    this.jj_consume_token(142);
                    if (!orderByColumn.isAscending()) break;
                    orderByColumn.setNullsOrderedLow();
                    break;
                }
                default: {
                    this.jj_la1[156] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final boolean offsetFetchFirstClause(ValueNode[] valueNodeArray) throws ParseException, StandardException {
        boolean bl = false;
        if (this.getToken((int)1).kind == 323 || this.getToken((int)1).kind == 141) {
            this.sqlStandardOffsetFetchFirst(valueNodeArray);
            return false;
        }
        if (this.getToken((int)1).kind == 451) {
            this.jdbcLimitOffset(valueNodeArray);
            bl = true;
        }
        return bl;
    }

    public final void sqlStandardOffsetFetchFirst(ValueNode[] valueNodeArray) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 323: {
                valueNodeArray[0] = this.offsetClause();
                break;
            }
            default: {
                this.jj_la1[157] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 141: {
                valueNodeArray[1] = this.fetchFirstClause();
                break;
            }
            default: {
                this.jj_la1[158] = this.jj_gen;
            }
        }
    }

    public final void jdbcLimitOffset(ValueNode[] valueNodeArray) throws ParseException, StandardException {
        ValueNode valueNode = null;
        ValueNode valueNode2 = null;
        this.jj_consume_token(451);
        this.jj_consume_token(303);
        switch (this.jj_nt.kind) {
            case 457: 
            case 459: 
            case 487: {
                valueNode = this.intLiteral();
                break;
            }
            case 472: {
                valueNode = this.dynamicParameterSpecification();
                break;
            }
            default: {
                this.jj_la1[159] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block4 : switch (this.jj_nt.kind) {
            case 323: {
                this.jj_consume_token(323);
                switch (this.jj_nt.kind) {
                    case 457: 
                    case 459: 
                    case 487: {
                        valueNode2 = this.intLiteral();
                        break block4;
                    }
                    case 472: {
                        valueNode2 = this.dynamicParameterSpecification();
                        break block4;
                    }
                }
                this.jj_la1[160] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[161] = this.jj_gen;
            }
        }
        this.jj_consume_token(452);
        if (valueNode instanceof NumericConstantNode && ((ConstantNode)valueNode).getValue().getInt() == 0) {
            valueNode = null;
        }
        if (valueNode2 == null) {
            valueNode2 = this.getNumericNode("0", true);
        }
        valueNodeArray[1] = valueNode;
        valueNodeArray[0] = valueNode2;
    }

    public final ValueNode offsetClause() throws ParseException, StandardException {
        ValueNode valueNode = null;
        this.jj_consume_token(323);
        switch (this.jj_nt.kind) {
            case 457: 
            case 459: 
            case 487: {
                valueNode = this.intLiteral();
                break;
            }
            case 472: {
                valueNode = this.dynamicParameterSpecification();
                break;
            }
            default: {
                this.jj_la1[162] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_nt.kind) {
            case 332: {
                this.jj_consume_token(332);
                break;
            }
            case 221: {
                this.jj_consume_token(221);
                break;
            }
            default: {
                this.jj_la1[163] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return valueNode;
    }

    public final ValueNode fetchFirstClause() throws ParseException, StandardException {
        ValueNode valueNode = this.getNumericNode("1", true);
        this.jj_consume_token(141);
        switch (this.jj_nt.kind) {
            case 142: {
                this.jj_consume_token(142);
                break;
            }
            case 188: {
                this.jj_consume_token(188);
                break;
            }
            default: {
                this.jj_la1[164] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block4 : switch (this.jj_nt.kind) {
            case 457: 
            case 459: 
            case 472: 
            case 487: {
                switch (this.jj_nt.kind) {
                    case 457: 
                    case 459: 
                    case 487: {
                        valueNode = this.intLiteral();
                        break block4;
                    }
                    case 472: {
                        valueNode = this.dynamicParameterSpecification();
                        break block4;
                    }
                }
                this.jj_la1[165] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[166] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 332: {
                this.jj_consume_token(332);
                break;
            }
            case 221: {
                this.jj_consume_token(221);
                break;
            }
            default: {
                this.jj_la1[167] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(196);
        return valueNode;
    }

    public final int forUpdateClause(List<String> list) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 254: {
                this.jj_consume_token(254);
                switch (this.jj_nt.kind) {
                    case 194: {
                        this.jj_consume_token(194);
                        this.forUpdateColumnList(list);
                        break;
                    }
                    default: {
                        this.jj_la1[168] = this.jj_gen;
                    }
                }
                return 2;
            }
            case 213: {
                this.jj_consume_token(213);
                this.jj_consume_token(196);
                return 1;
            }
            case 141: {
                this.jj_consume_token(141);
                this.jj_consume_token(196);
                return 1;
            }
        }
        this.jj_la1[169] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void forUpdateColumnList(List<String> list) throws ParseException, StandardException {
        this.forUpdateColumn(list);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 458: {
                    break;
                }
                default: {
                    this.jj_la1[170] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(458);
            this.forUpdateColumn(list);
        }
    }

    public final void forUpdateColumn(List<String> list) throws ParseException, StandardException {
        String string = this.identifier(128, true);
        list.add(string);
    }

    public final ResultColumnList setClauseList() throws ParseException, StandardException {
        ResultColumnList resultColumnList = new ResultColumnList(this.getContextManager());
        this.setClause(resultColumnList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 458: {
                    break;
                }
                default: {
                    this.jj_la1[171] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(458);
            this.setClause(resultColumnList);
        }
        return resultColumnList;
    }

    public final void setClause(ResultColumnList resultColumnList) throws ParseException, StandardException {
        ColumnReference columnReference = this.columnReference();
        this.jj_consume_token(467);
        ValueNode valueNode = this.updateSource(columnReference.getColumnName());
        ResultColumn resultColumn = new ResultColumn(columnReference, valueNode, this.getContextManager());
        resultColumnList.addResultColumn(resultColumn);
    }

    public final ValueNode updateSource(String string) throws ParseException, StandardException {
        if (this.jj_2_53(1)) {
            ValueNode valueNode = this.valueExpression();
            return valueNode;
        }
        switch (this.jj_nt.kind) {
            case 191: {
                ValueNode valueNode = this.nullSpecification();
                return valueNode;
            }
            case 119: {
                this.jj_consume_token(119);
                return new DefaultNode(string, this.getContextManager());
            }
        }
        this.jj_la1[172] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode nullSpecification() throws ParseException, StandardException {
        this.jj_consume_token(191);
        return new UntypedNullConstantNode(this.getContextManager());
    }

    public final StatementNode insertColumnsAndSource(QueryTreeNode queryTreeNode) throws ParseException, StandardException {
        Properties properties = null;
        ResultColumnList resultColumnList = null;
        OrderByList orderByList = null;
        ValueNode[] valueNodeArray = new ValueNode[2];
        boolean bl = false;
        if (this.getToken((int)1).kind == 453 && !this.subqueryFollows()) {
            this.jj_consume_token(453);
            resultColumnList = this.insertColumnList();
            this.jj_consume_token(454);
        }
        switch (this.jj_nt.kind) {
            case 59: {
                properties = this.propertyList(false);
                this.jj_consume_token(64);
                break;
            }
            default: {
                this.jj_la1[173] = this.jj_gen;
            }
        }
        ResultSetNode resultSetNode = this.queryExpression(null, 0);
        switch (this.jj_nt.kind) {
            case 200: {
                orderByList = this.orderByClause(resultSetNode);
                break;
            }
            default: {
                this.jj_la1[174] = this.jj_gen;
            }
        }
        bl = this.offsetFetchFirstClause(valueNodeArray);
        if (orderByList != null && this.isTableValueConstructor(resultSetNode)) {
            throw StandardException.newException("42X01", "ORDER BY");
        }
        if ((valueNodeArray[0] != null || valueNodeArray[1] != null) && this.isTableValueConstructor(resultSetNode)) {
            String string = bl ? "LIMIT" : (valueNodeArray[0] != null ? "OFFSET" : "FETCH");
            throw StandardException.newException("42X01", string);
        }
        return new InsertNode(queryTreeNode, resultColumnList, resultSetNode, null, properties, orderByList, valueNodeArray[0], valueNodeArray[1], bl, this.getContextManager());
    }

    public final ResultColumnList insertColumnList() throws ParseException, StandardException {
        ResultColumnList resultColumnList = new ResultColumnList(this.getContextManager());
        this.columnQualifiedNameList(resultColumnList);
        return resultColumnList;
    }

    public final void columnQualifiedNameList(ResultColumnList resultColumnList) throws ParseException, StandardException {
        this.columnQualifiedNameItem(resultColumnList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 458: {
                    break;
                }
                default: {
                    this.jj_la1[175] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(458);
            this.columnQualifiedNameItem(resultColumnList);
        }
    }

    public final void columnQualifiedNameItem(ResultColumnList resultColumnList) throws ParseException, StandardException {
        ColumnReference columnReference = this.columnReference();
        ResultColumn resultColumn = new ResultColumn(columnReference, null, this.getContextManager());
        resultColumnList.addResultColumn(resultColumn);
    }

    public final ResultSetNode rowValueConstructor(ResultSetNode resultSetNode) throws ParseException, StandardException {
        ResultColumnList resultColumnList = new ResultColumnList(this.getContextManager());
        if (this.rowValueConstructorListFollows()) {
            this.jj_consume_token(453);
            this.rowValueConstructorList(resultColumnList);
            this.jj_consume_token(454);
            FromTable fromTable = new RowResultSetNode(resultColumnList, null, this.getContextManager());
            if (resultSetNode != null) {
                if (resultSetNode.getResultColumns().size() != fromTable.getResultColumns().size()) {
                    throw StandardException.newException("42X59", new Object[0]);
                }
                fromTable = new UnionNode(resultSetNode, fromTable, true, true, null, this.getContextManager());
            }
            return fromTable;
        }
        this.rowValueConstructorElement(resultColumnList);
        FromTable fromTable = new RowResultSetNode(resultColumnList, null, this.getContextManager());
        if (resultSetNode != null) {
            if (resultSetNode.getResultColumns().size() != fromTable.getResultColumns().size()) {
                throw StandardException.newException("42X59", new Object[0]);
            }
            fromTable = new UnionNode(resultSetNode, fromTable, true, true, null, this.getContextManager());
        }
        return fromTable;
    }

    public final void rowValueConstructorElement(ResultColumnList resultColumnList) throws ParseException, StandardException {
        if (this.jj_2_54(1)) {
            ValueNode valueNode = this.valueExpression();
            resultColumnList.addResultColumn(new ResultColumn((String)null, valueNode, this.getContextManager()));
        } else {
            switch (this.jj_nt.kind) {
                case 191: {
                    ValueNode valueNode = this.nullSpecification();
                    resultColumnList.addResultColumn(new ResultColumn((String)null, valueNode, this.getContextManager()));
                    break;
                }
                case 119: {
                    this.jj_consume_token(119);
                    resultColumnList.addResultColumn(new ResultColumn((String)null, (ValueNode)new DefaultNode(null, this.getContextManager()), this.getContextManager()));
                    break;
                }
                default: {
                    this.jj_la1[176] = this.jj_gen;
                    throw StandardException.newException("42X80", new Object[0]);
                }
            }
        }
    }

    public final void rowValueConstructorList(ResultColumnList resultColumnList) throws ParseException, StandardException {
        this.rowValueConstructorElement(resultColumnList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 458: {
                    break;
                }
                default: {
                    this.jj_la1[177] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(458);
            this.rowValueConstructorElement(resultColumnList);
        }
    }

    public final SubqueryNode tableSubquery(int n, ValueNode valueNode) throws ParseException, StandardException {
        SubqueryNode subqueryNode = this.subquery(n, valueNode);
        return subqueryNode;
    }

    public final SubqueryNode subquery(int n, ValueNode valueNode) throws ParseException, StandardException {
        OrderByList orderByList = null;
        ValueNode[] valueNodeArray = new ValueNode[2];
        boolean bl = false;
        ResultSetNode resultSetNode = this.queryExpression(null, 0);
        switch (this.jj_nt.kind) {
            case 200: {
                orderByList = this.orderByClause(resultSetNode);
                break;
            }
            default: {
                this.jj_la1[178] = this.jj_gen;
            }
        }
        bl = this.offsetFetchFirstClause(valueNodeArray);
        SubqueryNode subqueryNode = new SubqueryNode(resultSetNode, n, valueNode, orderByList, valueNodeArray[0], valueNodeArray[1], bl, this.getContextManager());
        return subqueryNode;
    }

    public final ValueNode inPredicateValue(ValueNode valueNode) throws ParseException, StandardException {
        ValueNode valueNode2;
        this.jj_consume_token(453);
        if (this.subqueryFollows()) {
            valueNode2 = this.tableSubquery(1, valueNode);
        } else if (this.jj_2_55(1)) {
            valueNode2 = this.inValueList(valueNode);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(454);
        return valueNode2;
    }

    public final ValueNode inValueList(ValueNode valueNode) throws ParseException, StandardException {
        ValueNodeList valueNodeList = new ValueNodeList(this.getContextManager());
        this.inElement(valueNodeList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 458: {
                    break;
                }
                default: {
                    this.jj_la1[179] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(458);
            this.inElement(valueNodeList);
        }
        return new InListOperatorNode(valueNode, valueNodeList, this.getContextManager());
    }

    public final void inElement(ValueNodeList valueNodeList) throws ParseException, StandardException {
        ValueNode valueNode = this.additiveExpression(null, 0);
        valueNodeList.addElement(valueNode);
    }

    public final int quantifier(int n) throws ParseException, StandardException {
        int n2 = 0;
        switch (this.jj_nt.kind) {
            case 66: {
                this.jj_consume_token(66);
                switch (n) {
                    case 6: {
                        n2 = 4;
                        break;
                    }
                    case 7: {
                        n2 = 6;
                        break;
                    }
                    case 11: {
                        n2 = 14;
                        break;
                    }
                    case 10: {
                        n2 = 12;
                        break;
                    }
                    case 9: {
                        n2 = 10;
                        break;
                    }
                    case 8: {
                        n2 = 8;
                        break;
                    }
                }
                return n2;
            }
            case 70: 
            case 229: {
                this.some();
                switch (n) {
                    case 6: {
                        n2 = 3;
                        break;
                    }
                    case 7: {
                        n2 = 5;
                        break;
                    }
                    case 11: {
                        n2 = 13;
                        break;
                    }
                    case 10: {
                        n2 = 11;
                        break;
                    }
                    case 9: {
                        n2 = 9;
                        break;
                    }
                    case 8: {
                        n2 = 7;
                        break;
                    }
                }
                return n2;
            }
        }
        this.jj_la1[180] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void some() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 229: {
                this.jj_consume_token(229);
                break;
            }
            case 70: {
                this.jj_consume_token(70);
                break;
            }
            default: {
                this.jj_la1[181] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final SubqueryNode existsExpression() throws ParseException, StandardException {
        this.jj_consume_token(138);
        this.jj_consume_token(453);
        SubqueryNode subqueryNode = this.tableSubquery(15, null);
        this.jj_consume_token(454);
        return subqueryNode;
    }

    public final SelectNode tableExpression(ResultColumnList resultColumnList) throws ParseException, StandardException {
        ValueNode valueNode = null;
        GroupByList groupByList = null;
        ValueNode valueNode2 = null;
        WindowList windowList = null;
        OptimizerPlan optimizerPlan = null;
        FromList fromList = this.fromClause();
        switch (this.jj_nt.kind) {
            case 265: {
                Token token = this.jj_consume_token(265);
                valueNode = this.whereClause(token);
                break;
            }
            default: {
                this.jj_la1[182] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 155: {
                groupByList = this.groupByClause();
                break;
            }
            default: {
                this.jj_la1[183] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 156: {
                valueNode2 = this.havingClause();
                break;
            }
            default: {
                this.jj_la1[184] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 266: {
                windowList = this.windowClause();
                break;
            }
            default: {
                this.jj_la1[185] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 359: {
                optimizerPlan = this.optimizerOverridePlan();
                break;
            }
            default: {
                this.jj_la1[186] = this.jj_gen;
            }
        }
        if (valueNode2 != null && groupByList == null) {
            AggregateNode aggregateNode = new AggregateNode(null, CountAggregateDefinition.class, false, "COUNT(*)", this.getContextManager());
            aggregateNode.replaceAggregatesWithColumnReferences(resultColumnList, 0);
        }
        SelectNode selectNode = new SelectNode(resultColumnList, fromList, valueNode, groupByList, valueNode2, windowList, optimizerPlan, this.getContextManager());
        return selectNode;
    }

    public final FromList fromClause() throws ParseException, StandardException {
        FromList fromList = new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager());
        this.jj_consume_token(147);
        Token token = this.getToken(1);
        switch (this.jj_nt.kind) {
            case 59: {
                this.fromListProperties(fromList);
                break;
            }
            default: {
                this.jj_la1[187] = this.jj_gen;
            }
        }
        this.dummyTableReferenceRule(fromList);
        block6: while (true) {
            switch (this.jj_nt.kind) {
                case 458: {
                    break;
                }
                default: {
                    this.jj_la1[188] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(458);
            this.dummyTableReferenceRule(fromList);
        }
        Token token2 = this.getToken(0);
        fromList.setBeginOffset(token.beginOffset);
        fromList.setEndOffset(token2.endOffset);
        return fromList;
    }

    public final void fromListProperties(FromList fromList) throws ParseException, StandardException {
        Properties properties = this.propertyList(true);
        this.jj_consume_token(64);
        fromList.setProperties(properties);
    }

    public final void dummyTableReferenceRule(FromList fromList) throws ParseException, StandardException {
        if (this.getToken((int)1).kind == 239 && this.getToken((int)2).kind == 453 && (this.getToken((int)3).kind == 225 || this.getToken((int)3).kind == 259)) {
            this.jj_consume_token(239);
            FromTable fromTable = this.tableReferenceTypes(false);
            fromList.addFromTable(fromTable);
        } else if (this.jj_2_56(1)) {
            FromTable fromTable = this.tableReferenceTypes(false);
            fromList.addFromTable(fromTable);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final FromTable tableReferenceTypes(boolean bl) throws ParseException, StandardException {
        if (this.jj_2_57(1)) {
            FromTable fromTable = this.tableReference(bl);
            return fromTable;
        }
        switch (this.jj_nt.kind) {
            case 451: {
                this.jj_consume_token(451);
                this.jj_consume_token(412);
                FromTable fromTable = this.tableReference(bl);
                this.jj_consume_token(452);
                return fromTable;
            }
        }
        this.jj_la1[189] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Object[] optionalTableClauses() throws ParseException, StandardException {
        Object[] objectArray = null;
        Properties properties = null;
        ResultColumnList resultColumnList = null;
        String string = null;
        switch (this.jj_nt.kind) {
            case 59: {
                objectArray = this.optionalTableProperties();
                objectArray[1] = resultColumnList;
                objectArray[2] = string;
                return objectArray;
            }
        }
        this.jj_la1[193] = this.jj_gen;
        if (this.jj_2_58(1)) {
            switch (this.jj_nt.kind) {
                case 72: {
                    this.jj_consume_token(72);
                    break;
                }
                default: {
                    this.jj_la1[190] = this.jj_gen;
                }
            }
            string = this.identifier(128, true);
            switch (this.jj_nt.kind) {
                case 453: {
                    this.jj_consume_token(453);
                    resultColumnList = this.derivedColumnList();
                    this.jj_consume_token(454);
                    break;
                }
                default: {
                    this.jj_la1[191] = this.jj_gen;
                }
            }
            switch (this.jj_nt.kind) {
                case 59: {
                    properties = this.propertyList(true);
                    this.jj_consume_token(64);
                    break;
                }
                default: {
                    this.jj_la1[192] = this.jj_gen;
                }
            }
        }
        objectArray = new Object[]{properties, resultColumnList, string};
        return objectArray;
    }

    public final Object[] optionalTableProperties() throws ParseException, StandardException {
        Object[] objectArray = null;
        Properties properties = null;
        properties = this.propertyList(true);
        this.jj_consume_token(64);
        objectArray = new Object[3];
        objectArray[0] = properties;
        return objectArray;
    }

    public final FromTable tableReference(boolean bl) throws ParseException, StandardException {
        TableOperatorNode tableOperatorNode = null;
        FromTable fromTable = this.tableFactor();
        while (this.joinedTableExpressionFollows()) {
            tableOperatorNode = this.joinedTableExpression(tableOperatorNode == null ? fromTable : tableOperatorNode, bl);
        }
        return tableOperatorNode == null ? fromTable : tableOperatorNode;
    }

    public final FromTable tableFactor() throws ParseException, StandardException {
        JavaToSQLValueNode javaToSQLValueNode = null;
        String string = null;
        ResultColumnList resultColumnList = null;
        Object[] objectArray = new Object[3];
        Object var8_5 = null;
        if (this.jj_2_59(1)) {
            if (this.newInvocationFollows(1)) {
                javaToSQLValueNode = this.newInvocation();
            } else {
                switch (this.jj_nt.kind) {
                    case 239: {
                        javaToSQLValueNode = this.vtiTableConstruct();
                        break;
                    }
                    default: {
                        this.jj_la1[194] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            switch (this.jj_nt.kind) {
                case 72: {
                    this.jj_consume_token(72);
                    break;
                }
                default: {
                    this.jj_la1[195] = this.jj_gen;
                }
            }
            string = this.identifier(128, true);
            switch (this.jj_nt.kind) {
                case 453: {
                    this.jj_consume_token(453);
                    resultColumnList = this.derivedColumnList();
                    this.jj_consume_token(454);
                    break;
                }
                default: {
                    this.jj_la1[196] = this.jj_gen;
                }
            }
            switch (this.jj_nt.kind) {
                case 59: {
                    objectArray = this.optionalTableProperties();
                    break;
                }
                default: {
                    this.jj_la1[197] = this.jj_gen;
                }
            }
            FromVTI fromVTI = new FromVTI((MethodCallNode)javaToSQLValueNode.getJavaValueNode(), string, resultColumnList, objectArray != null ? (Properties)objectArray[0] : (Properties)null, this.getContextManager());
            return fromVTI;
        }
        if (this.jj_2_60(1)) {
            TableName tableName = this.qualifiedName(128);
            objectArray = this.optionalTableClauses();
            FromBaseTable fromBaseTable = new FromBaseTable(tableName, (String)objectArray[2], (ResultColumnList)objectArray[1], (Properties)objectArray[0], this.getContextManager());
            return fromBaseTable;
        }
        if (this.getToken((int)1).kind == 453 && (this.getToken((int)2).kind == 225 || this.getToken((int)2).kind == 259)) {
            SubqueryNode subqueryNode = this.derivedTable();
            switch (this.jj_nt.kind) {
                case 72: {
                    this.jj_consume_token(72);
                    break;
                }
                default: {
                    this.jj_la1[198] = this.jj_gen;
                }
            }
            string = this.identifier(128, true);
            switch (this.jj_nt.kind) {
                case 453: {
                    this.jj_consume_token(453);
                    resultColumnList = this.derivedColumnList();
                    this.jj_consume_token(454);
                    break;
                }
                default: {
                    this.jj_la1[199] = this.jj_gen;
                }
            }
            switch (this.jj_nt.kind) {
                case 59: {
                    objectArray = this.optionalTableProperties();
                    break;
                }
                default: {
                    this.jj_la1[200] = this.jj_gen;
                }
            }
            FromSubquery fromSubquery = new FromSubquery(subqueryNode.getResultSet(), subqueryNode.getOrderByList(), subqueryNode.getOffset(), subqueryNode.getFetchFirst(), subqueryNode.hasJDBClimitClause(), string, resultColumnList, objectArray != null ? (Properties)objectArray[0] : (Properties)null, this.getContextManager());
            return fromSubquery;
        }
        switch (this.jj_nt.kind) {
            case 453: {
                this.jj_consume_token(453);
                FromTable fromTable = this.tableReferenceTypes(true);
                this.jj_consume_token(454);
                FromTable fromTable2 = fromTable;
                return fromTable2;
            }
        }
        this.jj_la1[201] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ResultColumnList derivedColumnList() throws ParseException, StandardException {
        ResultColumnList resultColumnList = new ResultColumnList(this.getContextManager());
        this.columnNameList(resultColumnList);
        return resultColumnList;
    }

    public final void columnNameList(ResultColumnList resultColumnList) throws ParseException, StandardException {
        this.columnNameItem(resultColumnList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 458: {
                    break;
                }
                default: {
                    this.jj_la1[202] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(458);
            this.columnNameItem(resultColumnList);
        }
    }

    public final void columnNameItem(ResultColumnList resultColumnList) throws ParseException, StandardException {
        String string = this.identifier(128, true);
        ResultColumn resultColumn = new ResultColumn(string, null, this.getContextManager());
        resultColumnList.addResultColumn(resultColumn);
    }

    public final void indexColumnList(List<String> list) throws ParseException, StandardException {
        this.indexColumnItem(list);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 458: {
                    break;
                }
                default: {
                    this.jj_la1[203] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(458);
            this.indexColumnItem(list);
        }
    }

    public final void indexColumnItem(List<String> list) throws ParseException, StandardException {
        String string = this.identifier(128, true);
        block0 : switch (this.jj_nt.kind) {
            case 73: 
            case 123: {
                switch (this.jj_nt.kind) {
                    case 73: {
                        this.jj_consume_token(73);
                        break block0;
                    }
                    case 123: {
                        this.jj_consume_token(123);
                        string = string + ' ';
                        break block0;
                    }
                }
                this.jj_la1[204] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[205] = this.jj_gen;
            }
        }
        list.add(string);
    }

    public final SubqueryNode derivedTable() throws ParseException, StandardException {
        this.jj_consume_token(453);
        SubqueryNode subqueryNode = this.tableSubquery(0, null);
        this.jj_consume_token(454);
        return subqueryNode;
    }

    public final TableOperatorNode joinedTableExpression(ResultSetNode resultSetNode, boolean bl) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 107: {
                TableOperatorNode tableOperatorNode = this.crossJoin(resultSetNode, bl);
                return tableOperatorNode;
            }
            case 163: 
            case 173: 
            case 177: 
            case 219: {
                TableOperatorNode tableOperatorNode = this.qualifiedJoin(resultSetNode, bl);
                return tableOperatorNode;
            }
            case 186: {
                TableOperatorNode tableOperatorNode = this.naturalJoin(resultSetNode, bl);
                return tableOperatorNode;
            }
        }
        this.jj_la1[206] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final TableOperatorNode crossJoin(ResultSetNode resultSetNode, boolean bl) throws ParseException, StandardException {
        this.jj_consume_token(107);
        this.jj_consume_token(173);
        FromTable fromTable = this.tableFactor();
        JoinNode joinNode = this.newJoinNode(resultSetNode, fromTable, null, null, 1);
        joinNode.setNestedInParens(bl);
        return joinNode;
    }

    public final TableOperatorNode qualifiedJoin(ResultSetNode resultSetNode, boolean bl) throws ParseException, StandardException {
        int n = 1;
        JoinNode joinNode = null;
        Object[] objectArray = null;
        ResultColumnList resultColumnList = null;
        switch (this.jj_nt.kind) {
            case 163: 
            case 177: 
            case 219: {
                n = this.joinType();
                break;
            }
            default: {
                this.jj_la1[207] = this.jj_gen;
            }
        }
        this.jj_consume_token(173);
        FromTable fromTable = this.tableReferenceTypes(bl);
        objectArray = this.joinSpecification(resultSetNode, fromTable);
        ValueNode valueNode = (ValueNode)objectArray[0];
        resultColumnList = (ResultColumnList)objectArray[1];
        if (valueNode == null && resultColumnList == null) {
            throw StandardException.newException("42Y11", JoinNode.joinTypeToString(n));
        }
        joinNode = this.newJoinNode(resultSetNode, fromTable, valueNode, resultColumnList, n);
        joinNode.setNestedInParens(bl);
        return joinNode;
    }

    public final TableOperatorNode naturalJoin(ResultSetNode resultSetNode, boolean bl) throws ParseException, StandardException {
        int n = 1;
        this.jj_consume_token(186);
        switch (this.jj_nt.kind) {
            case 163: 
            case 177: 
            case 219: {
                n = this.joinType();
                break;
            }
            default: {
                this.jj_la1[208] = this.jj_gen;
            }
        }
        this.jj_consume_token(173);
        FromTable fromTable = this.tableFactor();
        JoinNode joinNode = this.newJoinNode(resultSetNode, fromTable, null, null, n);
        joinNode.setNestedInParens(bl);
        joinNode.setNaturalJoin();
        return joinNode;
    }

    public final int joinType() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 163: {
                this.jj_consume_token(163);
                return 1;
            }
            case 177: 
            case 219: {
                int n = this.outerJoinType();
                switch (this.jj_nt.kind) {
                    case 201: {
                        this.jj_consume_token(201);
                        break;
                    }
                    default: {
                        this.jj_la1[209] = this.jj_gen;
                    }
                }
                return n;
            }
        }
        this.jj_la1[210] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int outerJoinType() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 177: {
                this.jj_consume_token(177);
                return 3;
            }
            case 219: {
                this.jj_consume_token(219);
                return 4;
            }
        }
        this.jj_la1[211] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Object[] joinSpecification(ResultSetNode resultSetNode, ResultSetNode resultSetNode2) throws ParseException, StandardException {
        Object[] objectArray = new Object[2];
        ResultColumnList resultColumnList = null;
        ValueNode valueNode = null;
        switch (this.jj_nt.kind) {
            case 195: {
                valueNode = this.joinCondition();
                objectArray[0] = valueNode;
                objectArray[1] = resultColumnList;
                return objectArray;
            }
            case 257: {
                resultColumnList = this.namedColumnsJoin();
                objectArray[0] = valueNode;
                objectArray[1] = resultColumnList;
                return objectArray;
            }
        }
        this.jj_la1[212] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode joinCondition() throws ParseException, StandardException {
        this.jj_consume_token(195);
        ValueNode valueNode = this.valueExpression();
        return valueNode;
    }

    public final ResultColumnList namedColumnsJoin() throws ParseException, StandardException {
        ResultColumnList resultColumnList = new ResultColumnList(this.getContextManager());
        this.jj_consume_token(257);
        this.jj_consume_token(453);
        this.columnNameList(resultColumnList);
        this.jj_consume_token(454);
        return resultColumnList;
    }

    public final ResultSetNode tableValueConstructor() throws ParseException, StandardException {
        this.jj_consume_token(259);
        ResultSetNode resultSetNode = this.tableValueConstructorList();
        return resultSetNode;
    }

    public final ResultSetNode tableValueConstructorList() throws ParseException, StandardException {
        ResultSetNode resultSetNode = this.rowValueConstructor(null);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 458: {
                    break;
                }
                default: {
                    this.jj_la1[213] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(458);
            resultSetNode = this.rowValueConstructor(resultSetNode);
        }
        if (resultSetNode instanceof UnionNode) {
            ((UnionNode)resultSetNode).markTopTableConstructor();
        }
        return resultSetNode;
    }

    public final ValueNode datetimeValueFunction() throws ParseException, StandardException {
        int n = -1;
        if (this.getToken((int)1).kind == 108 && this.getToken((int)2).kind == 285) {
            this.jj_consume_token(108);
            this.jj_consume_token(285);
            return new CurrentDatetimeOperatorNode(0, this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 109: {
                this.jj_consume_token(109);
                return new CurrentDatetimeOperatorNode(0, this.getContextManager());
            }
        }
        this.jj_la1[214] = this.jj_gen;
        if (this.getToken((int)1).kind == 108 && this.getToken((int)2).kind == 350) {
            this.jj_consume_token(108);
            this.jj_consume_token(350);
            return new CurrentDatetimeOperatorNode(1, this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 110: {
                this.jj_consume_token(110);
                return new CurrentDatetimeOperatorNode(1, this.getContextManager());
            }
        }
        this.jj_la1[215] = this.jj_gen;
        if (this.getToken((int)1).kind == 108 && this.getToken((int)2).kind == 351) {
            this.jj_consume_token(108);
            this.jj_consume_token(351);
            return new CurrentDatetimeOperatorNode(2, this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 111: {
                this.jj_consume_token(111);
                return new CurrentDatetimeOperatorNode(2, this.getContextManager());
            }
        }
        this.jj_la1[216] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode windowOrAggregateFunctionNode() throws ParseException, StandardException {
        WindowNode windowNode = null;
        AggregateNode aggregateNode = null;
        switch (this.jj_nt.kind) {
            case 105: {
                this.jj_consume_token(105);
                this.jj_consume_token(453);
                switch (this.jj_nt.kind) {
                    case 455: {
                        this.jj_consume_token(455);
                        aggregateNode = new AggregateNode(null, CountAggregateDefinition.class, false, "COUNT(*)", this.getContextManager());
                        break;
                    }
                    default: {
                        this.jj_la1[217] = this.jj_gen;
                        if (this.jj_2_61(1)) {
                            aggregateNode = this.aggregateExpression("COUNT", CountAggregateDefinition.class);
                            break;
                        }
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(454);
                if (this.jj_2_62(1)) {
                    windowNode = this.overClause();
                }
                if (windowNode != null) {
                    return new AggregateWindowFunctionNode(windowNode, aggregateNode, this.getContextManager());
                }
                return aggregateNode;
            }
            case 77: 
            case 181: 
            case 182: 
            case 236: {
                aggregateNode = this.generalAggregate();
                if (this.jj_2_63(1)) {
                    windowNode = this.overClause();
                }
                if (windowNode != null) {
                    return new AggregateWindowFunctionNode(windowNode, aggregateNode, this.getContextManager());
                }
                return aggregateNode;
            }
            case 374: {
                this.jj_consume_token(374);
                this.jj_consume_token(453);
                this.jj_consume_token(454);
                windowNode = this.overClause();
                return new RowNumberFunctionNode(null, windowNode, this.getContextManager());
            }
        }
        this.jj_la1[218] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final WindowNode overClause() throws ParseException, StandardException {
        OrderByList orderByList = null;
        if (this.getToken((int)2).kind != 453 && this.getToken((int)2).kind != 480) {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(372);
        switch (this.jj_nt.kind) {
            case 453: {
                this.jj_consume_token(453);
                switch (this.jj_nt.kind) {
                    case 200: {
                        orderByList = this.orderByClause(null);
                        break;
                    }
                    default: {
                        this.jj_la1[219] = this.jj_gen;
                    }
                }
                this.jj_consume_token(454);
                return new WindowDefinitionNode(null, orderByList, this.getContextManager());
            }
        }
        this.jj_la1[220] = this.jj_gen;
        if (this.jj_2_64(1)) {
            String string = this.identifier(128, true);
            return new WindowReferenceNode(string, this.getContextManager());
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final AggregateNode aggregateExpression(String string, Class clazz) throws ParseException, StandardException {
        boolean bl = false;
        if (this.jj_2_65(1)) {
            bl = this.setQuantifier();
        }
        ValueNode valueNode = this.additiveExpression(null, 0);
        return new AggregateNode(valueNode, clazz, bl, string, this.getContextManager());
    }

    public final AggregateNode generalAggregate() throws ParseException, StandardException {
        Token token = this.builtInAggregateType();
        this.jj_consume_token(453);
        AggregateNode aggregateNode = this.aggregateExpression(SQLParser.aggName(token), SQLParser.aggClass(token));
        this.jj_consume_token(454);
        return aggregateNode;
    }

    public final Token builtInAggregateType() throws ParseException, StandardException {
        Token token;
        switch (this.jj_nt.kind) {
            case 181: {
                token = this.jj_consume_token(181);
                break;
            }
            case 77: {
                token = this.jj_consume_token(77);
                break;
            }
            case 182: {
                token = this.jj_consume_token(182);
                break;
            }
            case 236: {
                token = this.jj_consume_token(236);
                break;
            }
            default: {
                this.jj_la1[221] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return token;
    }

    public final ValueNode castSpecification() throws ParseException, StandardException {
        int n = -1;
        TableName[] tableNameArray = new TableName[1];
        this.jj_consume_token(87);
        this.jj_consume_token(453);
        ValueNode valueNode = this.castOperand();
        this.jj_consume_token(72);
        DataTypeDescriptor dataTypeDescriptor = this.dataTypeCast(tableNameArray);
        this.jj_consume_token(454);
        CastNode castNode = new CastNode(valueNode, dataTypeDescriptor, this.getContextManager());
        castNode.setForExternallyGeneratedCASTnode();
        castNode.setTargetUDTName(tableNameArray[0]);
        ValueNode valueNode2 = castNode;
        if (dataTypeDescriptor.getTypeId().userType()) {
            valueNode2 = new JavaToSQLValueNode(new SQLToJavaValueNode(valueNode2, this.getContextManager()), this.getContextManager());
        }
        return valueNode2;
    }

    public final ValueNode nextValueExpression() throws ParseException, StandardException {
        this.jj_consume_token(188);
        this.jj_consume_token(258);
        this.jj_consume_token(144);
        TableName tableName = this.qualifiedName(128);
        this.checkVersion(180, "NEXT VALUE");
        return new NextSequenceNode(tableName, this.getContextManager());
    }

    public final int charOrVarchar() throws ParseException {
        switch (this.jj_nt.kind) {
            case 88: {
                this.jj_consume_token(88);
                return 1;
            }
            case 261: {
                this.jj_consume_token(261);
                return 12;
            }
        }
        this.jj_la1[222] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode castOperand() throws ParseException, StandardException {
        if (this.jj_2_66(1)) {
            ValueNode valueNode = this.additiveExpression(null, 0);
            return valueNode;
        }
        switch (this.jj_nt.kind) {
            case 191: {
                this.jj_consume_token(191);
                return new UntypedNullConstantNode(this.getContextManager());
            }
        }
        this.jj_la1[223] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ParameterNode dynamicParameterSpecification() throws ParseException, StandardException {
        this.jj_consume_token(472);
        return this.makeParameterNode();
    }

    public final ValueNode whereClause(Token token) throws ParseException, StandardException {
        ValueNode valueNode = this.valueExpression();
        Token token2 = this.getToken(0);
        valueNode.setBeginOffset(token.endOffset + 1);
        valueNode.setEndOffset(token2.endOffset);
        return valueNode;
    }

    public final GroupByList groupByClause() throws ParseException, StandardException {
        this.jj_consume_token(155);
        this.jj_consume_token(83);
        if (this.getToken((int)1).kind == 331 && this.getToken((int)2).kind == 453) {
            this.jj_consume_token(331);
            this.jj_consume_token(453);
            GroupByList groupByList = this.groupingColumnReferenceList();
            this.jj_consume_token(454);
            groupByList.setRollup();
            return groupByList;
        }
        if (this.jj_2_67(1)) {
            GroupByList groupByList = this.groupingColumnReferenceList();
            return groupByList;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final GroupByList groupingColumnReferenceList() throws ParseException, StandardException {
        GroupByList groupByList = new GroupByList(this.getContextManager());
        this.groupingColumnReference(groupByList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 458: {
                    break;
                }
                default: {
                    this.jj_la1[224] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(458);
            this.groupingColumnReference(groupByList);
        }
        return groupByList;
    }

    public final void groupingColumnReference(GroupByList groupByList) throws ParseException, StandardException {
        ValueNode valueNode = this.additiveExpression(null, 0);
        HasNodeVisitor hasNodeVisitor = new HasNodeVisitor(AggregateNode.class);
        valueNode.accept(hasNodeVisitor);
        if (hasNodeVisitor.hasNode()) {
            throw StandardException.newException("42Y26.S.0", new Object[0]);
        }
        CollectNodesVisitor<StaticMethodCallNode> collectNodesVisitor = new CollectNodesVisitor<StaticMethodCallNode>(StaticMethodCallNode.class);
        valueNode.accept(collectNodesVisitor);
        for (StaticMethodCallNode staticMethodCallNode : collectNodesVisitor.getList()) {
            staticMethodCallNode.setAppearsInGroupBy();
        }
        if (valueNode.isParameterNode()) {
            throw StandardException.newException("42X01", "?");
        }
        groupByList.addGroupByColumn(new GroupByColumn(valueNode, this.getContextManager()));
    }

    public final ValueNode havingClause() throws ParseException, StandardException {
        this.jj_consume_token(156);
        ValueNode valueNode = this.valueExpression();
        return valueNode;
    }

    public final WindowList windowClause() throws ParseException, StandardException {
        WindowList windowList = new WindowList(this.getContextManager());
        this.jj_consume_token(266);
        windowList = this.windowDefinition(windowList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 458: {
                    break;
                }
                default: {
                    this.jj_la1[225] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(458);
            windowList = this.windowDefinition(windowList);
        }
        return windowList;
    }

    public final WindowList windowDefinition(WindowList windowList) throws ParseException, StandardException {
        OrderByList orderByList = null;
        String string = this.identifier(128, true);
        this.jj_consume_token(72);
        this.jj_consume_token(453);
        switch (this.jj_nt.kind) {
            case 200: {
                orderByList = this.orderByClause(null);
                break;
            }
            default: {
                this.jj_la1[226] = this.jj_gen;
            }
        }
        this.jj_consume_token(454);
        windowList.addWindow(new WindowDefinitionNode(string, orderByList, this.getContextManager()));
        return windowList;
    }

    public final OptimizerPlan optimizerOverridePlan() throws ParseException, StandardException {
        this.jj_consume_token(359);
        OptimizerPlan optimizerPlan = this.optimizerPlan();
        return optimizerPlan;
    }

    public final OptimizerPlan optimizerPlan() throws ParseException, StandardException {
        if (this.getToken((int)1).kind == 453) {
            OptimizerPlan optimizerPlan = this.optimizerJoin();
            return optimizerPlan;
        }
        if (this.jj_2_68(1)) {
            OptimizerPlan optimizerPlan = this.optimizerRowSource();
            return optimizerPlan;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final OptimizerPlan optimizerJoin() throws ParseException, StandardException {
        this.jj_consume_token(453);
        OptimizerPlan optimizerPlan = this.optimizerPlan();
        JoinStrategy joinStrategy = this.joinStrategy();
        OptimizerPlan optimizerPlan2 = this.optimizerPlan();
        this.jj_consume_token(454);
        return new OptimizerPlan.Join(joinStrategy, optimizerPlan, optimizerPlan2);
    }

    public final JoinStrategy joinStrategy() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 455: {
                this.jj_consume_token(455);
                return new NestedLoopJoinStrategy();
            }
            case 456: {
                this.jj_consume_token(456);
                return new HashJoinStrategy();
            }
        }
        this.jj_la1[227] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final OptimizerPlan optimizerRowSource() throws ParseException, StandardException {
        TableName tableName = null;
        Token token = null;
        tableName = this.qualifiedName(128);
        switch (this.jj_nt.kind) {
            case 453: {
                token = this.jj_consume_token(453);
                this.jj_consume_token(454);
                break;
            }
            default: {
                this.jj_la1[228] = this.jj_gen;
            }
        }
        if (token != null) {
            return new OptimizerPlan.TableFunctionRS(tableName.getSchemaName(), tableName.getTableName());
        }
        return new OptimizerPlan.ConglomerateRS(tableName.getSchemaName(), tableName.getTableName());
    }

    public final StatementNode schemaDefinition() throws ParseException, StandardException {
        String string = null;
        String string2 = null;
        this.jj_consume_token(222);
        if (this.jj_2_69(1)) {
            string = this.identifier(128, true);
            switch (this.jj_nt.kind) {
                case 76: {
                    this.jj_consume_token(76);
                    string2 = this.identifier(128, true);
                    break;
                }
                default: {
                    this.jj_la1[229] = this.jj_gen;
                }
            }
            if (string2 != null) {
                this.checkVersion(140, "AUTHORIZATION");
            }
            if (string.startsWith("SYS")) {
                throw StandardException.newException("42939", string);
            }
            return new CreateSchemaNode(string, string2, this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 76: {
                this.jj_consume_token(76);
                string2 = this.identifier(128, true);
                this.checkVersion(140, "AUTHORIZATION");
                if (string2.startsWith("SYS")) {
                    throw StandardException.newException("42939", string2);
                }
                return new CreateSchemaNode(string2, string2, this.getContextManager());
            }
        }
        this.jj_la1[230] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode roleDefinition() throws ParseException, StandardException {
        String string = null;
        this.jj_consume_token(373);
        string = this.identifier(128, true);
        this.checkVersion(170, "ROLES");
        this.checkSqlStandardAccess("CREATE ROLE");
        if (string.startsWith("SYS")) {
            throw StandardException.newException("4293A", string);
        }
        return new CreateRoleNode(string, this.getContextManager());
    }

    public final StatementNode sequenceDefinition() throws ParseException, StandardException {
        TableName tableName = null;
        DataTypeDescriptor dataTypeDescriptor = null;
        Long l = null;
        Long l2 = null;
        Long l3 = null;
        Long l4 = null;
        Boolean bl = Boolean.FALSE;
        Object[] objectArray = new Object[6];
        this.jj_consume_token(432);
        tableName = this.qualifiedName(128);
        while (this.jj_2_70(1)) {
            this.sequenceGeneratorOption(objectArray);
        }
        this.checkVersion(180, "SEQUENCES");
        if (objectArray[0] != null) {
            dataTypeDescriptor = (DataTypeDescriptor)objectArray[0];
        }
        if (objectArray[1] != null) {
            l = (Long)objectArray[1];
        }
        if (objectArray[2] != null) {
            l2 = (Long)objectArray[2];
        }
        if (objectArray[3] != null && !(objectArray[3] instanceof Boolean)) {
            l3 = (Long)objectArray[3];
        }
        if (objectArray[4] != null && !(objectArray[4] instanceof Boolean)) {
            l4 = (Long)objectArray[4];
        }
        if (objectArray[5] != null) {
            bl = (Boolean)objectArray[5];
        }
        return new CreateSequenceNode(tableName, dataTypeDescriptor, l, l2, l3, l4, bl, this.getContextManager());
    }

    public final void sequenceGeneratorOption(Object[] objectArray) throws ParseException, StandardException {
        Serializable serializable = null;
        int n = -1;
        Boolean[] booleanArray = new Boolean[1];
        Object var5_5 = null;
        Token token = null;
        block0 : switch (this.jj_nt.kind) {
            case 72: {
                token = this.jj_consume_token(72);
                serializable = this.exactIntegerType();
                n = 0;
                break;
            }
            case 346: {
                token = this.jj_consume_token(346);
                this.jj_consume_token(267);
                serializable = this.exactIntegerObject();
                n = 1;
                break;
            }
            case 294: {
                token = this.jj_consume_token(294);
                this.jj_consume_token(83);
                serializable = this.exactIntegerObject();
                n = 2;
                break;
            }
            default: {
                this.jj_la1[233] = this.jj_gen;
                if (this.jj_2_71(1)) {
                    switch (this.jj_nt.kind) {
                        case 308: {
                            token = this.jj_consume_token(308);
                            serializable = this.exactIntegerObject();
                            break;
                        }
                        default: {
                            this.jj_la1[231] = this.jj_gen;
                            if (this.getToken((int)2).kind == 308) {
                                this.jj_consume_token(189);
                                token = this.jj_consume_token(308);
                                serializable = Boolean.FALSE;
                                break;
                            }
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    n = 3;
                    break;
                }
                if (this.jj_2_72(1)) {
                    switch (this.jj_nt.kind) {
                        case 310: {
                            token = this.jj_consume_token(310);
                            serializable = this.exactIntegerObject();
                            break;
                        }
                        default: {
                            this.jj_la1[232] = this.jj_gen;
                            if (this.getToken((int)2).kind == 310) {
                                this.jj_consume_token(189);
                                token = this.jj_consume_token(310);
                                serializable = Boolean.FALSE;
                                break;
                            }
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    n = 4;
                    break;
                }
                switch (this.jj_nt.kind) {
                    case 189: 
                    case 283: {
                        token = this.cycleClause(booleanArray);
                        serializable = booleanArray[0];
                        n = 5;
                        break block0;
                    }
                }
                this.jj_la1[234] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (n != -1) {
            if (objectArray[n] != null) {
                throw StandardException.newException("42XAJ", token.image);
            }
            objectArray[n] = serializable;
        }
    }

    public final Token cycleClause(Boolean[] booleanArray) throws ParseException, StandardException {
        Token token = null;
        switch (this.jj_nt.kind) {
            case 283: {
                token = this.jj_consume_token(283);
                booleanArray[0] = Boolean.TRUE;
                return token;
            }
            case 189: {
                this.jj_consume_token(189);
                token = this.jj_consume_token(283);
                booleanArray[0] = Boolean.FALSE;
                return token;
            }
        }
        this.jj_la1[235] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Long exactIntegerObject() throws ParseException, StandardException {
        long l = this.exactNumber();
        return l;
    }

    public final Long stepValue() throws ParseException, StandardException {
        this.jj_consume_token(294);
        this.jj_consume_token(83);
        long l = this.exactNumber();
        return l;
    }

    public final StatementNode dropSequenceStatement() throws ParseException, StandardException {
        this.jj_consume_token(432);
        TableName tableName = this.qualifiedName(128);
        this.jj_consume_token(217);
        this.checkVersion(180, "SEQUENCES");
        return new DropSequenceNode(tableName, this.getContextManager());
    }

    public final StatementNode tableDefinition() throws ParseException, StandardException {
        char c = 'R';
        Properties properties = null;
        ResultColumnList resultColumnList = null;
        boolean bl = true;
        this.jj_consume_token(239);
        TableName tableName = this.qualifiedName(128);
        if (this.getToken((int)1).kind == 453 && this.getToken((int)3).kind != 458 && this.getToken((int)3).kind != 454) {
            TableElementList tableElementList = this.tableElementList();
            switch (this.jj_nt.kind) {
                case 59: {
                    properties = this.propertyList(false);
                    this.jj_consume_token(64);
                    break;
                }
                default: {
                    this.jj_la1[236] = this.jj_gen;
                }
            }
            return new CreateTableNode(tableName, tableElementList, properties, c, this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 72: 
            case 453: {
                switch (this.jj_nt.kind) {
                    case 453: {
                        this.jj_consume_token(453);
                        resultColumnList = this.tableColumnList();
                        this.jj_consume_token(454);
                        break;
                    }
                    default: {
                        this.jj_la1[237] = this.jj_gen;
                    }
                }
                this.jj_consume_token(72);
                ResultSetNode resultSetNode = this.queryExpression(null, 0);
                this.jj_consume_token(267);
                switch (this.jj_nt.kind) {
                    case 189: {
                        this.jj_consume_token(189);
                        bl = false;
                        break;
                    }
                    default: {
                        this.jj_la1[238] = this.jj_gen;
                    }
                }
                this.jj_consume_token(284);
                if (bl) {
                    throw StandardException.newException("0A000.S", "WITH DATA");
                }
                HasNodeVisitor hasNodeVisitor = new HasNodeVisitor(ParameterNode.class);
                resultSetNode.accept(hasNodeVisitor);
                if (hasNodeVisitor.hasNode()) {
                    throw StandardException.newException("42X99", new Object[0]);
                }
                return new CreateTableNode(tableName, resultColumnList, resultSetNode, this.getContextManager());
            }
        }
        this.jj_la1[239] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ResultColumnList tableColumnList() throws ParseException, StandardException {
        ResultColumnList resultColumnList = new ResultColumnList(this.getContextManager());
        this.columnNameList(resultColumnList);
        return resultColumnList;
    }

    public final Properties propertyList(boolean bl) throws ParseException, StandardException {
        FormatableProperties formatableProperties = new FormatableProperties();
        this.jj_consume_token(59);
        StringTokenizer stringTokenizer = new StringTokenizer(this.getToken((int)1).image, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string, "=", true);
            if (stringTokenizer2.countTokens() != 3) {
                throw StandardException.newException("XCY04.S", new Object[0]);
            }
            String string2 = stringTokenizer2.nextToken().trim();
            if (!stringTokenizer2.nextToken().equals("=")) {
                throw StandardException.newException("XCY04.S", new Object[0]);
            }
            String string3 = stringTokenizer2.nextToken().trim();
            SQLParser.verifyImageLength(string3);
            if (formatableProperties.put(string2, string3 = string3.startsWith("'") && string3.endsWith("'") ? StringUtil.compressQuotes(string3.substring(1, string3.length() - 1), SINGLEQUOTES) : (string3.startsWith("\"") && string3.endsWith("\"") ? StringUtil.compressQuotes(string3.substring(1, string3.length() - 1), DOUBLEQUOTES) : string3.toUpperCase())) == null) continue;
            throw StandardException.newException("42Y49", string2);
        }
        if (!bl) {
            this.checkInternalFeature("DERBY-PROPERTIES");
        }
        return formatableProperties;
    }

    public final char DB2lockGranularityClause() throws ParseException, StandardException {
        this.jj_consume_token(305);
        char c = this.lockGranularity();
        return c;
    }

    public final char lockGranularity() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 239: {
                this.jj_consume_token(239);
                return 'T';
            }
            case 332: {
                this.jj_consume_token(332);
                return 'R';
            }
        }
        this.jj_la1[240] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode indexDefinition() throws ParseException, StandardException {
        Boolean bl = Boolean.FALSE;
        Properties properties = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        switch (this.jj_nt.kind) {
            case 252: {
                bl = this.unique();
                break;
            }
            default: {
                this.jj_la1[241] = this.jj_gen;
            }
        }
        this.jj_consume_token(400);
        TableName tableName = this.qualifiedName(128);
        this.jj_consume_token(195);
        TableName tableName2 = this.qualifiedName(128);
        this.jj_consume_token(453);
        this.indexColumnList(arrayList);
        this.jj_consume_token(454);
        switch (this.jj_nt.kind) {
            case 59: {
                properties = this.propertyList(false);
                this.jj_consume_token(64);
                break;
            }
            default: {
                this.jj_la1[242] = this.jj_gen;
            }
        }
        if (tableName.getSchemaName() == null) {
            tableName.setSchemaName(tableName2.getSchemaName());
        } else if (tableName2.getSchemaName() == null) {
            tableName2.setSchemaName(tableName.getSchemaName());
        } else if (!tableName.getSchemaName().equals(tableName2.getSchemaName())) {
            throw StandardException.newException("X0Y26.S", tableName, tableName2);
        }
        return new CreateIndexNode(bl, DEFAULT_INDEX_TYPE, tableName, tableName2, arrayList, properties, this.getContextManager());
    }

    public final Boolean unique() throws ParseException, StandardException {
        this.jj_consume_token(252);
        return Boolean.TRUE;
    }

    public final StatementNode procedureDefinition() throws ParseException, StandardException {
        Object[] objectArray = new Object[12];
        this.jj_consume_token(211);
        TableName tableName = this.qualifiedName(128);
        objectArray[0] = this.procedureParameterList(objectArray);
        block3: while (true) {
            this.routineElement(true, false, objectArray);
            switch (this.jj_nt.kind) {
                case 139: 
                case 189: 
                case 190: 
                case 277: 
                case 282: 
                case 288: 
                case 289: 
                case 299: 
                case 312: 
                case 330: 
                case 417: 
                case 421: 
                case 426: 
                case 437: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[243] = this.jj_gen;
        this.checkRequiredRoutineClause(JAVA_ROUTINE_CLAUSES, objectArray);
        return this.getCreateAliasNode(tableName, (String)objectArray[4], objectArray, 'P');
    }

    public final void routineElement(boolean bl, boolean bl2, Object[] objectArray) throws ParseException, StandardException {
        int n = -1;
        Object object = null;
        block0 : switch (this.jj_nt.kind) {
            case 437: {
                this.jj_consume_token(437);
                object = this.qualifiedName(128);
                n = 1;
                throw StandardException.newException("0A000.S", "SPECIFIC identifier");
            }
            case 289: 
            case 426: {
                switch (this.jj_nt.kind) {
                    case 289: {
                        this.jj_consume_token(289);
                        break;
                    }
                    default: {
                        this.jj_la1[244] = this.jj_gen;
                    }
                }
                this.jj_consume_token(426);
                this.jj_consume_token(434);
                int n2 = this.uint_value();
                if (!bl) {
                    throw StandardException.newException("42X01", "RESULT SETS");
                }
                object = ReuseFactory.getInteger(n2);
                n = 2;
                break;
            }
            case 299: {
                this.jj_consume_token(299);
                this.jj_consume_token(402);
                object = "JAVA";
                n = 3;
                break;
            }
            case 288: {
                this.jj_consume_token(288);
                object = Boolean.TRUE;
                n = 7;
                this.checkVersion(170, "DETERMINISTIC");
                break;
            }
            case 190: {
                this.jj_consume_token(190);
                this.jj_consume_token(288);
                object = Boolean.FALSE;
                n = 7;
                this.checkVersion(170, "DETERMINISTIC");
                break;
            }
            case 139: {
                this.jj_consume_token(139);
                switch (this.jj_nt.kind) {
                    case 317: {
                        this.jj_consume_token(317);
                        object = this.string();
                        n = 4;
                        break block0;
                    }
                    case 335: {
                        this.jj_consume_token(335);
                        this.checkVersion(190, "EXTERNAL SECURITY");
                        this.checkSqlStandardAccess("EXTERNAL SECURITY");
                        object = new Boolean(this.routineSecurityClause());
                        n = 10;
                        break block0;
                    }
                }
                this.jj_la1[245] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 417: {
                this.jj_consume_token(417);
                this.jj_consume_token(441);
                object = this.parameterStyle(bl2);
                n = 5;
                break;
            }
            case 189: {
                this.jj_consume_token(189);
                this.jj_consume_token(231);
                object = ReuseFactory.getShort((short)3);
                n = 6;
                break;
            }
            case 282: {
                this.jj_consume_token(282);
                this.jj_consume_token(231);
                object = ReuseFactory.getShort((short)2);
                n = 6;
                break;
            }
            case 421: {
                this.jj_consume_token(421);
                this.jj_consume_token(231);
                this.jj_consume_token(284);
                object = ReuseFactory.getShort((short)1);
                n = 6;
                break;
            }
            case 312: {
                this.jj_consume_token(312);
                this.jj_consume_token(231);
                this.jj_consume_token(284);
                if (!bl) {
                    throw StandardException.newException("42X01", "MODIFIES SQL DATA");
                }
                object = ReuseFactory.getShort((short)0);
                n = 6;
                break;
            }
            case 277: 
            case 330: {
                object = this.calledOnNullInput(bl);
                n = 8;
                break;
            }
            default: {
                this.jj_la1[246] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (n != -1) {
            if (objectArray[n] != null) {
                String string = ROUTINE_CLAUSE_NAMES[n];
                throw StandardException.newException("42613", string);
            }
            objectArray[n] = object;
        }
    }

    public final Boolean calledOnNullInput(boolean bl) throws ParseException, StandardException {
        Boolean bl2;
        switch (this.jj_nt.kind) {
            case 277: {
                this.jj_consume_token(277);
                bl2 = Boolean.TRUE;
                break;
            }
            case 330: {
                this.jj_consume_token(330);
                this.jj_consume_token(191);
                if (bl) {
                    throw StandardException.newException("42X01", "RETURNS NULL ON NULL INPUT");
                }
                bl2 = Boolean.FALSE;
                break;
            }
            default: {
                this.jj_la1[247] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(195);
        this.jj_consume_token(191);
        this.jj_consume_token(164);
        return bl2;
    }

    public final boolean routineSecurityClause() throws ParseException, StandardException {
        boolean bl = false;
        switch (this.jj_nt.kind) {
            case 298: {
                this.jj_consume_token(298);
                bl = false;
                break;
            }
            case 287: {
                this.jj_consume_token(287);
                bl = true;
                break;
            }
            default: {
                this.jj_la1[248] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return bl;
    }

    public final Short parameterStyle(boolean bl) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 402: {
                this.jj_consume_token(402);
                if (bl) {
                    throw StandardException.newException("42ZB2", new Object[0]);
                }
                return ReuseFactory.getShort((short)0);
            }
            case 392: {
                this.jj_consume_token(392);
                if (!bl) {
                    throw StandardException.newException("42ZB1", new Object[0]);
                }
                return ReuseFactory.getShort((short)1);
            }
            case 391: {
                this.jj_consume_token(391);
                this.checkVersion(220, "DERBY");
                if (bl) {
                    throw StandardException.newException("42ZB2", new Object[0]);
                }
                return ReuseFactory.getShort((short)2);
            }
        }
        this.jj_la1[249] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Object[] procedureParameterList(Object[] objectArray) throws ParseException, StandardException {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<TypeDescriptor> arrayList2 = new ArrayList<TypeDescriptor>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        Object[] objectArray2 = new Object[3];
        Boolean bl = null;
        this.jj_consume_token(453);
        if (this.jj_2_73(1)) {
            this.procedureParameterDefinition(arrayList, arrayList2, arrayList3);
            block6: while (true) {
                switch (this.jj_nt.kind) {
                    case 458: {
                        break;
                    }
                    default: {
                        this.jj_la1[250] = this.jj_gen;
                        break block6;
                    }
                }
                this.jj_consume_token(458);
                this.procedureParameterDefinition(arrayList, arrayList2, arrayList3);
            }
            switch (this.jj_nt.kind) {
                case 479: {
                    bl = this.ellipsis();
                    break;
                }
                default: {
                    this.jj_la1[251] = this.jj_gen;
                }
            }
        }
        this.jj_consume_token(454);
        objectArray[11] = bl;
        objectArray2[0] = arrayList;
        objectArray2[1] = arrayList2;
        objectArray2[2] = arrayList3;
        return objectArray2;
    }

    public final void procedureParameterDefinition(List<String> list, List<TypeDescriptor> list2, List<Integer> list3) throws ParseException, StandardException {
        String string = "";
        Integer n = this.inoutParameter();
        if (this.dataTypeCheck(2)) {
            string = this.identifier(128, true);
        }
        DataTypeDescriptor dataTypeDescriptor = this.dataTypeDDL();
        list.add(string);
        list2.add(dataTypeDescriptor.getCatalogType());
        list3.add(n);
    }

    public final Integer inoutParameter() throws ParseException {
        int n = 1;
        block0 : switch (this.jj_nt.kind) {
            case 160: 
            case 296: 
            case 416: {
                switch (this.jj_nt.kind) {
                    case 160: {
                        this.jj_consume_token(160);
                        break block0;
                    }
                    case 416: {
                        this.jj_consume_token(416);
                        n = 4;
                        break block0;
                    }
                    case 296: {
                        this.jj_consume_token(296);
                        n = 2;
                        break block0;
                    }
                }
                this.jj_la1[252] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[253] = this.jj_gen;
            }
        }
        return ReuseFactory.getInteger(n);
    }

    public final StatementNode functionDefinition() throws ParseException, StandardException {
        Object[] objectArray = new Object[12];
        this.jj_consume_token(149);
        TableName tableName = this.qualifiedName(128);
        objectArray[0] = this.functionParameterList(objectArray);
        this.jj_consume_token(330);
        TypeDescriptor typeDescriptor = this.functionReturnDataType();
        block3: while (true) {
            this.routineElement(false, typeDescriptor.isRowMultiSet(), objectArray);
            switch (this.jj_nt.kind) {
                case 139: 
                case 189: 
                case 190: 
                case 277: 
                case 282: 
                case 288: 
                case 289: 
                case 299: 
                case 312: 
                case 330: 
                case 417: 
                case 421: 
                case 426: 
                case 437: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[254] = this.jj_gen;
        objectArray[9] = typeDescriptor;
        this.checkRequiredRoutineClause(JAVA_ROUTINE_CLAUSES, objectArray);
        return this.getCreateAliasNode(tableName, (String)objectArray[4], objectArray, 'F');
    }

    public final Object[] functionParameterList(Object[] objectArray) throws ParseException, StandardException {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<TypeDescriptor> arrayList2 = new ArrayList<TypeDescriptor>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        Object[] objectArray2 = new Object[3];
        Boolean bl = null;
        this.jj_consume_token(453);
        if (this.jj_2_74(1)) {
            this.functionParameterDefinition(arrayList, arrayList2, arrayList3);
            block6: while (true) {
                switch (this.jj_nt.kind) {
                    case 458: {
                        break;
                    }
                    default: {
                        this.jj_la1[255] = this.jj_gen;
                        break block6;
                    }
                }
                this.jj_consume_token(458);
                this.functionParameterDefinition(arrayList, arrayList2, arrayList3);
            }
            switch (this.jj_nt.kind) {
                case 479: {
                    bl = this.ellipsis();
                    break;
                }
                default: {
                    this.jj_la1[256] = this.jj_gen;
                }
            }
        }
        this.jj_consume_token(454);
        objectArray[11] = bl;
        objectArray2[0] = arrayList;
        objectArray2[1] = arrayList2;
        objectArray2[2] = arrayList3;
        return objectArray2;
    }

    public final Boolean ellipsis() throws ParseException, StandardException {
        this.jj_consume_token(479);
        this.checkVersion(220, "...");
        return Boolean.TRUE;
    }

    public final void functionParameterDefinition(List<String> list, List<TypeDescriptor> list2, List<Integer> list3) throws ParseException, StandardException {
        String string = "";
        if (this.dataTypeCheck(2)) {
            string = this.identifier(128, true);
        }
        DataTypeDescriptor dataTypeDescriptor = this.dataTypeDDL();
        list.add(string);
        list2.add(dataTypeDescriptor.getCatalogType());
        list3.add(ReuseFactory.getInteger(1));
    }

    public final TypeDescriptor functionReturnDataType() throws ParseException, StandardException {
        TypeDescriptor typeDescriptor;
        if (this.jj_2_75(1)) {
            typeDescriptor = this.catalogType();
        } else {
            switch (this.jj_nt.kind) {
                case 239: {
                    typeDescriptor = this.functionTableType();
                    break;
                }
                default: {
                    this.jj_la1[257] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return typeDescriptor;
    }

    public final TypeDescriptor functionTableType() throws ParseException, StandardException {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<TypeDescriptor> arrayList2 = new ArrayList<TypeDescriptor>();
        this.jj_consume_token(239);
        this.jj_consume_token(453);
        this.functionTableReturnColumn(arrayList, arrayList2);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 458: {
                    break;
                }
                default: {
                    this.jj_la1[258] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(458);
            this.functionTableReturnColumn(arrayList, arrayList2);
        }
        this.jj_consume_token(454);
        this.checkVersion(160, "CREATE FUNCTION...RETURNS TABLE");
        int n = arrayList.size();
        String[] stringArray = new String[n];
        arrayList.toArray(stringArray);
        TypeDescriptor[] typeDescriptorArray = new TypeDescriptor[n];
        arrayList2.toArray(typeDescriptorArray);
        for (int i = 0; i < n; ++i) {
            if (typeDescriptorArray[i].getJDBCTypeId() != 2009) continue;
            throw StandardException.newException("42ZB3", new Object[0]);
        }
        return DataTypeDescriptor.getRowMultiSet(stringArray, typeDescriptorArray);
    }

    public final void functionTableReturnColumn(ArrayList<String> arrayList, ArrayList<TypeDescriptor> arrayList2) throws ParseException, StandardException {
        String string = this.identifier(128, true);
        DataTypeDescriptor dataTypeDescriptor = this.dataTypeDDL();
        arrayList.add(string);
        arrayList2.add(dataTypeDescriptor.getCatalogType());
    }

    public final StatementNode udtDefinition() throws ParseException, StandardException {
        this.jj_consume_token(355);
        TableName tableName = this.qualifiedName(128);
        this.jj_consume_token(139);
        this.jj_consume_token(317);
        String string = this.string();
        this.jj_consume_token(299);
        this.jj_consume_token(402);
        this.checkVersion(180, "CREATE TYPE");
        return this.getCreateAliasNode(tableName, string, null, 'A');
    }

    public final StatementNode aggregateDefinition() throws ParseException, StandardException {
        DataTypeDescriptor dataTypeDescriptor = null;
        Object[] objectArray = new Object[2];
        this.jj_consume_token(391);
        this.jj_consume_token(383);
        TableName tableName = this.qualifiedName(128);
        this.jj_consume_token(144);
        DataTypeDescriptor dataTypeDescriptor2 = this.dataTypeDDL();
        switch (this.jj_nt.kind) {
            case 330: {
                this.jj_consume_token(330);
                dataTypeDescriptor = this.dataTypeDDL();
                break;
            }
            default: {
                this.jj_la1[259] = this.jj_gen;
            }
        }
        this.jj_consume_token(139);
        this.jj_consume_token(317);
        String string = this.string();
        this.checkVersion(220, "CREATE DERBY AGGREGATE");
        if (dataTypeDescriptor == null) {
            dataTypeDescriptor = dataTypeDescriptor2;
        }
        objectArray[0] = dataTypeDescriptor2.getCatalogType();
        objectArray[1] = dataTypeDescriptor.getCatalogType();
        return this.getCreateAliasNode(tableName, string, objectArray, 'G');
    }

    public final StatementNode viewDefinition(Token token) throws ParseException, StandardException {
        ResultColumnList resultColumnList = null;
        Object var6_3 = null;
        OrderByList orderByList = null;
        ValueNode[] valueNodeArray = new ValueNode[2];
        boolean bl = false;
        this.jj_consume_token(263);
        TableName tableName = this.qualifiedName(128);
        switch (this.jj_nt.kind) {
            case 453: {
                this.jj_consume_token(453);
                resultColumnList = this.viewColumnList();
                this.jj_consume_token(454);
                break;
            }
            default: {
                this.jj_la1[260] = this.jj_gen;
            }
        }
        this.jj_consume_token(72);
        ResultSetNode resultSetNode = this.queryExpression(null, 0);
        switch (this.jj_nt.kind) {
            case 200: {
                orderByList = this.orderByClause(resultSetNode);
                break;
            }
            default: {
                this.jj_la1[261] = this.jj_gen;
            }
        }
        bl = this.offsetFetchFirstClause(valueNodeArray);
        int n = 0;
        Token token2 = this.getToken(0);
        HasNodeVisitor hasNodeVisitor = new HasNodeVisitor(ParameterNode.class);
        resultSetNode.accept(hasNodeVisitor);
        if (hasNodeVisitor.hasNode()) {
            throw StandardException.newException("42X98", new Object[0]);
        }
        return new CreateViewNode(tableName, resultColumnList, resultSetNode, n, StringUtil.slice(this.statementSQLText, token.beginOffset, token2.endOffset, false), orderByList, valueNodeArray[0], valueNodeArray[1], bl, this.getContextManager());
    }

    public final ResultColumnList viewColumnList() throws ParseException, StandardException {
        ResultColumnList resultColumnList = new ResultColumnList(this.getContextManager());
        this.columnNameList(resultColumnList);
        return resultColumnList;
    }

    public final StatementNode triggerDefinition() throws ParseException, StandardException {
        Boolean bl = Boolean.FALSE;
        Token[] tokenArray = new Token[1];
        Object var7_3 = null;
        ResultColumnList resultColumnList = new ResultColumnList(this.getContextManager());
        List<TriggerReferencingStruct> list = null;
        ValueNode valueNode = null;
        Token token = null;
        Token token2 = null;
        this.jj_consume_token(442);
        TableName tableName = this.qualifiedName(128);
        Boolean bl2 = this.beforeOrAfter();
        int n = this.triggerEvent(resultColumnList);
        this.jj_consume_token(195);
        TableName tableName2 = this.qualifiedName(128);
        switch (this.jj_nt.kind) {
            case 423: {
                list = this.triggerReferencingClause();
                break;
            }
            default: {
                this.jj_la1[262] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 144: {
                this.jj_consume_token(144);
                this.jj_consume_token(396);
                bl = this.rowOrStatement();
                break;
            }
            default: {
                this.jj_la1[263] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 408: {
                this.jj_consume_token(408);
                this.jj_consume_token(390);
                break;
            }
            default: {
                this.jj_la1[264] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 358: {
                this.jj_consume_token(358);
                token = this.jj_consume_token(453);
                valueNode = this.valueExpression();
                token2 = this.jj_consume_token(454);
                break;
            }
            default: {
                this.jj_la1[265] = this.jj_gen;
            }
        }
        StatementNode statementNode = this.proceduralStatement(tokenArray);
        int n2 = this.getToken((int)0).endOffset;
        int n3 = tokenArray[0].beginOffset;
        statementNode.setBeginOffset(n3);
        statementNode.setEndOffset(n2);
        if (bl2.booleanValue() && statementNode instanceof DMLModStatementNode) {
            throw StandardException.newException("42Z9D", statementNode.statementToString(), "BEFORE");
        }
        HasNodeVisitor hasNodeVisitor = new HasNodeVisitor(ParameterNode.class);
        statementNode.accept(hasNodeVisitor);
        if (valueNode != null) {
            valueNode.accept(hasNodeVisitor);
        }
        if (hasNodeVisitor.hasNode()) {
            throw StandardException.newException("42Y27", new Object[0]);
        }
        String string = StringUtil.slice(this.statementSQLText, n3, n2, false);
        String string2 = null;
        if (valueNode != null) {
            this.checkVersion(230, "WHEN");
            int n4 = token.endOffset + 1;
            int n5 = token2.beginOffset - 1;
            valueNode.setBeginOffset(n4);
            valueNode.setEndOffset(n5);
            string2 = StringUtil.slice(this.statementSQLText, n4, n5, false);
        }
        return new CreateTriggerNode(tableName, tableName2, n, resultColumnList, bl2, bl, true, list, valueNode, string2, statementNode, string, this.getContextManager());
    }

    public final StatementNode synonymDefinition() throws ParseException, StandardException {
        this.jj_consume_token(348);
        TableName tableName = this.qualifiedName(128);
        this.jj_consume_token(144);
        TableName tableName2 = this.qualifiedName(128);
        this.checkVersion(130, "CREATE SYNONYM");
        return this.getCreateAliasNode(tableName, tableName2, null, 'S');
    }

    public final Boolean beforeOrAfter() throws ParseException {
        switch (this.jj_nt.kind) {
            case 189: {
                this.jj_consume_token(189);
                this.jj_consume_token(84);
                this.jj_consume_token(384);
                return Boolean.TRUE;
            }
            case 382: {
                this.jj_consume_token(382);
                return Boolean.FALSE;
            }
        }
        this.jj_la1[266] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int triggerEvent(ResultColumnList resultColumnList) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 166: {
                this.jj_consume_token(166);
                return 4;
            }
            case 122: {
                this.jj_consume_token(122);
                return 2;
            }
            case 254: {
                this.jj_consume_token(254);
                switch (this.jj_nt.kind) {
                    case 194: {
                        this.jj_consume_token(194);
                        this.columnNameList(resultColumnList);
                        break;
                    }
                    default: {
                        this.jj_la1[267] = this.jj_gen;
                    }
                }
                return 1;
            }
        }
        this.jj_la1[268] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Boolean rowOrStatement() throws ParseException {
        switch (this.jj_nt.kind) {
            case 332: {
                this.token = this.jj_consume_token(332);
                return Boolean.TRUE;
            }
            case 347: {
                this.token = this.jj_consume_token(347);
                return Boolean.FALSE;
            }
        }
        this.jj_la1[269] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final List<TriggerReferencingStruct> triggerReferencingClause() throws ParseException, StandardException {
        ArrayList<TriggerReferencingStruct> arrayList = new ArrayList<TriggerReferencingStruct>();
        this.jj_consume_token(423);
        this.triggerReferencingExpression(arrayList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 409: 
                case 410: 
                case 414: 
                case 415: {
                    break;
                }
                default: {
                    this.jj_la1[270] = this.jj_gen;
                    break block3;
                }
            }
            this.triggerReferencingExpression(arrayList);
        }
        return arrayList;
    }

    public final void triggerReferencingExpression(List<TriggerReferencingStruct> list) throws ParseException, StandardException {
        boolean bl = true;
        boolean bl2 = true;
        block0 : switch (this.jj_nt.kind) {
            case 409: {
                this.jj_consume_token(409);
                switch (this.jj_nt.kind) {
                    case 239: 
                    case 332: {
                        switch (this.jj_nt.kind) {
                            case 332: {
                                this.jj_consume_token(332);
                                break block0;
                            }
                            case 239: {
                                this.jj_consume_token(239);
                                bl2 = false;
                                break block0;
                            }
                        }
                        this.jj_la1[271] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_la1[272] = this.jj_gen;
                break;
            }
            case 414: {
                this.jj_consume_token(414);
                bl = false;
                switch (this.jj_nt.kind) {
                    case 239: 
                    case 332: {
                        switch (this.jj_nt.kind) {
                            case 332: {
                                this.jj_consume_token(332);
                                break block0;
                            }
                            case 239: {
                                this.jj_consume_token(239);
                                bl2 = false;
                                break block0;
                            }
                        }
                        this.jj_la1[273] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_la1[274] = this.jj_gen;
                break;
            }
            case 410: {
                this.jj_consume_token(410);
                bl2 = false;
                break;
            }
            case 415: {
                this.jj_consume_token(415);
                bl = false;
                bl2 = false;
                break;
            }
            default: {
                this.jj_la1[275] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(72);
        String string = this.identifier(128, true);
        list.add(new TriggerReferencingStruct(bl2, bl, string));
    }

    public final ValueNode defaultClause(long[] lArray, String string) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 119: 
            case 267: {
                switch (this.jj_nt.kind) {
                    case 267: {
                        this.jj_consume_token(267);
                        break;
                    }
                    default: {
                        this.jj_la1[276] = this.jj_gen;
                    }
                }
                Token token = this.jj_consume_token(119);
                ValueNode valueNode = this.defaultOption(token, lArray, string);
                return valueNode;
            }
            case 292: {
                ValueNode valueNode = this.generatedColumnOption(lArray);
                return valueNode;
            }
        }
        this.jj_la1[277] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode defaultNullOnlyClause() throws ParseException, StandardException {
        this.jj_consume_token(119);
        this.jj_consume_token(191);
        return new UntypedNullConstantNode(this.getContextManager());
    }

    public final ValueNode generatedColumnOption(long[] lArray) throws ParseException, StandardException {
        ValueNode valueNode = null;
        lArray[0] = 1L;
        lArray[1] = 1L;
        lArray[2] = 1L;
        lArray[3] = 0L;
        this.jj_consume_token(292);
        switch (this.jj_nt.kind) {
            case 274: {
                valueNode = this.generatedAlways(lArray);
                return valueNode;
            }
            case 83: {
                valueNode = this.generatedByDefault(lArray);
                return valueNode;
            }
        }
        this.jj_la1[278] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode generatedAlways(long[] lArray) throws ParseException, StandardException {
        ValueNode valueNode = null;
        this.jj_consume_token(274);
        if (this.getToken((int)1).kind == 72 && this.getToken((int)2).kind == 158) {
            this.asIdentity(lArray);
            return valueNode;
        }
        if (this.getToken((int)1).kind == 72 && this.getToken((int)2).kind == 453) {
            valueNode = this.generationClause();
            return valueNode;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode generatedByDefault(long[] lArray) throws ParseException, StandardException {
        DefaultNode defaultNode = null;
        this.jj_consume_token(83);
        this.jj_consume_token(119);
        this.asIdentity(lArray);
        this.checkVersion(130, "GENERATED BY DEFAULT");
        defaultNode = new DefaultNode(this.getContextManager());
        return defaultNode;
    }

    public final void asIdentity(long[] lArray) throws ParseException, StandardException {
        this.jj_consume_token(72);
        this.jj_consume_token(158);
        switch (this.jj_nt.kind) {
            case 453: {
                this.jj_consume_token(453);
                this.autoIncrementBeginEnd(lArray);
                this.jj_consume_token(454);
                break;
            }
            default: {
                this.jj_la1[279] = this.jj_gen;
            }
        }
    }

    public final ValueNode generationClause() throws ParseException, StandardException {
        ValueNode valueNode = null;
        Token token = null;
        Token token2 = null;
        this.jj_consume_token(72);
        token = this.jj_consume_token(453);
        valueNode = this.valueExpression();
        token2 = this.jj_consume_token(454);
        this.checkVersion(170, "GENERATED COLUMN");
        return new GenerationClauseNode(valueNode, StringUtil.slice(this.statementSQLText, token.endOffset + 1, token2.beginOffset - 1, true), this.getContextManager());
    }

    public final void autoIncrementBeginEnd(long[] lArray) throws ParseException, StandardException {
        long l = 1L;
        long l2 = 1L;
        switch (this.jj_nt.kind) {
            case 294: {
                this.jj_consume_token(294);
                this.jj_consume_token(83);
                lArray[1] = l2 = this.exactNumber();
                lArray[3] = 0L;
                return;
            }
            case 346: {
                this.jj_consume_token(346);
                this.jj_consume_token(267);
                l = this.exactNumber();
                switch (this.jj_nt.kind) {
                    case 458: {
                        this.jj_consume_token(458);
                        this.jj_consume_token(294);
                        this.jj_consume_token(83);
                        l2 = this.exactNumber();
                        break;
                    }
                    default: {
                        this.jj_la1[280] = this.jj_gen;
                    }
                }
                lArray[0] = l;
                lArray[1] = l2;
                lArray[3] = 0L;
                return;
            }
        }
        this.jj_la1[281] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode defaultOption(Token token, long[] lArray, String string) throws ParseException, StandardException {
        Object var5_4 = null;
        Object var6_5 = null;
        if (this.getToken((int)1).kind == 191 && this.getToken((int)2).kind != 460 && this.getToken((int)2).kind != 463) {
            this.jj_consume_token(191);
            return new UntypedNullConstantNode(this.getContextManager());
        }
        if (this.jj_2_76(1)) {
            ValueNode valueNode = this.DB2DefaultOption(string);
            Token token2 = this.getToken(0);
            valueNode.setBeginOffset(token.beginOffset);
            valueNode.setEndOffset(token2.endOffset);
            valueNode = new DefaultNode(valueNode, StringUtil.slice(this.statementSQLText, token.beginOffset + 7, token2.endOffset, true), this.getContextManager());
            return valueNode;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode DB2DefaultOption(String string) throws ParseException, StandardException {
        if (this.getToken((int)2).kind == 222 || this.getToken((int)2).kind == 436) {
            this.jj_consume_token(108);
            switch (this.jj_nt.kind) {
                case 222: {
                    this.jj_consume_token(222);
                    break;
                }
                case 436: {
                    this.jj_consume_token(436);
                    break;
                }
                default: {
                    this.jj_la1[282] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            return new SpecialFunctionNode(2, this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 112: 
            case 226: 
            case 256: {
                ValueNode valueNode = this.userNode();
                return valueNode;
            }
            case 363: {
                ValueNode valueNode = this.currentRoleNode();
                return valueNode;
            }
        }
        this.jj_la1[283] = this.jj_gen;
        if (this.getToken((int)1).kind == 285 || this.getToken((int)1).kind == 350 || this.getToken((int)1).kind == 351) {
            ValueNode valueNode = this.miscBuiltins();
            return valueNode;
        }
        if (this.getToken((int)2).kind == 453 || this.getToken((int)4).kind == 453 && this.getToken((int)2).kind != 458) {
            ValueNode valueNode = this.miscBuiltins();
            throw StandardException.newException("42894", string);
        }
        if (this.jj_2_77(1)) {
            ValueNode valueNode = this.datetimeValueFunction();
            return valueNode;
        }
        switch (this.jj_nt.kind) {
            case 140: 
            case 249: 
            case 451: 
            case 457: 
            case 459: 
            case 487: 
            case 490: 
            case 491: 
            case 492: {
                ValueNode valueNode = this.literal();
                return valueNode;
            }
        }
        this.jj_la1[284] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode literal() throws ParseException, StandardException {
        String string = "";
        switch (this.jj_nt.kind) {
            case 457: 
            case 459: 
            case 487: 
            case 492: {
                switch (this.jj_nt.kind) {
                    case 457: 
                    case 459: {
                        string = this.sign();
                        break;
                    }
                    default: {
                        this.jj_la1[285] = this.jj_gen;
                    }
                }
                ValueNode valueNode = this.numericLiteral(string);
                return valueNode;
            }
            case 490: {
                CharConstantNode charConstantNode = this.stringLiteral();
                return charConstantNode;
            }
            case 491: {
                ValueNode valueNode = this.hexLiteral();
                return valueNode;
            }
            case 451: {
                ValueNode valueNode = this.dateTimeLiteral();
                return valueNode;
            }
            case 140: 
            case 249: {
                Token token = this.booleanLiteral();
                return new BooleanConstantNode(StringUtil.SQLEqualsIgnoreCase(token.image, "true"), this.getContextManager());
            }
        }
        this.jj_la1[286] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final NumericConstantNode intLiteral() throws ParseException, StandardException {
        NumericConstantNode numericConstantNode;
        String string = null;
        switch (this.jj_nt.kind) {
            case 457: 
            case 459: {
                string = this.sign();
                break;
            }
            default: {
                this.jj_la1[287] = this.jj_gen;
            }
        }
        Token token = this.jj_consume_token(487);
        String string2 = token.image;
        if (string != null && string.equals("-")) {
            string2 = string.concat(string2);
        }
        try {
            numericConstantNode = this.getNumericNode(string2, true);
        }
        catch (NumberFormatException numberFormatException) {
            throw StandardException.newException("42X20", new Object[0]);
        }
        return numericConstantNode;
    }

    public final ValueNode numericLiteral(String string) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 487: {
                Token token = this.jj_consume_token(487);
                String string2 = token.image;
                if (string.equals("-")) {
                    string2 = string.concat(string2);
                }
                return this.getNumericNode(string2, false);
            }
            case 492: {
                Double d;
                Token token = this.jj_consume_token(492);
                StringBuffer stringBuffer = new StringBuffer(string);
                stringBuffer.append(token.image);
                String string3 = stringBuffer.toString();
                int n = string3.indexOf(69);
                if (n == -1) {
                    n = string3.indexOf(101);
                }
                if (string3.length() > 30) {
                    throw StandardException.newException("42820", string3, "DOUBLE");
                }
                int n2 = string3.substring(0, n).indexOf(46);
                if (n2 == -1) {
                    stringBuffer.insert(n, '.');
                    string3 = stringBuffer.toString();
                    ++n;
                }
                try {
                    d = Double.valueOf(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    throw StandardException.newException("22018", "DOUBLE");
                }
                double d2 = d;
                if (d2 == 0.0 && Double.parseDouble(string3.substring(0, n - 1)) != 0.0) {
                    throw StandardException.newException("22003", "DOUBLE");
                }
                if (Double.isNaN(d2) || Double.isInfinite(d2)) {
                    throw StandardException.newException("22003", "DOUBLE");
                }
                return new NumericConstantNode(TypeId.getBuiltInTypeId(8), d, this.getContextManager());
            }
        }
        this.jj_la1[288] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode dateTimeLiteral() throws ParseException, StandardException {
        this.jj_consume_token(451);
        ValueNode valueNode = this.escapedDateTimeLiteral();
        this.jj_consume_token(452);
        return valueNode;
    }

    public final ValueNode escapedDateTimeLiteral() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 114: {
                this.jj_consume_token(114);
                ValueNode valueNode = this.bareDateLiteral();
                return valueNode;
            }
            case 238: {
                this.jj_consume_token(238);
                ValueNode valueNode = this.bareTimeLiteral();
                return valueNode;
            }
            case 250: {
                this.jj_consume_token(250);
                ValueNode valueNode = this.bareTimestampLiteral();
                return valueNode;
            }
        }
        this.jj_la1[289] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode bareDateLiteral() throws ParseException, StandardException {
        String string = this.string();
        return new UserTypeConstantNode(this.getLanguageConnectionContext().getDataValueFactory().getDateValue(string, true), this.getContextManager());
    }

    public final ValueNode bareTimeLiteral() throws ParseException, StandardException {
        String string = this.string();
        return new UserTypeConstantNode(this.getLanguageConnectionContext().getDataValueFactory().getTimeValue(string, true), this.getContextManager());
    }

    public final ValueNode bareTimestampLiteral() throws ParseException, StandardException {
        String string = this.string();
        return new UserTypeConstantNode(this.getLanguageConnectionContext().getDataValueFactory().getTimestampValue(string, true), this.getContextManager());
    }

    public final String string() throws ParseException, StandardException {
        Token token = this.jj_consume_token(490);
        SQLParser.verifyImageLength(token.image);
        return StringUtil.compressQuotes(token.image.substring(1, token.image.length() - 1), SINGLEQUOTES);
    }

    public final CharConstantNode stringLiteral() throws ParseException, StandardException {
        Token token = this.jj_consume_token(490);
        if (token.image.length() - 2 > 32672) {
            throw StandardException.newException("54002", StringUtil.formatForPrint(token.image));
        }
        String string = StringUtil.compressQuotes(token.image.substring(1, token.image.length() - 1), SINGLEQUOTES);
        return new CharConstantNode(string, this.getContextManager());
    }

    public final ValueNode hexLiteral() throws ParseException, StandardException {
        Token token = this.jj_consume_token(491);
        String string = token.image;
        if (string.length() - 3 > 16336) {
            throw StandardException.newException("54002", StringUtil.formatForPrint(string));
        }
        if ((string.length() - 3) % 2 == 1) {
            throw StandardException.newException("42606", StringUtil.formatForPrint(string));
        }
        int n = (string.length() - 3) / 2;
        return new VarbitConstantNode(string.substring(2, string.length() - 1), n, this.getContextManager());
    }

    public final TableName constraintNameDefinition() throws ParseException, StandardException {
        this.jj_consume_token(100);
        TableName tableName = this.qualifiedName(128);
        return tableName;
    }

    public final ConstraintDefinitionNode checkConstraintDefinition(TableName tableName, String string) throws ParseException, StandardException {
        ResultColumnList resultColumnList = null;
        this.jj_consume_token(91);
        Token token = this.jj_consume_token(453);
        ValueNode valueNode = this.valueExpression();
        Token token2 = this.jj_consume_token(454);
        if (string != null) {
            resultColumnList = new ResultColumnList(this.getContextManager());
            resultColumnList.addElement(new ResultColumn(string, null, this.getContextManager()));
        }
        valueNode.setBeginOffset(token.beginOffset);
        valueNode.setEndOffset(token2.endOffset);
        return new ConstraintDefinitionNode(tableName, 4, resultColumnList, null, valueNode, StringUtil.slice(this.statementSQLText, token.beginOffset, token2.endOffset, true), 2, 5, this.getContextManager());
    }

    public final StatementNode spsRenameStatement() throws ParseException, StandardException {
        StatementNode statementNode;
        this.jj_consume_token(424);
        switch (this.jj_nt.kind) {
            case 239: {
                statementNode = this.renameTableStatement();
                break;
            }
            case 400: {
                statementNode = this.renameIndexStatement();
                break;
            }
            case 96: {
                statementNode = this.renameColumnStatement();
                break;
            }
            default: {
                this.jj_la1[290] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return statementNode;
    }

    public final StatementNode renameTableStatement() throws ParseException, StandardException {
        this.jj_consume_token(239);
        TableName tableName = this.qualifiedName(128);
        this.jj_consume_token(243);
        String string = this.identifier(128, true);
        return new RenameNode(tableName, null, string, false, 1, this.getContextManager());
    }

    public final StatementNode renameIndexStatement() throws ParseException, StandardException {
        this.jj_consume_token(400);
        String string = this.identifier(128, true);
        this.jj_consume_token(243);
        String string2 = this.identifier(128, true);
        return new RenameNode(null, string, string2, false, 3, this.getContextManager());
    }

    public final StatementNode renameColumnStatement() throws ParseException, StandardException {
        this.jj_consume_token(96);
        ColumnReference columnReference = this.columnReference();
        this.jj_consume_token(243);
        String string = this.identifier(128, true);
        if (columnReference.getQualifiedTableName() == null) {
            throw StandardException.newException("42Y55", "RENAME COLUMN", columnReference.getColumnName());
        }
        return new RenameNode(columnReference.getQualifiedTableName(), columnReference.getColumnName(), string, false, 2, this.getContextManager());
    }

    public final StatementNode lockStatement() throws ParseException, StandardException {
        this.jj_consume_token(405);
        this.jj_consume_token(239);
        TableName tableName = this.qualifiedName(128);
        this.jj_consume_token(160);
        boolean bl = this.lockMode();
        this.jj_consume_token(408);
        return new LockTableNode(tableName, bl, this.getContextManager());
    }

    public final boolean lockMode() throws ParseException {
        switch (this.jj_nt.kind) {
            case 398: {
                this.jj_consume_token(398);
                return true;
            }
            case 435: {
                this.jj_consume_token(435);
                return false;
            }
        }
        this.jj_la1[291] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode execStatement() throws ParseException, StandardException {
        this.jj_consume_token(137);
        this.jj_consume_token(347);
        TableName tableName = this.qualifiedName(128);
        return new ExecSPSNode(tableName, this.getContextManager());
    }

    public final TransactionStatementNode setIsolationStatement() throws ParseException, StandardException {
        this.setIsolationHeader();
        block0 : switch (this.jj_nt.kind) {
            case 243: 
            case 467: {
                switch (this.jj_nt.kind) {
                    case 467: {
                        this.jj_consume_token(467);
                        break block0;
                    }
                    case 243: {
                        this.jj_consume_token(243);
                        break block0;
                    }
                }
                this.jj_la1[292] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[293] = this.jj_gen;
            }
        }
        TransactionStatementNode transactionStatementNode = this.transactionMode();
        return transactionStatementNode;
    }

    public final void setIsolationHeader() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 172: {
                this.jj_consume_token(172);
                break;
            }
            default: {
                this.jj_la1[294] = this.jj_gen;
                if (this.getToken((int)1).kind == 108 && this.getToken((int)2).kind == 172) {
                    this.jj_consume_token(108);
                    this.jj_consume_token(172);
                    break;
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final TransactionStatementNode transactionMode() throws ParseException, StandardException {
        int n = this.isolationLevelDB2OrReset();
        return new SetTransactionIsolationNode(n, this.getContextManager());
    }

    public final int isolationLevelDB2OrReset() throws ParseException {
        switch (this.jj_nt.kind) {
            case 425: {
                this.jj_consume_token(425);
                return 0;
            }
        }
        this.jj_la1[295] = this.jj_gen;
        if (this.jj_2_78(1)) {
            int n = this.isolationLevelDB2();
            return n;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int isolationLevelDB2() throws ParseException {
        switch (this.jj_nt.kind) {
            case 388: 
            case 429: 
            case 430: 
            case 445: {
                int n = this.isolationLevelDB2Abbrev();
                return n;
            }
            case 328: 
            case 336: {
                switch (this.jj_nt.kind) {
                    case 328: {
                        this.jj_consume_token(328);
                        this.jj_consume_token(213);
                        break;
                    }
                    case 336: {
                        this.jj_consume_token(336);
                        break;
                    }
                    default: {
                        this.jj_la1[296] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return 4;
            }
            case 113: {
                this.jj_consume_token(113);
                this.jj_consume_token(439);
                return 2;
            }
            case 394: {
                this.jj_consume_token(394);
                this.jj_consume_token(213);
                return 1;
            }
        }
        this.jj_la1[297] = this.jj_gen;
        if (this.getToken((int)1).kind == 213 && this.getToken((int)2).kind == 280) {
            this.jj_consume_token(213);
            this.jj_consume_token(280);
            return 2;
        }
        if (this.getToken((int)1).kind == 213 && this.getToken((int)2).kind == 356) {
            this.jj_consume_token(213);
            this.jj_consume_token(356);
            return 1;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int isolationLevelDB2Abbrev() throws ParseException {
        switch (this.jj_nt.kind) {
            case 429: {
                this.jj_consume_token(429);
                return 4;
            }
            case 430: {
                this.jj_consume_token(430);
                return 3;
            }
            case 388: {
                this.jj_consume_token(388);
                return 2;
            }
            case 445: {
                this.jj_consume_token(445);
                return 1;
            }
        }
        this.jj_la1[298] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int isolationLevel() throws ParseException {
        this.jj_consume_token(172);
        this.jj_consume_token(302);
        int n = this.levelOfIsolation();
        return n;
    }

    public final int levelOfIsolation() throws ParseException {
        switch (this.jj_nt.kind) {
            case 213: {
                this.jj_consume_token(213);
                return this.levelOfIsolationRead();
            }
            case 328: {
                this.jj_consume_token(328);
                this.jj_consume_token(213);
                return 3;
            }
            case 336: {
                this.jj_consume_token(336);
                return 4;
            }
        }
        this.jj_la1[299] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int levelOfIsolationRead() throws ParseException {
        switch (this.jj_nt.kind) {
            case 356: {
                this.jj_consume_token(356);
                return 1;
            }
            case 280: {
                this.jj_consume_token(280);
                return 2;
            }
        }
        this.jj_la1[300] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode simpleValueSpecification() throws ParseException, StandardException {
        ValueNode valueNode = this.literal();
        return valueNode;
    }

    public final StatementNode setRoleStatement() throws ParseException, StandardException {
        this.jj_consume_token(373);
        StatementNode statementNode = this.setRoleSpecification();
        if (this.parameterList != null && this.parameterList.size() > 0) {
            this.setUpAndLinkParameters();
            ParameterNode parameterNode = this.parameterList.get(0);
            parameterNode.setType(new DataTypeDescriptor(TypeId.getBuiltInTypeId(12), false, 128));
        }
        return statementNode;
    }

    public final StatementNode setRoleSpecification() throws ParseException, StandardException {
        String string = null;
        this.checkVersion(170, "ROLES");
        this.checkSqlStandardAccess("SET ROLE");
        switch (this.jj_nt.kind) {
            case 371: {
                this.jj_consume_token(371);
                return new SetRoleNode(string, 0, this.getContextManager());
            }
        }
        this.jj_la1[301] = this.jj_gen;
        if (this.jj_2_79(1)) {
            string = this.identifier(128, true);
            return new SetRoleNode(string, 0, this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 472: {
                this.dynamicParameterSpecification();
                return new SetRoleNode(null, 1, this.getContextManager());
            }
            case 490: {
                string = this.string();
                string = IdUtil.parseRoleId(string);
                return new SetRoleNode(string, 0, this.getContextManager());
            }
        }
        this.jj_la1[302] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode setSchemaStatement() throws ParseException, StandardException {
        this.setSchemaHeader();
        switch (this.jj_nt.kind) {
            case 467: {
                this.jj_consume_token(467);
                break;
            }
            default: {
                this.jj_la1[303] = this.jj_gen;
            }
        }
        StatementNode statementNode = this.setSchemaValues();
        if (this.parameterList != null && this.parameterList.size() > 0) {
            this.setUpAndLinkParameters();
            ParameterNode parameterNode = this.parameterList.get(0);
            parameterNode.setType(new DataTypeDescriptor(TypeId.getBuiltInTypeId(12), false, 128));
        }
        return statementNode;
    }

    public final void setSchemaHeader() throws ParseException, StandardException {
        block0 : switch (this.jj_nt.kind) {
            case 222: {
                this.jj_consume_token(222);
                break;
            }
            default: {
                this.jj_la1[305] = this.jj_gen;
                if (this.getToken((int)1).kind == 108 && (this.getToken((int)2).kind == 222 || this.getToken((int)2).kind == 436)) {
                    this.jj_consume_token(108);
                    switch (this.jj_nt.kind) {
                        case 222: {
                            this.jj_consume_token(222);
                            break block0;
                        }
                        case 436: {
                            this.jj_consume_token(436);
                            break block0;
                        }
                    }
                    this.jj_la1[304] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final StatementNode setSchemaValues() throws ParseException, StandardException {
        if (this.jj_2_80(1)) {
            String string = this.identifier(128, true);
            return new SetSchemaNode(string, 0, this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 256: {
                this.jj_consume_token(256);
                return new SetSchemaNode(null, 1, this.getContextManager());
            }
            case 472: {
                this.dynamicParameterSpecification();
                return new SetSchemaNode(null, 2, this.getContextManager());
            }
            case 490: {
                String string = this.string();
                IdUtil.checkIdentifierLengthLimit(string, 128);
                return new SetSchemaNode(string, 0, this.getContextManager());
            }
        }
        this.jj_la1[306] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode setMessageLocaleStatement() throws ParseException, StandardException {
        this.jj_consume_token(406);
        String string = this.string();
        this.getContextManager().setMessageLocale(string);
        return new NOPStatementNode(this.getContextManager());
    }

    public final ValueNode valueSpecification() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 140: 
            case 249: 
            case 451: 
            case 457: 
            case 459: 
            case 487: 
            case 490: 
            case 491: 
            case 492: {
                ValueNode valueNode = this.literal();
                return valueNode;
            }
            case 112: 
            case 226: 
            case 256: 
            case 363: 
            case 472: {
                ValueNode valueNode = this.generalValueSpecification();
                return valueNode;
            }
            case 192: {
                this.jj_consume_token(192);
                this.jj_consume_token(453);
                ValueNode valueNode = this.valueExpression();
                this.jj_consume_token(458);
                ValueNode valueNode2 = this.valueExpression();
                this.jj_consume_token(454);
                ContextManager contextManager = this.getContextManager();
                ValueNodeList valueNodeList = new ValueNodeList(contextManager);
                ValueNodeList valueNodeList2 = new ValueNodeList(contextManager);
                valueNode = new CachedValueNode(valueNode);
                valueNodeList.addElement(new BinaryRelationalOperatorNode(0, valueNode, valueNode2, false, contextManager));
                valueNodeList2.addElement(new UntypedNullConstantNode(contextManager));
                valueNodeList2.addElement(valueNode);
                return new ConditionalNode(null, valueNodeList, valueNodeList2, contextManager);
            }
        }
        this.jj_la1[307] = this.jj_gen;
        if (this.getToken((int)1).kind == 86 && this.getToken((int)2).kind == 358) {
            this.jj_consume_token(86);
            ConditionalNode conditionalNode = this.searchedCaseExpression();
            return conditionalNode;
        }
        switch (this.jj_nt.kind) {
            case 86: {
                this.jj_consume_token(86);
                ValueNode valueNode = this.valueExpression();
                ConditionalNode conditionalNode = this.simpleCaseExpression(new CachedValueNode(valueNode));
                return conditionalNode;
            }
        }
        this.jj_la1[308] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ConditionalNode searchedCaseExpression() throws ParseException, StandardException {
        ContextManager contextManager = this.getContextManager();
        ValueNodeList valueNodeList = new ValueNodeList(contextManager);
        ValueNodeList valueNodeList2 = new ValueNodeList(contextManager);
        ValueNode valueNode = null;
        block6: while (true) {
            this.whenThenExpression(valueNodeList, valueNodeList2);
            switch (this.jj_nt.kind) {
                case 358: {
                    continue block6;
                }
            }
            break;
        }
        this.jj_la1[309] = this.jj_gen;
        switch (this.jj_nt.kind) {
            case 130: {
                this.jj_consume_token(130);
                valueNode = this.thenElseExpression();
                break;
            }
            default: {
                this.jj_la1[310] = this.jj_gen;
            }
        }
        this.jj_consume_token(131);
        if (valueNode == null) {
            valueNode = new UntypedNullConstantNode(contextManager);
        }
        valueNodeList2.addElement(valueNode);
        return new ConditionalNode(null, valueNodeList, valueNodeList2, contextManager);
    }

    public final void whenThenExpression(ValueNodeList valueNodeList, ValueNodeList valueNodeList2) throws ParseException, StandardException {
        this.jj_consume_token(358);
        ValueNode valueNode = this.valueExpression();
        this.jj_consume_token(349);
        ValueNode valueNode2 = this.thenElseExpression();
        valueNodeList.addElement(valueNode);
        valueNodeList2.addElement(valueNode2);
    }

    public final ValueNode thenElseExpression() throws ParseException, StandardException {
        if (this.getToken((int)1).kind == 191) {
            this.jj_consume_token(191);
            return new UntypedNullConstantNode(this.getContextManager());
        }
        if (this.jj_2_81(1)) {
            ValueNode valueNode = this.valueExpression();
            return valueNode;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ConditionalNode simpleCaseExpression(CachedValueNode cachedValueNode) throws ParseException, StandardException {
        ContextManager contextManager = this.getContextManager();
        ValueNodeList valueNodeList = new ValueNodeList(contextManager);
        ValueNodeList valueNodeList2 = new ValueNodeList(contextManager);
        ValueNode valueNode = null;
        block6: while (true) {
            this.simpleWhenClause(cachedValueNode, valueNodeList, valueNodeList2);
            switch (this.jj_nt.kind) {
                case 358: {
                    continue block6;
                }
            }
            break;
        }
        this.jj_la1[311] = this.jj_gen;
        switch (this.jj_nt.kind) {
            case 130: {
                this.jj_consume_token(130);
                valueNode = this.thenElseExpression();
                break;
            }
            default: {
                this.jj_la1[312] = this.jj_gen;
            }
        }
        this.jj_consume_token(131);
        if (valueNode == null) {
            valueNode = new UntypedNullConstantNode(contextManager);
        }
        valueNodeList2.addElement(valueNode);
        return new ConditionalNode(cachedValueNode, valueNodeList, valueNodeList2, contextManager);
    }

    public final void simpleWhenClause(ValueNode valueNode, ValueNodeList valueNodeList, ValueNodeList valueNodeList2) throws ParseException, StandardException {
        this.jj_consume_token(358);
        ValueNode valueNode2 = this.whenOperandList(valueNode);
        this.jj_consume_token(349);
        ValueNode valueNode3 = this.thenElseExpression();
        valueNodeList.addElement(valueNode2);
        valueNodeList2.addElement(valueNode3);
    }

    public final ValueNode whenOperandList(ValueNode valueNode) throws ParseException, StandardException {
        ValueNode valueNode2 = null;
        ValueNode valueNode3 = this.whenOperand(valueNode);
        switch (this.jj_nt.kind) {
            case 458: {
                this.jj_consume_token(458);
                valueNode2 = this.whenOperandList(valueNode);
                break;
            }
            default: {
                this.jj_la1[313] = this.jj_gen;
            }
        }
        if (valueNode2 == null) {
            return valueNode3;
        }
        return new OrNode(valueNode3, valueNode2, this.getContextManager());
    }

    public final ValueNode whenOperand(ValueNode valueNode) throws ParseException, StandardException {
        ContextManager contextManager = this.getContextManager();
        if (this.remainingPredicateFollows()) {
            ValueNode valueNode2 = this.remainingPredicate(valueNode);
            return valueNode2;
        }
        if (this.jj_2_82(1)) {
            ValueNode valueNode3 = this.valueExpression();
            return new BinaryRelationalOperatorNode(0, valueNode, valueNode3, false, contextManager);
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final TableElementNode tableConstraintDefinition() throws ParseException, StandardException {
        Properties properties = null;
        TableName tableName = null;
        switch (this.jj_nt.kind) {
            case 100: {
                tableName = this.constraintNameDefinition();
                break;
            }
            default: {
                this.jj_la1[314] = this.jj_gen;
            }
        }
        ConstraintDefinitionNode constraintDefinitionNode = this.tableConstraint(tableName);
        switch (this.jj_nt.kind) {
            case 59: {
                properties = this.propertyList(false);
                this.jj_consume_token(64);
                break;
            }
            default: {
                this.jj_la1[315] = this.jj_gen;
            }
        }
        if (properties != null) {
            constraintDefinitionNode.setProperties(properties);
        }
        return constraintDefinitionNode;
    }

    public final ConstraintDefinitionNode tableConstraint(TableName tableName) throws ParseException, StandardException {
        ConstraintDefinitionNode constraintDefinitionNode;
        boolean[] blArray = null;
        switch (this.jj_nt.kind) {
            case 208: 
            case 252: {
                constraintDefinitionNode = this.uniqueConstraintDefinition(tableName);
                break;
            }
            case 145: {
                constraintDefinitionNode = this.referentialConstraintDefinition(tableName);
                break;
            }
            case 91: {
                constraintDefinitionNode = this.checkConstraintDefinition(tableName, null);
                break;
            }
            default: {
                this.jj_la1[316] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (this.jj_2_83(1)) {
            blArray = this.constraintCharacteristics();
        }
        if (blArray != null) {
            constraintDefinitionNode.setCharacteristics(blArray);
        }
        return constraintDefinitionNode;
    }

    public final ConstraintDefinitionNode uniqueConstraintDefinition(TableName tableName) throws ParseException, StandardException {
        int n = this.uniqueSpecification(null);
        this.jj_consume_token(453);
        ResultColumnList resultColumnList = this.uniqueColumnList();
        this.jj_consume_token(454);
        return new ConstraintDefinitionNode(tableName, ReuseFactory.getInteger(n), resultColumnList, null, null, null, 2, 5, this.getContextManager());
    }

    public final int uniqueSpecification(String string) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 252: {
                this.jj_consume_token(252);
                return 3;
            }
            case 208: {
                this.jj_consume_token(208);
                this.jj_consume_token(174);
                return 2;
            }
        }
        this.jj_la1[317] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ResultColumnList uniqueColumnList() throws ParseException, StandardException {
        ResultColumnList resultColumnList = new ResultColumnList(this.getContextManager());
        this.columnNameList(resultColumnList);
        return resultColumnList;
    }

    public final ConstraintDefinitionNode referentialConstraintDefinition(TableName tableName) throws ParseException, StandardException {
        ResultColumnList resultColumnList = new ResultColumnList(this.getContextManager());
        ResultColumnList resultColumnList2 = new ResultColumnList(this.getContextManager());
        int[] nArray = new int[]{2, 2};
        this.jj_consume_token(145);
        this.jj_consume_token(174);
        this.jj_consume_token(453);
        this.columnNameList(resultColumnList);
        this.jj_consume_token(454);
        TableName tableName2 = this.referencesSpecification(resultColumnList2, nArray);
        return new FKConstraintDefinitionNode(tableName, tableName2, resultColumnList, resultColumnList2, nArray, this.getContextManager());
    }

    public final TableName referencesSpecification(ResultColumnList resultColumnList, int[] nArray) throws ParseException, StandardException {
        TableName tableName = null;
        this.jj_consume_token(215);
        tableName = this.referencedTableAndColumns(resultColumnList);
        switch (this.jj_nt.kind) {
            case 195: {
                this.jj_consume_token(195);
                this.referentialTriggeredAction(nArray);
                break;
            }
            default: {
                this.jj_la1[318] = this.jj_gen;
            }
        }
        return tableName;
    }

    public final TableName referencedTableAndColumns(ResultColumnList resultColumnList) throws ParseException, StandardException {
        TableName tableName = null;
        tableName = this.qualifiedName(128);
        switch (this.jj_nt.kind) {
            case 453: {
                this.jj_consume_token(453);
                this.columnNameList(resultColumnList);
                this.jj_consume_token(454);
                break;
            }
            default: {
                this.jj_la1[319] = this.jj_gen;
            }
        }
        return tableName;
    }

    public final void referentialTriggeredAction(int[] nArray) throws ParseException, StandardException {
        block0 : switch (this.jj_nt.kind) {
            case 254: {
                nArray[1] = this.updateRule();
                switch (this.jj_nt.kind) {
                    case 195: {
                        this.jj_consume_token(195);
                        nArray[0] = this.deleteRule();
                        break block0;
                    }
                }
                this.jj_la1[320] = this.jj_gen;
                break;
            }
            case 122: {
                nArray[0] = this.deleteRule();
                switch (this.jj_nt.kind) {
                    case 195: {
                        this.jj_consume_token(195);
                        nArray[1] = this.updateRule();
                        break block0;
                    }
                }
                this.jj_la1[321] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[322] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final int updateRule() throws ParseException {
        this.jj_consume_token(254);
        int n = this.updateReferentialAction();
        return n;
    }

    public final int deleteRule() throws ParseException {
        this.jj_consume_token(122);
        int n = this.deleteReferentialAction();
        return n;
    }

    public final int updateReferentialAction() throws ParseException {
        switch (this.jj_nt.kind) {
            case 217: {
                this.jj_consume_token(217);
                return 1;
            }
            case 189: {
                this.jj_consume_token(189);
                this.jj_consume_token(273);
                return 2;
            }
        }
        this.jj_la1[323] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int deleteReferentialAction() throws ParseException {
        switch (this.jj_nt.kind) {
            case 84: {
                this.jj_consume_token(84);
                return 0;
            }
            case 217: {
                this.jj_consume_token(217);
                return 1;
            }
            case 189: {
                this.jj_consume_token(189);
                this.jj_consume_token(273);
                return 2;
            }
            case 227: {
                this.jj_consume_token(227);
                switch (this.jj_nt.kind) {
                    case 191: {
                        this.jj_consume_token(191);
                        return 3;
                    }
                    case 119: {
                        this.jj_consume_token(119);
                        return 4;
                    }
                }
                this.jj_la1[324] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_la1[325] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final boolean[] constraintCharacteristics() throws ParseException, StandardException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        boolean[] blArray = new boolean[]{false, false};
        switch (this.jj_nt.kind) {
            case 162: {
                bl2 = this.initiallyDeferred();
                blArray[1] = true;
                if (this.getToken((int)1).kind == 120 || this.getToken((int)2).kind == 120) {
                    bl = this.deferrable();
                    blArray[0] = true;
                }
                if (this.getToken((int)1).kind != 290 && this.getToken((int)2).kind != 290) break;
                bl3 = this.constraintEnforcement();
                break;
            }
            default: {
                this.jj_la1[327] = this.jj_gen;
                if (this.getToken((int)1).kind == 120 || this.getToken((int)2).kind == 120) {
                    bl = this.deferrable();
                    blArray[0] = true;
                    switch (this.jj_nt.kind) {
                        case 162: {
                            bl2 = this.initiallyDeferred();
                            blArray[1] = true;
                            break;
                        }
                        default: {
                            this.jj_la1[326] = this.jj_gen;
                        }
                    }
                    if (this.getToken((int)1).kind != 290 && this.getToken((int)2).kind != 290) break;
                    bl3 = this.constraintEnforcement();
                    break;
                }
                if (this.getToken((int)1).kind == 290 || this.getToken((int)2).kind == 290) {
                    bl3 = this.constraintEnforcement();
                    break;
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (!blArray[0] && blArray[1] && bl2) {
            bl = true;
        }
        if (blArray[0] && !bl && blArray[1] && bl2) {
            throw StandardException.newException("42X97", new Object[0]);
        }
        return new boolean[]{bl, bl2, bl3};
    }

    public final boolean initiallyDeferred() throws ParseException {
        this.jj_consume_token(162);
        switch (this.jj_nt.kind) {
            case 159: {
                this.jj_consume_token(159);
                return false;
            }
            case 121: {
                this.jj_consume_token(121);
                return true;
            }
        }
        this.jj_la1[328] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final boolean deferrable() throws ParseException {
        boolean bl = true;
        switch (this.jj_nt.kind) {
            case 190: {
                this.jj_consume_token(190);
                bl = false;
                break;
            }
            default: {
                this.jj_la1[329] = this.jj_gen;
            }
        }
        this.jj_consume_token(120);
        return bl;
    }

    public final boolean constraintEnforcement() throws ParseException {
        boolean bl = true;
        switch (this.jj_nt.kind) {
            case 190: {
                this.jj_consume_token(190);
                bl = false;
                break;
            }
            default: {
                this.jj_la1[330] = this.jj_gen;
            }
        }
        this.jj_consume_token(290);
        return bl;
    }

    public final void columnConstraintDefinition(DataTypeDescriptor[] dataTypeDescriptorArray, TableElementList tableElementList, String string) throws ParseException, StandardException {
        TableName tableName = null;
        boolean[] blArray = null;
        switch (this.jj_nt.kind) {
            case 100: {
                tableName = this.constraintNameDefinition();
                break;
            }
            default: {
                this.jj_la1[331] = this.jj_gen;
            }
        }
        ConstraintDefinitionNode constraintDefinitionNode = this.columnConstraint(tableName, dataTypeDescriptorArray, string);
        if (this.jj_2_84(1)) {
            blArray = this.constraintCharacteristics();
        }
        if (blArray != null) {
            if (constraintDefinitionNode == null) {
                throw StandardException.newException("42XAN", new Object[0]);
            }
            constraintDefinitionNode.setCharacteristics(blArray);
        }
        if (constraintDefinitionNode == null) {
            return;
        }
        tableElementList.addTableElement(constraintDefinitionNode);
    }

    public final ConstraintDefinitionNode columnConstraint(TableName tableName, DataTypeDescriptor[] dataTypeDescriptorArray, String string) throws ParseException, StandardException {
        Properties properties = null;
        ResultColumnList resultColumnList = new ResultColumnList(this.getContextManager());
        int[] nArray = new int[]{2, 2};
        switch (this.jj_nt.kind) {
            case 190: {
                this.jj_consume_token(190);
                this.jj_consume_token(191);
                if (dataTypeDescriptorArray[0] == null) {
                    throw StandardException.newException("42XAB", new Object[0]);
                }
                dataTypeDescriptorArray[0] = dataTypeDescriptorArray[0].getNullabilityType(false);
                return null;
            }
            case 208: 
            case 252: {
                int n = this.uniqueSpecification(string);
                switch (this.jj_nt.kind) {
                    case 59: {
                        properties = this.propertyList(false);
                        this.jj_consume_token(64);
                        break;
                    }
                    default: {
                        this.jj_la1[332] = this.jj_gen;
                    }
                }
                ResultColumnList resultColumnList2 = new ResultColumnList(this.getContextManager());
                resultColumnList2.addElement(new ResultColumn(string, null, this.getContextManager()));
                return new ConstraintDefinitionNode(tableName, ReuseFactory.getInteger(n), resultColumnList2, properties, null, null, 2, 5, this.getContextManager());
            }
            case 215: {
                TableName tableName2 = this.referencesSpecification(resultColumnList, nArray);
                switch (this.jj_nt.kind) {
                    case 59: {
                        properties = this.propertyList(false);
                        this.jj_consume_token(64);
                        break;
                    }
                    default: {
                        this.jj_la1[333] = this.jj_gen;
                    }
                }
                ResultColumnList resultColumnList3 = new ResultColumnList(this.getContextManager());
                resultColumnList3.addElement(new ResultColumn(string, null, this.getContextManager()));
                FKConstraintDefinitionNode fKConstraintDefinitionNode = new FKConstraintDefinitionNode(tableName, tableName2, resultColumnList3, resultColumnList, nArray, this.getContextManager());
                if (properties != null) {
                    fKConstraintDefinitionNode.setProperties(properties);
                }
                return fKConstraintDefinitionNode;
            }
            case 91: {
                ConstraintDefinitionNode constraintDefinitionNode = this.checkConstraintDefinition(tableName, string);
                return constraintDefinitionNode;
            }
        }
        this.jj_la1[334] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode dropRoleStatement() throws ParseException, StandardException {
        this.jj_consume_token(373);
        String string = this.identifier(128, true);
        this.checkVersion(170, "ROLES");
        this.checkSqlStandardAccess("DROP ROLE");
        return new DropRoleNode(string, this.getContextManager());
    }

    public final StatementNode dropSchemaStatement() throws ParseException, StandardException {
        this.jj_consume_token(222);
        String string = this.identifier(128, true);
        this.jj_consume_token(217);
        DropSchemaNode dropSchemaNode = new DropSchemaNode(string, 1, this.getContextManager());
        return dropSchemaNode;
    }

    public final StatementNode alterTableStatement() throws ParseException, StandardException {
        this.jj_consume_token(239);
        TableName tableName = this.qualifiedName(128);
        StatementNode statementNode = this.alterTableBody(tableName);
        return statementNode;
    }

    public final StatementNode alterTableBody(TableName tableName) throws ParseException, StandardException {
        char c = '\u0000';
        TableElementList tableElementList = new TableElementList(this.getContextManager());
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        String string = null;
        switch (this.jj_nt.kind) {
            case 386: {
                StatementNode statementNode;
                this.jj_consume_token(386);
                switch (this.jj_nt.kind) {
                    case 401: {
                        statementNode = this.inplaceCompress(tableName);
                        break;
                    }
                    default: {
                        this.jj_la1[335] = this.jj_gen;
                        statementNode = this.sequentialCompress(tableName);
                    }
                }
                return statementNode;
            }
            case 66: {
                StatementNode statementNode;
                this.jj_consume_token(66);
                switch (this.jj_nt.kind) {
                    case 129: {
                        statementNode = this.dropStatistics(tableName);
                        break;
                    }
                    case 254: {
                        statementNode = this.updateStatistics(tableName);
                        break;
                    }
                    default: {
                        this.jj_la1[336] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return statementNode;
            }
            case 254: {
                this.jj_consume_token(254);
                this.jj_consume_token(431);
                string = this.identifier(128, true);
                this.checkVersion(170, "SYSCS_UPDATE_STATISTICS");
                this.checkInternalFeature("UPDATE STATISTICS");
                return new AlterTableNode(tableName, 5, false, string, this.getContextManager());
            }
            case 431: {
                this.jj_consume_token(431);
                this.jj_consume_token(129);
                string = this.identifier(128, true);
                this.checkVersion(210, "SYSCS_UPDATE_STATISTICS");
                this.checkInternalFeature("DROP STATISTICS");
                return new AlterTableNode(tableName, 6, false, string, this.getContextManager());
            }
            case 129: {
                StatementNode statementNode;
                this.jj_consume_token(129);
                if (this.jj_2_85(1)) {
                    statementNode = this.dropColumnDefinition(tableName, tableElementList, nArray, nArray2);
                } else if (this.jj_2_86(1)) {
                    statementNode = this.dropTableConstraintDefinitionCore(tableName, tableElementList, nArray, nArray2);
                } else {
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                return statementNode;
            }
        }
        this.jj_la1[337] = this.jj_gen;
        if (this.jj_2_87(1)) {
            c = this.alterTableAction(tableElementList, nArray, nArray2);
            return new AlterTableNode(tableName, nArray[0], tableElementList, c, nArray2[0], this.getContextManager());
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode dropStatistics(TableName tableName) throws ParseException, StandardException {
        this.jj_consume_token(129);
        this.jj_consume_token(431);
        this.checkVersion(210, "SYSCS_DROP_STATISTICS");
        this.checkInternalFeature("DROP STATISTICS");
        return new AlterTableNode(tableName, 6, true, null, this.getContextManager());
    }

    public final StatementNode updateStatistics(TableName tableName) throws ParseException, StandardException {
        this.jj_consume_token(254);
        this.jj_consume_token(431);
        this.checkVersion(170, "SYSCS_UPDATE_STATISTICS");
        this.checkInternalFeature("UPDATE STATISTICS");
        int[] nArray = new int[1];
        return new AlterTableNode(tableName, 5, true, null, this.getContextManager());
    }

    public final StatementNode inplaceCompress(TableName tableName) throws ParseException, StandardException {
        Token token = null;
        Token token2 = null;
        Token token3 = null;
        this.jj_consume_token(401);
        switch (this.jj_nt.kind) {
            case 420: {
                token = this.jj_consume_token(420);
                break;
            }
            default: {
                this.jj_la1[338] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 393: {
                token2 = this.jj_consume_token(393);
                break;
            }
            default: {
                this.jj_la1[339] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 443: {
                token3 = this.jj_consume_token(443);
                break;
            }
            default: {
                this.jj_la1[340] = this.jj_gen;
            }
        }
        this.checkInternalFeature("COMPRESS");
        return new AlterTableNode(tableName, token != null, token2 != null, token3 != null, this.getContextManager());
    }

    public final StatementNode sequentialCompress(TableName tableName) throws ParseException, StandardException {
        Token token = null;
        switch (this.jj_nt.kind) {
            case 433: {
                token = this.jj_consume_token(433);
                break;
            }
            default: {
                this.jj_la1[341] = this.jj_gen;
            }
        }
        this.checkInternalFeature("COMPRESS");
        return new AlterTableNode(tableName, token != null, this.getContextManager());
    }

    public final char alterTableAction(TableElementList tableElementList, int[] nArray, int[] nArray2) throws ParseException, StandardException {
        char c = '\u0000';
        Object var7_5 = null;
        long[] lArray = new long[4];
        switch (this.jj_nt.kind) {
            case 65: {
                ColumnDefinitionNode columnDefinitionNode;
                TableElementNode tableElementNode;
                this.jj_consume_token(65);
                if (this.jj_2_88(1)) {
                    tableElementNode = this.addColumnDefinition(tableElementList);
                } else {
                    switch (this.jj_nt.kind) {
                        case 91: 
                        case 100: 
                        case 145: 
                        case 208: 
                        case 252: {
                            tableElementNode = this.tableConstraintDefinition();
                            break;
                        }
                        default: {
                            this.jj_la1[342] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                }
                if (tableElementNode instanceof ColumnDefinitionNode && (columnDefinitionNode = (ColumnDefinitionNode)tableElementNode).isAutoincrementColumn()) {
                    this.checkVersion(230, "ADD IDENTITY COLUMN");
                }
                nArray[0] = 1;
                tableElementList.addTableElement(tableElementNode);
                return c;
            }
        }
        this.jj_la1[344] = this.jj_gen;
        if (this.getToken((int)1).kind == 68 && this.getToken((int)2).kind != 100) {
            this.jj_consume_token(68);
            switch (this.jj_nt.kind) {
                case 96: {
                    this.jj_consume_token(96);
                    break;
                }
                default: {
                    this.jj_la1[343] = this.jj_gen;
                }
            }
            String string = this.identifier(128, true);
            TableElementNode tableElementNode = this.columnAlterClause(string);
            nArray[0] = 3;
            tableElementList.addTableElement(tableElementNode);
            return c;
        }
        switch (this.jj_nt.kind) {
            case 68: {
                this.jj_consume_token(68);
                TableName tableName = this.constraintNameDefinition();
                boolean bl = this.constraintEnforcement();
                ConstraintDefinitionNode constraintDefinitionNode = new ConstraintDefinitionNode(tableName, 7, null, null, null, null, 2, 7, this.getContextManager());
                boolean[] blArray = new boolean[]{false, false, bl};
                constraintDefinitionNode.setCharacteristics(blArray);
                nArray[0] = 3;
                tableElementList.addTableElement(constraintDefinitionNode);
                return c;
            }
            case 305: {
                c = this.DB2lockGranularityClause();
                nArray[0] = 4;
                return c;
            }
        }
        this.jj_la1[345] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode dropColumnDefinition(TableName tableName, TableElementList tableElementList, int[] nArray, int[] nArray2) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 96: {
                this.jj_consume_token(96);
                break;
            }
            default: {
                this.jj_la1[346] = this.jj_gen;
            }
        }
        String string = this.identifier(128, true);
        this.dropColumnReferentialAction(nArray2);
        ModifyColumnNode modifyColumnNode = new ModifyColumnNode(4, string, null, null, null, this.getContextManager());
        tableElementList.addTableElement(modifyColumnNode);
        return new AlterTableNode(tableName, 2, tableElementList, '\u0000', nArray2[0], this.getContextManager());
    }

    public final void dropColumnReferentialAction(int[] nArray) throws ParseException {
        int n = 0;
        block0 : switch (this.jj_nt.kind) {
            case 84: 
            case 217: {
                switch (this.jj_nt.kind) {
                    case 84: {
                        this.jj_consume_token(84);
                        n = 0;
                        break block0;
                    }
                    case 217: {
                        this.jj_consume_token(217);
                        n = 1;
                        break block0;
                    }
                }
                this.jj_la1[347] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[348] = this.jj_gen;
            }
        }
        nArray[0] = n;
    }

    public final TableElementNode addColumnDefinition(TableElementList tableElementList) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 96: {
                this.jj_consume_token(96);
                break;
            }
            default: {
                this.jj_la1[349] = this.jj_gen;
            }
        }
        TableElementNode tableElementNode = this.columnDefinition(tableElementList);
        return tableElementNode;
    }

    public final TableElementNode columnAlterClause(String string) throws ParseException, StandardException {
        long[] lArray = new long[4];
        long l = 1L;
        long l2 = 1L;
        DataTypeDescriptor dataTypeDescriptor = null;
        if (this.getToken((int)2).kind == 284) {
            this.jj_consume_token(227);
            this.jj_consume_token(284);
            this.jj_consume_token(355);
            dataTypeDescriptor = this.dataTypeDDL();
            return new ModifyColumnNode(0, string, null, dataTypeDescriptor, null, this.getContextManager());
        }
        if (this.getToken((int)2).kind == 294) {
            this.jj_consume_token(227);
            this.jj_consume_token(294);
            this.jj_consume_token(83);
            lArray[1] = l = this.exactNumber();
            lArray[3] = 2L;
            return new ModifyColumnNode(1, string, null, null, lArray, this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 329: {
                this.jj_consume_token(329);
                this.jj_consume_token(267);
                lArray[0] = l2 = this.exactNumber();
                lArray[3] = 1L;
                return new ModifyColumnNode(1, string, null, null, lArray, this.getContextManager());
            }
        }
        this.jj_la1[353] = this.jj_gen;
        if (this.getToken((int)1).kind == 267 || this.getToken((int)1).kind == 119 || this.getToken((int)1).kind == 227 && this.getToken((int)2).kind == 119) {
            switch (this.jj_nt.kind) {
                case 227: {
                    this.jj_consume_token(227);
                    break;
                }
                default: {
                    this.jj_la1[350] = this.jj_gen;
                }
            }
            ValueNode valueNode = this.defaultClause(lArray, string);
            return this.wrapAlterColumnDefaultValue(valueNode, string, lArray);
        }
        if (this.getToken((int)1).kind == 129 && this.getToken((int)2).kind == 119) {
            this.jj_consume_token(129);
            this.jj_consume_token(119);
            UntypedNullConstantNode untypedNullConstantNode = new UntypedNullConstantNode(this.getContextManager());
            return this.wrapAlterColumnDefaultValue(untypedNullConstantNode, string, lArray);
        }
        if (this.getToken((int)1).kind == 191 || this.getToken((int)1).kind == 129 && this.getToken((int)2).kind == 190) {
            switch (this.jj_nt.kind) {
                case 191: {
                    this.jj_consume_token(191);
                    break;
                }
                case 129: {
                    this.jj_consume_token(129);
                    this.jj_consume_token(190);
                    this.jj_consume_token(191);
                    break;
                }
                default: {
                    this.jj_la1[351] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            return new ModifyColumnNode(2, string, null, null, null, this.getContextManager());
        }
        if (this.getToken((int)1).kind == 190 || this.getToken((int)1).kind == 227 && this.getToken((int)2).kind == 190) {
            switch (this.jj_nt.kind) {
                case 190: {
                    this.jj_consume_token(190);
                    this.jj_consume_token(191);
                    break;
                }
                case 227: {
                    this.jj_consume_token(227);
                    this.jj_consume_token(190);
                    this.jj_consume_token(191);
                    break;
                }
                default: {
                    this.jj_la1[352] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            return new ModifyColumnNode(3, string, null, null, null, this.getContextManager());
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode dropTableConstraintDefinitionCore(TableName tableName, TableElementList tableElementList, int[] nArray, int[] nArray2) throws ParseException, StandardException {
        TableElementNode tableElementNode = this.dropTableConstraintDefinition();
        tableElementList.addTableElement(tableElementNode);
        return new AlterTableNode(tableName, 2, tableElementList, '\u0000', nArray2[0], this.getContextManager());
    }

    public final TableElementNode dropTableConstraintDefinition() throws ParseException, StandardException {
        if (this.getToken((int)1).kind == 100) {
            this.jj_consume_token(100);
            TableName tableName = this.qualifiedName(128);
            return new ConstraintDefinitionNode(tableName, 5, null, null, null, null, 2, 5, this.getContextManager());
        }
        if (this.getToken((int)1).kind == 208) {
            this.jj_consume_token(208);
            this.jj_consume_token(174);
            return new ConstraintDefinitionNode(null, 5, null, null, null, null, 2, 5, this.getContextManager());
        }
        if (this.getToken((int)1).kind == 145) {
            this.jj_consume_token(145);
            this.jj_consume_token(174);
            TableName tableName = this.qualifiedName(128);
            return new ConstraintDefinitionNode(tableName, 5, null, null, null, null, 2, 6, this.getContextManager());
        }
        if (this.getToken((int)1).kind == 252) {
            this.jj_consume_token(252);
            TableName tableName = this.qualifiedName(128);
            return new ConstraintDefinitionNode(tableName, 5, null, null, null, null, 2, 3, this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 91: {
                this.jj_consume_token(91);
                TableName tableName = this.qualifiedName(128);
                return new ConstraintDefinitionNode(tableName, 5, null, null, null, null, 2, 4, this.getContextManager());
            }
        }
        this.jj_la1[354] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode dropTableStatement() throws ParseException, StandardException {
        this.jj_consume_token(239);
        TableName tableName = this.qualifiedName(128);
        return new DropTableNode(tableName, 2, this.getContextManager());
    }

    public final StatementNode dropIndexStatement() throws ParseException, StandardException {
        this.jj_consume_token(400);
        TableName tableName = this.qualifiedName(128);
        return new DropIndexNode(tableName, this.getContextManager());
    }

    public final StatementNode dropAliasStatement() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 211: {
                this.jj_consume_token(211);
                TableName tableName = this.qualifiedName(128);
                return this.dropAliasNode(tableName, 'P');
            }
            case 149: {
                this.jj_consume_token(149);
                TableName tableName = this.qualifiedName(128);
                return this.dropAliasNode(tableName, 'F');
            }
            case 348: {
                this.jj_consume_token(348);
                TableName tableName = this.qualifiedName(128);
                this.checkVersion(130, "DROP SYNONYM");
                return this.dropAliasNode(tableName, 'S');
            }
            case 355: {
                this.jj_consume_token(355);
                TableName tableName = this.qualifiedName(128);
                this.jj_consume_token(217);
                this.checkVersion(180, "DROP TYPE");
                return this.dropAliasNode(tableName, 'A');
            }
            case 391: {
                this.jj_consume_token(391);
                this.jj_consume_token(383);
                TableName tableName = this.qualifiedName(128);
                this.jj_consume_token(217);
                this.checkVersion(220, "DROP DERBY AGGREGATE");
                return this.dropAliasNode(tableName, 'G');
            }
        }
        this.jj_la1[355] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode dropViewStatement() throws ParseException, StandardException {
        this.jj_consume_token(263);
        TableName tableName = this.qualifiedName(128);
        return new DropViewNode(tableName, this.getContextManager());
    }

    public final StatementNode dropTriggerStatement() throws ParseException, StandardException {
        this.jj_consume_token(442);
        TableName tableName = this.qualifiedName(128);
        return new DropTriggerNode(tableName, this.getContextManager());
    }

    public final StatementNode truncateTableStatement() throws ParseException, StandardException {
        this.jj_consume_token(354);
        this.jj_consume_token(239);
        TableName tableName = this.qualifiedName(128);
        return new AlterTableNode(tableName, this.getContextManager());
    }

    public final StatementNode grantStatement() throws ParseException, StandardException {
        if (this.getToken((int)1).kind == 154 && (this.getToken((int)2).kind == 442 && (this.getToken((int)3).kind == 458 && this.isPrivilegeKeywordExceptTrigger(this.getToken((int)4).kind) || this.getToken((int)3).kind == 195) || this.isPrivilegeKeywordExceptTrigger(this.getToken((int)2).kind))) {
            StatementNode statementNode;
            this.jj_consume_token(154);
            this.checkVersion(140, "GRANT");
            this.checkSqlStandardAccess("GRANT");
            switch (this.jj_nt.kind) {
                case 66: 
                case 122: 
                case 166: 
                case 215: 
                case 225: 
                case 254: 
                case 442: {
                    statementNode = this.tableGrantStatement();
                    break;
                }
                case 137: {
                    statementNode = this.routineGrantStatement();
                    break;
                }
                case 357: {
                    statementNode = this.usageGrantStatement();
                    break;
                }
                default: {
                    this.jj_la1[356] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            return statementNode;
        }
        if (this.getToken((int)1).kind == 154 && (this.getToken((int)2).kind == 442 && (this.getToken((int)3).kind == 458 && !this.isPrivilegeKeywordExceptTrigger(this.getToken((int)4).kind) || this.getToken((int)3).kind == 243) || !this.isPrivilegeKeywordExceptTrigger(this.getToken((int)2).kind))) {
            this.jj_consume_token(154);
            StatementNode statementNode = this.roleGrantStatement();
            return statementNode;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode tableGrantStatement() throws ParseException, StandardException {
        PrivilegeNode privilegeNode = this.tablePrivileges();
        this.jj_consume_token(243);
        List<String> list = this.granteeList();
        return new GrantNode(privilegeNode, list, this.getContextManager());
    }

    public final PrivilegeNode tablePrivileges() throws ParseException, StandardException {
        TablePrivilegesNode tablePrivilegesNode = null;
        TableName tableName = null;
        tablePrivilegesNode = this.tableActions();
        this.jj_consume_token(195);
        switch (this.jj_nt.kind) {
            case 239: {
                this.jj_consume_token(239);
                break;
            }
            default: {
                this.jj_la1[357] = this.jj_gen;
            }
        }
        tableName = this.qualifiedName(128);
        return new PrivilegeNode(0, tableName, tablePrivilegesNode, this.getContextManager());
    }

    public final TablePrivilegesNode tableActions() throws ParseException, StandardException {
        TablePrivilegesNode tablePrivilegesNode = new TablePrivilegesNode(this.getContextManager());
        switch (this.jj_nt.kind) {
            case 66: {
                this.jj_consume_token(66);
                this.jj_consume_token(210);
                tablePrivilegesNode.addAll();
                return tablePrivilegesNode;
            }
            case 122: 
            case 166: 
            case 215: 
            case 225: 
            case 254: 
            case 442: {
                this.tableAction(tablePrivilegesNode);
                block7: while (true) {
                    switch (this.jj_nt.kind) {
                        case 458: {
                            break;
                        }
                        default: {
                            this.jj_la1[358] = this.jj_gen;
                            break block7;
                        }
                    }
                    this.jj_consume_token(458);
                    this.tableAction(tablePrivilegesNode);
                }
                return tablePrivilegesNode;
            }
        }
        this.jj_la1[359] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode routineGrantStatement() throws ParseException, StandardException {
        this.jj_consume_token(137);
        this.jj_consume_token(195);
        RoutineDesignator routineDesignator = this.routineDesignator();
        this.jj_consume_token(243);
        List<String> list = this.granteeList();
        PrivilegeNode privilegeNode = new PrivilegeNode(1, routineDesignator, null, this.getContextManager());
        return new GrantNode(privilegeNode, list, this.getContextManager());
    }

    public final StatementNode usageGrantStatement() throws ParseException, StandardException {
        this.jj_consume_token(357);
        this.jj_consume_token(195);
        Integer n = this.usableObjects();
        TableName tableName = this.qualifiedName(128);
        this.jj_consume_token(243);
        List<String> list = this.granteeList();
        this.checkVersion(180, "GRANT USAGE");
        PrivilegeNode privilegeNode = new PrivilegeNode(n, tableName, "USAGE", false, this.getContextManager());
        return new GrantNode(privilegeNode, list, this.getContextManager());
    }

    public final Integer usableObjects() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 391: {
                this.jj_consume_token(391);
                this.jj_consume_token(383);
                return ReuseFactory.getInteger(4);
            }
            case 432: {
                this.jj_consume_token(432);
                return ReuseFactory.getInteger(2);
            }
            case 355: {
                this.jj_consume_token(355);
                return ReuseFactory.getInteger(3);
            }
        }
        this.jj_la1[360] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final RoutineDesignator routineDesignator() throws ParseException, StandardException {
        Token token;
        List<TypeDescriptor> list = null;
        switch (this.jj_nt.kind) {
            case 149: {
                token = this.jj_consume_token(149);
                break;
            }
            case 211: {
                token = this.jj_consume_token(211);
                break;
            }
            default: {
                this.jj_la1[361] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        TableName tableName = this.qualifiedName(128);
        switch (this.jj_nt.kind) {
            case 453: {
                this.jj_consume_token(453);
                list = this.parameterTypeList();
                this.jj_consume_token(454);
                break;
            }
            default: {
                this.jj_la1[362] = this.jj_gen;
            }
        }
        return new RoutineDesignator(tableName, token.kind == 149, list);
    }

    public final List<TypeDescriptor> parameterTypeList() throws ParseException, StandardException {
        ArrayList<TypeDescriptor> arrayList = new ArrayList<TypeDescriptor>();
        if (this.jj_2_89(1)) {
            TypeDescriptor typeDescriptor = this.catalogType();
            arrayList.add(typeDescriptor);
            block3: while (true) {
                switch (this.jj_nt.kind) {
                    case 458: {
                        break;
                    }
                    default: {
                        this.jj_la1[363] = this.jj_gen;
                        break block3;
                    }
                }
                this.jj_consume_token(458);
                typeDescriptor = this.catalogType();
                arrayList.add(typeDescriptor);
            }
        }
        return arrayList;
    }

    public final void tableAction(TablePrivilegesNode tablePrivilegesNode) throws ParseException, StandardException {
        ResultColumnList resultColumnList = null;
        switch (this.jj_nt.kind) {
            case 225: {
                this.jj_consume_token(225);
                switch (this.jj_nt.kind) {
                    case 453: {
                        resultColumnList = this.privilegeColumnList();
                        break;
                    }
                    default: {
                        this.jj_la1[364] = this.jj_gen;
                    }
                }
                tablePrivilegesNode.addAction(0, resultColumnList);
                break;
            }
            case 122: {
                this.jj_consume_token(122);
                tablePrivilegesNode.addAction(1, null);
                break;
            }
            case 166: {
                this.jj_consume_token(166);
                tablePrivilegesNode.addAction(2, null);
                break;
            }
            case 254: {
                this.jj_consume_token(254);
                switch (this.jj_nt.kind) {
                    case 453: {
                        resultColumnList = this.privilegeColumnList();
                        break;
                    }
                    default: {
                        this.jj_la1[365] = this.jj_gen;
                    }
                }
                tablePrivilegesNode.addAction(3, resultColumnList);
                break;
            }
            case 215: {
                this.jj_consume_token(215);
                switch (this.jj_nt.kind) {
                    case 453: {
                        resultColumnList = this.privilegeColumnList();
                        break;
                    }
                    default: {
                        this.jj_la1[366] = this.jj_gen;
                    }
                }
                tablePrivilegesNode.addAction(4, resultColumnList);
                break;
            }
            case 442: {
                this.jj_consume_token(442);
                tablePrivilegesNode.addAction(5, null);
                break;
            }
            default: {
                this.jj_la1[367] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final ResultColumnList privilegeColumnList() throws ParseException, StandardException {
        ResultColumnList resultColumnList = new ResultColumnList(this.getContextManager());
        this.jj_consume_token(453);
        this.columnNameList(resultColumnList);
        this.jj_consume_token(454);
        return resultColumnList;
    }

    public final List<String> granteeList() throws ParseException, StandardException {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.grantee(arrayList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 458: {
                    break;
                }
                default: {
                    this.jj_la1[368] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(458);
            this.grantee(arrayList);
        }
        return arrayList;
    }

    public final void grantee(List<String> list) throws ParseException, StandardException {
        if (this.jj_2_90(1)) {
            String string = this.identifier(128, true);
            list.add(string);
        } else {
            switch (this.jj_nt.kind) {
                case 212: {
                    this.jj_consume_token(212);
                    list.add("PUBLIC");
                    break;
                }
                default: {
                    this.jj_la1[369] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final StatementNode roleGrantStatement() throws ParseException, StandardException {
        List<String> list = this.roleList();
        this.jj_consume_token(243);
        List<String> list2 = this.granteeList();
        this.checkSqlStandardAccess("GRANT <role>");
        this.checkVersion(170, "ROLES");
        return new GrantRoleNode(list, list2, this.getContextManager());
    }

    public final List<String> roleList() throws ParseException, StandardException {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.roleElement(arrayList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 458: {
                    break;
                }
                default: {
                    this.jj_la1[370] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(458);
            this.roleElement(arrayList);
        }
        return arrayList;
    }

    public final void roleElement(List<String> list) throws ParseException, StandardException {
        String string = this.identifier(128, true);
        list.add(string);
    }

    public final StatementNode revokeStatement() throws ParseException, StandardException {
        if (this.getToken((int)1).kind == 218 && (this.getToken((int)2).kind == 442 && (this.getToken((int)3).kind == 458 && this.isPrivilegeKeywordExceptTrigger(this.getToken((int)4).kind) || this.getToken((int)3).kind == 195) || this.isPrivilegeKeywordExceptTrigger(this.getToken((int)2).kind))) {
            StatementNode statementNode;
            this.jj_consume_token(218);
            this.checkVersion(140, "REVOKE");
            this.checkSqlStandardAccess("REVOKE");
            switch (this.jj_nt.kind) {
                case 66: 
                case 122: 
                case 166: 
                case 215: 
                case 225: 
                case 254: 
                case 442: {
                    statementNode = this.tableRevokeStatement();
                    break;
                }
                case 137: {
                    statementNode = this.routineRevokeStatement();
                    break;
                }
                case 357: {
                    statementNode = this.usageRevokeStatement();
                    break;
                }
                default: {
                    this.jj_la1[371] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            return statementNode;
        }
        if (this.getToken((int)1).kind == 218 && (this.getToken((int)2).kind == 442 && (this.getToken((int)3).kind == 458 && !this.isPrivilegeKeywordExceptTrigger(this.getToken((int)4).kind) || this.getToken((int)3).kind == 147) || !this.isPrivilegeKeywordExceptTrigger(this.getToken((int)2).kind))) {
            this.jj_consume_token(218);
            this.checkVersion(170, "ROLES");
            this.checkSqlStandardAccess("REVOKE <role>");
            StatementNode statementNode = this.roleRevokeStatement();
            return statementNode;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode tableRevokeStatement() throws ParseException, StandardException {
        PrivilegeNode privilegeNode = null;
        privilegeNode = this.tablePrivileges();
        this.jj_consume_token(147);
        List<String> list = this.granteeList();
        return new RevokeNode(privilegeNode, list, this.getContextManager());
    }

    public final StatementNode routineRevokeStatement() throws ParseException, StandardException {
        RoutineDesignator routineDesignator = null;
        this.jj_consume_token(137);
        this.jj_consume_token(195);
        routineDesignator = this.routineDesignator();
        this.jj_consume_token(147);
        List<String> list = this.granteeList();
        this.jj_consume_token(217);
        PrivilegeNode privilegeNode = new PrivilegeNode(1, routineDesignator, null, this.getContextManager());
        return new RevokeNode(privilegeNode, list, this.getContextManager());
    }

    public final StatementNode usageRevokeStatement() throws ParseException, StandardException {
        this.jj_consume_token(357);
        this.jj_consume_token(195);
        Integer n = this.usableObjects();
        TableName tableName = this.qualifiedName(128);
        this.jj_consume_token(147);
        List<String> list = this.granteeList();
        this.jj_consume_token(217);
        this.checkVersion(180, "REVOKE USAGE");
        PrivilegeNode privilegeNode = new PrivilegeNode(n, tableName, "USAGE", true, this.getContextManager());
        return new RevokeNode(privilegeNode, list, this.getContextManager());
    }

    public final StatementNode roleRevokeStatement() throws ParseException, StandardException {
        List<String> list = this.roleList();
        this.jj_consume_token(147);
        List<String> list2 = this.granteeList();
        return new RevokeRoleNode(list, list2, this.getContextManager());
    }

    public final String internalIdentifier(int n, boolean bl) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 480: {
                Token token = this.jj_consume_token(480);
                String string = StringUtil.SQLToUpperCase(token.image);
                if (bl) {
                    IdUtil.checkIdentifierLengthLimit(string, n);
                }
                this.nextToLastTokenDelimitedIdentifier = this.lastTokenDelimitedIdentifier;
                this.lastTokenDelimitedIdentifier = false;
                this.thirdToLastIdentifierToken = this.nextToLastIdentifierToken;
                this.nextToLastIdentifierToken = this.lastIdentifierToken;
                this.lastIdentifierToken = token;
                return string;
            }
            case 486: {
                String string = this.delimitedIdentifier();
                if (bl) {
                    IdUtil.checkIdentifierLengthLimit(string, n);
                }
                return string;
            }
        }
        this.jj_la1[372] = this.jj_gen;
        if (this.jj_2_91(1)) {
            String string = this.nonReservedKeyword();
            return StringUtil.SQLToUpperCase(string);
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String identifier(int n, boolean bl) throws ParseException, StandardException {
        String string = this.internalIdentifier(n, bl);
        return string;
    }

    public final String delimitedIdentifier() throws ParseException {
        Token token = this.jj_consume_token(486);
        String string = token.image.substring(1, token.image.length() - 1);
        string = SQLParser.normalizeDelimitedID(string);
        this.nextToLastTokenDelimitedIdentifier = this.lastTokenDelimitedIdentifier;
        this.lastTokenDelimitedIdentifier = true;
        this.thirdToLastIdentifierToken = this.nextToLastIdentifierToken;
        this.nextToLastIdentifierToken = this.lastIdentifierToken;
        this.lastIdentifierToken = token;
        return string;
    }

    public final String reservedKeyword() throws ParseException {
        Token token;
        switch (this.jj_nt.kind) {
            case 65: {
                token = this.jj_consume_token(65);
                break;
            }
            case 66: {
                token = this.jj_consume_token(66);
                break;
            }
            case 67: {
                token = this.jj_consume_token(67);
                break;
            }
            case 68: {
                token = this.jj_consume_token(68);
                break;
            }
            case 69: {
                token = this.jj_consume_token(69);
                break;
            }
            case 70: {
                token = this.jj_consume_token(70);
                break;
            }
            case 71: {
                token = this.jj_consume_token(71);
                break;
            }
            case 72: {
                token = this.jj_consume_token(72);
                break;
            }
            case 73: {
                token = this.jj_consume_token(73);
                break;
            }
            case 74: {
                token = this.jj_consume_token(74);
                break;
            }
            case 75: {
                token = this.jj_consume_token(75);
                break;
            }
            case 76: {
                token = this.jj_consume_token(76);
                break;
            }
            case 77: {
                token = this.jj_consume_token(77);
                break;
            }
            case 78: {
                token = this.jj_consume_token(78);
                break;
            }
            case 79: {
                token = this.jj_consume_token(79);
                break;
            }
            case 81: {
                token = this.jj_consume_token(81);
                break;
            }
            case 82: {
                token = this.jj_consume_token(82);
                break;
            }
            case 83: {
                token = this.jj_consume_token(83);
                break;
            }
            case 84: {
                token = this.jj_consume_token(84);
                break;
            }
            case 85: {
                token = this.jj_consume_token(85);
                break;
            }
            case 86: {
                token = this.jj_consume_token(86);
                break;
            }
            case 87: {
                token = this.jj_consume_token(87);
                break;
            }
            case 88: {
                token = this.jj_consume_token(88);
                break;
            }
            case 89: {
                token = this.jj_consume_token(89);
                break;
            }
            case 91: {
                token = this.jj_consume_token(91);
                break;
            }
            case 92: {
                token = this.jj_consume_token(92);
                break;
            }
            case 94: {
                token = this.jj_consume_token(94);
                break;
            }
            case 95: {
                token = this.jj_consume_token(95);
                break;
            }
            case 96: {
                token = this.jj_consume_token(96);
                break;
            }
            case 97: {
                token = this.jj_consume_token(97);
                break;
            }
            case 98: {
                token = this.jj_consume_token(98);
                break;
            }
            case 99: {
                token = this.jj_consume_token(99);
                break;
            }
            case 100: {
                token = this.jj_consume_token(100);
                break;
            }
            case 101: {
                token = this.jj_consume_token(101);
                break;
            }
            case 102: {
                token = this.jj_consume_token(102);
                break;
            }
            case 103: {
                token = this.jj_consume_token(103);
                break;
            }
            case 104: {
                token = this.jj_consume_token(104);
                break;
            }
            case 106: {
                token = this.jj_consume_token(106);
                break;
            }
            case 107: {
                token = this.jj_consume_token(107);
                break;
            }
            case 108: {
                token = this.jj_consume_token(108);
                break;
            }
            case 109: {
                token = this.jj_consume_token(109);
                break;
            }
            case 110: {
                token = this.jj_consume_token(110);
                break;
            }
            case 111: {
                token = this.jj_consume_token(111);
                break;
            }
            case 112: {
                token = this.jj_consume_token(112);
                break;
            }
            case 113: {
                token = this.jj_consume_token(113);
                break;
            }
            case 115: {
                token = this.jj_consume_token(115);
                break;
            }
            case 116: {
                token = this.jj_consume_token(116);
                break;
            }
            case 117: {
                token = this.jj_consume_token(117);
                break;
            }
            case 118: {
                token = this.jj_consume_token(118);
                break;
            }
            case 119: {
                token = this.jj_consume_token(119);
                break;
            }
            case 120: {
                token = this.jj_consume_token(120);
                break;
            }
            case 121: {
                token = this.jj_consume_token(121);
                break;
            }
            case 122: {
                token = this.jj_consume_token(122);
                break;
            }
            case 123: {
                token = this.jj_consume_token(123);
                break;
            }
            case 124: {
                token = this.jj_consume_token(124);
                break;
            }
            case 125: {
                token = this.jj_consume_token(125);
                break;
            }
            case 126: {
                token = this.jj_consume_token(126);
                break;
            }
            case 127: {
                token = this.jj_consume_token(127);
                break;
            }
            case 128: {
                token = this.jj_consume_token(128);
                break;
            }
            case 129: {
                token = this.jj_consume_token(129);
                break;
            }
            case 130: {
                token = this.jj_consume_token(130);
                break;
            }
            case 131: {
                token = this.jj_consume_token(131);
                break;
            }
            case 132: {
                token = this.jj_consume_token(132);
                break;
            }
            case 133: {
                token = this.jj_consume_token(133);
                break;
            }
            case 134: {
                token = this.jj_consume_token(134);
                break;
            }
            case 135: {
                token = this.jj_consume_token(135);
                break;
            }
            case 136: {
                token = this.jj_consume_token(136);
                break;
            }
            case 137: {
                token = this.jj_consume_token(137);
                break;
            }
            case 138: {
                token = this.jj_consume_token(138);
                break;
            }
            case 139: {
                token = this.jj_consume_token(139);
                break;
            }
            case 140: {
                token = this.jj_consume_token(140);
                break;
            }
            case 141: {
                token = this.jj_consume_token(141);
                break;
            }
            case 142: {
                token = this.jj_consume_token(142);
                break;
            }
            case 143: {
                token = this.jj_consume_token(143);
                break;
            }
            case 144: {
                token = this.jj_consume_token(144);
                break;
            }
            case 145: {
                token = this.jj_consume_token(145);
                break;
            }
            case 146: {
                token = this.jj_consume_token(146);
                break;
            }
            case 147: {
                token = this.jj_consume_token(147);
                break;
            }
            case 148: {
                token = this.jj_consume_token(148);
                break;
            }
            case 149: {
                token = this.jj_consume_token(149);
                break;
            }
            case 150: {
                token = this.jj_consume_token(150);
                break;
            }
            case 366: {
                token = this.jj_consume_token(366);
                break;
            }
            case 151: {
                token = this.jj_consume_token(151);
                break;
            }
            case 152: {
                token = this.jj_consume_token(152);
                break;
            }
            case 153: {
                token = this.jj_consume_token(153);
                break;
            }
            case 154: {
                token = this.jj_consume_token(154);
                break;
            }
            case 155: {
                token = this.jj_consume_token(155);
                break;
            }
            case 156: {
                token = this.jj_consume_token(156);
                break;
            }
            case 157: {
                token = this.jj_consume_token(157);
                break;
            }
            case 158: {
                token = this.jj_consume_token(158);
                break;
            }
            case 159: {
                token = this.jj_consume_token(159);
                break;
            }
            case 160: {
                token = this.jj_consume_token(160);
                break;
            }
            case 161: {
                token = this.jj_consume_token(161);
                break;
            }
            case 162: {
                token = this.jj_consume_token(162);
                break;
            }
            case 163: {
                token = this.jj_consume_token(163);
                break;
            }
            case 296: {
                token = this.jj_consume_token(296);
                break;
            }
            case 164: {
                token = this.jj_consume_token(164);
                break;
            }
            case 165: {
                token = this.jj_consume_token(165);
                break;
            }
            case 166: {
                token = this.jj_consume_token(166);
                break;
            }
            case 167: {
                token = this.jj_consume_token(167);
                break;
            }
            case 168: {
                token = this.jj_consume_token(168);
                break;
            }
            case 169: {
                token = this.jj_consume_token(169);
                break;
            }
            case 170: {
                token = this.jj_consume_token(170);
                break;
            }
            case 171: {
                token = this.jj_consume_token(171);
                break;
            }
            case 172: {
                token = this.jj_consume_token(172);
                break;
            }
            case 173: {
                token = this.jj_consume_token(173);
                break;
            }
            case 174: {
                token = this.jj_consume_token(174);
                break;
            }
            case 175: {
                token = this.jj_consume_token(175);
                break;
            }
            case 176: {
                token = this.jj_consume_token(176);
                break;
            }
            case 177: {
                token = this.jj_consume_token(177);
                break;
            }
            case 178: {
                token = this.jj_consume_token(178);
                break;
            }
            case 179: {
                token = this.jj_consume_token(179);
                break;
            }
            case 180: {
                token = this.jj_consume_token(180);
                break;
            }
            case 181: {
                token = this.jj_consume_token(181);
                break;
            }
            case 182: {
                token = this.jj_consume_token(182);
                break;
            }
            case 183: {
                token = this.jj_consume_token(183);
                break;
            }
            case 185: {
                token = this.jj_consume_token(185);
                break;
            }
            case 186: {
                token = this.jj_consume_token(186);
                break;
            }
            case 187: {
                token = this.jj_consume_token(187);
                break;
            }
            case 411: {
                token = this.jj_consume_token(411);
                break;
            }
            case 188: {
                token = this.jj_consume_token(188);
                break;
            }
            case 189: {
                token = this.jj_consume_token(189);
                break;
            }
            case 371: {
                token = this.jj_consume_token(371);
                break;
            }
            case 190: {
                token = this.jj_consume_token(190);
                break;
            }
            case 191: {
                token = this.jj_consume_token(191);
                break;
            }
            case 192: {
                token = this.jj_consume_token(192);
                break;
            }
            case 193: {
                token = this.jj_consume_token(193);
                break;
            }
            case 194: {
                token = this.jj_consume_token(194);
                break;
            }
            case 195: {
                token = this.jj_consume_token(195);
                break;
            }
            case 196: {
                token = this.jj_consume_token(196);
                break;
            }
            case 197: {
                token = this.jj_consume_token(197);
                break;
            }
            case 198: {
                token = this.jj_consume_token(198);
                break;
            }
            case 199: {
                token = this.jj_consume_token(199);
                break;
            }
            case 200: {
                token = this.jj_consume_token(200);
                break;
            }
            case 416: {
                token = this.jj_consume_token(416);
                break;
            }
            case 201: {
                token = this.jj_consume_token(201);
                break;
            }
            case 202: {
                token = this.jj_consume_token(202);
                break;
            }
            case 203: {
                token = this.jj_consume_token(203);
                break;
            }
            case 204: {
                token = this.jj_consume_token(204);
                break;
            }
            case 205: {
                token = this.jj_consume_token(205);
                break;
            }
            case 206: {
                token = this.jj_consume_token(206);
                break;
            }
            case 207: {
                token = this.jj_consume_token(207);
                break;
            }
            case 208: {
                token = this.jj_consume_token(208);
                break;
            }
            case 209: {
                token = this.jj_consume_token(209);
                break;
            }
            case 210: {
                token = this.jj_consume_token(210);
                break;
            }
            case 211: {
                token = this.jj_consume_token(211);
                break;
            }
            case 212: {
                token = this.jj_consume_token(212);
                break;
            }
            case 213: {
                token = this.jj_consume_token(213);
                break;
            }
            case 214: {
                token = this.jj_consume_token(214);
                break;
            }
            case 215: {
                token = this.jj_consume_token(215);
                break;
            }
            case 216: {
                token = this.jj_consume_token(216);
                break;
            }
            case 217: {
                token = this.jj_consume_token(217);
                break;
            }
            case 218: {
                token = this.jj_consume_token(218);
                break;
            }
            case 219: {
                token = this.jj_consume_token(219);
                break;
            }
            case 220: {
                token = this.jj_consume_token(220);
                break;
            }
            case 221: {
                token = this.jj_consume_token(221);
                break;
            }
            case 222: {
                token = this.jj_consume_token(222);
                break;
            }
            case 223: {
                token = this.jj_consume_token(223);
                break;
            }
            case 224: {
                token = this.jj_consume_token(224);
                break;
            }
            case 225: {
                token = this.jj_consume_token(225);
                break;
            }
            case 226: {
                token = this.jj_consume_token(226);
                break;
            }
            case 227: {
                token = this.jj_consume_token(227);
                break;
            }
            case 228: {
                token = this.jj_consume_token(228);
                break;
            }
            case 229: {
                token = this.jj_consume_token(229);
                break;
            }
            case 230: {
                token = this.jj_consume_token(230);
                break;
            }
            case 231: {
                token = this.jj_consume_token(231);
                break;
            }
            case 232: {
                token = this.jj_consume_token(232);
                break;
            }
            case 233: {
                token = this.jj_consume_token(233);
                break;
            }
            case 234: {
                token = this.jj_consume_token(234);
                break;
            }
            case 235: {
                token = this.jj_consume_token(235);
                break;
            }
            case 236: {
                token = this.jj_consume_token(236);
                break;
            }
            case 237: {
                token = this.jj_consume_token(237);
                break;
            }
            case 239: {
                token = this.jj_consume_token(239);
                break;
            }
            case 240: {
                token = this.jj_consume_token(240);
                break;
            }
            case 241: {
                token = this.jj_consume_token(241);
                break;
            }
            case 242: {
                token = this.jj_consume_token(242);
                break;
            }
            case 243: {
                token = this.jj_consume_token(243);
                break;
            }
            case 247: {
                token = this.jj_consume_token(247);
                break;
            }
            case 244: {
                token = this.jj_consume_token(244);
                break;
            }
            case 245: {
                token = this.jj_consume_token(245);
                break;
            }
            case 246: {
                token = this.jj_consume_token(246);
                break;
            }
            case 249: {
                token = this.jj_consume_token(249);
                break;
            }
            case 251: {
                token = this.jj_consume_token(251);
                break;
            }
            case 252: {
                token = this.jj_consume_token(252);
                break;
            }
            case 253: {
                token = this.jj_consume_token(253);
                break;
            }
            case 254: {
                token = this.jj_consume_token(254);
                break;
            }
            case 255: {
                token = this.jj_consume_token(255);
                break;
            }
            case 256: {
                token = this.jj_consume_token(256);
                break;
            }
            case 257: {
                token = this.jj_consume_token(257);
                break;
            }
            case 259: {
                token = this.jj_consume_token(259);
                break;
            }
            case 261: {
                token = this.jj_consume_token(261);
                break;
            }
            case 262: {
                token = this.jj_consume_token(262);
                break;
            }
            case 263: {
                token = this.jj_consume_token(263);
                break;
            }
            case 264: {
                token = this.jj_consume_token(264);
                break;
            }
            case 265: {
                token = this.jj_consume_token(265);
                break;
            }
            case 267: {
                token = this.jj_consume_token(267);
                break;
            }
            case 268: {
                token = this.jj_consume_token(268);
                break;
            }
            case 269: {
                token = this.jj_consume_token(269);
                break;
            }
            case 270: {
                token = this.jj_consume_token(270);
                break;
            }
            case 360: {
                token = this.jj_consume_token(360);
                break;
            }
            case 361: {
                token = this.jj_consume_token(361);
                break;
            }
            case 363: {
                token = this.jj_consume_token(363);
                break;
            }
            case 367: {
                token = this.jj_consume_token(367);
                break;
            }
            case 368: {
                token = this.jj_consume_token(368);
                break;
            }
            case 370: {
                token = this.jj_consume_token(370);
                break;
            }
            case 375: {
                token = this.jj_consume_token(375);
                break;
            }
            case 248: {
                token = this.jj_consume_token(248);
                break;
            }
            case 376: {
                token = this.jj_consume_token(376);
                break;
            }
            case 377: {
                token = this.jj_consume_token(377);
                break;
            }
            case 379: {
                token = this.jj_consume_token(379);
                break;
            }
            case 381: {
                token = this.jj_consume_token(381);
                break;
            }
            case 378: {
                token = this.jj_consume_token(378);
                break;
            }
            case 380: {
                token = this.jj_consume_token(380);
                break;
            }
            default: {
                this.jj_la1[373] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.nextToLastTokenDelimitedIdentifier = this.lastTokenDelimitedIdentifier;
        this.lastTokenDelimitedIdentifier = false;
        return token.image;
    }

    public final String nonReservedKeyword() throws ParseException {
        Token token;
        block0 : switch (this.jj_nt.kind) {
            case 271: {
                token = this.jj_consume_token(271);
                break;
            }
            case 272: {
                token = this.jj_consume_token(272);
                break;
            }
            case 273: {
                token = this.jj_consume_token(273);
                break;
            }
            case 382: {
                token = this.jj_consume_token(382);
                break;
            }
            case 383: {
                token = this.jj_consume_token(383);
                break;
            }
            case 274: {
                token = this.jj_consume_token(274);
                break;
            }
            case 384: {
                token = this.jj_consume_token(384);
                break;
            }
            case 80: {
                token = this.jj_consume_token(80);
                break;
            }
            case 275: {
                token = this.jj_consume_token(275);
                break;
            }
            case 276: {
                token = this.jj_consume_token(276);
                break;
            }
            case 277: {
                token = this.jj_consume_token(277);
                break;
            }
            case 385: {
                token = this.jj_consume_token(385);
                break;
            }
            case 278: {
                token = this.jj_consume_token(278);
                break;
            }
            case 93: {
                token = this.jj_consume_token(93);
                break;
            }
            case 279: {
                token = this.jj_consume_token(279);
                break;
            }
            case 280: {
                token = this.jj_consume_token(280);
                break;
            }
            case 386: {
                token = this.jj_consume_token(386);
                break;
            }
            case 281: {
                token = this.jj_consume_token(281);
                break;
            }
            case 282: {
                token = this.jj_consume_token(282);
                break;
            }
            case 387: {
                token = this.jj_consume_token(387);
                break;
            }
            case 105: {
                token = this.jj_consume_token(105);
                break;
            }
            case 388: {
                token = this.jj_consume_token(388);
                break;
            }
            case 362: {
                token = this.jj_consume_token(362);
                break;
            }
            case 364: {
                token = this.jj_consume_token(364);
                break;
            }
            case 283: {
                token = this.jj_consume_token(283);
                break;
            }
            case 114: {
                token = this.jj_consume_token(114);
                break;
            }
            case 284: {
                token = this.jj_consume_token(284);
                break;
            }
            case 285: {
                token = this.jj_consume_token(285);
                break;
            }
            case 286: {
                token = this.jj_consume_token(286);
                break;
            }
            case 393: {
                token = this.jj_consume_token(393);
                break;
            }
            case 394: {
                token = this.jj_consume_token(394);
                break;
            }
            case 289: {
                token = this.jj_consume_token(289);
                break;
            }
            case 365: {
                token = this.jj_consume_token(365);
                break;
            }
            case 390: {
                token = this.jj_consume_token(390);
                break;
            }
            case 391: {
                token = this.jj_consume_token(391);
                break;
            }
            case 392: {
                token = this.jj_consume_token(392);
                break;
            }
            case 395: {
                token = this.jj_consume_token(395);
                break;
            }
            case 290: {
                token = this.jj_consume_token(290);
                break;
            }
            case 396: {
                token = this.jj_consume_token(396);
                break;
            }
            case 397: {
                token = this.jj_consume_token(397);
                break;
            }
            case 398: {
                token = this.jj_consume_token(398);
                break;
            }
            case 399: {
                token = this.jj_consume_token(399);
                break;
            }
            case 291: {
                token = this.jj_consume_token(291);
                break;
            }
            case 292: {
                token = this.jj_consume_token(292);
                break;
            }
            case 293: {
                token = this.jj_consume_token(293);
                break;
            }
            case 294: {
                token = this.jj_consume_token(294);
                break;
            }
            case 400: {
                token = this.jj_consume_token(400);
                break;
            }
            case 295: {
                token = this.jj_consume_token(295);
                break;
            }
            case 401: {
                token = this.jj_consume_token(401);
                break;
            }
            case 297: {
                token = this.jj_consume_token(297);
                break;
            }
            case 402: {
                token = this.jj_consume_token(402);
                break;
            }
            case 299: {
                token = this.jj_consume_token(299);
                break;
            }
            case 300: {
                token = this.jj_consume_token(300);
                break;
            }
            case 403: {
                token = this.jj_consume_token(403);
                break;
            }
            case 301: {
                token = this.jj_consume_token(301);
                break;
            }
            case 302: {
                token = this.jj_consume_token(302);
                break;
            }
            case 303: {
                token = this.jj_consume_token(303);
                break;
            }
            case 404: {
                token = this.jj_consume_token(404);
                break;
            }
            case 405: {
                token = this.jj_consume_token(405);
                break;
            }
            case 304: {
                token = this.jj_consume_token(304);
                break;
            }
            case 305: {
                token = this.jj_consume_token(305);
                break;
            }
            case 306: {
                token = this.jj_consume_token(306);
                break;
            }
            case 369: {
                token = this.jj_consume_token(369);
                break;
            }
            case 307: {
                token = this.jj_consume_token(307);
                break;
            }
            case 308: {
                token = this.jj_consume_token(308);
                break;
            }
            case 309: {
                token = this.jj_consume_token(309);
                break;
            }
            case 310: {
                token = this.jj_consume_token(310);
                break;
            }
            case 406: {
                token = this.jj_consume_token(406);
                break;
            }
            case 407: {
                token = this.jj_consume_token(407);
                break;
            }
            case 311: {
                token = this.jj_consume_token(311);
                break;
            }
            case 408: {
                token = this.jj_consume_token(408);
                break;
            }
            case 312: {
                token = this.jj_consume_token(312);
                break;
            }
            case 313: {
                token = this.jj_consume_token(313);
                break;
            }
            case 184: {
                token = this.jj_consume_token(184);
                break;
            }
            case 314: {
                token = this.jj_consume_token(314);
                break;
            }
            case 315: {
                token = this.jj_consume_token(315);
                break;
            }
            case 316: {
                token = this.jj_consume_token(316);
                break;
            }
            case 317: {
                token = this.jj_consume_token(317);
                break;
            }
            case 318: {
                token = this.jj_consume_token(318);
                break;
            }
            case 409: {
                token = this.jj_consume_token(409);
                break;
            }
            case 410: {
                token = this.jj_consume_token(410);
                break;
            }
            case 319: {
                token = this.jj_consume_token(319);
                break;
            }
            case 320: {
                token = this.jj_consume_token(320);
                break;
            }
            case 321: {
                token = this.jj_consume_token(321);
                break;
            }
            case 322: {
                token = this.jj_consume_token(322);
                break;
            }
            case 413: {
                token = this.jj_consume_token(413);
                break;
            }
            default: {
                this.jj_la1[374] = this.jj_gen;
                if (this.getToken((int)1).kind == 323 && !this.seeingOffsetClause()) {
                    token = this.jj_consume_token(323);
                    break;
                }
                switch (this.jj_nt.kind) {
                    case 414: {
                        token = this.jj_consume_token(414);
                        break block0;
                    }
                    case 415: {
                        token = this.jj_consume_token(415);
                        break block0;
                    }
                    case 412: {
                        token = this.jj_consume_token(412);
                        break block0;
                    }
                    case 372: {
                        token = this.jj_consume_token(372);
                        break block0;
                    }
                    case 324: {
                        token = this.jj_consume_token(324);
                        break block0;
                    }
                    case 418: {
                        token = this.jj_consume_token(418);
                        break block0;
                    }
                    case 325: {
                        token = this.jj_consume_token(325);
                        break block0;
                    }
                    case 326: {
                        token = this.jj_consume_token(326);
                        break block0;
                    }
                    case 419: {
                        token = this.jj_consume_token(419);
                        break block0;
                    }
                    case 420: {
                        token = this.jj_consume_token(420);
                        break block0;
                    }
                    case 421: {
                        token = this.jj_consume_token(421);
                        break block0;
                    }
                    case 422: {
                        token = this.jj_consume_token(422);
                        break block0;
                    }
                    case 327: {
                        token = this.jj_consume_token(327);
                        break block0;
                    }
                    case 424: {
                        token = this.jj_consume_token(424);
                        break block0;
                    }
                    case 328: {
                        token = this.jj_consume_token(328);
                        break block0;
                    }
                    case 423: {
                        token = this.jj_consume_token(423);
                        break block0;
                    }
                    case 425: {
                        token = this.jj_consume_token(425);
                        break block0;
                    }
                    case 329: {
                        token = this.jj_consume_token(329);
                        break block0;
                    }
                    case 426: {
                        token = this.jj_consume_token(426);
                        break block0;
                    }
                    case 427: {
                        token = this.jj_consume_token(427);
                        break block0;
                    }
                    case 428: {
                        token = this.jj_consume_token(428);
                        break block0;
                    }
                    case 330: {
                        token = this.jj_consume_token(330);
                        break block0;
                    }
                    case 373: {
                        token = this.jj_consume_token(373);
                        break block0;
                    }
                    case 331: {
                        token = this.jj_consume_token(331);
                        break block0;
                    }
                    case 332: {
                        token = this.jj_consume_token(332);
                        break block0;
                    }
                    case 374: {
                        token = this.jj_consume_token(374);
                        break block0;
                    }
                    case 429: {
                        token = this.jj_consume_token(429);
                        break block0;
                    }
                    case 430: {
                        token = this.jj_consume_token(430);
                        break block0;
                    }
                    case 334: {
                        token = this.jj_consume_token(334);
                        break block0;
                    }
                    case 333: {
                        token = this.jj_consume_token(333);
                        break block0;
                    }
                    case 335: {
                        token = this.jj_consume_token(335);
                        break block0;
                    }
                    case 432: {
                        token = this.jj_consume_token(432);
                        break block0;
                    }
                    case 433: {
                        token = this.jj_consume_token(433);
                        break block0;
                    }
                    case 336: {
                        token = this.jj_consume_token(336);
                        break block0;
                    }
                    case 434: {
                        token = this.jj_consume_token(434);
                        break block0;
                    }
                    case 435: {
                        token = this.jj_consume_token(435);
                        break block0;
                    }
                    case 437: {
                        token = this.jj_consume_token(437);
                        break block0;
                    }
                    case 436: {
                        token = this.jj_consume_token(436);
                        break block0;
                    }
                    case 337: {
                        token = this.jj_consume_token(337);
                        break block0;
                    }
                    case 338: {
                        token = this.jj_consume_token(338);
                        break block0;
                    }
                    case 339: {
                        token = this.jj_consume_token(339);
                        break block0;
                    }
                    case 340: {
                        token = this.jj_consume_token(340);
                        break block0;
                    }
                    case 341: {
                        token = this.jj_consume_token(341);
                        break block0;
                    }
                    case 342: {
                        token = this.jj_consume_token(342);
                        break block0;
                    }
                    case 343: {
                        token = this.jj_consume_token(343);
                        break block0;
                    }
                    case 344: {
                        token = this.jj_consume_token(344);
                        break block0;
                    }
                    case 345: {
                        token = this.jj_consume_token(345);
                        break block0;
                    }
                    case 438: {
                        token = this.jj_consume_token(438);
                        break block0;
                    }
                    case 439: {
                        token = this.jj_consume_token(439);
                        break block0;
                    }
                    case 346: {
                        token = this.jj_consume_token(346);
                        break block0;
                    }
                    case 347: {
                        token = this.jj_consume_token(347);
                        break block0;
                    }
                    case 431: {
                        token = this.jj_consume_token(431);
                        break block0;
                    }
                    case 440: {
                        token = this.jj_consume_token(440);
                        break block0;
                    }
                    case 348: {
                        token = this.jj_consume_token(348);
                        break block0;
                    }
                    case 441: {
                        token = this.jj_consume_token(441);
                        break block0;
                    }
                    case 238: {
                        token = this.jj_consume_token(238);
                        break block0;
                    }
                    case 349: {
                        token = this.jj_consume_token(349);
                        break block0;
                    }
                    case 350: {
                        token = this.jj_consume_token(350);
                        break block0;
                    }
                    case 351: {
                        token = this.jj_consume_token(351);
                        break block0;
                    }
                    case 352: {
                        token = this.jj_consume_token(352);
                        break block0;
                    }
                    case 353: {
                        token = this.jj_consume_token(353);
                        break block0;
                    }
                    case 442: {
                        token = this.jj_consume_token(442);
                        break block0;
                    }
                    case 354: {
                        token = this.jj_consume_token(354);
                        break block0;
                    }
                    case 443: {
                        token = this.jj_consume_token(443);
                        break block0;
                    }
                    case 250: {
                        token = this.jj_consume_token(250);
                        break block0;
                    }
                    case 355: {
                        token = this.jj_consume_token(355);
                        break block0;
                    }
                    case 444: {
                        token = this.jj_consume_token(444);
                        break block0;
                    }
                    case 356: {
                        token = this.jj_consume_token(356);
                        break block0;
                    }
                    case 445: {
                        token = this.jj_consume_token(445);
                        break block0;
                    }
                    case 357: {
                        token = this.jj_consume_token(357);
                        break block0;
                    }
                    case 258: {
                        token = this.jj_consume_token(258);
                        break block0;
                    }
                    case 260: {
                        token = this.jj_consume_token(260);
                        break block0;
                    }
                    case 417: {
                        token = this.jj_consume_token(417);
                        break block0;
                    }
                    case 358: {
                        token = this.jj_consume_token(358);
                        break block0;
                    }
                    case 446: {
                        token = this.jj_consume_token(446);
                        break block0;
                    }
                }
                this.jj_la1[375] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.nextToLastTokenDelimitedIdentifier = this.lastTokenDelimitedIdentifier;
        this.lastTokenDelimitedIdentifier = false;
        this.thirdToLastIdentifierToken = this.nextToLastIdentifierToken;
        this.nextToLastIdentifierToken = this.lastIdentifierToken;
        this.lastIdentifierToken = token;
        return token.image;
    }

    public final String caseSensitiveIdentifierPlusReservedWords() throws ParseException {
        if (this.jj_2_92(1)) {
            String string = this.caseSensitiveIdentifier();
            return string;
        }
        switch (this.jj_nt.kind) {
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 92: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 239: 
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 251: 
            case 252: 
            case 253: 
            case 254: 
            case 255: 
            case 256: 
            case 257: 
            case 259: 
            case 261: 
            case 262: 
            case 263: 
            case 264: 
            case 265: 
            case 267: 
            case 268: 
            case 269: 
            case 270: 
            case 296: 
            case 360: 
            case 361: 
            case 363: 
            case 366: 
            case 367: 
            case 368: 
            case 370: 
            case 371: 
            case 375: 
            case 376: 
            case 377: 
            case 378: 
            case 379: 
            case 380: 
            case 381: 
            case 411: 
            case 416: {
                String string = this.reservedKeyword();
                return string;
            }
        }
        this.jj_la1[376] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String caseInsensitiveIdentifierPlusReservedWords() throws ParseException, StandardException {
        if (this.jj_2_93(1)) {
            String string = this.identifier(128, true);
            return string;
        }
        switch (this.jj_nt.kind) {
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 92: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 239: 
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 251: 
            case 252: 
            case 253: 
            case 254: 
            case 255: 
            case 256: 
            case 257: 
            case 259: 
            case 261: 
            case 262: 
            case 263: 
            case 264: 
            case 265: 
            case 267: 
            case 268: 
            case 269: 
            case 270: 
            case 296: 
            case 360: 
            case 361: 
            case 363: 
            case 366: 
            case 367: 
            case 368: 
            case 370: 
            case 371: 
            case 375: 
            case 376: 
            case 377: 
            case 378: 
            case 379: 
            case 380: 
            case 381: 
            case 411: 
            case 416: {
                String string = this.reservedKeyword();
                return StringUtil.SQLToUpperCase(string);
            }
        }
        this.jj_la1[377] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String caseSensitiveIdentifier() throws ParseException {
        switch (this.jj_nt.kind) {
            case 480: {
                Token token = this.jj_consume_token(480);
                this.nextToLastTokenDelimitedIdentifier = this.lastTokenDelimitedIdentifier;
                this.lastTokenDelimitedIdentifier = false;
                return token.image;
            }
            case 486: {
                String string = this.delimitedIdentifier();
                return string;
            }
        }
        this.jj_la1[378] = this.jj_gen;
        if (this.jj_2_94(1)) {
            String string = this.nonReservedKeyword();
            return string;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_1(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_2(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_3(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_4(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_5(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_6(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_7(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_8(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_9(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_10(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_11(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_12(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_13(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(12, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_14(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(13, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_15(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_15();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(14, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_16(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_16();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(15, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_17(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_17();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(16, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_18(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_18();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(17, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_19(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_19();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(18, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_20(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_20();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(19, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_21(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_21();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(20, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_22(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_22();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(21, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_23(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_23();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(22, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_24(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_24();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(23, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_25(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_25();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(24, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_26(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_26();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(25, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_27(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_27();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(26, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_28(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_28();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(27, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_29(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_29();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(28, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_30(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_30();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(29, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_31(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_31();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(30, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_32(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_32();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(31, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_33(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_33();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(32, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_34(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_34();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(33, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_35(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_35();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(34, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_36(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_36();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(35, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_37(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_37();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(36, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_38(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_38();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(37, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_39(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_39();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(38, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_40(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_40();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(39, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_41(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_41();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(40, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_42(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_42();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(41, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_43(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_43();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(42, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_44(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_44();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(43, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_45(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_45();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(44, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_46(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_46();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(45, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_47(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_47();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(46, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_48(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_48();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(47, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_49(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_49();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(48, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_50(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_50();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(49, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_51(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_51();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(50, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_52(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_52();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(51, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_53(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_53();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(52, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_54(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_54();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(53, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_55(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_55();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(54, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_56(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_56();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(55, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_57(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_57();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(56, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_58(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_58();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(57, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_59(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_59();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(58, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_60(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_60();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(59, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_61(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_61();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(60, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_62(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_62();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(61, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_63(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_63();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(62, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_64(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_64();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(63, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_65(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_65();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(64, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_66(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_66();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(65, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_67(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_67();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(66, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_68(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_68();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(67, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_69(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_69();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(68, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_70(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_70();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(69, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_71(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_71();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(70, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_72(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_72();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(71, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_73(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_73();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(72, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_74(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_74();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(73, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_75(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_75();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(74, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_76(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_76();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(75, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_77(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_77();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(76, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_78(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_78();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(77, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_79(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_79();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(78, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_80(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_80();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(79, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_81(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_81();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(80, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_82(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_82();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(81, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_83(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_83();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(82, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_84(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_84();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(83, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_85(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_85();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(84, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_86(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_86();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(85, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_87(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_87();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(86, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_88(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_88();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(87, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_89(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_89();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(88, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_90(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_90();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(89, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_91(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_91();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(90, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_92(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_92();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(91, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_93(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_93();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(92, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_94(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_94();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(93, n);
        }
    }

    private final boolean jj_3R_282() {
        return this.jj_scan_token(162);
    }

    private final boolean jj_3R_173() {
        return this.jj_3R_263();
    }

    private final boolean jj_3R_285() {
        return this.jj_scan_token(100);
    }

    private final boolean jj_3R_231() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)1).kind == 100;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_285()) {
            this.jj_scanpos = token;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)1).kind == 208;
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_286()) {
                this.jj_scanpos = token;
                this.lookingAhead = true;
                this.jj_semLA = this.getToken((int)1).kind == 145;
                this.lookingAhead = false;
                if (!this.jj_semLA || this.jj_3R_287()) {
                    this.jj_scanpos = token;
                    this.lookingAhead = true;
                    this.jj_semLA = this.getToken((int)1).kind == 252;
                    this.lookingAhead = false;
                    if (!this.jj_semLA || this.jj_3R_288()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_289()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_279() {
        return this.jj_scan_token(363);
    }

    private final boolean jj_3R_86() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_172()) {
            this.jj_scanpos = token;
            if (this.jj_3R_173()) {
                this.jj_scanpos = token;
                if (this.jj_3R_174()) {
                    this.jj_scanpos = token;
                    if (this.jj_3_45()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_175()) {
                            this.jj_scanpos = token;
                            if (this.jj_3R_176()) {
                                this.jj_scanpos = token;
                                if (this.jj_3R_177()) {
                                    this.jj_scanpos = token;
                                    if (this.jj_3R_178()) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_172() {
        return this.jj_scan_token(366);
    }

    private final boolean jj_3_36() {
        return this.jj_3R_85();
    }

    private final boolean jj_3R_371() {
        return this.jj_scan_token(377);
    }

    private final boolean jj_3R_366() {
        return this.jj_scan_token(327);
    }

    private final boolean jj_3R_63() {
        return this.jj_3R_141();
    }

    private final boolean jj_3R_77() {
        return this.jj_3R_83();
    }

    private final boolean jj_3R_130() {
        return this.jj_scan_token(129);
    }

    private final boolean jj_3R_118() {
        return this.jj_3R_231();
    }

    private final boolean jj_3_60() {
        return this.jj_3R_60();
    }

    private final boolean jj_3R_365() {
        return this.jj_scan_token(220);
    }

    private final boolean jj_3R_354() {
        return this.jj_scan_token(226);
    }

    private final boolean jj_3_91() {
        return this.jj_3R_121();
    }

    private final boolean jj_3R_230() {
        return this.jj_3R_284();
    }

    private final boolean jj_3R_245() {
        return this.jj_scan_token(108);
    }

    private final boolean jj_3R_364() {
        return this.jj_scan_token(333);
    }

    private final boolean jj_3R_298() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_364()) {
            this.jj_scanpos = token;
            if (this.jj_3R_365()) {
                this.jj_scanpos = token;
                if (this.jj_3R_366()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_136() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(172)) {
            this.jj_scanpos = token;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)1).kind == 108 && this.getToken((int)2).kind == 172;
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_245()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_353() {
        return this.jj_scan_token(112);
    }

    private final boolean jj_3_44() {
        return this.jj_3R_90();
    }

    private final boolean jj_3R_299() {
        return this.jj_3R_367();
    }

    private final boolean jj_3R_249() {
        return this.jj_3R_291();
    }

    private final boolean jj_3_28() {
        return this.jj_3R_77();
    }

    private final boolean jj_3R_352() {
        return this.jj_scan_token(256);
    }

    private final boolean jj_3R_278() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_352()) {
            this.jj_scanpos = token;
            if (this.jj_3R_353()) {
                this.jj_scanpos = token;
                if (this.jj_3R_354()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3_43() {
        return this.jj_3R_89();
    }

    private final boolean jj_3R_101() {
        return this.jj_3R_206();
    }

    private final boolean jj_3R_100() {
        return this.jj_3R_205();
    }

    private final boolean jj_3R_56() {
        return this.jj_3R_136();
    }

    private final boolean jj_3_59() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.newInvocationFollows(1);
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_100()) {
            this.jj_scanpos = token;
            if (this.jj_3R_101()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_204() {
        Token token = this.jj_scanpos;
        if (this.jj_3_59()) {
            this.jj_scanpos = token;
            if (this.jj_3_60()) {
                this.jj_scanpos = token;
                this.lookingAhead = true;
                this.jj_semLA = this.getToken((int)1).kind == 453 && (this.getToken((int)2).kind == 225 || this.getToken((int)2).kind == 259);
                this.lookingAhead = false;
                if (!this.jj_semLA || this.jj_3R_274()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_275()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_229() {
        return this.jj_3R_283();
    }

    private final boolean jj_3R_336() {
        return this.jj_3R_279();
    }

    private final boolean jj_3_35() {
        return this.jj_3R_84();
    }

    private final boolean jj_3R_369() {
        return this.jj_scan_token(369);
    }

    private final boolean jj_3R_253() {
        return this.jj_3R_60();
    }

    private final boolean jj_3R_248() {
        return this.jj_scan_token(480);
    }

    private final boolean jj_3R_158() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)2).kind == 460 && (this.getToken((int)3).kind == 455 || this.getToken((int)4).kind == 460 && this.getToken((int)5).kind == 455);
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_253()) {
            this.jj_scanpos = token;
            if (this.jj_3_28()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_135() {
        return this.jj_scan_token(137);
    }

    private final boolean jj_3R_141() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_248()) {
            this.jj_scanpos = token;
            if (this.jj_3R_249()) {
                this.jj_scanpos = token;
                if (this.jj_3_91()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_335() {
        return this.jj_3R_278();
    }

    private final boolean jj_3_15() {
        return this.jj_3R_62();
    }

    private final boolean jj_3R_208() {
        return this.jj_3R_79();
    }

    private final boolean jj_3R_228() {
        return this.jj_3R_282();
    }

    private final boolean jj_3R_247() {
        return this.jj_3R_299();
    }

    private final boolean jj_3R_140() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.javaClassFollows();
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_247()) {
            this.jj_scanpos = token;
            if (this.jj_3_35()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_129() {
        return this.jj_scan_token(106);
    }

    private final boolean jj_3R_334() {
        return this.jj_3R_384();
    }

    private final boolean jj_3R_267() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_334()) {
            this.jj_scanpos = token;
            if (this.jj_3R_335()) {
                this.jj_scanpos = token;
                if (this.jj_3R_336()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_116() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_228()) {
            this.jj_scanpos = token;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)1).kind == 120 || this.getToken((int)2).kind == 120;
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_229()) {
                this.jj_scanpos = token;
                this.lookingAhead = true;
                this.jj_semLA = this.getToken((int)1).kind == 290 || this.getToken((int)2).kind == 290;
                this.lookingAhead = false;
                if (!this.jj_semLA || this.jj_3R_230()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_374() {
        return this.jj_3R_90();
    }

    private final boolean jj_3R_308() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)2).kind == 460 && this.getToken((int)4).kind == 453;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_374()) {
            this.jj_scanpos = token;
            if (this.jj_3_15()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_155() {
        return this.jj_scan_token(128);
    }

    private final boolean jj_3R_104() {
        return this.jj_3R_208();
    }

    private final boolean jj_3R_74() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)2).kind == 326;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_155()) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(128)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_55() {
        return this.jj_3R_135();
    }

    private final boolean jj_3_3() {
        return this.jj_3R_48();
    }

    private final boolean jj_3_2() {
        return this.jj_3R_47();
    }

    private final boolean jj_3R_54() {
        return this.jj_3R_134();
    }

    private final boolean jj_3R_76() {
        return this.jj_3R_158();
    }

    private final boolean jj_3R_99() {
        return this.jj_3R_204();
    }

    private final boolean jj_3R_407() {
        return this.jj_scan_token(140);
    }

    private final boolean jj_3_25() {
        return this.jj_3R_74();
    }

    private final boolean jj_3R_199() {
        return this.jj_3R_273();
    }

    private final boolean jj_3R_406() {
        return this.jj_scan_token(249);
    }

    private final boolean jj_3R_383() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_406()) {
            this.jj_scanpos = token;
            if (this.jj_3R_407()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_67() {
        return this.jj_3R_104();
    }

    private final boolean jj_3_1() {
        return this.jj_3R_46();
    }

    private final boolean jj_3_34() {
        return this.jj_3R_83();
    }

    private final boolean jj_3R_95() {
        Token token = this.jj_scanpos;
        if (this.jj_3_34()) {
            this.jj_scanpos = token;
            if (this.jj_3R_199()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_53() {
        return this.jj_3R_133();
    }

    private final boolean jj_3R_52() {
        return this.jj_3R_132();
    }

    private final boolean jj_3_27() {
        return this.jj_3R_76();
    }

    private final boolean jj_3R_51() {
        return this.jj_3R_131();
    }

    private final boolean jj_3R_50() {
        return this.jj_3R_130();
    }

    private final boolean jj_3R_49() {
        return this.jj_3R_129();
    }

    private final boolean jj_3R_154() {
        return this.jj_scan_token(214);
    }

    private final boolean jj_3R_139() {
        return this.jj_scan_token(358);
    }

    private final boolean jj_3_4() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_49()) {
            this.jj_scanpos = token;
            if (this.jj_3R_50()) {
                this.jj_scanpos = token;
                if (this.jj_3R_51()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_52()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_53()) {
                            this.jj_scanpos = token;
                            if (this.jj_3_1()) {
                                this.jj_scanpos = token;
                                if (this.jj_3R_54()) {
                                    this.jj_scanpos = token;
                                    if (this.jj_3_2()) {
                                        this.jj_scanpos = token;
                                        if (this.jj_3_3()) {
                                            this.jj_scanpos = token;
                                            if (this.jj_3R_55()) {
                                                return true;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_313() {
        return this.jj_3R_86();
    }

    private final boolean jj_3R_259() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = (this.getToken((int)1).kind == 366 || this.getToken((int)1).kind == 271 || this.getToken((int)1).kind == 272 || this.getToken((int)1).kind == 438 || this.getToken((int)1).kind == 311 || this.getToken((int)1).kind == 93 || this.getToken((int)1).kind == 258 || this.getToken((int)1).kind == 293 || this.getToken((int)1).kind == 235 || this.getToken((int)1).kind == 376 || this.getToken((int)1).kind == 255 || this.getToken((int)1).kind == 179 || this.getToken((int)1).kind == 444 || this.getToken((int)1).kind == 403 || this.getToken((int)1).kind == 370 || this.getToken((int)1).kind == 375 || this.getToken((int)1).kind == 248 || this.getToken((int)1).kind == 285 || this.getToken((int)1).kind == 350 || this.getToken((int)1).kind == 351 || this.getToken((int)1).kind == 128 || this.getToken((int)1).kind == 88 || this.getToken((int)1).kind == 261 || this.getToken((int)1).kind == 168 || this.getToken((int)1).kind == 167 || this.getToken((int)1).kind == 228 || this.getToken((int)1).kind == 368 || this.getToken((int)1).kind == 270 || this.getToken((int)1).kind == 314 || this.getToken((int)1).kind == 286 || this.getToken((int)1).kind == 157 || this.getToken((int)1).kind == 183 || this.getToken((int)1).kind == 224 || this.getToken((int)1).kind == 301 || this.getToken((int)1).kind == 404 || this.getToken((int)1).kind == 379 || this.getToken((int)1).kind == 381 || this.getToken((int)1).kind == 378 || this.getToken((int)1).kind == 380) && this.getToken((int)2).kind == 453;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_313()) {
            this.jj_scanpos = token;
            if (this.jj_3_43()) {
                this.jj_scanpos = token;
                if (this.jj_3_44()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3_14() {
        return this.jj_3R_61();
    }

    private final boolean jj_3_58() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(72)) {
            this.jj_scanpos = token;
        }
        return this.jj_3R_63();
    }

    private final boolean jj_3R_59() {
        return this.jj_3R_83();
    }

    private final boolean jj_3R_61() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)1).kind == 358 && this.getToken((int)2).kind != 190;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_138()) {
            this.jj_scanpos = token;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)1).kind == 358 && this.getToken((int)2).kind == 190;
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_139()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_138() {
        return this.jj_scan_token(358);
    }

    private final boolean jj_3R_157() {
        return this.jj_scan_token(66);
    }

    private final boolean jj_3_40() {
        return this.jj_3R_83();
    }

    private final boolean jj_3R_170() {
        return this.jj_3R_261();
    }

    private final boolean jj_3R_169() {
        return this.jj_3R_260();
    }

    private final boolean jj_3R_340() {
        return this.jj_3R_385();
    }

    private final boolean jj_3R_384() {
        return this.jj_scan_token(472);
    }

    private final boolean jj_3R_73() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_153()) {
            this.jj_scanpos = token;
            if (this.jj_3R_154()) {
                this.jj_scanpos = token;
                if (this.jj_3_25()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_153() {
        return this.jj_scan_token(143);
    }

    private final boolean jj_3R_339() {
        return this.jj_scan_token(351);
    }

    private final boolean jj_3R_203() {
        return this.jj_scan_token(451);
    }

    private final boolean jj_3_57() {
        return this.jj_3R_99();
    }

    private final boolean jj_3R_98() {
        Token token = this.jj_scanpos;
        if (this.jj_3_57()) {
            this.jj_scanpos = token;
            if (this.jj_3R_203()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_338() {
        return this.jj_scan_token(285);
    }

    private final boolean jj_3R_75() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)1).kind == 127 && this.getToken((int)2).kind != 460 && this.getToken((int)2).kind != 463;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_156()) {
            this.jj_scanpos = token;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)1).kind == 66 && this.getToken((int)2).kind != 460 && this.getToken((int)2).kind != 463;
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_157()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_156() {
        return this.jj_scan_token(127);
    }

    private final boolean jj_3_66() {
        return this.jj_3R_79();
    }

    private final boolean jj_3R_168() {
        return this.jj_scan_token(453);
    }

    private final boolean jj_3_26() {
        return this.jj_3R_75();
    }

    private final boolean jj_3R_337() {
        return this.jj_scan_token(350);
    }

    private final boolean jj_3R_270() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_337()) {
            this.jj_scanpos = token;
            if (this.jj_3R_338()) {
                this.jj_scanpos = token;
                if (this.jj_3R_339()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_340()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_345() {
        return this.jj_scan_token(368);
    }

    private final boolean jj_3_56() {
        return this.jj_3R_98();
    }

    private final boolean jj_3R_344() {
        return this.jj_scan_token(228);
    }

    private final boolean jj_3_42() {
        return this.jj_3R_88();
    }

    private final boolean jj_3R_343() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(168)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(167)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_272() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_343()) {
            this.jj_scanpos = token;
            if (this.jj_3R_344()) {
                this.jj_scanpos = token;
                if (this.jj_3R_345()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_342() {
        return this.jj_scan_token(261);
    }

    private final boolean jj_3R_167() {
        return this.jj_3R_259();
    }

    private final boolean jj_3R_430() {
        return this.jj_scan_token(225);
    }

    private final boolean jj_3R_341() {
        return this.jj_scan_token(88);
    }

    private final boolean jj_3R_306() {
        return this.jj_3R_272();
    }

    private final boolean jj_3R_271() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_341()) {
            this.jj_scanpos = token;
            if (this.jj_3R_342()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_295() {
        return this.jj_scan_token(309);
    }

    private final boolean jj_3R_256() {
        return this.jj_scan_token(460);
    }

    private final boolean jj_3R_166() {
        return this.jj_3R_258();
    }

    private final boolean jj_3R_120() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(96)) {
            this.jj_scanpos = token;
        }
        return this.jj_3R_65();
    }

    private final boolean jj_3R_194() {
        return this.jj_3R_272();
    }

    private final boolean jj_3R_128() {
        return this.jj_scan_token(218);
    }

    private final boolean jj_3R_92() {
        Token token = this.jj_scanpos;
        if (this.jj_3_50()) {
            this.jj_scanpos = token;
            if (this.jj_3R_194()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_50() {
        return this.jj_3R_74();
    }

    private final boolean jj_3R_429() {
        return this.jj_3R_431();
    }

    private final boolean jj_3R_165() {
        return this.jj_3R_205();
    }

    private final boolean jj_3R_261() {
        return this.jj_scan_token(188);
    }

    private final boolean jj_3R_428() {
        return this.jj_3R_430();
    }

    private final boolean jj_3R_427() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_428()) {
            this.jj_scanpos = token;
            if (this.jj_3R_429()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_41() {
        return this.jj_3R_87();
    }

    private final boolean jj_3_52() {
        return this.jj_3R_96();
    }

    private final boolean jj_3R_48() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)1).kind == 218 && (this.getToken((int)2).kind == 442 && (this.getToken((int)3).kind == 458 && this.isPrivilegeKeywordExceptTrigger(this.getToken((int)4).kind) || this.getToken((int)3).kind == 195) || this.isPrivilegeKeywordExceptTrigger(this.getToken((int)2).kind));
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_127()) {
            this.jj_scanpos = token;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)1).kind == 218 && (this.getToken((int)2).kind == 442 && (this.getToken((int)3).kind == 458 && !this.isPrivilegeKeywordExceptTrigger(this.getToken((int)4).kind) || this.getToken((int)3).kind == 147) || !this.isPrivilegeKeywordExceptTrigger(this.getToken((int)2).kind));
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_128()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_127() {
        return this.jj_scan_token(218);
    }

    private final boolean jj_3R_164() {
        return this.jj_scan_token(108);
    }

    private final boolean jj_3R_255() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(478)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(460)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_160() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)3).kind == 453;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_255()) {
            this.jj_scanpos = token;
            if (this.jj_3R_256()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_163() {
        return this.jj_scan_token(108);
    }

    private final boolean jj_3R_84() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.escapedValueFunctionFollows();
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_162()) {
            this.jj_scanpos = token;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)2).kind == 222 || this.getToken((int)2).kind == 436;
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_163()) {
                this.jj_scanpos = token;
                this.lookingAhead = true;
                this.jj_semLA = this.getToken((int)2).kind == 172;
                this.lookingAhead = false;
                if (!this.jj_semLA || this.jj_3R_164()) {
                    this.jj_scanpos = token;
                    if (this.jj_3_41()) {
                        this.jj_scanpos = token;
                        this.lookingAhead = true;
                        this.jj_semLA = this.newInvocationFollows(1);
                        this.lookingAhead = false;
                        if (!this.jj_semLA || this.jj_3R_165()) {
                            this.jj_scanpos = token;
                            this.lookingAhead = true;
                            this.jj_semLA = this.windowOrAggregateFunctionFollows();
                            this.lookingAhead = false;
                            if (!this.jj_semLA || this.jj_3R_166()) {
                                this.jj_scanpos = token;
                                this.lookingAhead = true;
                                this.jj_semLA = this.miscBuiltinFollows();
                                this.lookingAhead = false;
                                if (!this.jj_semLA || this.jj_3R_167()) {
                                    this.jj_scanpos = token;
                                    if (this.jj_3_42()) {
                                        this.jj_scanpos = token;
                                        if (this.jj_3R_168()) {
                                            this.jj_scanpos = token;
                                            if (this.jj_3R_169()) {
                                                this.jj_scanpos = token;
                                                if (this.jj_3R_170()) {
                                                    return true;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_162() {
        return this.jj_scan_token(451);
    }

    private final boolean jj_3R_372() {
        return this.jj_scan_token(193);
    }

    private final boolean jj_3R_305() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_372()) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(117)) {
                this.jj_scanpos = token;
                if (this.jj_scan_token(116)) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_252() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_305()) {
            this.jj_scanpos = token;
            if (this.jj_3R_306()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_290() {
        return this.jj_scan_token(305);
    }

    private final boolean jj_3R_117() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(96)) {
            this.jj_scanpos = token;
        }
        return this.jj_3R_63();
    }

    private final boolean jj_3R_82() {
        return this.jj_3R_160();
    }

    private final boolean jj_3R_201() {
        return this.jj_scan_token(320);
    }

    private final boolean jj_3R_260() {
        return this.jj_scan_token(87);
    }

    private final boolean jj_3_33() {
        return this.jj_3R_82();
    }

    private final boolean jj_3R_96() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)2).kind == 175;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_200()) {
            this.jj_scanpos = token;
            if (this.jj_3R_201()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_200() {
        return this.jj_scan_token(320);
    }

    private final boolean jj_3R_412() {
        return this.jj_3R_384();
    }

    private final boolean jj_3R_198() {
        return this.jj_scan_token(428);
    }

    private final boolean jj_3R_62() {
        return this.jj_3R_140();
    }

    private final boolean jj_3R_421() {
        return this.jj_scan_token(370);
    }

    private final boolean jj_3_24() {
        return this.jj_3R_73();
    }

    private final boolean jj_3R_235() {
        return this.jj_3R_290();
    }

    private final boolean jj_3R_94() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)2).kind == 432;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_197()) {
            this.jj_scanpos = token;
            if (this.jj_3R_198()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_197() {
        return this.jj_scan_token(428);
    }

    private final boolean jj_3R_420() {
        return this.jj_scan_token(375);
    }

    private final boolean jj_3R_415() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_420()) {
            this.jj_scanpos = token;
            if (this.jj_3R_421()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_72() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_152()) {
            this.jj_scanpos = token;
            if (this.jj_3_24()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_152() {
        return this.jj_3R_252();
    }

    private final boolean jj_3R_418() {
        return this.jj_scan_token(453);
    }

    private final boolean jj_3R_417() {
        return this.jj_3R_427();
    }

    private final boolean jj_3R_410() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_417()) {
            this.jj_scanpos = token;
            if (this.jj_3R_418()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_401() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(181)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(77)) {
                this.jj_scanpos = token;
                if (this.jj_scan_token(182)) {
                    this.jj_scanpos = token;
                    if (this.jj_scan_token(236)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_411() {
        return this.jj_scan_token(361);
    }

    private final boolean jj_3R_387() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_411()) {
            this.jj_scanpos = token;
            if (this.jj_3R_412()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_399() {
        return this.jj_scan_token(459);
    }

    private final boolean jj_3R_398() {
        return this.jj_scan_token(457);
    }

    private final boolean jj_3R_373() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_398()) {
            this.jj_scanpos = token;
            if (this.jj_3R_399()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_94() {
        return this.jj_3R_121();
    }

    private final boolean jj_3R_397() {
        return this.jj_scan_token(185);
    }

    private final boolean jj_3R_363() {
        return this.jj_scan_token(451);
    }

    private final boolean jj_3R_362() {
        return this.jj_3R_387();
    }

    private final boolean jj_3_83() {
        return this.jj_3R_116();
    }

    private final boolean jj_3R_237() {
        return this.jj_3R_291();
    }

    private final boolean jj_3R_396() {
        return this.jj_3R_251();
    }

    private final boolean jj_3R_395() {
        return this.jj_scan_token(80);
    }

    private final boolean jj_3R_234() {
        return this.jj_scan_token(68);
    }

    private final boolean jj_3R_122() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_236()) {
            this.jj_scanpos = token;
            if (this.jj_3R_237()) {
                this.jj_scanpos = token;
                if (this.jj_3_94()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_236() {
        return this.jj_scan_token(480);
    }

    private final boolean jj_3R_381() {
        return this.jj_scan_token(491);
    }

    private final boolean jj_3R_376() {
        return this.jj_3R_401();
    }

    private final boolean jj_3R_297() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_362()) {
            this.jj_scanpos = token;
            if (this.jj_3R_363()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_233() {
        return this.jj_scan_token(68);
    }

    private final boolean jj_3R_394() {
        return this.jj_scan_token(318);
    }

    private final boolean jj_3R_196() {
        return this.jj_scan_token(83);
    }

    private final boolean jj_3R_393() {
        return this.jj_scan_token(278);
    }

    private final boolean jj_3R_93() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)2).kind == 422;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_195()) {
            this.jj_scanpos = token;
            if (this.jj_3R_196()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_195() {
        return this.jj_scan_token(83);
    }

    private final boolean jj_3R_392() {
        return this.jj_scan_token(275);
    }

    private final boolean jj_3_88() {
        return this.jj_3R_120();
    }

    private final boolean jj_3_38() {
        return this.jj_scan_token(147);
    }

    private final boolean jj_3_65() {
        return this.jj_3R_75();
    }

    private final boolean jj_3_39() {
        return this.jj_3R_79();
    }

    private final boolean jj_3R_102() {
        Token token = this.jj_scanpos;
        if (this.jj_3_65()) {
            this.jj_scanpos = token;
        }
        return this.jj_3R_79();
    }

    private final boolean jj_3R_419() {
        return this.jj_scan_token(138);
    }

    private final boolean jj_3R_380() {
        return this.jj_scan_token(490);
    }

    private final boolean jj_3_93() {
        return this.jj_3R_63();
    }

    private final boolean jj_3R_370() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_392()) {
            this.jj_scanpos = token;
            if (this.jj_3R_393()) {
                this.jj_scanpos = token;
                if (this.jj_3R_394()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_395()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_396()) {
                            this.jj_scanpos = token;
                            if (this.jj_3R_397()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3_12() {
        return this.jj_3R_59();
    }

    private final boolean jj_3R_119() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_232()) {
            this.jj_scanpos = token;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)1).kind == 68 && this.getToken((int)2).kind != 100;
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_233()) {
                this.jj_scanpos = token;
                if (this.jj_3R_234()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_235()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_232() {
        return this.jj_scan_token(65);
    }

    private final boolean jj_3R_307() {
        return this.jj_3R_373();
    }

    private final boolean jj_3_90() {
        return this.jj_3R_63();
    }

    private final boolean jj_3R_262() {
        return this.jj_3R_314();
    }

    private final boolean jj_3_82() {
        return this.jj_3R_83();
    }

    private final boolean jj_3R_207() {
        return false;
    }

    private final boolean jj_3R_254() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_307()) {
            this.jj_scanpos = token;
        }
        return this.jj_3R_308();
    }

    private final boolean jj_3_64() {
        return this.jj_3R_63();
    }

    private final boolean jj_3_92() {
        return this.jj_3R_122();
    }

    private final boolean jj_3R_171() {
        Token token = this.jj_scanpos;
        if (this.jj_3_92()) {
            this.jj_scanpos = token;
            if (this.jj_3R_262()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_63() {
        return this.jj_3R_103();
    }

    private final boolean jj_3R_403() {
        return this.jj_scan_token(248);
    }

    private final boolean jj_3R_103() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)2).kind == 453 || this.getToken((int)2).kind == 480;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_207()) {
            return true;
        }
        return this.jj_scan_token(372);
    }

    private final boolean jj_3R_151() {
        return this.jj_scan_token(411);
    }

    private final boolean jj_3R_402() {
        return this.jj_3R_415();
    }

    private final boolean jj_3R_377() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_402()) {
            this.jj_scanpos = token;
            if (this.jj_3R_403()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_13() {
        return this.jj_3R_60();
    }

    private final boolean jj_3_62() {
        return this.jj_3R_103();
    }

    private final boolean jj_3R_312() {
        return this.jj_scan_token(374);
    }

    private final boolean jj_3R_150() {
        return this.jj_scan_token(187);
    }

    private final boolean jj_3R_386() {
        return this.jj_3R_410();
    }

    private final boolean jj_3_49() {
        return this.jj_3R_93();
    }

    private final boolean jj_3R_311() {
        return this.jj_3R_376();
    }

    private final boolean jj_3R_149() {
        return this.jj_scan_token(185);
    }

    private final boolean jj_3_61() {
        return this.jj_3R_102();
    }

    private final boolean jj_3R_71() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_149()) {
            this.jj_scanpos = token;
            if (this.jj_3R_150()) {
                this.jj_scanpos = token;
                if (this.jj_3R_151()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_324() {
        return this.jj_scan_token(404);
    }

    private final boolean jj_3R_310() {
        return this.jj_scan_token(105);
    }

    private final boolean jj_3R_258() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_310()) {
            this.jj_scanpos = token;
            if (this.jj_3R_311()) {
                this.jj_scanpos = token;
                if (this.jj_3R_312()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_323() {
        return this.jj_3R_377();
    }

    private final boolean jj_3R_322() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(444)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(403)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_321() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(255)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(179)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_159() {
        return this.jj_3R_254();
    }

    private final boolean jj_3R_189() {
        return this.jj_scan_token(111);
    }

    private final boolean jj_3R_320() {
        return this.jj_scan_token(376);
    }

    private final boolean jj_3R_296() {
        return this.jj_scan_token(254);
    }

    private final boolean jj_3R_264() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_320()) {
            this.jj_scanpos = token;
            if (this.jj_3R_321()) {
                this.jj_scanpos = token;
                if (this.jj_3R_322()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_323()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_324()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3_89() {
        return this.jj_3R_113();
    }

    private final boolean jj_3_81() {
        return this.jj_3R_83();
    }

    private final boolean jj_3R_188() {
        return this.jj_scan_token(108);
    }

    private final boolean jj_3R_187() {
        return this.jj_scan_token(110);
    }

    private final boolean jj_3R_361() {
        return this.jj_3R_386();
    }

    private final boolean jj_3R_186() {
        return this.jj_scan_token(108);
    }

    private final boolean jj_3R_251() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(88)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(89)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_11() {
        return this.jj_3R_60();
    }

    private final boolean jj_3R_409() {
        return this.jj_scan_token(224);
    }

    private final boolean jj_3R_202() {
        return this.jj_3R_79();
    }

    private final boolean jj_3R_185() {
        return this.jj_scan_token(109);
    }

    private final boolean jj_3R_408() {
        return this.jj_3R_416();
    }

    private final boolean jj_3R_385() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_408()) {
            this.jj_scanpos = token;
            if (this.jj_3R_409()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_382() {
        return this.jj_scan_token(451);
    }

    private final boolean jj_3R_89() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)1).kind == 108 && this.getToken((int)2).kind == 285;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_184()) {
            this.jj_scanpos = token;
            if (this.jj_3R_185()) {
                this.jj_scanpos = token;
                this.lookingAhead = true;
                this.jj_semLA = this.getToken((int)1).kind == 108 && this.getToken((int)2).kind == 350;
                this.lookingAhead = false;
                if (!this.jj_semLA || this.jj_3R_186()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_187()) {
                        this.jj_scanpos = token;
                        this.lookingAhead = true;
                        this.jj_semLA = this.getToken((int)1).kind == 108 && this.getToken((int)2).kind == 351;
                        this.lookingAhead = false;
                        if (!this.jj_semLA || this.jj_3R_188()) {
                            this.jj_scanpos = token;
                            if (this.jj_3R_189()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_184() {
        return this.jj_scan_token(108);
    }

    private final boolean jj_3R_97() {
        return this.jj_3R_202();
    }

    private final boolean jj_3R_88() {
        return this.jj_3R_63();
    }

    private final boolean jj_3_47() {
        return this.jj_3R_93();
    }

    private final boolean jj_3_55() {
        return this.jj_3R_97();
    }

    private final boolean jj_3R_148() {
        return this.jj_3R_251();
    }

    private final boolean jj_3R_294() {
        return this.jj_scan_token(166);
    }

    private final boolean jj_3R_147() {
        return this.jj_scan_token(261);
    }

    private final boolean jj_3R_69() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_147()) {
            this.jj_scanpos = token;
            if (this.jj_3R_148()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_48() {
        return this.jj_3R_94();
    }

    private final boolean jj_3R_183() {
        return this.jj_scan_token(86);
    }

    private final boolean jj_3R_60() {
        return this.jj_3R_63();
    }

    private final boolean jj_3R_431() {
        return this.jj_scan_token(259);
    }

    private final boolean jj_3R_304() {
        return this.jj_3R_371();
    }

    private final boolean jj_3R_79() {
        return this.jj_3R_159();
    }

    private final boolean jj_3R_303() {
        return this.jj_3R_370();
    }

    private final boolean jj_3R_302() {
        return this.jj_3R_369();
    }

    private final boolean jj_3R_182() {
        return this.jj_scan_token(86);
    }

    private final boolean jj_3R_348() {
        return this.jj_scan_token(189);
    }

    private final boolean jj_3R_70() {
        return false;
    }

    private final boolean jj_3R_347() {
        return this.jj_scan_token(283);
    }

    private final boolean jj_3R_276() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_347()) {
            this.jj_scanpos = token;
            if (this.jj_3R_348()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_68() {
        return false;
    }

    private final boolean jj_3R_300() {
        return this.jj_3R_368();
    }

    private final boolean jj_3_86() {
        return this.jj_3R_118();
    }

    private final boolean jj_3_23() {
        return this.jj_3R_72();
    }

    private final boolean jj_3_87() {
        return this.jj_3R_119();
    }

    private final boolean jj_3_85() {
        return this.jj_3R_117();
    }

    private final boolean jj_3R_391() {
        return this.jj_scan_token(351);
    }

    private final boolean jj_3R_301() {
        return this.jj_scan_token(360);
    }

    private final boolean jj_3_22() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)3).kind != 300;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_70()) {
            return true;
        }
        return this.jj_3R_71();
    }

    private final boolean jj_3R_405() {
        return this.jj_scan_token(492);
    }

    private final boolean jj_3_21() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)2).kind != 300;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_68()) {
            return true;
        }
        return this.jj_3R_69();
    }

    private final boolean jj_3R_293() {
        return this.jj_3R_361();
    }

    private final boolean jj_3R_212() {
        return this.jj_3R_276();
    }

    private final boolean jj_3R_181() {
        return this.jj_scan_token(192);
    }

    private final boolean jj_3R_390() {
        return this.jj_scan_token(350);
    }

    private final boolean jj_3R_110() {
        return this.jj_scan_token(189);
    }

    private final boolean jj_3R_180() {
        return this.jj_3R_267();
    }

    private final boolean jj_3R_109() {
        return this.jj_scan_token(310);
    }

    private final boolean jj_3R_404() {
        return this.jj_scan_token(487);
    }

    private final boolean jj_3R_379() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_404()) {
            this.jj_scanpos = token;
            if (this.jj_3R_405()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_250() {
        Token token = this.jj_scanpos;
        if (this.jj_3_21()) {
            this.jj_scanpos = token;
            if (this.jj_3_22()) {
                this.jj_scanpos = token;
                if (this.jj_3_23()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_300()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_301()) {
                            this.jj_scanpos = token;
                            if (this.jj_3R_302()) {
                                this.jj_scanpos = token;
                                if (this.jj_3R_303()) {
                                    this.jj_scanpos = token;
                                    if (this.jj_3R_304()) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_389() {
        return this.jj_scan_token(285);
    }

    private final boolean jj_3R_368() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_389()) {
            this.jj_scanpos = token;
            if (this.jj_3R_390()) {
                this.jj_scanpos = token;
                if (this.jj_3R_391()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_87() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_179()) {
            this.jj_scanpos = token;
            if (this.jj_3R_180()) {
                this.jj_scanpos = token;
                if (this.jj_3R_181()) {
                    this.jj_scanpos = token;
                    this.lookingAhead = true;
                    this.jj_semLA = this.getToken((int)1).kind == 86 && this.getToken((int)2).kind == 358;
                    this.lookingAhead = false;
                    if (!this.jj_semLA || this.jj_3R_182()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_183()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_179() {
        return this.jj_3R_266();
    }

    private final boolean jj_3R_319() {
        return this.jj_scan_token(293);
    }

    private final boolean jj_3_72() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_109()) {
            this.jj_scanpos = token;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)2).kind == 310;
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_110()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_108() {
        return this.jj_scan_token(189);
    }

    private final boolean jj_3R_107() {
        return this.jj_scan_token(308);
    }

    private final boolean jj_3R_318() {
        return this.jj_scan_token(311);
    }

    private final boolean jj_3R_121() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(271)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(272)) {
                this.jj_scanpos = token;
                if (this.jj_scan_token(273)) {
                    this.jj_scanpos = token;
                    if (this.jj_scan_token(382)) {
                        this.jj_scanpos = token;
                        if (this.jj_scan_token(383)) {
                            this.jj_scanpos = token;
                            if (this.jj_scan_token(274)) {
                                this.jj_scanpos = token;
                                if (this.jj_scan_token(384)) {
                                    this.jj_scanpos = token;
                                    if (this.jj_scan_token(80)) {
                                        this.jj_scanpos = token;
                                        if (this.jj_scan_token(275)) {
                                            this.jj_scanpos = token;
                                            if (this.jj_scan_token(276)) {
                                                this.jj_scanpos = token;
                                                if (this.jj_scan_token(277)) {
                                                    this.jj_scanpos = token;
                                                    if (this.jj_scan_token(385)) {
                                                        this.jj_scanpos = token;
                                                        if (this.jj_scan_token(278)) {
                                                            this.jj_scanpos = token;
                                                            if (this.jj_scan_token(93)) {
                                                                this.jj_scanpos = token;
                                                                if (this.jj_scan_token(279)) {
                                                                    this.jj_scanpos = token;
                                                                    if (this.jj_scan_token(280)) {
                                                                        this.jj_scanpos = token;
                                                                        if (this.jj_scan_token(386)) {
                                                                            this.jj_scanpos = token;
                                                                            if (this.jj_scan_token(281)) {
                                                                                this.jj_scanpos = token;
                                                                                if (this.jj_scan_token(282)) {
                                                                                    this.jj_scanpos = token;
                                                                                    if (this.jj_scan_token(387)) {
                                                                                        this.jj_scanpos = token;
                                                                                        if (this.jj_scan_token(105)) {
                                                                                            this.jj_scanpos = token;
                                                                                            if (this.jj_scan_token(388)) {
                                                                                                this.jj_scanpos = token;
                                                                                                if (this.jj_scan_token(362)) {
                                                                                                    this.jj_scanpos = token;
                                                                                                    if (this.jj_scan_token(364)) {
                                                                                                        this.jj_scanpos = token;
                                                                                                        if (this.jj_scan_token(283)) {
                                                                                                            this.jj_scanpos = token;
                                                                                                            if (this.jj_scan_token(114)) {
                                                                                                                this.jj_scanpos = token;
                                                                                                                if (this.jj_scan_token(284)) {
                                                                                                                    this.jj_scanpos = token;
                                                                                                                    if (this.jj_scan_token(285)) {
                                                                                                                        this.jj_scanpos = token;
                                                                                                                        if (this.jj_scan_token(286)) {
                                                                                                                            this.jj_scanpos = token;
                                                                                                                            if (this.jj_scan_token(393)) {
                                                                                                                                this.jj_scanpos = token;
                                                                                                                                if (this.jj_scan_token(394)) {
                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                    if (this.jj_scan_token(289)) {
                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                        if (this.jj_scan_token(365)) {
                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                            if (this.jj_scan_token(390)) {
                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                if (this.jj_scan_token(391)) {
                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                    if (this.jj_scan_token(392)) {
                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                        if (this.jj_scan_token(395)) {
                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                            if (this.jj_scan_token(290)) {
                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                if (this.jj_scan_token(396)) {
                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                    if (this.jj_scan_token(397)) {
                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                        if (this.jj_scan_token(398)) {
                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                            if (this.jj_scan_token(399)) {
                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                if (this.jj_scan_token(291)) {
                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                    if (this.jj_scan_token(292)) {
                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                        if (this.jj_scan_token(293)) {
                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                            if (this.jj_scan_token(294)) {
                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                if (this.jj_scan_token(400)) {
                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                    if (this.jj_scan_token(295)) {
                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                        if (this.jj_scan_token(401)) {
                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                            if (this.jj_scan_token(297)) {
                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                if (this.jj_scan_token(402)) {
                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                    if (this.jj_scan_token(299)) {
                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                        if (this.jj_scan_token(300)) {
                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                            if (this.jj_scan_token(403)) {
                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                if (this.jj_scan_token(301)) {
                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                    if (this.jj_scan_token(302)) {
                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                        if (this.jj_scan_token(303)) {
                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                            if (this.jj_scan_token(404)) {
                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                if (this.jj_scan_token(405)) {
                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                    if (this.jj_scan_token(304)) {
                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                        if (this.jj_scan_token(305)) {
                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                            if (this.jj_scan_token(306)) {
                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                if (this.jj_scan_token(369)) {
                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                    if (this.jj_scan_token(307)) {
                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                        if (this.jj_scan_token(308)) {
                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                            if (this.jj_scan_token(309)) {
                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                if (this.jj_scan_token(310)) {
                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(406)) {
                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(407)) {
                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(311)) {
                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(408)) {
                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(312)) {
                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(313)) {
                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(184)) {
                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(314)) {
                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(315)) {
                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(316)) {
                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(317)) {
                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(318)) {
                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(409)) {
                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(410)) {
                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(319)) {
                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(320)) {
                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(321)) {
                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(322)) {
                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(413)) {
                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                this.lookingAhead = true;
                                                                                                                                                                                                                                                                                                                                                                this.jj_semLA = this.getToken((int)1).kind == 323 && !this.seeingOffsetClause();
                                                                                                                                                                                                                                                                                                                                                                this.lookingAhead = false;
                                                                                                                                                                                                                                                                                                                                                                if (!this.jj_semLA || this.jj_scan_token(323)) {
                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(414)) {
                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(415)) {
                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(412)) {
                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(372)) {
                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(324)) {
                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(418)) {
                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(325)) {
                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(326)) {
                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(419)) {
                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(420)) {
                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(421)) {
                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(422)) {
                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(327)) {
                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(424)) {
                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(328)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(423)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(425)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(329)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(426)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(427)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(428)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(330)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(373)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(331)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(332)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(374)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(429)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(430)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(334)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(333)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(335)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(432)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(433)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(336)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(434)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(435)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(437)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(436)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(337)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(338)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(339)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(340)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(341)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(342)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(343)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(344)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(345)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(438)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(439)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(346)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(347)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(431)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(440)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(348)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(441)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(238)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(349)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(350)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(351)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(352)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(353)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(442)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(354)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(443)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(250)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(355)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(444)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(356)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(445)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(357)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(258)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(260)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(417)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(358)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(446)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return true;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                }
                                                                                                                                                                                                            }
                                                                                                                                                                                                        }
                                                                                                                                                                                                    }
                                                                                                                                                                                                }
                                                                                                                                                                                            }
                                                                                                                                                                                        }
                                                                                                                                                                                    }
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3_20() {
        return this.jj_3R_67();
    }

    private final boolean jj_3_71() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_107()) {
            this.jj_scanpos = token;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)2).kind == 308;
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_108()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_211() {
        return this.jj_scan_token(294);
    }

    private final boolean jj_3R_210() {
        return this.jj_scan_token(346);
    }

    private final boolean jj_3R_209() {
        return this.jj_scan_token(72);
    }

    private final boolean jj_3R_317() {
        return this.jj_scan_token(438);
    }

    private final boolean jj_3R_106() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_209()) {
            this.jj_scanpos = token;
            if (this.jj_3R_210()) {
                this.jj_scanpos = token;
                if (this.jj_3R_211()) {
                    this.jj_scanpos = token;
                    if (this.jj_3_71()) {
                        this.jj_scanpos = token;
                        if (this.jj_3_72()) {
                            this.jj_scanpos = token;
                            if (this.jj_3R_212()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3_75() {
        return this.jj_3R_113();
    }

    private final boolean jj_3R_316() {
        return this.jj_scan_token(272);
    }

    private final boolean jj_3R_315() {
        return this.jj_scan_token(271);
    }

    private final boolean jj_3R_263() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_315()) {
            this.jj_scanpos = token;
            if (this.jj_3R_316()) {
                this.jj_scanpos = token;
                if (this.jj_3R_317()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_318()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_319()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_113() {
        return this.jj_3R_66();
    }

    private final boolean jj_3R_81() {
        return this.jj_scan_token(451);
    }

    private final boolean jj_3R_80() {
        return this.jj_scan_token(133);
    }

    private final boolean jj_3_32() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_80()) {
            this.jj_scanpos = token;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)1).kind == 451 && this.getToken((int)2).kind != 303;
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_81()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_10() {
        return this.jj_3R_59();
    }

    private final boolean jj_3_54() {
        return this.jj_3R_83();
    }

    private final boolean jj_3R_215() {
        return this.jj_3R_63();
    }

    private final boolean jj_3R_112() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_215()) {
            this.jj_scanpos = token;
        }
        return this.jj_3R_66();
    }

    private final boolean jj_3R_146() {
        return this.jj_3R_67();
    }

    private final boolean jj_3R_66() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.commonDatatypeName(false);
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_145()) {
            this.jj_scanpos = token;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)1).kind != 292;
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_146()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_145() {
        return this.jj_3R_250();
    }

    private final boolean jj_3R_367() {
        return this.jj_3R_388();
    }

    private final boolean jj_3_80() {
        return this.jj_3R_63();
    }

    private final boolean jj_3R_126() {
        return this.jj_scan_token(154);
    }

    private final boolean jj_3R_333() {
        return this.jj_3R_383();
    }

    private final boolean jj_3R_332() {
        return this.jj_3R_382();
    }

    private final boolean jj_3R_246() {
        return this.jj_scan_token(108);
    }

    private final boolean jj_3R_137() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(222)) {
            this.jj_scanpos = token;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)1).kind == 108 && (this.getToken((int)2).kind == 222 || this.getToken((int)2).kind == 436);
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_246()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_31() {
        return this.jj_3R_79();
    }

    private final boolean jj_3R_331() {
        return this.jj_3R_381();
    }

    private final boolean jj_3_70() {
        return this.jj_3R_106();
    }

    private final boolean jj_3R_330() {
        return this.jj_3R_380();
    }

    private final boolean jj_3_74() {
        return this.jj_3R_112();
    }

    private final boolean jj_3R_378() {
        return this.jj_3R_373();
    }

    private final boolean jj_3R_47() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)1).kind == 154 && (this.getToken((int)2).kind == 442 && (this.getToken((int)3).kind == 458 && this.isPrivilegeKeywordExceptTrigger(this.getToken((int)4).kind) || this.getToken((int)3).kind == 195) || this.isPrivilegeKeywordExceptTrigger(this.getToken((int)2).kind));
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_125()) {
            this.jj_scanpos = token;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)1).kind == 154 && (this.getToken((int)2).kind == 442 && (this.getToken((int)3).kind == 458 && !this.isPrivilegeKeywordExceptTrigger(this.getToken((int)4).kind) || this.getToken((int)3).kind == 243) || !this.isPrivilegeKeywordExceptTrigger(this.getToken((int)2).kind));
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_126()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_125() {
        return this.jj_scan_token(154);
    }

    private final boolean jj_3R_329() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_378()) {
            this.jj_scanpos = token;
        }
        return this.jj_3R_379();
    }

    private final boolean jj_3R_266() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_329()) {
            this.jj_scanpos = token;
            if (this.jj_3R_330()) {
                this.jj_scanpos = token;
                if (this.jj_3R_331()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_332()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_333()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_269() {
        return this.jj_3R_60();
    }

    private final boolean jj_3R_57() {
        return this.jj_3R_137();
    }

    private final boolean jj_3R_221() {
        return this.jj_3R_266();
    }

    private final boolean jj_3_19() {
        return this.jj_3R_66();
    }

    private final boolean jj_3R_65() {
        return this.jj_3R_63();
    }

    private final boolean jj_3_77() {
        return this.jj_3R_89();
    }

    private final boolean jj_3R_268() {
        return this.jj_3R_60();
    }

    private final boolean jj_3R_134() {
        return this.jj_scan_token(354);
    }

    private final boolean jj_3R_292() {
        return this.jj_scan_token(122);
    }

    private final boolean jj_3_79() {
        return this.jj_3R_63();
    }

    private final boolean jj_3R_220() {
        return this.jj_3R_259();
    }

    private final boolean jj_3R_191() {
        return this.jj_3R_269();
    }

    private final boolean jj_3R_244() {
        return this.jj_3R_298();
    }

    private final boolean jj_3_18() {
        return this.jj_3R_65();
    }

    private final boolean jj_3R_90() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = !this.distinctUDAFollows();
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_190()) {
            this.jj_scanpos = token;
            this.lookingAhead = true;
            this.jj_semLA = this.distinctUDAFollows();
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_191()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_190() {
        return this.jj_3R_268();
    }

    private final boolean jj_3R_349() {
        return this.jj_scan_token(160);
    }

    private final boolean jj_3R_277() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_349()) {
            this.jj_scanpos = token;
            if (this.jj_3R_350()) {
                this.jj_scanpos = token;
                if (this.jj_3R_351()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3_51() {
        return this.jj_3R_95();
    }

    private final boolean jj_3R_243() {
        return this.jj_3R_297();
    }

    private final boolean jj_3R_219() {
        return this.jj_3R_259();
    }

    private final boolean jj_3_69() {
        return this.jj_3R_63();
    }

    private final boolean jj_3R_351() {
        return this.jj_scan_token(296);
    }

    private final boolean jj_3R_350() {
        return this.jj_scan_token(416);
    }

    private final boolean jj_3R_242() {
        return this.jj_3R_296();
    }

    private final boolean jj_3R_218() {
        return this.jj_3R_279();
    }

    private final boolean jj_3R_213() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_277()) {
            this.jj_scanpos = token;
        }
        return false;
    }

    private final boolean jj_3R_241() {
        return this.jj_3R_295();
    }

    private final boolean jj_3R_217() {
        return this.jj_3R_278();
    }

    private final boolean jj_3R_414() {
        return this.jj_3R_419();
    }

    private final boolean jj_3R_346() {
        return this.jj_scan_token(453);
    }

    private final boolean jj_3_30() {
        return this.jj_3R_79();
    }

    private final boolean jj_3R_240() {
        return this.jj_3R_294();
    }

    private final boolean jj_3R_239() {
        return this.jj_3R_293();
    }

    private final boolean jj_3R_114() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)2).kind == 222 || this.getToken((int)2).kind == 436;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_216()) {
            this.jj_scanpos = token;
            if (this.jj_3R_217()) {
                this.jj_scanpos = token;
                if (this.jj_3R_218()) {
                    this.jj_scanpos = token;
                    this.lookingAhead = true;
                    this.jj_semLA = this.getToken((int)1).kind == 285 || this.getToken((int)1).kind == 350 || this.getToken((int)1).kind == 351;
                    this.lookingAhead = false;
                    if (!this.jj_semLA || this.jj_3R_219()) {
                        this.jj_scanpos = token;
                        this.lookingAhead = true;
                        this.jj_semLA = this.getToken((int)2).kind == 453 || this.getToken((int)4).kind == 453 && this.getToken((int)2).kind != 458;
                        this.lookingAhead = false;
                        if (!this.jj_semLA || this.jj_3R_220()) {
                            this.jj_scanpos = token;
                            if (this.jj_3_77()) {
                                this.jj_scanpos = token;
                                if (this.jj_3R_221()) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_216() {
        return this.jj_scan_token(108);
    }

    private final boolean jj_3R_400() {
        Token token = this.jj_scanpos;
        if (this.jj_3_30()) {
            this.jj_scanpos = token;
            if (this.jj_3R_414()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_214() {
        return this.jj_3R_63();
    }

    private final boolean jj_3R_133() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_238()) {
            this.jj_scanpos = token;
            if (this.jj_3R_239()) {
                this.jj_scanpos = token;
                if (this.jj_3R_240()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_241()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_242()) {
                            this.jj_scanpos = token;
                            if (this.jj_3R_243()) {
                                this.jj_scanpos = token;
                                if (this.jj_3R_244()) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_238() {
        return this.jj_3R_292();
    }

    private final boolean jj_3R_111() {
        if (this.jj_3R_213()) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_214()) {
            this.jj_scanpos = token;
        }
        return this.jj_3R_66();
    }

    private final boolean jj_3R_328() {
        return this.jj_scan_token(380);
    }

    private final boolean jj_3R_327() {
        return this.jj_scan_token(378);
    }

    private final boolean jj_3R_375() {
        return this.jj_3R_400();
    }

    private final boolean jj_3R_326() {
        return this.jj_scan_token(381);
    }

    private final boolean jj_3R_105() {
        return this.jj_3R_60();
    }

    private final boolean jj_3R_325() {
        return this.jj_scan_token(379);
    }

    private final boolean jj_3R_265() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_325()) {
            this.jj_scanpos = token;
            if (this.jj_3R_326()) {
                this.jj_scanpos = token;
                if (this.jj_3R_327()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_328()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3_73() {
        return this.jj_3R_111();
    }

    private final boolean jj_3R_144() {
        return this.jj_scan_token(195);
    }

    private final boolean jj_3_76() {
        return this.jj_3R_114();
    }

    private final boolean jj_3R_309() {
        return this.jj_3R_375();
    }

    private final boolean jj_3R_143() {
        return this.jj_scan_token(195);
    }

    private final boolean jj_3R_142() {
        return this.jj_scan_token(190);
    }

    private final boolean jj_3R_64() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_142()) {
            this.jj_scanpos = token;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)1).kind == 195 && this.getToken((int)2).kind == 97;
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_143()) {
                this.jj_scanpos = token;
                this.lookingAhead = true;
                this.jj_semLA = this.getToken((int)1).kind == 195 && this.getToken((int)2).kind == 220;
                this.lookingAhead = false;
                if (!this.jj_semLA || this.jj_3R_144()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3_9() {
        return this.jj_3R_58();
    }

    private final boolean jj_3R_193() {
        return this.jj_3R_271();
    }

    private final boolean jj_3_84() {
        return this.jj_3R_116();
    }

    private final boolean jj_3R_388() {
        return this.jj_3R_413();
    }

    private final boolean jj_3R_257() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(190)) {
            this.jj_scanpos = token;
        }
        return this.jj_3R_309();
    }

    private final boolean jj_3_17() {
        return this.jj_3R_64();
    }

    private final boolean jj_3_46() {
        return this.jj_3R_92();
    }

    private final boolean jj_3R_206() {
        return this.jj_scan_token(239);
    }

    private final boolean jj_3_37() {
        return this.jj_3R_86();
    }

    private final boolean jj_3R_91() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_192()) {
            this.jj_scanpos = token;
            if (this.jj_3_46()) {
                this.jj_scanpos = token;
                if (this.jj_3R_193()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_192() {
        return this.jj_3R_270();
    }

    private final boolean jj_3R_289() {
        return this.jj_scan_token(91);
    }

    private final boolean jj_3R_358() {
        return this.jj_scan_token(445);
    }

    private final boolean jj_3R_58() {
        return this.jj_3R_60();
    }

    private final boolean jj_3R_132() {
        return this.jj_scan_token(118);
    }

    private final boolean jj_3R_413() {
        return this.jj_3R_171();
    }

    private final boolean jj_3_68() {
        return this.jj_3R_105();
    }

    private final boolean jj_3R_357() {
        return this.jj_scan_token(388);
    }

    private final boolean jj_3R_356() {
        return this.jj_scan_token(430);
    }

    private final boolean jj_3R_355() {
        return this.jj_scan_token(429);
    }

    private final boolean jj_3R_161() {
        return this.jj_3R_257();
    }

    private final boolean jj_3R_426() {
        return this.jj_scan_token(183);
    }

    private final boolean jj_3R_360() {
        return this.jj_scan_token(190);
    }

    private final boolean jj_3R_273() {
        return this.jj_scan_token(191);
    }

    private final boolean jj_3R_288() {
        return this.jj_scan_token(252);
    }

    private final boolean jj_3_8() {
        return this.jj_3R_56();
    }

    private final boolean jj_3R_284() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_360()) {
            this.jj_scanpos = token;
        }
        return this.jj_scan_token(290);
    }

    private final boolean jj_3_7() {
        return this.jj_3R_57();
    }

    private final boolean jj_3R_227() {
        return this.jj_scan_token(213);
    }

    private final boolean jj_3R_275() {
        return this.jj_scan_token(453);
    }

    private final boolean jj_3R_425() {
        return this.jj_scan_token(157);
    }

    private final boolean jj_3R_178() {
        return this.jj_3R_265();
    }

    private final boolean jj_3R_314() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(65)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(66)) {
                this.jj_scanpos = token;
                if (this.jj_scan_token(67)) {
                    this.jj_scanpos = token;
                    if (this.jj_scan_token(68)) {
                        this.jj_scanpos = token;
                        if (this.jj_scan_token(69)) {
                            this.jj_scanpos = token;
                            if (this.jj_scan_token(70)) {
                                this.jj_scanpos = token;
                                if (this.jj_scan_token(71)) {
                                    this.jj_scanpos = token;
                                    if (this.jj_scan_token(72)) {
                                        this.jj_scanpos = token;
                                        if (this.jj_scan_token(73)) {
                                            this.jj_scanpos = token;
                                            if (this.jj_scan_token(74)) {
                                                this.jj_scanpos = token;
                                                if (this.jj_scan_token(75)) {
                                                    this.jj_scanpos = token;
                                                    if (this.jj_scan_token(76)) {
                                                        this.jj_scanpos = token;
                                                        if (this.jj_scan_token(77)) {
                                                            this.jj_scanpos = token;
                                                            if (this.jj_scan_token(78)) {
                                                                this.jj_scanpos = token;
                                                                if (this.jj_scan_token(79)) {
                                                                    this.jj_scanpos = token;
                                                                    if (this.jj_scan_token(81)) {
                                                                        this.jj_scanpos = token;
                                                                        if (this.jj_scan_token(82)) {
                                                                            this.jj_scanpos = token;
                                                                            if (this.jj_scan_token(83)) {
                                                                                this.jj_scanpos = token;
                                                                                if (this.jj_scan_token(84)) {
                                                                                    this.jj_scanpos = token;
                                                                                    if (this.jj_scan_token(85)) {
                                                                                        this.jj_scanpos = token;
                                                                                        if (this.jj_scan_token(86)) {
                                                                                            this.jj_scanpos = token;
                                                                                            if (this.jj_scan_token(87)) {
                                                                                                this.jj_scanpos = token;
                                                                                                if (this.jj_scan_token(88)) {
                                                                                                    this.jj_scanpos = token;
                                                                                                    if (this.jj_scan_token(89)) {
                                                                                                        this.jj_scanpos = token;
                                                                                                        if (this.jj_scan_token(91)) {
                                                                                                            this.jj_scanpos = token;
                                                                                                            if (this.jj_scan_token(92)) {
                                                                                                                this.jj_scanpos = token;
                                                                                                                if (this.jj_scan_token(94)) {
                                                                                                                    this.jj_scanpos = token;
                                                                                                                    if (this.jj_scan_token(95)) {
                                                                                                                        this.jj_scanpos = token;
                                                                                                                        if (this.jj_scan_token(96)) {
                                                                                                                            this.jj_scanpos = token;
                                                                                                                            if (this.jj_scan_token(97)) {
                                                                                                                                this.jj_scanpos = token;
                                                                                                                                if (this.jj_scan_token(98)) {
                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                    if (this.jj_scan_token(99)) {
                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                        if (this.jj_scan_token(100)) {
                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                            if (this.jj_scan_token(101)) {
                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                if (this.jj_scan_token(102)) {
                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                    if (this.jj_scan_token(103)) {
                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                        if (this.jj_scan_token(104)) {
                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                            if (this.jj_scan_token(106)) {
                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                if (this.jj_scan_token(107)) {
                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                    if (this.jj_scan_token(108)) {
                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                        if (this.jj_scan_token(109)) {
                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                            if (this.jj_scan_token(110)) {
                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                if (this.jj_scan_token(111)) {
                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                    if (this.jj_scan_token(112)) {
                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                        if (this.jj_scan_token(113)) {
                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                            if (this.jj_scan_token(115)) {
                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                if (this.jj_scan_token(116)) {
                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                    if (this.jj_scan_token(117)) {
                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                        if (this.jj_scan_token(118)) {
                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                            if (this.jj_scan_token(119)) {
                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                if (this.jj_scan_token(120)) {
                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                    if (this.jj_scan_token(121)) {
                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                        if (this.jj_scan_token(122)) {
                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                            if (this.jj_scan_token(123)) {
                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                if (this.jj_scan_token(124)) {
                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                    if (this.jj_scan_token(125)) {
                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                        if (this.jj_scan_token(126)) {
                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                            if (this.jj_scan_token(127)) {
                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                if (this.jj_scan_token(128)) {
                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                    if (this.jj_scan_token(129)) {
                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                        if (this.jj_scan_token(130)) {
                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                            if (this.jj_scan_token(131)) {
                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                if (this.jj_scan_token(132)) {
                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                    if (this.jj_scan_token(133)) {
                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                        if (this.jj_scan_token(134)) {
                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                            if (this.jj_scan_token(135)) {
                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                if (this.jj_scan_token(136)) {
                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(137)) {
                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(138)) {
                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(139)) {
                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(140)) {
                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(141)) {
                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(142)) {
                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(143)) {
                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(144)) {
                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(145)) {
                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(146)) {
                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(147)) {
                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(148)) {
                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(149)) {
                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(150)) {
                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(366)) {
                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(151)) {
                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(152)) {
                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(153)) {
                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(154)) {
                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(155)) {
                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(156)) {
                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(157)) {
                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(158)) {
                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(159)) {
                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(160)) {
                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(161)) {
                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(162)) {
                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(163)) {
                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(296)) {
                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(164)) {
                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(165)) {
                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(166)) {
                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(167)) {
                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(168)) {
                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(169)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(170)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(171)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(172)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(173)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(174)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(175)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(176)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(177)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(178)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(179)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(180)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(181)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(182)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(183)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(185)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(186)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(187)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(411)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(188)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(189)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(371)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(190)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(191)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(192)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(193)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(194)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(195)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(196)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(197)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(198)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(199)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(200)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(416)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(201)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(202)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(203)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(204)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(205)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(206)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(207)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(208)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(209)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(210)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(211)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(212)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(213)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(214)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(215)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(216)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(217)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(218)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(219)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(220)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(221)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(222)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(223)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(224)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(225)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(226)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(227)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(228)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(229)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(230)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(231)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(232)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(233)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(234)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(235)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(236)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(237)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(239)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(240)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(241)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(242)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(243)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(247)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(244)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(245)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(246)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(249)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(251)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(252)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(253)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(254)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(255)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(256)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(257)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(259)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(261)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(262)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(263)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(264)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(265)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(267)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(268)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(269)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(270)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(360)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(361)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(363)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(367)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(368)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(370)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(375)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(248)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(376)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(377)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(379)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(381)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(378)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(380)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return true;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                           