require("libs.utils")

-- Code
local paint_hook = nil
local game_start_hook = nil
local first_time = false

function OnPaint()
    if (first_time == false) then
        local loaded_player = dota.GameRules:GetInstance():GetLoadedPlayers()
        local expected_player = dota.GameRules:GetInstance():GetExpectedPlayers()
        if (loaded_player > 0 and expected_player > 0 and loaded_player == expected_player) then
            log.Warning(string.format("[Lua] LoadedPlayer:%d, ExpectedPlayer:%d\n", loaded_player, expected_player))
            BringDotaWindowToTop()
            first_time = true
            log.Warning("game_start_reminder.lua first_time\n")
        end
    end
end

function OnMapLoadFinished()
    first_time = false
    log.Warning("game_start_reminder.lua first_time = false\n")
end

function Initialize()
    paint_hook = dota.AddPaintHook(OnPaint)
    game_start_hook = dota.AddMapLoadFinishedHook(OnMapLoadFinished)
    log.Warning("game_start_reminder.lua loaded\n")
end
