require("libs.utils")
local win_msg_hook = nil
local game_start_hook = nil
local hero_player_team_hook = nil
local hero_picker_shown_hook = nil
local game_start_warned = false

function OnWndProc(uMsg, wParam, lParam)
    if uMsg == WM_DotaConfig then
		if wParam == ConfigFlags.FreeCameraDistance then
    		if lParam > 0 then
                lua_execute("camera_distance.lua")
            else
                lua_unload("camera_distance.lua")
                dota.SetCameraDistance(1134)
            end
        elseif wParam == ConfigFlags.RightClickDeny then
            dota.IConVar.SetInt("dota_force_right_click_attack", lParam)
        elseif wParam == ConfigFlags.EnableRangeFinder then
            dota.IConVar.SetInt("dota_enable_range_finder", lParam)
        elseif wParam == ConfigFlags.CameraDisableZoom then
            dota.IConVar.SetInt("dota_camera_disable_zoom", lParam)
        elseif wParam == ConfigFlags.NetGraph then
            dota.IConVar.SetInt("dota_hud_netgraph", lParam)
        elseif wParam == ConfigFlags.AntiRunBack then
            dota.IConVar.SetFloat("dota_minimap_misclick_time", lParam)
        elseif wParam == ConfigFlags.ShowPing then
            if lParam > 0 then
                lua_execute("show_ping.lua")
            else
                lua_unload("show_ping.lua")
            end
        elseif wParam == ConfigFlags.IngameTimer then
            if lParam > 0 then
                lua_execute("ingame_timer.lua")
            else
                lua_unload("ingame_timer.lua")
            end
        elseif wParam == ConfigFlags.LastHitTips then
            if lParam > 0 then
                lua_execute("lasthit_tips.lua")
            else
                lua_unload("lasthit_tips.lua")
            end
        elseif wParam == ConfigFlags.ShowTowerRange then
            if lParam > 0 then
                lua_execute("tower_range.lua")
            else
                lua_unload("tower_range.lua")
            end
        elseif wParam == ConfigFlags.GamePausedTimer or wParam == ConfigFlags.GamePausedBroadcast then
            if lParam > 0 then
                lua_execute("game_paused_timer.lua")
            end
        elseif wParam == ConfigFlags.RoshanTimer or wParam == ConfigFlags.RoshanBroadcast then
            if lParam > 0 then
                lua_execute("roshan_tips.lua")
            end
        elseif wParam == ConfigFlags.RuneTimer or wParam == ConfigFlags.RuneTips or wParam == ConfigFlags.RuneBroadcast then
            if lParam > 0 then
                lua_execute("rune_tips.lua")
            end
        elseif wParam == ConfigFlags.ShowTeamHealthNum or wParam == ConfigFlags.ShowTeamManaNum or wParam == ConfigFlags.ShowTeamLevel or wParam == ConfigFlags.ShowEnemyHealthNum or wParam == ConfigFlags.ShowEnemyManaNum or wParam == ConfigFlags.ShowEnemyLevel then
            if lParam > 0 then
                lua_execute("esp.lua")
            end
        elseif wParam == ConfigFlags.ShowPlayerNames then
            dota.IConVar.SetInt("dota_always_show_player_names", lParam)
        elseif wParam == ConfigFlags.HealthPerVertical then
            if lParam > 0 then
                dota.IConVar.SetInt("dota_health_per_vertical_marker", App.GetConfig():GetInt("/utils/HealthPerVertical_Value", 225))
            else
                dota.IConVar.SetInt("dota_health_per_vertical_marker", 250)
            end
        elseif wParam == ConfigFlags.FpsMax then
            if lParam > 0 then
                dota.IConVar.SetInt("fps_max", App.GetConfig():GetInt("/utils/FpsMax_Value", 59))
            else
                dota.IConVar.SetInt("fps_max", 120)
            end
            
		end
	end
	
	if uMsg == WM_KEYDOWN then
		if wParam == VK_P then
    		if (bit.band(GetAsyncKeyState(VK_CONTROL),0x8000) == 0x8000) then
        		local value = App.GetConfig():GetBool("/utils/NetGraph", false)
                dota.IConVar.SetBool("dota_hud_netgraph", value)
                App.GetConfig():SetBool("/utils/NetGraph", value)
            end
        elseif wParam == VK_F5 then
            --lua_execute("test.lua")
		end
	end
end

function OnPlayerTeam()
    local LoadedPlayers = dota.GameRules:GetInstance():GetLoadedPlayers()
    local ExpectedPlayers = dota.GameRules:GetInstance():GetExpectedPlayers()
    
    log.Warning(string.format("[xxx]%d:%d\n",LoadedPlayers, ExpectedPlayers))
    if (LoadedPlayers == ExpectedPlayers and LoadedPlayers > 0 and game_start_warned == false) then
        log.Warning(string.format("[ooo]%d:%d\n",LoadedPlayers, ExpectedPlayers))
        game_start_warned = true
        BringDotaWindowToTop()
    end 
end

function OnHeroPickerShown()
    BringDotaWindowToTop()
end

function OnMapLoadFinished()
    game_start_warned = false
    --local convar = dota.GlobalInstanceManager:GetCVar():
end

function Initialize()
    local config = App.GetConfig()
    win_msg_hook = dota.AddWinMsgHook(OnWndProc)
    game_start_hook = dota.AddMapLoadFinishedHook(OnMapLoadFinished)
    
    --dota.IConVar.SetInt("con_enable", 1)

    -- 无论开关是否开启，都将修改以下配置，开关未开启则将配置改为默认值。
    dota.IConVar.SetBool("dota_hud_netgraph", config:GetBool("/utils/NetGraph", false))
    dota.IConVar.SetFloat("dota_minimap_misclick_time", config:GetBool("/utils/AntiRunBack", false) and 1 or 0)
    dota.IConVar.SetBool("dota_always_show_player_names", config:GetBool("/utils/ShowPlayerNames", false))
    dota.IConVar.SetBool("dota_force_right_click_attack", config:GetBool("/utils/RightClickDeny", false))
    dota.IConVar.SetBool("dota_enable_range_finder", config:GetBool("/utils/EnableRangeFinder", false))
    dota.IConVar.SetBool("dota_camera_disable_zoom", config:GetBool("/utils/CameraDisableZoom", false))

    
    -- 无论开关是否开启，都将修改以下配置，开关未开启则将配置改为【指定值】。
    if (config:GetBool("/utils/HealthPerVertical", false)) then
        dota.IConVar.SetInt("dota_health_per_vertical_marker", config:GetInt("/utils/HealthPerVertical_Value", 225))
    else
        dota.IConVar.SetInt("dota_health_per_vertical_marker", 250)
    end

    if (config:GetBool("/utils/FpsMax", false)) then
        dota.IConVar.SetInt("fps_max", config:GetInt("/utils/FpsMax_Value", 59))
    else
        dota.IConVar.SetInt("fps_max", 120)
    end

    -- 只有开关开启后才会修改以下配置。
    
    if (config:GetBool("/utils/AutoSwithToGame")) then
        --hero_player_team_hook = dota.AddEventListener("player_team", OnPlayerTeam)
        hero_picker_shown_hook = dota.AddEventListener("hero_picker_shown", OnHeroPickerShown)
        lua_execute("game_start_reminder.lua")
    end
    if (config:GetBool("/utils/GamePausedTimer") or config:GetBool("/utils/GamePausedBroadcast")) then
        lua_execute("game_paused_timer.lua")
    end
    if (config:GetBool("/utils/RoshanTimer") or config:GetBool("/utils/RoshanBroadcast")) then
        lua_execute("roshan_tips.lua")
    end
    if (config:GetBool("/utils/RuneTimer") or config:GetBool("/utils/RuneTips") or config:GetBool("/utils/RuneBroadcast")) then
        lua_execute("rune_tips.lua")
    end
    if (config:GetBool("/utils/ShowTowerRange", false)) then
        lua_execute("tower_range.lua")
    end
    if (config:GetBool("/utils/ShowTeamHealthNum") or config:GetBool("/utils/ShowTeamManaNum") or config:GetBool("/utils/ShowTeamLevel") or config:GetBool("/utils/ShowEnemyHealthNum") or config:GetBool("/utils/ShowEnemyManaNum") or config:GetBool("/utils/ShowEnemyLevel")) then
        lua_execute("esp.lua")
    end
    if (config:GetBool("/utils/LastHitTips")) then
        lua_execute("lasthit_tips.lua")
    end
    if (config:GetBool("/utils/FreeCameraDistance")) then
        lua_execute("camera_distance.lua")
    end
    if (config:GetBool("/utils/IngameTimer")) then
        lua_execute("ingame_timer.lua")
    end
    if (config:GetBool("/utils/ShowPing")) then
        lua_execute("show_ping.lua")
    end

    lua_execute("user_defined.lua")
    log.Warning("autoexec.lua Loaded\n")
end
