require("libs.utils")

local win_msg_hook = nil
local hook = nil
local font = dota.DrawUtils.GetInstance():CreateFont("", 14, 600, 0, 0, bit.bor(EFontFlags.FONTFLAG_DROPSHADOW, EFontFlags.FONTFLAG_OUTLINE))

local posFixA = 33
local posFixB = 11
local posFixC = 31
local posFixD = 22

-- esp.lua
local bShowTeamHealthNum  = App.GetConfig():GetBool("/utils/ShowTeamHealthNum")
local bShowTeamManaNum    = App.GetConfig():GetBool("/utils/ShowTeamManaNum")
local bShowTeamLevel      = App.GetConfig():GetBool("/utils/ShowTeamLevel")
local bShowEnemyHealthNum = App.GetConfig():GetBool("/utils/ShowEnemyHealthNum")
local bShowEnemyManaNum   = App.GetConfig():GetBool("/utils/ShowEnemyManaNum")
local bShowEnemyLevel     = App.GetConfig():GetBool("/utils/ShowEnemyLevel")

function onWndProc(uMsg, wParam, lParam)
	if uMsg == WM_DotaConfig then
		if wParam == ConfigFlags.ShowTeamHealthNum then
    		bShowTeamHealthNum = lParam > 0
        elseif wParam == ConfigFlags.ShowTeamManaNum then
            bShowTeamManaNum = lParam > 0
        elseif wParam == ConfigFlags.ShowTeamLevel then
            bShowTeamLevel = lParam > 0
        elseif wParam == ConfigFlags.ShowEnemyHealthNum then
            bShowEnemyHealthNum = lParam > 0
        elseif wParam == ConfigFlags.ShowEnemyManaNum then
            bShowEnemyManaNum = lParam > 0
        elseif wParam == ConfigFlags.ShowEnemyLevel then
            bShowEnemyLevel = lParam > 0
		end
	end
end

function GetPosFix()
    local screenWidth = dota.GetScreenWidth()
    local screenHeight = dota.GetScreenHeight()
    if (screenWidth == 800 and screenHeight == 600) then
    posFixA = 33; posFixB = 11; posFixC = 31; posFixD = 22;
    elseif (screenWidth == 1024 and screenHeight == 768) then
    posFixA = 37; posFixB = 12; posFixC = 40; posFixD = 25;
    elseif (screenWidth == 1152 and screenHeight == 864) then
    posFixA = 40; posFixB = 13; posFixC = 44; posFixD = 28;
    elseif (screenWidth == 1280 and screenHeight == 960) then
    posFixA = 43; posFixB = 14; posFixC = 49; posFixD = 31;
    elseif (screenWidth == 1280 and screenHeight == 1024) then
    posFixA = 46; posFixB = 17; posFixC = 53; posFixD = 34;
    
    elseif (screenWidth == 1280 and screenHeight == 720) then
    posFixA = 37; posFixB = 13; posFixC = 37; posFixD = 26;
    elseif (screenWidth == 1360 and screenHeight == 768) then
    posFixA = 37; posFixB = 13; posFixC = 39; posFixD = 26;
    elseif (screenWidth == 1366 and screenHeight == 768) then
    posFixA = 37; posFixB = 13; posFixC = 39; posFixD = 26;
    elseif (screenWidth == 1600 and screenHeight == 900) then
    posFixA = 41; posFixB = 15; posFixC = 45; posFixD = 29;
    elseif (screenWidth == 1920 and screenHeight == 1080) then
    posFixA = 47; posFixB = 19; posFixC = 54; posFixD = 36;

    elseif (screenWidth == 1280 and screenHeight == 768) then
    posFixA = 37; posFixB = 13; posFixC = 39; posFixD = 26;
    elseif (screenWidth == 1280 and screenHeight == 800) then
    posFixA = 38; posFixB = 13; posFixC = 42; posFixD = 26;
    elseif (screenWidth == 1400 and screenHeight == 900) then
    posFixA = 41; posFixB = 15; posFixC = 45; posFixD = 30;
    elseif (screenWidth == 1600 and screenHeight == 1024) then
    posFixA = 45; posFixB = 17; posFixC = 51; posFixD = 34;
    elseif (screenWidth == 1680 and screenHeight == 1050) then
    posFixA = 46; posFixB = 17; posFixC = 53; posFixD = 35;
    end
end

function OnPaint()
    if ((bShowTeamHealthNum or bShowTeamManaNum or bShowTeamLevel or bShowEnemyHealthNum or bShowEnemyManaNum or bShowEnemyLevel) == false) then return end
    local localHero = dota.GetLocalHero()
    if (localHero == nil) then return end
    local base_entity = nil
    local i = 0
    local n = dota.GetHighestEntityIndex()
    for i = 0, n do
        while true do
            base_entity = dota.GetClientEntity(i)
            if (base_entity == nil) then break end
            if (base_entity:IsVisible() == false) then break end
            
            local classID = base_entity:GetClientClass():GetClassID()
            if (classID < ClassIDs.CDOTA_Unit_Hero_Abaddon or classID > ClassIDs.CDOTA_Unit_Hero_Zuus) then break end
            
            local baseNPCHero = dota.toBaseNPCHero(base_entity)
            if (localHero:GetPlayerID() == baseNPCHero:GetPlayerID()) then break end
            if (baseNPCHero:IsIllusion()) then break end
            
            local health    = baseNPCHero:GetHealth()
            local mana      = string.format("%.f", baseNPCHero:GetMana())
            local level     = string.format("%d", baseNPCHero:GetCurrentLevel())
            local ilen      = string.len(level) * 8/2;
            
            if (health <= 0) then break end
            
            local healthbarOffset = baseNPCHero:GetHealthbarOffset();
            if (healthbarOffset == -1) then break end
            local vecScreen = dota.WorldToScreen(baseNPCHero:GetAbsOrigin(),dota.Vector(0,0,healthbarOffset))

            --health = string.format("0x%X",log.GetAddress(baseNPCHero))
            if (localHero:GetTeamNum() == baseNPCHero:GetTeamNum()) then
                if bShowTeamHealthNum then
                    dota.DrawString(font, vecScreen.x, vecScreen.y - posFixA, 0,255,0,255, true, health)
                end
                if bShowTeamManaNum then
                    dota.DrawString(font, vecScreen.x, vecScreen.y - posFixB, 0,180,255,255, true, mana)
                end
                if bShowTeamLevel then
                    dota.DrawString(font, vecScreen.x - ilen - posFixC, vecScreen.y - posFixD, 255,186,20,255, true, level)
                end
            else
                if bShowEnemyHealthNum then
                    dota.DrawString(font, vecScreen.x, vecScreen.y - posFixA, 0,255,0,255, true, health)
                end
                if bShowEnemyManaNum then
                    dota.DrawString(font, vecScreen.x, vecScreen.y - posFixB, 0,180,255,255, true, mana)
                end
                if bShowEnemyLevel then
                    dota.DrawString(font, vecScreen.x - ilen - posFixC, vecScreen.y - posFixD, 255,186,20,255, true, level)
                end
            end
            break
        end
    end
end

function Initialize()
    GetPosFix()
    hook = dota.AddPaintHook(OnPaint)
    win_msg_hook = dota.AddWinMsgHook(onWndProc)
    log.Warning("esp.lua loaded\n")
end


--[[    TeamNum：天辉2，夜魇3，中立生物4

        local neutrals    = dota.FindEntitiesWithName("CDOTA_BaseNPC_Creep_Neutral") -- 中立生物
        local creeps      = dota.FindEntitiesWithName("CDOTA_BaseNPC_Creep_Lane")    -- 线上小兵
        local sieges      = dota.FindEntitiesWithName("CDOTA_BaseNPC_Creep_Siege")   -- 攻城车
        local towers      = dota.FindEntitiesWithName("CDOTA_BaseNPC_Tower")         -- 防御塔
        local buildings   = dota.FindEntitiesWithName("CDOTA_BaseNPC_Building")      -- 建筑
        local barrackses  = dota.FindEntitiesWithName("CDOTA_BaseNPC_Barracks")      -- 兵营
        local forts       = dota.FindEntitiesWithName("CDOTA_BaseNPC_Fort")          -- 大本营

--]]