
#ifdef GL_ES
precision mediump float;
precision mediump int;
#endif

uniform sampler2D sampler0;
uniform vec4 u_time;

// The inverse of the texture dimensions along X and Y
uniform vec2 u_texelDelta;
uniform vec2 u_pixelDelta;
varying vec2 v_texcoord0;

#define SLsize       1   	//Default: 1   /basically sets how wide each line is, from 1 to looks_weird_when_too_high
#define SLcolor      2.0 	//Default: 2.0 /brightens screen to compensate for dark lines
#define SLpower      0.6 	//Default: 0.6 /less/more = darker/brighter lines, 
#define SLV          0   	//ON:1/OFF:0   /change to vertical scanlines

void main() {
	vec3 color = texture2D(sampler0, v_texcoord0.xy).xyz;
	vec3 colorSL=color*SLcolor;
	if(SLV==0){
		float rey = (1.0/SLsize/u_pixelDelta.y);
		float posSy = v_texcoord0.y*(rey/1.0);
		float lineSy = mod(posSy,2.0);
		color=color-lineSy;
	} else {
		float rex = (1.0/SLsize/u_pixelDelta.x);
		float posSx = v_texcoord0.x*(rex/1.0);
		float lineSx = mod(posSx,2.0);
		color=color-lineSx;
	}
	color=mix(color,colorSL,SLpower);
	gl_FragColor.xyz=color;
	gl_FragColor.a = 1.0;
}
