local T, C, L, _ = unpack(select(2, ...))

local _, ns = ...
local oUF = ns.oUF or oUF

local cfg = C.Module.Unitframe
local DUF = T.Unitframe

local mediaPath = cfg.mediaPath

local media = {
    portrait_overlay            = mediaPath .. "uf_portrait_overlay",

    foreground                  = mediaPath .. C.Media.style .. "\\" .. "uf_tot_foreground",
    background                  = mediaPath .. C.Media.style .. "\\" .. "uf_tot_background",
    
    hpTex                       = mediaPath .. "uf_bartex_normal",
    mpTex                       = mediaPath .. "uf_bartex_normal",
}

local createTexture = function(self)    
    -- foreground
    self.FrameFG = CreateFrame('Frame', nil, self)
    self.FrameFG:SetFrameStrata("HIGH")
    self.FrameFG:SetFrameLevel(7)
    
    self.FrameFG.texture = self.FrameFG:CreateTexture(nil, 'BORDER')
    self.FrameFG.texture:SetTexture(media.foreground)
    self.FrameFG.texture:SetAllPoints(self.FrameFG)

    self.FrameFG:SetSize(256, 128)
    self.FrameFG:SetPoint('CENTER', self, 0, 0)

    -- background
    self.FrameBG = CreateFrame('Frame', nil, self)
    self.FrameBG:SetFrameStrata('MEDIUM')
    self.FrameBG:SetFrameLevel(4)

    self.FrameBG.texture = self.FrameBG:CreateTexture(nil, 'BACKGROUND')
    self.FrameBG.texture:SetTexture(media.background)
    self.FrameBG.texture:SetAllPoints(self.FrameBG)

    self.FrameBG:SetSize(256, 128)
    self.FrameBG:SetPoint("CENTER", self, 0, 0)
end

local createBar = function(self)
    self.Health = CreateFrame("StatusBar", nil, self)
    self.Health:SetFrameStrata("MEDIUM")
    self.Health:SetFrameLevel(5)
    self.Health:SetSize(80, 16)
    self.Health:SetPoint('CENTER', self, 25, 4)

    self.Health:SetStatusBarTexture(media.hpTex)
    self.Health:SetStatusBarColor(0.2, 0.2, 0.2)

    self.Health.frequentUpdates = true
    self.Health.colorSmooth = true
    self.Health.Smooth = true
    self.Health.colorClass = true
    self.Health.colorClassNPC = true
    self.Health.colorClassPet = true

    --power bar
    self.Power = CreateFrame("StatusBar", nil, self)
    self.Power:SetPoint("CENTER")
    self.Power:SetFrameStrata("MEDIUM")
    self.Power:SetFrameLevel(6)
    self.Power:SetPoint('TOP', self.Health, 'BOTTOM', 0, 0)
    self.Power:SetSize(80, 4)
    
    self.Power:SetStatusBarTexture(media.mpTex)

    self.Power.frequentUpdates = true
    self.Power.colorPower = true
    self.Power.Smooth = true

    self.Power.bg = self.Power:CreateTexture(nil, "BORDER")
    self.Power.bg.multiplier = .45
    self.Power.bg:SetAllPoints(self.Power)
    self.Power.bg:SetTexture(media.mpTex)
end

local createPortrait = function(self)
    local overlayFrame

    if cfg.portrait3D == false then
        self.Portrait = self.FrameBG:CreateTexture(nil, 'ARTWORK', nil, 3)
        self.Portrait:SetSize(42, 42)

        overlayFrame = CreateFrame('Frame', nil, self.FrameBG)
    else
        self.Portrait = CreateFrame('PlayerModel', nil, self.FrameBG)
        self.Portrait:SetFrameLevel(3)
        self.Portrait:SetSize(38, 38)
    
        overlayFrame = CreateFrame('Frame', nil, self.Portrait)
    end
    
    self.Portrait:SetPoint('CENTER', self, 'LEFT', 2, 0)

    overlayFrame:SetFrameLevel(4)
    overlayFrame:SetAllPoints(self.Portrait)
    
    local overlay = overlayFrame:CreateTexture(nil, 'OVERLAY', nil, 7)
    overlay:SetTexture(media.portrait_overlay)
    overlay:SetPoint("TOPLEFT", overlayFrame, -2, 2)
    overlay:SetPoint("BOTTOMRIGHT", overlayFrame, 2, -2)
    overlay:SetAlpha(1)

    self.Portrait.overlay = overlay
end

local createTag = function(self)
    self.Tags = {}
    
    self.Tags.name = self:CreateTag(self.FrameFG, '[raidcolor][dd:realname]')
    :SetFont(STANDARD_TEXT_FONT, 14, 'THICKOUTLINE')
    :SetPoint('TOPLEFT', self, 'CENTER', -5, -18)
    :done()

    self.Tags.level = self:CreateTag(self.FrameFG, '[dd:difficulty][level]')
    :SetFont(STANDARD_TEXT_FONT, 14, 'OUTLINE')
    :SetPoint('CENTER', self, -20, -16)
    :done()

    self.Tags.smarthp = self:CreateTag(self.FrameFG, "[dd:smarthp]")
    :SetFont(STANDARD_TEXT_FONT, 12, "OUTLINE")
    :SetPoint("CENTER", self.Health, 0, -2)
    :SetJustifyH('CENTER')
    :done()
end

local createStyle = function(self)
    self.colors = C.oUF_colors
    self.cUnit = "boss"    

    self:SetSize(100, 33)
    self:SetScale(cfg.scale)
         
    self:RegisterForClicks("AnyDown")
    self:SetScript("OnEnter", UnitFrame_OnEnter)
    self:SetScript("OnLeave", UnitFrame_OnLeave)

    createTexture(self)
    createBar(self)
    createPortrait(self)
    createTag(self)

    self.RaidIcon = DUF.CreateIcon(self, "BACKGROUND", 18, -1, self, "CENTER", "CENTER", 20, 0)
    self.RaidIcon:SetTexCoord(0, 0.5, 0, 0.421875)

    DUF.SetFader(self, cfg.boss.fader)
end

---------------------------------------------
-- SPAWN PLAYER UNIT
---------------------------------------------
oUF:RegisterStyle("DarkUI:boss", createStyle)
oUF:SetActiveStyle("DarkUI:boss")

local boss = {}
for i = 1, MAX_BOSS_FRAMES do
    local name = "DarkUIBossFrame"..i
    local unit = oUF:Spawn("boss"..i, name)
    if i==1 then
        unit:SetPoint(unpack(cfg.boss.position))
    else
        unit:SetPoint("TOP", boss[i-1], "BOTTOM", 0, -cfg.boss.spacing)
    end
    
    boss[i] = unit
end