﻿----------------------------------------------------------------------------------------
--  Accept invites from guild members or friend list(by ALZA)
----------------------------------------------------------------------------------------
local T, C, L, _ = unpack(select(2, ...))
if C.Module.Automation.accept_invite ~= true then return end

local CheckFriend = function(name)
    for i = 1, GetNumFriends() do
        if GetFriendInfo(i) == name then
            return true
        end
    end
    for i = 1, select(2, BNGetNumFriends()) do
			local presenceID, _, _, _, _, toonID, client, isOnline = BNGetFriendInfo(i)
			if client == BNET_CLIENT_WOW and isOnline then
				local _, toonName, _, realmName = BNGetGameAccountInfo(toonID or presenceID)
            if name == toonName or name == toonName.."-"..realmName then
                return true
            end
        end
    end
    if IsInGuild() then
        for i = 1, GetNumGuildMembers() do
				if Ambiguate(GetGuildRosterInfo(i), "none") == name then
                return true
            end
        end
    end
end

local ai = CreateFrame("Frame")
ai:RegisterEvent("PARTY_INVITE_REQUEST")
ai:SetScript("OnEvent", function(self, event, name)
    if QueueStatusMinimapButton:IsShown() or GetNumGroupMembers() > 0 then return end
    if CheckFriend(name) then
        RaidNotice_AddMessage(RaidWarningFrame, L.AUTO_INVITE_INFO..name, {r = 0.41, g = 0.8, b = 0.94}, 3)
        print(format("|cffffff00"..L.AUTO_INVITE_INFO..name.."."))
        AcceptGroup()
        for i = 1, STATICPOPUP_NUMDIALOGS do
            local frame = _G["StaticPopup"..i]
            if frame:IsVisible() and frame.which == "PARTY_INVITE" then
                frame.inviteAccepted = 1
                StaticPopup_Hide("PARTY_INVITE")
                return
            elseif frame:IsVisible() and frame.which == "PARTY_INVITE_XREALM" then
                frame.inviteAccepted = 1
                StaticPopup_Hide("PARTY_INVITE_XREALM")
                return
            end
        end
    else
        SendWho(name)
    end
end)

----------------------------------------------------------------------------------------
--  Auto invite by whisper(by Tukz)
----------------------------------------------------------------------------------------
local autoinvite = CreateFrame("Frame")
autoinvite:RegisterEvent("CHAT_MSG_WHISPER")
autoinvite:RegisterEvent("CHAT_MSG_BN_WHISPER")
autoinvite:SetScript("OnEvent", function(self, event, arg1, arg2, ...)
    if ((not UnitExists("party1") or UnitIsGroupLeader("player") or UnitIsGroupAssistant("player")) 
        and arg1:lower():match(L.AUTO_INVITE_KEYWORD)) then
        if event == "CHAT_MSG_WHISPER" then
            InviteUnit(arg2)
        elseif event == "CHAT_MSG_BN_WHISPER" then
			local bnetIDAccount = select(11, ...)
			local bnetIDGameAccount = select(6, BNGetFriendInfoByID(bnetIDAccount))
			BNInviteFriend(bnetIDGameAccount)
        end
    end
end)