----------------------------------------------------------------------------------------
--  ActionBar Styler (from rActionBarStyler)
----------------------------------------------------------------------------------------
local T, C, L, _ = unpack(select(2, ...))
local gcfg = C.Module.Actionbar

local hide_blizzart = function()
    --hide blizzard
    local blizzHider = CreateFrame("Frame","rABS_BizzardHider")
    blizzHider:Hide()

    --hide main menu bar frames
    if gcfg.bars.bar1.enable then
        MainMenuBar:SetParent(blizzHider)
        MainMenuBarPageNumber:SetParent(blizzHider)
        ActionBarDownButton:SetParent(blizzHider)
        ActionBarUpButton:SetParent(blizzHider)
    end

    --hide override actionbar frames
    OverrideActionBarExpBar:SetParent(blizzHider)
    OverrideActionBarHealthBar:SetParent(blizzHider)
    OverrideActionBarPowerBar:SetParent(blizzHider)
    OverrideActionBarPitchFrame:SetParent(blizzHider) --maybe we can use that frame later for pitchig and such

    local textureList =  {
        "_BG",
        "EndCapL",
        "EndCapR",
        "_Border",
        "Divider1",
        "Divider2",
        "Divider3",
        "ExitBG",
        "MicroBGL",
        "MicroBGR",
        "_MicroBGMid",
        "ButtonBGL",
        "ButtonBGR",
        "_ButtonBGMid",
    }

    for _,tex in pairs(textureList) do
        OverrideActionBar[tex]:SetAlpha(0)
    end

    --remove some the default background textures
    StanceBarLeft:SetTexture(nil)
    StanceBarMiddle:SetTexture(nil)
    StanceBarRight:SetTexture(nil)
    SlidingActionBarTexture0:SetTexture(nil)
    SlidingActionBarTexture1:SetTexture(nil)
    PossessBackground1:SetTexture(nil)
    PossessBackground2:SetTexture(nil)

    if gcfg.bars.bar1.enable then
        MainMenuBarTexture0:SetTexture(nil)
        MainMenuBarTexture1:SetTexture(nil)
        MainMenuBarTexture2:SetTexture(nil)
        MainMenuBarTexture3:SetTexture(nil)
        MainMenuBarLeftEndCap:SetTexture(nil)
        MainMenuBarRightEndCap:SetTexture(nil)
    end
end

local styleBags = function()
    --get some values from the namespace
    local cfg = gcfg.bars.bags

    if not cfg.enable then return end

    --bag button objects
    local buttonList = {
        MainMenuBarBackpackButton,
        CharacterBag0Slot,
        CharacterBag1Slot,
        CharacterBag2Slot,
        CharacterBag3Slot,
    }

    local NUM_BAG_BUTTONS = #buttonList
    local buttonWidth = MainMenuBarBackpackButton:GetWidth()
    local buttonHeight = MainMenuBarBackpackButton:GetHeight()
    local gap = 2

    --create the frame to hold the buttons
    local frame = CreateFrame("Frame", "rABS_BagFrame", UIParent, "SecureHandlerStateTemplate")
    frame:SetWidth(NUM_BAG_BUTTONS*buttonWidth + (NUM_BAG_BUTTONS-1)*gap + 2*cfg.padding)
    frame:SetHeight(buttonHeight + 2*cfg.padding)
    frame:SetPoint(cfg.pos.a1,cfg.pos.af,cfg.pos.a2,cfg.pos.x,cfg.pos.y)
    frame:SetScale(cfg.scale)

    --move the buttons into position and reparent them
    for _, button in pairs(buttonList) do
        button:SetParent(frame)
    end
    MainMenuBarBackpackButton:ClearAllPoints();
    MainMenuBarBackpackButton:SetPoint("RIGHT", -cfg.padding, 0)

    if not cfg.show then --wait...you no see me? :(
        frame:SetParent(rABS_BizzardHider)
        return
    end

    --show/hide the frame on a given state driver
    RegisterStateDriver(frame, "visibility", "[petbattle] hide; show")

    if cfg.mouseover.enable then
        T.ButtonBarFader(frame, buttonList, cfg.mouseover.fadeIn, cfg.mouseover.fadeOut) --frame, buttonList, fadeIn, fadeOut
    end
end

local stylePlayerPowerBarAlt = function()
    local cfg = gcfg.bars.playerPowerBarAlt

    if not cfg.enable then return end

    PlayerPowerBarAlt:SetMovable(true)
    PlayerPowerBarAlt:SetUserPlaced(true)
    PlayerPowerBarAlt:SetClampedToScreen(true)
    PlayerPowerBarAlt:SetScript("OnMouseDown", function(self)
        if IsShiftKeyDown() then self:StartMoving() end
    end)
    PlayerPowerBarAlt:SetScript('OnMouseUp', function(self)
        self:StopMovingOrSizing()
    end)
end

local styleBar1 = function()
    local cfg = gcfg.bars.bar1
    cfg.buttons = { size = 28, margin = 6.15 }

    if not cfg.enable then return end

    local num = NUM_ACTIONBAR_BUTTONS
    local buttonList = {}

    --create the frame to hold the buttons
    local frame = CreateFrame("Frame", "rABS_MainMenuBar", UIParent, "SecureHandlerStateTemplate")
    frame:SetWidth(num * cfg.buttons.size + (num - 1) * cfg.buttons.margin)
    frame:SetHeight(cfg.buttons.size)
    frame:SetPoint(cfg.pos.a1, cfg.pos.af, cfg.pos.a2, cfg.pos.x, cfg.pos.y)

    --move the buttons into position and reparent them
    MainMenuBarArtFrame:SetParent(frame)
    MainMenuBarArtFrame:EnableMouse(false)

    for i=1, num do
        local button = _G["ActionButton" .. i]
        table.insert(buttonList, button) --add the button object to the list
        button:SetSize(cfg.buttons.size, cfg.buttons.size)
        button:ClearAllPoints()

        if i == 1 then
            button:ClearAllPoints()
            button:SetPoint("BOTTOMLEFT", frame, "BOTTOMLEFT", -1, -2);
        else
            local previous = _G["ActionButton" .. i - 1]
            button:SetPoint("LEFT", previous, "RIGHT", cfg.buttons.margin, 0)
        end
    end

    --show/hide the frame on a given state driver
    RegisterStateDriver(frame, "visibility", "[petbattle][overridebar][vehicleui][possessbar,@vehicle,exists] hide; show")

    --create the mouseover functionality
    if cfg.mouseover.enable then
        T.ButtonBarFader(frame, buttonList, cfg.mouseover.fadeIn, cfg.mouseover.fadeOut) --frame, buttonList, fadeIn, fadeOut
        frame.mouseover = cfg.mouseover
    end

    --create the combat fader
    if cfg.combat.enable then
        T.CombatFrameFader(frame, cfg.combat.fadeIn, cfg.combat.fadeOut) --frame, buttonList, fadeIn, fadeOut
    end
end

local styleBar2 = function()
    local cfg = gcfg.bars.bar2
    cfg.buttons = { size = 33, margin = 7.6 }
    cfg.pos = { a1 = "BOTTOM", a2 = "TOP", af = "rABS_MainMenuBar", x = -2.5, y = 22 }

    if not cfg.enable then return end

    local num = NUM_ACTIONBAR_BUTTONS
    local buttonList = {}

    --create the frame to hold the buttons
    local frame = CreateFrame("Frame", "rABS_MultiBarBottomLeft", UIParent, "SecureHandlerStateTemplate")
    frame:SetWidth(num * cfg.buttons.size + (num - 1) * cfg.buttons.margin)
    frame:SetHeight(cfg.buttons.size)
    frame:SetPoint(cfg.pos.a1, cfg.pos.af, cfg.pos.a2, cfg.pos.x, cfg.pos.y)

    --move the buttons into position and reparent them
    MultiBarBottomLeft:SetParent(frame)
    MultiBarBottomLeft:EnableMouse(false)

    for i=1, num do
        local button = _G["MultiBarBottomLeftButton" .. i]
        table.insert(buttonList, button) --add the button object to the list
        button:SetSize(cfg.buttons.size, cfg.buttons.size)
        button:ClearAllPoints()

        if i == 1 then
            button:ClearAllPoints()
            button:SetPoint("BOTTOMLEFT", frame, "BOTTOMLEFT", 2, -2);
        else
            local previous = _G["MultiBarBottomLeftButton" .. i - 1]
            button:SetPoint("LEFT", previous, "RIGHT", cfg.buttons.margin, 0)
        end
    end

    --show/hide the frame on a given state driver
    RegisterStateDriver(frame, "visibility", "[petbattle][overridebar][vehicleui][possessbar,@vehicle,exists] hide; show")

    --create the mouseover functionality
    if cfg.mouseover.enable then
        T.ButtonBarFader(frame, buttonList, cfg.mouseover.fadeIn, cfg.mouseover.fadeOut) --frame, buttonList, fadeIn, fadeOut
        frame.mouseover = cfg.mouseover
    end

    --create the combat fader
    if cfg.combat.enable then
        T.CombatFrameFader(frame, cfg.combat.fadeIn, cfg.combat.fadeOut) --frame, buttonList, fadeIn, fadeOut
    end
end

local styleBar3 = function()
    local cfg = gcfg.bars.bar3
    cfg.buttons = { size = 33, margin = 7.6 }
    cfg.pos = { a1 = "BOTTOM", a2 = "TOP", af = "rABS_MultiBarBottomLeft", x = 0, y = 10 }

    if not cfg.enable then return end

    local num = NUM_ACTIONBAR_BUTTONS
    local buttonList = {}

    --create the frame to hold the buttons
    local frame = CreateFrame("Frame", "rABS_MultiBarBottomRight", UIParent, "SecureHandlerStateTemplate")
    frame:SetWidth(num * cfg.buttons.size + (num - 1) * cfg.buttons.margin)
    frame:SetHeight(cfg.buttons.size)
    frame:SetPoint(cfg.pos.a1, cfg.pos.af, cfg.pos.a2, cfg.pos.x, cfg.pos.y)

    --move the buttons into position and reparent them
    MultiBarBottomRight:SetParent(frame)
    MultiBarBottomRight:EnableMouse(false)

    for i=1, num do
        local button = _G["MultiBarBottomRightButton" .. i]
        table.insert(buttonList, button) --add the button object to the list
        button:SetSize(cfg.buttons.size, cfg.buttons.size)
        button:ClearAllPoints()

        if i == 1 then
            button:ClearAllPoints()
            button:SetPoint("BOTTOMLEFT", frame, "BOTTOMLEFT", 2, -2);
        else
            local previous = _G["MultiBarBottomRightButton" .. i - 1]
            button:SetPoint("LEFT", previous, "RIGHT", cfg.buttons.margin, 0)
        end
    end

    --show/hide the frame on a given state driver
    RegisterStateDriver(frame, "visibility", "[petbattle][overridebar][vehicleui][possessbar,@vehicle,exists] hide; show")

    --create the mouseover functionality
    if cfg.mouseover.enable then
        T.ButtonBarFader(frame, buttonList, cfg.mouseover.fadeIn, cfg.mouseover.fadeOut) --frame, buttonList, fadeIn, fadeOut
        frame.mouseover = cfg.mouseover
    end

    --create the combat fader
    if cfg.combat.enable then
        T.CombatFrameFader(frame, cfg.combat.fadeIn, cfg.combat.fadeOut) --frame, buttonList, fadeIn, fadeOut
    end
end

local styleBar4 = function()
    local cfg = gcfg.bars.bar4

    if not cfg.enable then return end

    local num = NUM_ACTIONBAR_BUTTONS
    local buttonList = {}

    --create the frame to hold the buttons
    local frame = CreateFrame("Frame", "rABS_MultiBarRight", UIParent, "SecureHandlerStateTemplate")
    if cfg.combineBar4AndBar5 then
        frame:SetWidth(2*cfg.buttons.size + (2-1)*cfg.buttons.margin + 2*cfg.padding)
    else
        frame:SetWidth(cfg.buttons.size + 2*cfg.padding)
    end
    frame:SetHeight(num*cfg.buttons.size + (num-1)*cfg.buttons.margin + 2*cfg.padding)
    frame:SetPoint(cfg.pos.a1,cfg.pos.af,cfg.pos.a2,cfg.pos.x,cfg.pos.y)
    frame:SetScale(cfg.scale)

    --move the buttons into position and reparent them
    MultiBarRight:SetParent(frame)
    MultiBarRight:EnableMouse(false)
    if cfg.combineBar4AndBar5 then
        MultiBarLeft:SetParent(frame)
        MultiBarLeft:EnableMouse(false)
    end

    for i=1, num do
        local button = _G["MultiBarRightButton"..i]
        table.insert(buttonList, button) --add the button object to the list
        button:SetSize(cfg.buttons.size, cfg.buttons.size)
        button:ClearAllPoints()
        if i == 1 then
            button:SetPoint("TOPRIGHT", frame, -cfg.padding, -cfg.padding)
        else
            local previous = _G["MultiBarRightButton"..i-1]
            button:SetPoint("TOP", previous, "BOTTOM", 0, -cfg.buttons.margin)
        end
    end

    if cfg.combineBar4AndBar5 then
        for i=1, num do
            local button = _G["MultiBarLeftButton"..i]
            table.insert(buttonList, button) --add the button object to the list
            button:SetSize(cfg.buttons.size, cfg.buttons.size)
            button:ClearAllPoints()
            if i == 1 then
                button:SetPoint("TOPRIGHT", frame, -(cfg.padding+cfg.buttons.margin+cfg.buttons.size), -cfg.padding)
            else
                local previous = _G["MultiBarLeftButton"..i-1]
                button:SetPoint("TOP", previous, "BOTTOM", 0, -cfg.buttons.margin)
            end
        end
    end

    --show/hide the frame on a given state driver
    RegisterStateDriver(frame, "visibility", "[petbattle][overridebar][vehicleui][possessbar,@vehicle,exists] hide; show")

    --create the mouseover functionality
    if cfg.mouseover.enable then
        T.ButtonBarFader(frame, buttonList, cfg.mouseover.fadeIn, cfg.mouseover.fadeOut) --frame, buttonList, fadeIn, fadeOut
        frame.mouseover = cfg.mouseover
    end

    --create the combat fader
    if cfg.combat.enable then
        T.CombatFrameFader(frame, cfg.combat.fadeIn, cfg.combat.fadeOut) --frame, buttonList, fadeIn, fadeOut
    end
end

local styleBar5 = function()
    local cfg = gcfg.bars.bar5

    if not cfg.enable then return end
    if gcfg.bars.bar4.combineBar4AndBar5 then return end

    local num = NUM_ACTIONBAR_BUTTONS
    local buttonList = {}

    --create the frame to hold the buttons
    local frame = CreateFrame("Frame", "rABS_MultiBarLeft", UIParent, "SecureHandlerStateTemplate")
    frame:SetWidth(cfg.buttons.size + 2*cfg.padding)
    frame:SetHeight(num*cfg.buttons.size + (num-1)*cfg.buttons.margin + 2*cfg.padding)
    frame:SetPoint(cfg.pos.a1,cfg.pos.af,cfg.pos.a2,cfg.pos.x,cfg.pos.y)
    frame:SetScale(cfg.scale)

    --move the buttons into position and reparent them
    MultiBarLeft:SetParent(frame)
    MultiBarLeft:EnableMouse(false)

    for i=1, num do
        local button = _G["MultiBarLeftButton"..i]
        table.insert(buttonList, button) --add the button object to the list
        button:SetSize(cfg.buttons.size, cfg.buttons.size)
        button:ClearAllPoints()
        if i == 1 then
            button:SetPoint("TOPRIGHT", frame, -cfg.padding, -cfg.padding)
        else
            local previous = _G["MultiBarLeftButton"..i-1]
            button:SetPoint("TOP", previous, "BOTTOM", 0, -cfg.buttons.margin)
        end
    end

    --show/hide the frame on a given state driver
    RegisterStateDriver(frame, "visibility", "[petbattle][overridebar][vehicleui][possessbar,@vehicle,exists] hide; show")

    --create the mouseover functionality
    if cfg.mouseover.enable then
        T.ButtonBarFader(frame, buttonList, cfg.mouseover.fadeIn, cfg.mouseover.fadeOut) --frame, buttonList, fadeIn, fadeOut
        frame.mouseover = cfg.mouseover
    end

    --create the combat fader
    if cfg.combat.enable then
        T.CombatFrameFader(frame, cfg.combat.fadeIn, cfg.combat.fadeOut) --frame, buttonList, fadeIn, fadeOut
    end
end

local styleExtrabar = function()
    local cfg = gcfg.bars.extrabar

    if not cfg.enable then return end

    local num = 1
    local buttonList = {}

    --create the frame to hold the buttons
    local frame = CreateFrame("Frame", "rABS_ExtraBar", UIParent, "SecureHandlerStateTemplate")
    frame:SetWidth(num*cfg.buttons.size + (num-1)*cfg.buttons.margin + 2*cfg.padding)
    frame:SetHeight(cfg.buttons.size + 2*cfg.padding)
    frame:SetPoint(cfg.pos.a1,cfg.pos.af,cfg.pos.a2,cfg.pos.x,cfg.pos.y)
    frame:SetScale(cfg.scale)

    --move the buttons into position and reparent them
    ExtraActionBarFrame:SetParent(frame)
    ExtraActionBarFrame:EnableMouse(false)
    ExtraActionBarFrame:ClearAllPoints()
    ExtraActionBarFrame:SetPoint("CENTER", 0, 0)
    ExtraActionBarFrame.ignoreFramePositionManager = true

    --the extra button
    local button = ExtraActionButton1
    table.insert(buttonList, button) --add the button object to the list
    button:SetSize(cfg.buttons.size,cfg.buttons.size)

    --show/hide the frame on a given state driver
    RegisterStateDriver(frame, "visibility", "[petbattle][overridebar][vehicleui] hide; show")

    --create the mouseover functionality
    if cfg.mouseover.enable then
        T.ButtonBarFader(frame, buttonList, cfg.mouseover.fadeIn, cfg.mouseover.fadeOut) --frame, buttonList, fadeIn, fadeOut
    end
end

local styleMicromenu = function()
    local cfg = gcfg.bars.micromenu

    if not cfg.enable then return end

    --micro menu button objects
    local buttonList = {
        CharacterMicroButton,
        SpellbookMicroButton,
        TalentMicroButton,
        AchievementMicroButton,
        QuestLogMicroButton,
        GuildMicroButton,
        PVPMicroButton,
        LFDMicroButton,
        CompanionsMicroButton,
        EJMicroButton,
        MainMenuMicroButton,
        HelpMicroButton,
        StoreMicroButton,
        CollectionsMicroButton,
    }

    local NUM_MICROBUTTONS = # buttonList
    local buttonWidth = CharacterMicroButton:GetWidth()
    local buttonHeight = CharacterMicroButton:GetHeight()
    local gap = -3

    --create the frame to hold the buttons
    local frame = CreateFrame("Frame", "rABS_MicroMenu", UIParent, "SecureHandlerStateTemplate")
    frame:SetWidth(NUM_MICROBUTTONS*buttonWidth + (NUM_MICROBUTTONS-1)*gap + 2*cfg.padding)
    frame:SetHeight(buttonHeight + 2*cfg.padding)
    frame:SetPoint(cfg.pos.a1,cfg.pos.af,cfg.pos.a2,cfg.pos.x,cfg.pos.y)
    frame:SetScale(cfg.scale)

    --move the buttons into position and reparent them
    for _, button in pairs(buttonList) do
        button:SetParent(frame)
    end
    CharacterMicroButton:ClearAllPoints();
    CharacterMicroButton:SetPoint("LEFT", cfg.padding, 0)

    --disable reanchoring of the micro menu by the petbattle ui
    PetBattleFrame.BottomFrame.MicroButtonFrame:SetScript("OnShow", nil) --remove the onshow script

    if not cfg.show then --wait...you no see me? :(
        frame:SetParent(rABS_BizzardHider)
        return
    end

    --show/hide the frame on a given state driver
    RegisterStateDriver(frame, "visibility", "[petbattle] hide; show")

    --create the mouseover functionality
    if cfg.mouseover.enable then
        T.ButtonBarFader(frame, buttonList, cfg.mouseover.fadeIn, cfg.mouseover.fadeOut) --frame, buttonList, fadeIn, fadeOut
    end
end

local styleOverridebar = function()
    local cfg = gcfg.bars.bar1
    cfg.buttons = { size = 28, margin = 6.15 }

    if not cfg.enable then return end

    local num = NUM_ACTIONBAR_BUTTONS
    local buttonList = {}

    --create the frame to hold the buttons
    local frame = CreateFrame("Frame", "rABS_OverrideBar", UIParent, "SecureHandlerStateTemplate")
    frame:SetWidth(num * cfg.buttons.size + (num - 1) * cfg.buttons.margin)
    frame:SetHeight(cfg.buttons.size)
    frame:SetPoint(cfg.pos.a1, cfg.pos.af, cfg.pos.a2, cfg.pos.x, cfg.pos.y)

    --move the buttons into position and reparent them
    OverrideActionBar:SetParent(frame)
    OverrideActionBar:EnableMouse(false)
    OverrideActionBar:SetScript("OnShow", nil) --remove the onshow script

    local leaveButtonPlaced = false

    for i=1, num do
        local button = _G["OverrideActionBarButton" .. i]

        if not button and not leaveButtonPlaced then
            button = OverrideActionBar.LeaveButton --the magic 7th button
            leaveButtonPlaced = true
        end

        if not button then break end

        table.insert(buttonList, button) --add the button object to the list
        button:SetSize(cfg.buttons.size, cfg.buttons.size)
        button:ClearAllPoints()

        if i == 1 then
            button:ClearAllPoints()
            button:SetPoint("BOTTOMLEFT", frame, "BOTTOMLEFT", -1, -2);
        else
            local previous = _G["OverrideActionBarButton" .. i - 1]
            button:SetPoint("LEFT", previous, "RIGHT", cfg.buttons.margin, 0)
        end
    end

    --show/hide the frame on a given state driver
    RegisterStateDriver(frame, "visibility", "[petbattle] hide; [overridebar][vehicleui][possessbar,@vehicle,exists] show; hide")
    RegisterStateDriver(OverrideActionBar, "visibility", "[overridebar][vehicleui][possessbar,@vehicle,exists] show; hide")

    --create the mouseover functionality
    if cfg.mouseover.enable then
        T.ButtonBarFader(frame, buttonList, cfg.mouseover.fadeIn, cfg.mouseover.fadeOut) --frame, buttonList, fadeIn, fadeOut
    end

    --create the combat fader
    if cfg.combat.enable then
        T.CombatFrameFader(frame, cfg.combat.fadeIn, cfg.combat.fadeOut) --frame, buttonList, fadeIn, fadeOut
    end
end

local stylePetbar = function()
    local cfg = gcfg.bars.petbar

    if not cfg.enable then return end

    local num = NUM_PET_ACTION_SLOTS
    local buttonList = {}

    --create the frame to hold the buttons
    local frame = CreateFrame("Frame", "rABS_PetBar", UIParent, "SecureHandlerStateTemplate")
    frame:SetWidth(num*cfg.buttons.size + (num-1)*cfg.buttons.margin + 2*cfg.padding)
    frame:SetHeight(cfg.buttons.size + 2*cfg.padding)
    frame:SetPoint(cfg.pos.a1,cfg.pos.af,cfg.pos.a2,cfg.pos.x,cfg.pos.y)
    frame:SetScale(cfg.scale)

    --move the buttons into position and reparent them
    PetActionBarFrame:SetParent(frame)
    PetActionBarFrame:EnableMouse(false)

    for i=1, num do
        local button = _G["PetActionButton"..i]
        table.insert(buttonList, button) --add the button object to the list
        button:SetSize(cfg.buttons.size, cfg.buttons.size)
        button:ClearAllPoints()
        if i == 1 then
            button:SetPoint("LEFT", frame, cfg.padding, 0)
        else
            local previous = _G["PetActionButton"..i-1]
            button:SetPoint("LEFT", previous, "RIGHT", cfg.buttons.margin, 0)
        end
        --cooldown fix
        local cd = _G["PetActionButton"..i.."Cooldown"]
        cd:SetAllPoints(button)
    end

    if not cfg.show then --wait...you no see me? :(
        frame:SetParent(rABS_BizzardHider)
        return
    end

    --show/hide the frame on a given state driver
    RegisterStateDriver(frame, "visibility", "[petbattle][overridebar][vehicleui][possessbar,@vehicle,exists] hide; [@pet,exists,nomounted] show; hide")

    --create the mouseover functionality
    if cfg.mouseover.enable then
        T.ButtonBarFader(frame, buttonList, cfg.mouseover.fadeIn, cfg.mouseover.fadeOut) --frame, buttonList, fadeIn, fadeOut
    end

    --create the combat fader
    if cfg.combat.enable then
        T.CombatFrameFader(frame, cfg.combat.fadeIn, cfg.combat.fadeOut) --frame, buttonList, fadeIn, fadeOut
    end
end

local styleSpellflyout = function()
    local function addFlyoutFramesToFader(self)
        local frame = self:GetParent():GetParent():GetParent()
        if frame and frame.mouseover and frame.mouseover.enable then
            local NUM_FLYOUT_BUTTONS = 10
            local buttonList = {}
            for i = 1, NUM_FLYOUT_BUTTONS do
                local button = _G["SpellFlyoutButton"..i]
                if button then
                    table.insert(buttonList, button) --add the button object to the list
                end
            end

            rSpellFlyoutFader(frame,buttonList,frame.mouseover.fadeIn,frame.mouseover.fadeOut)
        end
    end

    SpellFlyout:HookScript("OnShow",addFlyoutFramesToFader)
end

local styleStancebar = function()
    local cfg = gcfg.bars.stancebar

    if not cfg.enable then return end

    local num = NUM_STANCE_SLOTS
    local num2 = NUM_POSSESS_SLOTS
    local buttonList = {}

    --make a frame that fits the size of all microbuttons
    local frame = CreateFrame("Frame", "rABS_StanceBar", UIParent, "SecureHandlerStateTemplate")
    frame:SetWidth(num*cfg.buttons.size + (num-1)*cfg.buttons.margin + 2*cfg.padding)
    frame:SetHeight(cfg.buttons.size + 2*cfg.padding)
    frame:SetPoint(cfg.pos.a1,cfg.pos.af,cfg.pos.a2,cfg.pos.x,cfg.pos.y)
    frame:SetScale(cfg.scale)

    --STANCE BAR

    --move the buttons into position and reparent them
    StanceBarFrame:SetParent(frame)
    StanceBarFrame:EnableMouse(false)

    for i=1, num do
        local button = _G["StanceButton"..i]
        table.insert(buttonList, button) --add the button object to the list
        button:SetSize(cfg.buttons.size, cfg.buttons.size)
        button:ClearAllPoints()
        if i == 1 then
            button:SetPoint("BOTTOMLEFT", frame, cfg.padding, cfg.padding)
        else
            local previous = _G["StanceButton"..i-1]
            button:SetPoint("LEFT", previous, "RIGHT", cfg.buttons.margin, 0)
        end
    end

    --POSSESS BAR

    --move the buttons into position and reparent them
    PossessBarFrame:SetParent(frame)
    PossessBarFrame:EnableMouse(false)

    for i=1, num2 do
        local button = _G["PossessButton"..i]
        table.insert(buttonList, button) --add the button object to the list
        button:SetSize(cfg.buttons.size, cfg.buttons.size)
        button:ClearAllPoints()
        if i == 1 then
            button:SetPoint("BOTTOMLEFT", frame, cfg.padding, cfg.padding)
        else
            local previous = _G["PossessButton"..i-1]
            button:SetPoint("LEFT", previous, "RIGHT", cfg.buttons.margin, 0)
        end
    end

    if not cfg.show then --wait...you no see me? :(
        frame:SetParent(rABS_BizzardHider)
        return
    end

    --show/hide the frame on a given state driver
    RegisterStateDriver(frame, "visibility", "[petbattle][overridebar][vehicleui][possessbar,@vehicle,exists] hide; show")

    --create the mouseover functionality
    if cfg.mouseover.enable then
        T.ButtonBarFader(frame, buttonList, cfg.mouseover.fadeIn, cfg.mouseover.fadeOut) --frame, buttonList, fadeIn, fadeOut
    end

    --create the combat fader
    if cfg.combat.enable then
        T.CombatFrameFader(frame, cfg.combat.fadeIn, cfg.combat.fadeOut) --frame, buttonList, fadeIn, fadeOut
    end
end

local styleVehicleExitBar = function()
    local cfg = gcfg.bars.leave_vehicle

    if not cfg.enable then return end

    local num = 1
    local buttonList = {}

    --create the frame to hold the buttons
    local frame = CreateFrame("Frame", "rABS_LeaveVehicle", UIParent, "SecureHandlerStateTemplate")
    frame:SetWidth(num*cfg.buttons.size + (num-1)*cfg.buttons.margin + 2*cfg.padding)
    frame:SetHeight(cfg.buttons.size + 2*cfg.padding)
    frame:SetPoint(cfg.pos.a1,cfg.pos.af,cfg.pos.a2,cfg.pos.x,cfg.pos.y)
    frame:SetScale(cfg.scale)

    --the button
    local button = CreateFrame("BUTTON", "rABS_LeaveVehicleButton", frame, "SecureHandlerClickTemplate, SecureHandlerStateTemplate");
    table.insert(buttonList, button) --add the button object to the list
    button:SetSize(cfg.buttons.size, cfg.buttons.size)
    button:SetPoint("BOTTOMLEFT", frame, cfg.padding, cfg.padding)
    button:RegisterForClicks("AnyUp")
    button:SetScript("OnClick", function()
        if UnitOnTaxi("player") then
            TaxiRequestEarlyLanding()
            self:LockHighlight()
        else
            VehicleExit()
        end
    end)

    button:SetNormalTexture("INTERFACE\\PLAYERACTIONBARALT\\NATURAL")
    button:SetPushedTexture("INTERFACE\\PLAYERACTIONBARALT\\NATURAL")
    button:SetHighlightTexture("INTERFACE\\PLAYERACTIONBARALT\\NATURAL")
    local nt = button:GetNormalTexture()
    local pu = button:GetPushedTexture()
    local hi = button:GetHighlightTexture()
    nt:SetTexCoord(0.0859375,0.1679688,0.359375,0.4414063)
    pu:SetTexCoord(0.001953125,0.08398438,0.359375,0.4414063)
    hi:SetTexCoord(0.6152344,0.6972656,0.359375,0.4414063)
    hi:SetBlendMode("ADD")

    --the button will spawn if a vehicle exists, but no vehicle ui is in place (the vehicle ui has its own exit button)
    --RegisterStateDriver(button, "visibility", "[petbattle] hide; [overridebar][vehicleui][possessbar][@vehicle,exists] show; hide")
    --frame is visibile when no vehicle ui is visible
    --RegisterStateDriver(frame, "visibility", "[petbattle] hide; show")
    hooksecurefunc("MainMenuBarVehicleLeaveButton_Update", function()
        if CanExitVehicle() then
            if UnitOnTaxi("player") then
                button:SetScript("OnClick", function(self)
                    TaxiRequestEarlyLanding()
                    self:LockHighlight()
                end)
            else
                button:SetScript("OnClick", function(self)
                    VehicleExit()
                end)
            end
            button:Show()
        else
            button:Hide()
        end
    end)

    hooksecurefunc("PossessBar_UpdateState", function()
        for i = 1, NUM_POSSESS_SLOTS do
            local _, name, enabled = GetPossessInfo(i)
            if enabled then
                button:SetScript("OnClick", function()
                    CancelUnitBuff("player", name)
                end)
                button:Show()
            else
                button:Hide()
            end
        end
    end)

    --create the mouseover functionality
    if cfg.mouseover.enable then
        T.ButtonBarFader(frame, buttonList, cfg.mouseover.fadeIn, cfg.mouseover.fadeOut) --frame, buttonList, fadeIn, fadeOut
    end
end

hide_blizzart()
stylePlayerPowerBarAlt()
styleBags()
styleBar1()
styleBar2()
styleBar3()
styleBar4()
styleBar5()
styleExtrabar()
styleMicromenu()
styleOverridebar()
stylePetbar()
styleSpellflyout()
styleStancebar()
styleVehicleExitBar()
