------------------------------------------------------
-- Expbar Module
------------------------------------------------------
local T, C, L, _ = unpack(select(2, ...))
local cfg = C.Module.Actionbar.bars.artifact

if cfg.enable ~= true then return end

if cfg.only_at_max_level and T.level ~= MAX_PLAYER_LEVEL then return end

cfg.bflevel             = 2
cfg.bfstrata            = "LOW"
cfg.statusbar           = C.Media.Texture.status

local getNumArtifactTraitsPurchasableFromXP = function(pointsSpent, artifactXP)
	local numPoints = 0
	local xpForNextPoint = C_ArtifactUI.GetCostForPointAtRank(pointsSpent)
	while artifactXP >= xpForNextPoint and xpForNextPoint > 0 do
		artifactXP = artifactXP - xpForNextPoint

		pointsSpent = pointsSpent + 1
		numPoints = numPoints + 1

		xpForNextPoint = C_ArtifactUI.GetCostForPointAtRank(pointsSpent)
	end

	return numPoints, artifactXP, xpForNextPoint
end

local function bar_OnEvent(self, event, ...)
    if not HasArtifactEquipped() then self:Hide() end

    local _, _, name, _, totalPower, traitsLearned = C_ArtifactUI.GetEquippedArtifactInfo()
    if not traitsLearned then return end
    local numTraitsLearnable, power, powerForNextTrait = getNumArtifactTraitsPurchasableFromXP(traitsLearned, totalPower)

    self:SetMinMaxValues(0, powerForNextTrait)
    self:SetValue(power)

    self.name = name
    self.power = power
    self.powerForNextTrait = powerForNextTrait
    self.totalPower = totalPower
    self.numTraitsLearnable = numTraitsLearnable
    self.traitsLearned = traitsLearned

    self:Show()
end

local function bar_OnEnter(self)
    GameTooltip:SetOwner(UIParent, "ANCHOR_CURSOR")

    GameTooltip:AddLine(L.ACTIONBAR_APB)
    GameTooltip:AddDoubleLine(L.ACTIONBAR_AP_NAME, self.name, NORMAL_FONT_COLOR.r,NORMAL_FONT_COLOR.g,NORMAL_FONT_COLOR.b, 1, 1, 1)
    GameTooltip:AddDoubleLine(L.ACTIONBAR_AP_TOTAL, self.totalPower .. "|cffffd100|r")
    GameTooltip:AddDoubleLine(L.ACTIONBAR_AP_UPGRADE, self.power .. "|cffffd100 /|r" .. self.powerForNextTrait .. "|cffffd100|r")
    GameTooltip:AddDoubleLine(L.ACTIONBAR_AP_POINT, self.numTraitsLearnable, NORMAL_FONT_COLOR.r,NORMAL_FONT_COLOR.g,NORMAL_FONT_COLOR.b, 204/255, 0, 0)

    GameTooltip:Show()
end

local function bar_OnLeave(self)
    GameTooltip:Hide()
end

local createbar = function()
    local statusbar = CreateFrame("StatusBar", nil, UIParent)
    statusbar:SetFrameStrata(cfg.bfstrata)
    statusbar:SetFrameLevel(cfg.bflevel)
    statusbar:SetSize(cfg.width, cfg.height)
    statusbar:SetPoint(unpack(cfg.pos))
    statusbar:SetScale(cfg.scale)
    statusbar:SetStatusBarTexture(cfg.statusbar)
    statusbar:SetStatusBarColor(T.color.r, T.color.g, T.color.b)
    
    statusbar.background = statusbar:CreateTexture(nil, "BORDER")
    statusbar.background:SetAllPoints()
    statusbar.background:SetTexture(cfg.statusbar)
    statusbar.background:SetVertexColor(1, 0, 0, 0.2)

    statusbar:SetScript("OnEvent", bar_OnEvent)
    statusbar:SetScript("OnEnter", bar_OnEnter)
    statusbar:SetScript("OnLeave", bar_OnLeave)

    statusbar:RegisterEvent("ARTIFACT_XP_UPDATE")
    statusbar:RegisterEvent("UNIT_INVENTORY_CHANGED")
    statusbar:RegisterEvent("PLAYER_ENTERING_WORLD")
end

local a = CreateFrame("Frame")
a:RegisterEvent("VARIABLES_LOADED")
a:SetScript("OnEvent", function(self)
  self:UnregisterEvent("VARIABLES_LOADED")
  self:SetScript("OnEvent", nil)
  createbar()
end)

