----------------------------------------------------------------------------------------
--  Variable of DarkUI
----------------------------------------------------------------------------------------
local T, C, L, _ = unpack(select(2, ...))

T.Dummy = function() return end

local OnLogon = CreateFrame("Frame")
OnLogon:RegisterEvent("PLAYER_ENTERING_WORLD")
OnLogon:SetScript("OnEvent", function(self, event)
    self:UnregisterEvent("PLAYER_ENTERING_WORLD")

    if DarkUIDB == nil then DarkUIDB = {} end

    local uiScale = tonumber(GetCVar("uiScale"))
    local cfgScale = C.Module.General.uiScale

    if cfgScale < 0.64 then cfgScale = 0.64 end
    if cfgScale > 1.15 then cfgScale = 1.15 end  

    if not DarkUIDB.inited or (uiScale and uiScale ~= cfgScale) then
        -- Don't need to set CVar multiple time
        SetCVar("screenshotQuality", 8)
        SetCVar("cameraDistanceMaxZoomFactor", 2.6)
        SetCVar("showTutorials", 0)
        SetCVar("gameTip", "0")
        SetCVar("UberTooltips", 1)
        SetCVar("chatMouseScroll", 1)
        SetCVar("removeChatDelay", 1)
        SetCVar("WholeChatWindowClickable", 0)
        SetCVar("WhisperMode", "inline")
        SetCVar("colorblindMode", 0)
        SetCVar("lootUnderMouse", 1)
        SetCVar("autoLootDefault", 1)
        SetCVar("RotateMinimap", 0)
        SetCVar("autoQuestProgress", 1)
        SetCVar("scriptErrors", 1)
        SetCVar("taintLog", 0)
        SetCVar("buffDurations", 1)
        --BETA SetCVar("enableCombatText", 1)
        SetCVar("autoOpenLootHistory", 0)
        SetCVar("lossOfControl", 0)
        SetCVar("nameplateShowSelf", 0)
        SetCVar("alwaysCompareItems", 1)
        SetCVar("autoSelfCast", 1)
        SetCVar("nameplateShowEnemies", 1)
        SetCVar("ShowClassColorInNameplate", 1)
        SetCVar("threatWarning", 3)
        SetCVar("lockActionBars", 1)
        SetCVar("countdownForCooldowns", 0)
        
        SetCVar("useUiScale", 1)
        SetCVar("uiScale", cfgScale)
        
        SetCVarBitfield("closedInfoFrames", LE_FRAME_TUTORIAL_WORLD_MAP_FRAME, true)
        SetCVarBitfield("closedInfoFrames", LE_FRAME_TUTORIAL_PET_JOURNAL, true)
        SetCVarBitfield("closedInfoFrames", LE_FRAME_TUTORIAL_GARRISON_BUILDING, true)

        -- Enable classcolor automatically on login and on each character without doing /configure each time
		ToggleChatColorNamesByClassGroup(true, "SAY")
		ToggleChatColorNamesByClassGroup(true, "EMOTE")
		ToggleChatColorNamesByClassGroup(true, "YELL")
		ToggleChatColorNamesByClassGroup(true, "GUILD")
		ToggleChatColorNamesByClassGroup(true, "OFFICER")
		ToggleChatColorNamesByClassGroup(true, "GUILD_ACHIEVEMENT")
		ToggleChatColorNamesByClassGroup(true, "ACHIEVEMENT")
		ToggleChatColorNamesByClassGroup(true, "WHISPER")
		ToggleChatColorNamesByClassGroup(true, "PARTY")
		ToggleChatColorNamesByClassGroup(true, "PARTY_LEADER")
		ToggleChatColorNamesByClassGroup(true, "RAID")
		ToggleChatColorNamesByClassGroup(true, "RAID_LEADER")
		ToggleChatColorNamesByClassGroup(true, "RAID_WARNING")
		ToggleChatColorNamesByClassGroup(true, "INSTANCE_CHAT")
		ToggleChatColorNamesByClassGroup(true, "INSTANCE_CHAT_LEADER")
		ToggleChatColorNamesByClassGroup(true, "CHANNEL1")
		ToggleChatColorNamesByClassGroup(true, "CHANNEL2")
		ToggleChatColorNamesByClassGroup(true, "CHANNEL3")
		ToggleChatColorNamesByClassGroup(true, "CHANNEL4")
		ToggleChatColorNamesByClassGroup(true, "CHANNEL5")

        StaticPopup_Show("RESETUI_CONFIRM")
    else
        print("|cffffff00"..L.WELCOME_LINE..T.version.." "..T.client..", "..T.name..".|r")

        if C.Module.General.uiScale < .64 or C.Module.General.uiScale > 1.15 then
            StaticPopup_Show("INVALID_SCALE")
        end
    end
end)

StaticPopupDialogs["RESETUI_CONFIRM"] = 
{ 
        text = L.POPUP_INSTALLUI,
        button1 = ACCEPT,
        button2 = CANCEL,
        OnAccept = function() DarkUIDB.inited = true; ReloadUI(); end,
        whileDead = 1,
        timeout = 0,
        hideOnEscape = 1,
}

StaticPopupDialogs["INVALID_SCALE"] = 
{
        text = L.INVALID_UISCALE,
        button1 = ACCEPT,
        whileDead = 1,
        timeout = 0,
        hideOnEscape = 1,
}

SLASH_CONFIGURE1 = "/resetui"
SlashCmdList.CONFIGURE = function() StaticPopup_Show("RESETUI_CONFIRM") end