----------------------------------------------------------------------------------------
--  Configure of Media
----------------------------------------------------------------------------------------
local T, C, L, _ = unpack(select(2, ...))

local path = "Interface\\Addons\\DarkUI\\Media\\"

local config = 
{
    path                                = path,

    style                               = "cold", -- avaliable style is: cold, warm

    border_color                        = {0.3, 0.3, 0.3, 1},
    backdrop_color                      = {0, 0, 0, 0.75},
    overlay_color                       = {0, 0, 0, 0.7},
    highlight_color                     = {1, 1, 1, 0.35},
    shadow_color                        = {0, 0, 0, 0.88},

    texCoord                            = {0.08, 0.92, 0.08, 0.92},
    
    standard_font                       = {STANDARD_TEXT_FONT, 12, "THINOUTLINE"},

    Nameplate =
    {
        arrow                           = path .. "uf_nameplate_arrow",
    },

    Button = 
    {
        normal                          = path .. "btn_gloss",
        flash                           = path .. "btn_flash",
        hover                           = path .. "btn_hover",
        pushed                          = path .. "btn_pushed",
        checked                         = path .. "btn_checked",
        equipped                        = path .. "btn_gloss_grey",
        buttonback                      = path .. "btn_background",
        buttonbackflat                  = path .. "btn_background_flat",
        outer_shadow                    = path .. "btn_outer_shadow",
    },

    Texture = 
    {
        border                          = path .. "tex_border",
        outer_border                    = path .. "tex_outer_border",
        status                          = path .. "tex_status",
        status_f                        = path .. "tex_status_f",
        status_s                        = path .. "tex_status_s",
        blank                           = path .. "tex_blank",
        shadow                          = path .. "tex_shadow",
        shadowBackground                = path .. "tex_shadow_background",
        shadow_lite                     = path .. "tex_shadow_lite",
    },
}

C.Media = config