----------------------------------------------------------------------------------------
--	Initiation of DarkUI
----------------------------------------------------------------------------------------
-- Including system
local addon, engine = ...
engine[1] = {}	-- T, Functions
engine[2] = {}	-- C, Config
engine[3] = {}	-- L, Localization

engine[1].class = select(2, UnitClass('player'))
engine[1].name = UnitName("player")
engine[1].race = select(2, UnitRace("player"))
engine[1].level = UnitLevel("player")
engine[1].color = (CUSTOM_CLASS_COLORS or RAID_CLASS_COLORS)[engine[1].class]
engine[1].colorstring = format('|cff%02x%02x%02x', engine[1].color.r * 255, engine[1].color.g * 255, engine[1].color.b * 255)
engine[1].resolution = ({GetScreenResolutions()})[GetCurrentResolution()] or GetCVar("gxWindowedResolution")
engine[1].screenwidth, engine[1].screenheight = DecodeResolution(engine[1].resolution)
engine[1].client = GetLocale()
engine[1].realm = GetRealmName()
engine[1].version = GetAddOnMetadata("DarkUI", "Version")

DarkUI = engine	-- Allow other addons to use Engine

--[[
	This should be at the top of every file inside of the DarkUI AddOn:
	local T, C, L, _ = unpack(select(2, ...))

	This is how another addon imports the DarkUI engine:
	local T, C, L, _ = unpack(DarkUI)
]]