﻿----------------------------------------------------------------------------------------
--  ChatBar(FavChatBar by Favorit)
----------------------------------------------------------------------------------------
local T, C, L, _ = unpack(select(2, ...))
if C.Module.Chat.chat_bar ~= true then return end

local frame = CreateFrame("Frame", "ChatBar", UIParent)
frame:CreatePanel("Invisible", 16, C.Module.Chat.background and C.Module.Chat.height + 4 or C.Module.Chat.height - 1, "BOTTOMLEFT", UIParent, "BOTTOMLEFT", 2, C.Module.Chat.background and 30 or 26)
if C.Module.Chat.chat_bar_mouseover == true then
    frame:SetAlpha(0)
    frame:SetScript("OnEnter", function()
        frame:FadeIn()
    end)
    frame:SetScript("OnLeave", function()
        frame:FadeOut()
    end)
end

local function CreateButton(b, l, r, m)
    b:SetSize(16, 16)

    b:CreateShadow()

    b.texture = b:CreateTexture(nil, "ARTWORK")
    b.texture:SetTexture(C.Media.Texture.status)
    b.texture:SetPoint("TOPLEFT", b, "TOPLEFT", 2, -2)
    b.texture:SetPoint("BOTTOMRIGHT", b, "BOTTOMRIGHT", -2, 2)

    b.highlight = b:CreateTexture(nil, "HIGHLIGHT")
    b.highlight:SetTexture(1, 1, 1, 0.35)
    b.highlight:SetAllPoints(b.texture)

    b:RegisterForClicks("AnyUp")
    b:SetScript("OnClick", function(self, b)
        if b == "LeftButton" then
            ChatFrame_OpenChat(l, SELECTED_DOCK_FRAME)
        elseif b == "RightButton" then
            ChatFrame_OpenChat(r, SELECTED_DOCK_FRAME)
        elseif m and b == "MiddleButton" then
            ChatFrame_OpenChat(m, SELECTED_DOCK_FRAME)
        end
    end)

    if C.Module.Chat.chat_bar_mouseover == true then
        b:SetScript("OnEnter", function()
            frame:FadeIn()
        end)
        b:SetScript("OnLeave", function()
            frame:FadeOut()
        end)
    end
end

local b1 = CreateFrame("Button", "$parentButton1", frame)
CreateButton(b1, "/s", "/w ", "/y")
b1:SetPoint("TOP", frame, "TOP", 0, 0)
b1.texture:SetVertexColor(0.8, 0.8, 0.8, 1)

local b2 = CreateFrame("Button", "$parentButton2", frame)
CreateButton(b2, "/g", "/o")
b2:SetPoint("TOP", b1, "BOTTOM", 0, C.Module.Chat.background and -4 or -3)
b2.texture:SetVertexColor(0, 0.8, 0, 1)

local b3 = CreateFrame("Button", "$parentButton3", frame)
CreateButton(b3, "/p", "/i")
b3:SetPoint("TOP", b2, "BOTTOM", 0, C.Module.Chat.background and -4 or -3)
b3.texture:SetVertexColor(0.11, 0.5, 0.7, 1)

local b4 = CreateFrame("Button", "$parentButton4", frame)
CreateButton(b4, "/ra", "/rw")
b4:SetPoint("TOP", b3, "BOTTOM", 0, C.Module.Chat.background and -4 or -3)
b4.texture:SetVertexColor(1, 0.3, 0, 1)

local b5 = CreateFrame("Button", "$parentButton5", frame)
CreateButton(b5, "/1", "/2")
b5:SetPoint("TOP", b4, "BOTTOM", 0, C.Module.Chat.background and -4 or -3)
b5.texture:SetVertexColor(0.93, 0.8, 0.8, 1)

local b6 = CreateFrame("Button", "$parentButton6", frame)
CreateButton(b6, "/3", "/4")
b6:SetPoint("TOP", b5, "BOTTOM", 0, C.Module.Chat.background and -4 or -3)
b6.texture:SetVertexColor(1, 0.75, 0.75, 1)