local T, C, L, _ = unpack(select(2, ...))

------------------------------------------------------------
--  FacePaint ~ paints the default interface (w/<3) ~ by Aprikot
------------------------------------------------------------
local class = false     
local gradient = false  
local topcolor = {      
    r = 0.3,
    g = 0.3,
    b = 0.3,
}
local bottomcolor = {   
    r = 0.5,
    g = 0.5,
    b = 0.5,
}
local topalpha = 1.0    
local bottomalpha = 1.0 

if not IsAddOnLoaded("Blizzard_TimeManager") then
    LoadAddOn("Blizzard_TimeManager")
end

local objects = {
    PlayerFrameTexture,
    select(2, PlayerFrameAlternateManaBar:GetRegions()),
    TargetFrameTextureFrameTexture,
    FocusFrameTextureFrameTexture,
    TargetFrameToTTextureFrameTexture,
    FocusFrameToTTextureFrameTexture,
    PetFrameTexture,

    PartyMemberFrame1Texture,
    PartyMemberFrame2Texture,
    PartyMemberFrame3Texture,
    PartyMemberFrame4Texture,

    PartyMemberFrame1PetFrameTexture,
    PartyMemberFrame2PetFrameTexture,
    PartyMemberFrame3PetFrameTexture,
    PartyMemberFrame4PetFrameTexture,
    
    Boss1TargetFrameTexture,
    Boss2TargetFrameTexture,
    Boss3TargetFrameTexture,
    Boss4TargetFrameTexture,

    Boss1TargetFrameTextureFrameTexture,
    Boss2TargetFrameTextureFrameTexture,
    Boss3TargetFrameTextureFrameTexture,
    Boss4TargetFrameTextureFrameTexture,
    Boss5TargetFrameTextureFrameTexture,
    
    CompactRaidGroup1BorderFrame,
    CompactRaidGroup2BorderFrame,
    CompactRaidGroup3BorderFrame,
    CompactRaidGroup4BorderFrame,
    CompactRaidGroup5BorderFrame,
    CompactRaidGroup6BorderFrame,
    CompactRaidGroup7BorderFrame,
    CompactRaidGroup8BorderFrame,
    
    CompactRaidFrameContainerBorderFrameBorderBottom,
    CompactRaidFrameContainerBorderFrameBorderBottomLeft,
    CompactRaidFrameContainerBorderFrameBorderBottomRight,
    CompactRaidFrameContainerBorderFrameBorderLeft,
    CompactRaidFrameContainerBorderFrameBorderRight,
    CompactRaidFrameContainerBorderFrameBorderTop,
    CompactRaidFrameContainerBorderFrameBorderTopLeft,
    CompactRaidFrameContainerBorderFrameBorderTopRight,

    CompactRaidFrameManagerToggleButton:GetRegions(),
    CompactRaidFrameManagerBg,
    CompactRaidFrameManagerBorderBottom,
    CompactRaidFrameManagerBorderBottomLeft,
    CompactRaidFrameManagerBorderBottomRight,
    CompactRaidFrameManagerBorderRight,
    CompactRaidFrameManagerBorderTopLeft,
    CompactRaidFrameManagerBorderTopRight,
    CompactRaidFrameManagerBorderTop,
    
    GarrisonLandingPageMinimapButton,
    MiniMapBattlefieldBorder,
    MiniMapLFGFrameBorder,
    MinimapBackdrop,
    MinimapBorder,
    MiniMapMailBorder,
    MiniMapTrackingButtonBorder,
    MinimapBorderTop,
    MinimapZoneTextButton,
    MiniMapWorldMapButton,
    MiniMapWorldMapButton,
    MiniMapWorldIcon,
    MinimapZoomIn:GetRegions(),
    select(3, MinimapZoomIn:GetRegions()),
    MinimapZoomOut:GetRegions(),
    select(3, MinimapZoomOut:GetRegions()),
    TimeManagerClockButton:GetRegions(),
    MiniMapWorldMapButton:GetRegions(),
    select(6, GameTimeFrame:GetRegions()),
    
    MainMenuBarTexture0,
    MainMenuBarTexture1,
    MainMenuBarTexture2,
    MainMenuBarTexture3,
    MainMenuXPBarTextureRightCap,
    MainMenuXPBarTextureMid,
    MainMenuXPBarTextureLeftCap,
    ActionBarUpButton:GetRegions(),
    ActionBarDownButton:GetRegions(),
    MainMenuMaxLevelBar0,
    MainMenuMaxLevelBar1,
    MainMenuMaxLevelBar2,
    MainMenuMaxLevelBar3,
    MainMenuBarMaxLevelBar,
    MainMenuBarMaxLevelBarTexture0,
    MainMenuBarMaxLevelBarTexture1,
    MainMenuBarMaxLevelBarTexture2,
    MainMenuBarMaxLevelBarTexture3,
    
    MainMenuXPBarDiv1,
    MainMenuXPBarDiv2,
    MainMenuXPBarDiv3,
    MainMenuXPBarDiv4,
    MainMenuXPBarDiv5,
    MainMenuXPBarDiv6,
    MainMenuXPBarDiv7,
    MainMenuXPBarDiv8,
    MainMenuXPBarDiv9,
    MainMenuXPBarDiv10,
    MainMenuXPBarDiv11,
    MainMenuXPBarDiv12,
    MainMenuXPBarDiv13,
    MainMenuXPBarDiv14,
    MainMenuXPBarDiv15,
    MainMenuXPBarDiv16,
    MainMenuXPBarDiv17,
    MainMenuXPBarDiv18,
    MainMenuXPBarDiv19,
    
    --select(2, FriendsMicroButton:GetRegions()),
    ChatFrameMenuButton:GetRegions(),
    ChatFrame1ButtonFrameUpButton:GetRegions(),
    ChatFrame1ButtonFrameDownButton:GetRegions(),
    select(2, ChatFrame1ButtonFrameBottomButton:GetRegions()),
    ChatFrame2ButtonFrameUpButton:GetRegions(),
    ChatFrame2ButtonFrameDownButton:GetRegions(),
    select(2, ChatFrame2ButtonFrameBottomButton:GetRegions()),
    
    select(2,CastingBarFrame:GetRegions()),
    select(2,MirrorTimer1:GetRegions()),
    CastingBarFrameBorder,
    FocusFrameSpellBarBorder,
    TargetFrameSpellBarBorder,
}

if class then
    local classcolor = RAID_CLASS_COLORS[select(2, UnitClass("player"))]
    topcolor.r, topcolor.g, topcolor.b = (classcolor.r * 1.2), (classcolor.g * 1.2), (classcolor.b * 1.2)
end

local paint = function(object)
    object:SetDesaturated(1)
    if gradient then
        object:SetGradientAlpha("VERTICAL", bottomcolor.r, bottomcolor.g, bottomcolor.b, bottomalpha, topcolor.r, topcolor.g, topcolor.b, topalpha)
    else
        object:SetVertexColor(topcolor.r, topcolor.g, topcolor.b, topalpha)
    end
end

local exec = function()
    for i,v in pairs(objects) do
        if v:GetObjectType() == "Texture" then
            paint(v)
        end
    end
end
exec()

select(5, GameTimeFrame:GetRegions()):SetVertexColor(1, 1, 1)

hooksecurefunc("TargetFrame_CheckClassification", function(self)
    self.borderTexture:SetDesaturated(0);
end);

if gradient then
	MainMenuBarLeftEndCap:SetGradientAlpha("HORIZONTAL", bottomcolor.r, bottomcolor.g, bottomcolor.b, bottomalpha, topcolor.r, topcolor.g, topcolor.b, topalpha)
	MainMenuBarRightEndCap:SetGradientAlpha("HORIZONTAL", topcolor.r, topcolor.g, topcolor.b, topalpha, bottomcolor.r, bottomcolor.g, bottomcolor.b, bottomalpha)
else
	MainMenuBarLeftEndCap:SetVertexColor(topcolor.r, topcolor.g, topcolor.b, topalpha)
	MainMenuBarRightEndCap:SetVertexColor(topcolor.r, topcolor.g, topcolor.b, topalpha)
end

TOOLTIP_DEFAULT_COLOR = { r = topcolor.r * 0.7, g = topcolor.g * 0.7, b = topcolor.b * 0.7 };
TOOLTIP_DEFAULT_BACKGROUND_COLOR = { r = bottomcolor.r * 0.2, g = bottomcolor.g * 0.2, b = bottomcolor.b * 0.2};

if not C.Module.General.shadow then return end

local f = CreateFrame("Frame", "ShadowBackground")
f:SetPoint("TOPLEFT")
f:SetPoint("BOTTOMRIGHT")
f:SetFrameLevel(0)
f:SetFrameStrata("BACKGROUND")
f.tex = f:CreateTexture(C.Media.Texture.shadowBackground)
f.tex:SetAllPoints(f)

f:SetScript("OnEvent", function()
    f:SetAlpha(.5)
end)
f:RegisterEvent("PLAYER_ENTERING_WORLD")