package com.example.ytsdk_demo;

import org.json.JSONObject;

import android.app.Activity;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

import com.example.demo.R;
import com.game.sdk.SDKManager;
import com.game.sdk.domain.LoginErrorMsg;
import com.game.sdk.domain.LogincallBack;
import com.game.sdk.domain.OnLoginListener;
import com.game.sdk.domain.OnPaymentListener;
import com.game.sdk.domain.PaymentCallbackInfo;
import com.game.sdk.domain.PaymentErrorMsg;
import com.game.sdk.util.MResource;




public class SDKActivity extends Activity implements OnClickListener {

	public SDKManager sdkmanager;
	private EditText et_money;
	private TextView tv_msg;
	private Button btn_login, btn_charger;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		// TODO Auto-generated method stub
		super.onCreate(savedInstanceState);
		sdkmanager = SDKManager.getInstance(this);
	
		sdkmanager.setIsPortrait(2);
		setContentView(R.layout.yt_sdk);
		btn_login = (Button) findViewById(MResource.getIdByName(
				getApplication(), "id", "btn_login"));
		btn_charger = (Button) findViewById(MResource.getIdByName(
				getApplication(), "id", "btn_charger"));
		tv_msg = (TextView) findViewById(MResource.getIdByName(
				getApplication(), "id", "tv_msg"));

		et_money = (EditText) findViewById(MResource.getIdByName(
				getApplication(), "id", "et_money"));

		btn_login.setOnClickListener(this);
		btn_charger.setOnClickListener(this);
	}

	@Override
	public void onClick(View v) {
		// TODO Auto-generated method stub
		if (null != btn_login && btn_login.getId() == v.getId()) {
			
			sdkmanager.showLogin(this, true, new OnLoginListener() {
				@Override
				public void loginSuccess(LogincallBack logincallback) {
					sdkmanager.showFloatView();//显示浮点
					
					try {
						JSONObject jsonExData = new JSONObject();
						jsonExData.put("service", "游戏一区-逍遥谷");
						jsonExData.put("role", "令狐冲");
						jsonExData.put("grade", "99");
						
						SDKManager.getInstance(SDKActivity.this).submitExtendData(1, jsonExData);
						} catch (Exception e) {
						//处理异常
						}
				}

				@Override
				public void loginError(LoginErrorMsg errorMsg) {
					// TODO Auto-generated method stub

				}
			});
			return;
		}
		if (null != btn_charger && btn_charger.getId() == v.getId()) {
			String money_str = et_money.getText().toString().trim();
			String money = "1";
			if (!TextUtils.isEmpty(money_str) && !"".equals(money_str)) {
				money = money_str;
			}
			sdkmanager.showPay(this, "roleid", money, "1", "魔神", "产品描述", "扩展参数", new OnPaymentListener() {
						@Override
						public void paymentSuccess(
								PaymentCallbackInfo callbackInfo) {
							// TODO Auto-generated method stub
							Toast.makeText(
									getApplication(),
									"充值金额数：" + callbackInfo.money + " 消息提示："
											+ callbackInfo.msg,
									Toast.LENGTH_LONG).show();
						}

						@Override
						public void paymentError(PaymentErrorMsg errorMsg) {
							// TODO Auto-generated method stub
							Toast.makeText(
									getApplication(),
									"充值失败：code:" + errorMsg.code
											+ "  ErrorMsg:" + errorMsg.msg
											+ "  预充值的金额：" + errorMsg.money,
									Toast.LENGTH_LONG).show();
						}
					});

			return;
		}

	}
	
	@Override
	protected void onDestroy() {
		sdkmanager.recycle();//游戏退出必须调用
		super.onDestroy();
	};
	
	@Override
	protected void onStop() {
		// TODO Auto-generated method stub
		sdkmanager.removeFloatView();//隐藏悬浮窗口
		super.onStop();
	}
	
	@Override
	protected void onResume() {
		// TODO Auto-generated method stub
		sdkmanager.showFloatView();//显示悬浮窗口
		super.onResume();
	}
	
}
