/*
 * Decompiled with CFR 0.152.
 */
package com.game.sdk.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Looper;
import android.widget.Toast;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class NetworkImpl {
    public static HttpClient getHttpClient(Context context) {
        if (!NetworkImpl.isNetWorkConneted(context)) {
            Looper.prepare();
            Toast.makeText((Context)context, (CharSequence)"\u7f51\u7edc\u8fde\u63a5\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u5f53\u524d\u7f51\u7edc\u72b6\u6001\uff01", (int)0).show();
            Looper.loop();
            return null;
        }
        DefaultHttpClient defaultHttpClient = null;
        if (NetworkImpl.isCmwapType(context)) {
            BasicHttpParams basicHttpParams = new BasicHttpParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)basicHttpParams, (int)30000);
            HttpConnectionParams.setSoTimeout((HttpParams)basicHttpParams, (int)30000);
            HttpConnectionParams.setSocketBufferSize((HttpParams)basicHttpParams, (int)102400);
            HttpClientParams.setRedirecting((HttpParams)basicHttpParams, (boolean)true);
            HttpHost httpHost = new HttpHost("10.0.0.172", 80);
            basicHttpParams.setParameter("http.route.default-proxy", (Object)httpHost);
            defaultHttpClient = new DefaultHttpClient((HttpParams)basicHttpParams);
        } else {
            defaultHttpClient = new DefaultHttpClient();
            HttpParams httpParams = defaultHttpClient.getParams();
            httpParams.setParameter("http.connection.timeout", (Object)30000);
            httpParams.setParameter("http.socket.timeout", (Object)30000);
        }
        return defaultHttpClient;
    }

    public static boolean isNetWorkConneted(Context context) {
        try {
            NetworkInfo networkInfo;
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            if (connectivityManager != null && (networkInfo = connectivityManager.getActiveNetworkInfo()) != null && networkInfo.isConnectedOrConnecting()) {
                return networkInfo.isAvailable();
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    private static boolean isCmwapType(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        String string = networkInfo.getExtraInfo();
        if (null == string) {
            return false;
        }
        return "cmwap".equalsIgnoreCase(string) || "3gwap".equalsIgnoreCase(string) || "uniwap".equalsIgnoreCase(string);
    }
}

