/*
 * Decompiled with CFR 0.152.
 */
package com.game.sdk.pager;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcelable;
import android.os.SystemClock;
import android.support.v4.view.KeyEventCompat;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.VelocityTrackerCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewConfigurationCompat;
import android.support.v4.widget.EdgeEffectCompat;
import android.util.AttributeSet;
import android.util.Log;
import android.view.FocusFinder;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.SoundEffectConstants;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.animation.Interpolator;
import android.widget.Scroller;
import com.game.sdk.pager.VerticalViewPager$LayoutParams;
import com.game.sdk.pager.a;
import com.game.sdk.pager.b;
import com.game.sdk.pager.c;
import com.game.sdk.pager.d;
import com.game.sdk.pager.e;
import com.game.sdk.pager.f;
import com.game.sdk.pager.g;
import com.game.sdk.pager.h;
import com.game.sdk.pager.i;
import com.game.sdk.pager.j;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class VerticalViewPager
extends ViewGroup {
    private static final String TAG = "VerticalViewPager";
    private static final boolean DEBUG = false;
    private static final boolean USE_CACHE = false;
    private static final int DEFAULT_OFFSCREEN_PAGES = 1;
    private static final int MAX_SETTLE_DURATION = 600;
    private static final int MIN_DISTANCE_FOR_FLING = 25;
    private static final int[] LAYOUT_ATTRS = new int[]{16842931};
    private static final Comparator COMPARATOR = new c();
    private static final Interpolator sInterpolator = new d();
    private final ArrayList mItems = new ArrayList();
    private a mAdapter;
    private int mCurItem;
    private int mRestoredCurItem = -1;
    private Parcelable mRestoredAdapterState = null;
    private ClassLoader mRestoredClassLoader = null;
    private Scroller mScroller;
    private i mObserver;
    private int mPageMargin;
    private Drawable mMarginDrawable;
    private int mLeftPageBounds;
    private int mRightPageBounds;
    private int mChildWidthMeasureSpec;
    private int mChildHeightMeasureSpec;
    private boolean mInLayout;
    private boolean mScrollingCacheEnabled;
    private boolean mPopulatePending;
    private boolean mScrolling;
    private int mOffscreenPageLimit = 1;
    private boolean mIsBeingDragged;
    private boolean mIsUnableToDrag;
    private int mTouchSlop;
    private float mInitialMotionY;
    private float mLastMotionX;
    private float mLastMotionY;
    private int mActivePointerId = -1;
    private static final int INVALID_POINTER = -1;
    private VelocityTracker mVelocityTracker;
    private int mMinimumVelocity;
    private int mMaximumVelocity;
    private int mFlingDistance;
    private boolean mFakeDragging;
    private long mFakeDragBeginTime;
    private EdgeEffectCompat mTopEdge;
    private EdgeEffectCompat mBottomEdge;
    private boolean mFirstLayout = true;
    private boolean mCalledSuper;
    private int mDecorChildCount;
    private h mOnPageChangeListener;
    private h mInternalPageChangeListener;
    private g mAdapterChangeListener;
    public static final int SCROLL_STATE_IDLE = 0;
    public static final int SCROLL_STATE_DRAGGING = 1;
    public static final int SCROLL_STATE_SETTLING = 2;
    private int mScrollState = 0;

    public void setOnClickListener(View.OnClickListener onClickListener) {
        super.setOnClickListener((View.OnClickListener)new b(this));
    }

    public VerticalViewPager(Context context) {
        super(context);
        this.initViewPager();
    }

    public VerticalViewPager(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.initViewPager();
    }

    void initViewPager() {
        this.setWillNotDraw(false);
        this.setDescendantFocusability(262144);
        this.setFocusable(true);
        Context context = this.getContext();
        this.mScroller = new Scroller(context, sInterpolator);
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)context);
        this.mTouchSlop = ViewConfigurationCompat.getScaledPagingTouchSlop((ViewConfiguration)viewConfiguration);
        this.mMinimumVelocity = viewConfiguration.getScaledMinimumFlingVelocity();
        this.mMaximumVelocity = viewConfiguration.getScaledMaximumFlingVelocity();
        this.mTopEdge = new EdgeEffectCompat(context);
        this.mBottomEdge = new EdgeEffectCompat(context);
        float f2 = context.getResources().getDisplayMetrics().density;
        this.mFlingDistance = (int)(25.0f * f2);
    }

    private void setScrollState(int n2) {
        if (this.mScrollState == n2) {
            return;
        }
        this.mScrollState = n2;
        if (this.mOnPageChangeListener != null) {
            this.mOnPageChangeListener.b(n2);
        }
    }

    public void setAdapter(a a2) {
        if (this.mAdapter != null) {
            this.mAdapter.startUpdate(this);
            for (int i2 = 0; i2 < this.mItems.size(); ++i2) {
                f f2 = (f)this.mItems.get(i2);
                this.mAdapter.destroyItem(this, f2.b, f2.a);
            }
            this.mAdapter.finishUpdate(this);
            this.mItems.clear();
            this.removeNonDecorViews();
            this.mCurItem = 0;
            this.scrollTo(0, 0);
        }
        a a3 = this.mAdapter;
        this.mAdapter = a2;
        if (this.mAdapter != null) {
            if (this.mObserver == null) {
                this.mObserver = new i(this, null);
            }
            this.mPopulatePending = false;
            if (this.mRestoredCurItem >= 0) {
                this.mAdapter.restoreState(this.mRestoredAdapterState, this.mRestoredClassLoader);
                this.setCurrentItemInternal(this.mRestoredCurItem, false, true);
                this.mRestoredCurItem = -1;
                this.mRestoredAdapterState = null;
                this.mRestoredClassLoader = null;
            } else {
                this.populate();
            }
        }
        if (this.mAdapterChangeListener != null && a3 != a2) {
            this.mAdapterChangeListener.a(a3, a2);
        }
    }

    private void removeNonDecorViews() {
        for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
            View view = this.getChildAt(i2);
            VerticalViewPager$LayoutParams verticalViewPager$LayoutParams = (VerticalViewPager$LayoutParams)view.getLayoutParams();
            if (verticalViewPager$LayoutParams.a) continue;
            this.removeViewAt(i2);
            --i2;
        }
    }

    public a getAdapter() {
        return this.mAdapter;
    }

    void setOnAdapterChangeListener(g g2) {
        this.mAdapterChangeListener = g2;
    }

    public void setCurrentItem(int n2) {
        this.mPopulatePending = false;
        this.setCurrentItemInternal(n2, !this.mFirstLayout, false);
    }

    public void setCurrentItem(int n2, boolean bl) {
        this.mPopulatePending = false;
        this.setCurrentItemInternal(n2, bl, false);
    }

    public int getCurrentItem() {
        return this.mCurItem;
    }

    void setCurrentItemInternal(int n2, boolean bl, boolean bl2) {
        this.setCurrentItemInternal(n2, bl, bl2, 0);
    }

    void setCurrentItemInternal(int n2, boolean bl, boolean bl2, int n3) {
        int n4;
        if (this.mAdapter == null || this.mAdapter.getCount() <= 0) {
            this.setScrollingCacheEnabled(false);
            return;
        }
        if (!bl2 && this.mCurItem == n2 && this.mItems.size() != 0) {
            this.setScrollingCacheEnabled(false);
            return;
        }
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= this.mAdapter.getCount()) {
            n2 = this.mAdapter.getCount() - 1;
        }
        int n5 = this.mOffscreenPageLimit;
        if (n2 > this.mCurItem + n5 || n2 < this.mCurItem - n5) {
            for (n4 = 0; n4 < this.mItems.size(); ++n4) {
                ((f)this.mItems.get((int)n4)).c = true;
            }
        }
        n4 = this.mCurItem != n2 ? 1 : 0;
        this.mCurItem = n2;
        this.populate();
        int n6 = (this.getHeight() + this.mPageMargin) * n2;
        if (bl) {
            this.smoothScrollTo(0, n6, n3);
            if (n4 != 0 && this.mOnPageChangeListener != null) {
                this.mOnPageChangeListener.a(n2);
            }
            if (n4 != 0 && this.mInternalPageChangeListener != null) {
                this.mInternalPageChangeListener.a(n2);
            }
        } else {
            if (n4 != 0 && this.mOnPageChangeListener != null) {
                this.mOnPageChangeListener.a(n2);
            }
            if (n4 != 0 && this.mInternalPageChangeListener != null) {
                this.mInternalPageChangeListener.a(n2);
            }
            this.completeScroll();
            this.scrollTo(0, n6);
        }
    }

    public void setOnPageChangeListener(h h2) {
        this.mOnPageChangeListener = h2;
    }

    h setInternalPageChangeListener(h h2) {
        h h3 = this.mInternalPageChangeListener;
        this.mInternalPageChangeListener = h2;
        return h3;
    }

    public int getOffscreenPageLimit() {
        return this.mOffscreenPageLimit;
    }

    public void setOffscreenPageLimit(int n2) {
        if (n2 < 1) {
            Log.w((String)TAG, (String)("Requested offscreen page limit " + n2 + " too small; defaulting to " + 1));
            n2 = 1;
        }
        if (n2 != this.mOffscreenPageLimit) {
            this.mOffscreenPageLimit = n2;
            this.populate();
        }
    }

    public void setPageMargin(int n2) {
        int n3 = this.mPageMargin;
        this.mPageMargin = n2;
        int n4 = this.getHeight();
        this.recomputeScrollPosition(n4, n4, n2, n3);
        this.requestLayout();
    }

    public int getPageMargin() {
        return this.mPageMargin;
    }

    public void setPageMarginDrawable(Drawable drawable) {
        this.mMarginDrawable = drawable;
        if (drawable != null) {
            this.refreshDrawableState();
        }
        this.setWillNotDraw(drawable == null);
        this.invalidate();
    }

    public void setPageMarginDrawable(int n2) {
        this.setPageMarginDrawable(this.getContext().getResources().getDrawable(n2));
    }

    protected boolean verifyDrawable(Drawable drawable) {
        return super.verifyDrawable(drawable) || drawable == this.mMarginDrawable;
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        Drawable drawable = this.mMarginDrawable;
        if (drawable != null && drawable.isStateful()) {
            drawable.setState(this.getDrawableState());
        }
    }

    float distanceInfluenceForSnapDuration(float f2) {
        f2 -= 0.5f;
        f2 = (float)((double)f2 * 0.4712389167638204);
        return (float)Math.sin(f2);
    }

    void smoothScrollTo(int n2, int n3) {
        this.smoothScrollTo(n2, n3, 0);
    }

    void smoothScrollTo(int n2, int n3, int n4) {
        if (this.getChildCount() == 0) {
            this.setScrollingCacheEnabled(false);
            return;
        }
        int n5 = this.getScrollX();
        int n6 = this.getScrollY();
        int n7 = n2 - n5;
        int n8 = n3 - n6;
        if (n7 == 0 && n8 == 0) {
            this.completeScroll();
            this.setScrollState(0);
            return;
        }
        this.setScrollingCacheEnabled(true);
        this.mScrolling = true;
        this.setScrollState(2);
        int n9 = this.getHeight();
        int n10 = n9 / 2;
        float f2 = Math.min(1.0f, 1.0f * (float)Math.abs(n8) / (float)n9);
        float f3 = (float)n10 + (float)n10 * this.distanceInfluenceForSnapDuration(f2);
        int n11 = 0;
        n4 = Math.abs(n4);
        if (n4 > 0) {
            n11 = 4 * Math.round(1000.0f * Math.abs(f3 / (float)n4));
        } else {
            float f4 = (float)Math.abs(n8) / (float)(n9 + this.mPageMargin);
            n11 = (int)((f4 + 1.0f) * 100.0f);
        }
        n11 = Math.min(n11, 600);
        this.mScroller.startScroll(n5, n6, n7, n8, n11);
        this.invalidate();
    }

    void addNewItem(int n2, int n3) {
        f f2 = new f();
        f2.b = n2;
        f2.a = this.mAdapter.instantiateItem(this, n2);
        if (n3 < 0) {
            this.mItems.add(f2);
        } else {
            this.mItems.add(n3, f2);
        }
    }

    void dataSetChanged() {
        boolean bl = this.mItems.size() < 3 && this.mItems.size() < this.mAdapter.getCount();
        int n2 = -1;
        boolean bl2 = false;
        for (int i2 = 0; i2 < this.mItems.size(); ++i2) {
            f f2 = (f)this.mItems.get(i2);
            int n3 = this.mAdapter.getItemPosition(f2.a);
            if (n3 == -1) continue;
            if (n3 == -2) {
                this.mItems.remove(i2);
                --i2;
                if (!bl2) {
                    this.mAdapter.startUpdate(this);
                    bl2 = true;
                }
                this.mAdapter.destroyItem(this, f2.b, f2.a);
                bl = true;
                if (this.mCurItem != f2.b) continue;
                n2 = Math.max(0, Math.min(this.mCurItem, this.mAdapter.getCount() - 1));
                continue;
            }
            if (f2.b == n3) continue;
            if (f2.b == this.mCurItem) {
                n2 = n3;
            }
            f2.b = n3;
            bl = true;
        }
        if (bl2) {
            this.mAdapter.finishUpdate(this);
        }
        Collections.sort(this.mItems, COMPARATOR);
        if (n2 >= 0) {
            this.setCurrentItemInternal(n2, false, true);
            bl = true;
        }
        if (bl) {
            this.populate();
            this.requestLayout();
        }
    }

    void populate() {
        if (this.mAdapter == null) {
            return;
        }
        if (this.mPopulatePending) {
            return;
        }
        if (this.getWindowToken() == null) {
            return;
        }
        this.mAdapter.startUpdate(this);
        int n2 = this.mOffscreenPageLimit;
        int n3 = Math.max(0, this.mCurItem - n2);
        int n4 = this.mAdapter.getCount();
        int n5 = Math.min(n4 - 1, this.mCurItem + n2);
        int n6 = -1;
        for (int i2 = 0; i2 < this.mItems.size(); ++i2) {
            f f2 = (f)this.mItems.get(i2);
            if (!(f2.b >= n3 && f2.b <= n5 || f2.c)) {
                this.mItems.remove(i2);
                --i2;
                this.mAdapter.destroyItem(this, f2.b, f2.a);
            } else if (n6 < n5 && f2.b > n3) {
                if (++n6 < n3) {
                    n6 = n3;
                }
                while (n6 <= n5 && n6 < f2.b) {
                    this.addNewItem(n6, i2);
                    ++n6;
                    ++i2;
                }
            }
            n6 = f2.b;
        }
        int n7 = n6 = this.mItems.size() > 0 ? ((f)this.mItems.get((int)(this.mItems.size() - 1))).b : -1;
        if (n6 < n5) {
            int n8 = n6 = ++n6 > n3 ? n6 : n3;
            while (n6 <= n5) {
                this.addNewItem(n6, -1);
                ++n6;
            }
        }
        f f3 = null;
        for (int i3 = 0; i3 < this.mItems.size(); ++i3) {
            if (((f)this.mItems.get((int)i3)).b != this.mCurItem) continue;
            f3 = (f)this.mItems.get(i3);
            break;
        }
        this.mAdapter.setPrimaryItem(this, this.mCurItem, f3 != null ? f3.a : null);
        this.mAdapter.finishUpdate(this);
        if (this.hasFocus()) {
            f f4;
            View view = this.findFocus();
            f f5 = f4 = view != null ? this.infoForAnyChild(view) : null;
            if (f4 == null || f4.b != this.mCurItem) {
                View view2;
                for (int i4 = 0; !(i4 >= this.getChildCount() || (f4 = this.infoForChild(view2 = this.getChildAt(i4))) != null && f4.b == this.mCurItem && view2.requestFocus(2)); ++i4) {
                }
            }
        }
    }

    public Parcelable onSaveInstanceState() {
        Parcelable parcelable = super.onSaveInstanceState();
        j j2 = new j(parcelable);
        j2.a = this.mCurItem;
        if (this.mAdapter != null) {
            j2.b = this.mAdapter.saveState();
        }
        return j2;
    }

    public void onRestoreInstanceState(Parcelable parcelable) {
        if (!(parcelable instanceof j)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        j j2 = (j)parcelable;
        super.onRestoreInstanceState(j2.getSuperState());
        if (this.mAdapter != null) {
            this.mAdapter.restoreState(j2.b, j2.c);
            this.setCurrentItemInternal(j2.a, false, true);
        } else {
            this.mRestoredCurItem = j2.a;
            this.mRestoredAdapterState = j2.b;
            this.mRestoredClassLoader = j2.c;
        }
    }

    public void addView(View view, int n2, ViewGroup.LayoutParams layoutParams) {
        if (!this.checkLayoutParams(layoutParams)) {
            layoutParams = this.generateLayoutParams(layoutParams);
        }
        VerticalViewPager$LayoutParams verticalViewPager$LayoutParams = (VerticalViewPager$LayoutParams)layoutParams;
        verticalViewPager$LayoutParams.a |= view instanceof e;
        if (this.mInLayout) {
            if (verticalViewPager$LayoutParams != null && verticalViewPager$LayoutParams.a) {
                throw new IllegalStateException("Cannot add pager decor view during layout");
            }
            this.addViewInLayout(view, n2, layoutParams);
            view.measure(this.mChildWidthMeasureSpec, this.mChildHeightMeasureSpec);
        } else {
            super.addView(view, n2, layoutParams);
        }
    }

    f infoForChild(View view) {
        for (int i2 = 0; i2 < this.mItems.size(); ++i2) {
            f f2 = (f)this.mItems.get(i2);
            if (!this.mAdapter.isViewFromObject(view, f2.a)) continue;
            return f2;
        }
        return null;
    }

    f infoForAnyChild(View view) {
        ViewParent viewParent;
        while ((viewParent = view.getParent()) != this) {
            if (viewParent == null || !(viewParent instanceof View)) {
                return null;
            }
            view = (View)viewParent;
        }
        return this.infoForChild(view);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mFirstLayout = true;
    }

    protected void onMeasure(int n2, int n3) {
        VerticalViewPager$LayoutParams verticalViewPager$LayoutParams;
        View view;
        int n4;
        this.setMeasuredDimension(VerticalViewPager.getDefaultSize((int)0, (int)n2), VerticalViewPager.getDefaultSize((int)0, (int)n3));
        int n5 = this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight();
        int n6 = this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom();
        int n7 = this.getChildCount();
        for (n4 = 0; n4 < n7; ++n4) {
            boolean bl;
            view = this.getChildAt(n4);
            if (view.getVisibility() == 8 || (verticalViewPager$LayoutParams = (VerticalViewPager$LayoutParams)view.getLayoutParams()) == null || !verticalViewPager$LayoutParams.a) continue;
            int n8 = verticalViewPager$LayoutParams.b & 7;
            int n9 = verticalViewPager$LayoutParams.b & 0x70;
            Log.d((String)TAG, (String)("gravity: " + verticalViewPager$LayoutParams.b + " hgrav: " + n8 + " vgrav: " + n9));
            int n10 = Integer.MIN_VALUE;
            int n11 = Integer.MIN_VALUE;
            boolean bl2 = n9 == 48 || n9 == 80;
            boolean bl3 = bl = n8 == 3 || n8 == 5;
            if (bl2) {
                n10 = 0x40000000;
            } else if (bl) {
                n11 = 0x40000000;
            }
            int n12 = View.MeasureSpec.makeMeasureSpec((int)n5, (int)n10);
            int n13 = View.MeasureSpec.makeMeasureSpec((int)n6, (int)n11);
            view.measure(n12, n13);
            if (bl2) {
                n6 -= view.getMeasuredHeight();
                continue;
            }
            if (!bl) continue;
            n5 -= view.getMeasuredWidth();
        }
        this.mChildWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)n5, (int)0x40000000);
        this.mChildHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)n6, (int)0x40000000);
        this.mInLayout = true;
        this.populate();
        this.mInLayout = false;
        n7 = this.getChildCount();
        for (n4 = 0; n4 < n7; ++n4) {
            view = this.getChildAt(n4);
            if (view.getVisibility() == 8 || (verticalViewPager$LayoutParams = (VerticalViewPager$LayoutParams)view.getLayoutParams()) != null && verticalViewPager$LayoutParams.a) continue;
            view.measure(this.mChildWidthMeasureSpec, this.mChildHeightMeasureSpec);
        }
    }

    protected void onSizeChanged(int n2, int n3, int n4, int n5) {
        super.onSizeChanged(n2, n3, n4, n5);
        if (n3 != n5) {
            this.recomputeScrollPosition(n3, n5, this.mPageMargin, this.mPageMargin);
        }
    }

    private void recomputeScrollPosition(int n2, int n3, int n4, int n5) {
        int n6 = n2 + n4;
        if (n3 > 0) {
            int n7 = this.getScrollY();
            int n8 = n3 + n5;
            int n9 = n7 / n8;
            float f2 = (float)(n7 % n8) / (float)n8;
            int n10 = (int)(((float)n9 + f2) * (float)n6);
            this.scrollTo(this.getScrollX(), n10);
            if (!this.mScroller.isFinished()) {
                int n11 = this.mScroller.getDuration() - this.mScroller.timePassed();
                this.mScroller.startScroll(0, n10, this.mCurItem * n6, 0, n11);
            }
        } else {
            int n12 = this.mCurItem * n6;
            if (n12 != this.getScrollY()) {
                this.completeScroll();
                this.scrollTo(this.getScrollX(), n12);
            }
        }
    }

    protected void onLayout(boolean bl, int n2, int n3, int n4, int n5) {
        this.mInLayout = true;
        this.populate();
        this.mInLayout = false;
        int n6 = this.getChildCount();
        int n7 = n4 - n2;
        int n8 = n5 - n3;
        int n9 = this.getPaddingLeft();
        int n10 = this.getPaddingTop();
        int n11 = this.getPaddingRight();
        int n12 = this.getPaddingBottom();
        int n13 = this.getScrollY();
        int n14 = 0;
        for (int i2 = 0; i2 < n6; ++i2) {
            int n15;
            View view = this.getChildAt(i2);
            if (view.getVisibility() == 8) continue;
            VerticalViewPager$LayoutParams verticalViewPager$LayoutParams = (VerticalViewPager$LayoutParams)view.getLayoutParams();
            int n16 = 0;
            int n17 = 0;
            if (verticalViewPager$LayoutParams.a) {
                n15 = verticalViewPager$LayoutParams.b & 7;
                int n18 = verticalViewPager$LayoutParams.b & 0x70;
                switch (n15) {
                    default: {
                        n16 = n9;
                        break;
                    }
                    case 3: {
                        n16 = n9;
                        n9 += view.getMeasuredWidth();
                        break;
                    }
                    case 1: {
                        n16 = Math.max((n7 - view.getMeasuredWidth()) / 2, n9);
                        break;
                    }
                    case 5: {
                        n16 = n7 - n11 - view.getMeasuredWidth();
                        n11 += view.getMeasuredWidth();
                    }
                }
                switch (n18) {
                    default: {
                        n17 = n10;
                        break;
                    }
                    case 48: {
                        n17 = n10;
                        n10 += view.getMeasuredHeight();
                        break;
                    }
                    case 16: {
                        n17 = Math.max((n8 - view.getMeasuredHeight()) / 2, n10);
                        break;
                    }
                    case 80: {
                        n17 = n8 - n12 - view.getMeasuredHeight();
                        n12 += view.getMeasuredHeight();
                    }
                }
                ++n14;
                view.layout(n16, n17 += n13, n16 + view.getMeasuredWidth(), n17 + view.getMeasuredHeight());
                continue;
            }
            f f2 = this.infoForChild(view);
            if (f2 == null) continue;
            n15 = (n8 + this.mPageMargin) * f2.b;
            n16 = n9;
            n17 = n10 + n15;
            view.layout(n16, n17, n16 + view.getMeasuredWidth(), n17 + view.getMeasuredHeight());
        }
        this.mLeftPageBounds = n9;
        this.mRightPageBounds = n7 - n11;
        this.mDecorChildCount = n14;
        this.mFirstLayout = false;
    }

    public void computeScroll() {
        if (!this.mScroller.isFinished() && this.mScroller.computeScrollOffset()) {
            int n2 = this.getScrollX();
            int n3 = this.getScrollY();
            int n4 = this.mScroller.getCurrX();
            int n5 = this.mScroller.getCurrY();
            if (n2 != n4 || n3 != n5) {
                this.scrollTo(n4, n5);
                this.pageScrolled(n5);
            }
            this.invalidate();
            return;
        }
        this.completeScroll();
    }

    private void pageScrolled(int n2) {
        int n3 = this.getHeight() + this.mPageMargin;
        int n4 = n2 / n3;
        int n5 = n2 % n3;
        float f2 = (float)n5 / (float)n3;
        this.mCalledSuper = false;
        this.onPageScrolled(n4, f2, n5);
        if (!this.mCalledSuper) {
            throw new IllegalStateException("onPageScrolled did not call superclass implementation");
        }
    }

    protected void onPageScrolled(int n2, float f2, int n3) {
        if (this.mDecorChildCount > 0) {
            int n4 = this.getScrollY();
            int n5 = this.getPaddingTop();
            int n6 = this.getPaddingBottom();
            int n7 = this.getHeight();
            int n8 = this.getChildCount();
            for (int i2 = 0; i2 < n8; ++i2) {
                View view = this.getChildAt(i2);
                VerticalViewPager$LayoutParams verticalViewPager$LayoutParams = (VerticalViewPager$LayoutParams)view.getLayoutParams();
                if (!verticalViewPager$LayoutParams.a) continue;
                int n9 = verticalViewPager$LayoutParams.b & 0x70;
                int n10 = 0;
                switch (n9) {
                    default: {
                        n10 = n5;
                        break;
                    }
                    case 48: {
                        n10 = n5;
                        n5 += view.getHeight();
                        break;
                    }
                    case 1: {
                        n10 = Math.max((n7 - view.getMeasuredHeight()) / 2, n5);
                        break;
                    }
                    case 80: {
                        n10 = n7 - n6 - view.getMeasuredHeight();
                        n6 += view.getMeasuredHeight();
                    }
                }
                int n11 = (n10 += n4) - view.getTop();
                if (n11 == 0) continue;
                view.offsetTopAndBottom(n11);
            }
        }
        if (this.mOnPageChangeListener != null) {
            this.mOnPageChangeListener.a(n2, f2, n3);
        }
        if (this.mInternalPageChangeListener != null) {
            this.mInternalPageChangeListener.a(n2, f2, n3);
        }
        this.mCalledSuper = true;
    }

    private void completeScroll() {
        int n2;
        boolean bl = this.mScrolling;
        if (bl) {
            this.setScrollingCacheEnabled(false);
            this.mScroller.abortAnimation();
            n2 = this.getScrollX();
            int n3 = this.getScrollY();
            int n4 = this.mScroller.getCurrX();
            int n5 = this.mScroller.getCurrY();
            if (n2 != n4 || n3 != n5) {
                this.scrollTo(n4, n5);
            }
            this.setScrollState(0);
        }
        this.mPopulatePending = false;
        this.mScrolling = false;
        for (n2 = 0; n2 < this.mItems.size(); ++n2) {
            f f2 = (f)this.mItems.get(n2);
            if (!f2.c) continue;
            bl = true;
            f2.c = false;
        }
        if (bl) {
            this.populate();
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        int n2 = motionEvent.getAction() & 0xFF;
        if (n2 == 3 || n2 == 1) {
            this.mIsBeingDragged = false;
            this.mIsUnableToDrag = false;
            this.mActivePointerId = -1;
            if (this.mVelocityTracker != null) {
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
            }
            return false;
        }
        if (n2 != 0) {
            if (this.mIsBeingDragged) {
                return true;
            }
            if (this.mIsUnableToDrag) {
                return false;
            }
        }
        switch (n2) {
            case 2: {
                int n3 = this.mActivePointerId;
                if (n3 == -1) break;
                int n4 = MotionEventCompat.findPointerIndex((MotionEvent)motionEvent, (int)n3);
                float f2 = MotionEventCompat.getX((MotionEvent)motionEvent, (int)n4);
                float f3 = Math.abs(f2 - this.mLastMotionX);
                float f4 = MotionEventCompat.getY((MotionEvent)motionEvent, (int)n4);
                float f5 = f4 - this.mLastMotionY;
                float f6 = Math.abs(f5);
                if (this.canScroll((View)this, false, (int)f5, (int)f2, (int)f4)) {
                    this.mInitialMotionY = this.mLastMotionY = f4;
                    this.mLastMotionX = f2;
                    return false;
                }
                if (f6 > (float)this.mTouchSlop && f6 > f3) {
                    this.mIsBeingDragged = true;
                    this.setScrollState(1);
                    this.mLastMotionY = f4;
                    this.setScrollingCacheEnabled(true);
                    break;
                }
                if (!(f3 > (float)this.mTouchSlop)) break;
                this.mIsUnableToDrag = true;
                break;
            }
            case 0: {
                this.mLastMotionX = motionEvent.getX();
                this.mLastMotionY = this.mInitialMotionY = motionEvent.getY();
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)motionEvent, (int)0);
                if (this.mScrollState == 2) {
                    this.mIsBeingDragged = true;
                    this.mIsUnableToDrag = false;
                    this.setScrollState(1);
                    break;
                }
                this.completeScroll();
                this.mIsBeingDragged = false;
                this.mIsUnableToDrag = false;
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(motionEvent);
            }
        }
        if (!this.mIsBeingDragged) {
            if (this.mVelocityTracker == null) {
                this.mVelocityTracker = VelocityTracker.obtain();
            }
            this.mVelocityTracker.addMovement(motionEvent);
        }
        return this.mIsBeingDragged;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.mFakeDragging) {
            return true;
        }
        if (motionEvent.getAction() == 0 && motionEvent.getEdgeFlags() != 0) {
            return false;
        }
        if (this.mAdapter == null || this.mAdapter.getCount() == 0) {
            return false;
        }
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(motionEvent);
        int n2 = motionEvent.getAction();
        boolean bl = false;
        switch (n2 & 0xFF) {
            case 0: {
                this.completeScroll();
                this.mLastMotionY = this.mInitialMotionY = motionEvent.getY();
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)motionEvent, (int)0);
                break;
            }
            case 2: {
                float f2;
                float f3;
                float f4;
                float f5;
                int n3;
                if (!this.mIsBeingDragged) {
                    n3 = MotionEventCompat.findPointerIndex((MotionEvent)motionEvent, (int)this.mActivePointerId);
                    f5 = MotionEventCompat.getX((MotionEvent)motionEvent, (int)n3);
                    f4 = Math.abs(f5 - this.mLastMotionX);
                    f3 = MotionEventCompat.getY((MotionEvent)motionEvent, (int)n3);
                    f2 = Math.abs(f3 - this.mLastMotionY);
                    if (f2 > (float)this.mTouchSlop && f2 > f4) {
                        this.mIsBeingDragged = true;
                        this.mLastMotionY = f3;
                        this.setScrollState(1);
                        this.setScrollingCacheEnabled(true);
                    }
                }
                if (!this.mIsBeingDragged) break;
                n3 = MotionEventCompat.findPointerIndex((MotionEvent)motionEvent, (int)this.mActivePointerId);
                f5 = MotionEventCompat.getY((MotionEvent)motionEvent, (int)n3);
                f4 = this.mLastMotionY - f5;
                this.mLastMotionY = f5;
                f3 = this.getScrollY();
                f2 = f3 + f4;
                int n4 = this.getHeight();
                int n5 = n4 + this.mPageMargin;
                int n6 = this.mAdapter.getCount() - 1;
                float f6 = Math.max(0, (this.mCurItem - 1) * n5);
                float f7 = Math.min(this.mCurItem + 1, n6) * n5;
                if (f2 < f6) {
                    if (f6 == 0.0f) {
                        float f8 = -f2;
                        bl = this.mTopEdge.onPull(f8 / (float)n4);
                    }
                    f2 = f6;
                } else if (f2 > f7) {
                    if (f7 == (float)(n6 * n5)) {
                        float f9 = f2 - f7;
                        bl = this.mBottomEdge.onPull(f9 / (float)n4);
                    }
                    f2 = f7;
                }
                this.mLastMotionY += f2 - (float)((int)f2);
                this.scrollTo(this.getScrollX(), (int)f2);
                this.pageScrolled((int)f2);
                break;
            }
            case 1: {
                if (!this.mIsBeingDragged) break;
                VelocityTracker velocityTracker = this.mVelocityTracker;
                velocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                int n7 = (int)VelocityTrackerCompat.getYVelocity((VelocityTracker)velocityTracker, (int)this.mActivePointerId);
                this.mPopulatePending = true;
                int n8 = this.getHeight() + this.mPageMargin;
                int n9 = this.getScrollY();
                int n10 = n9 / n8;
                float f10 = (float)(n9 % n8) / (float)n8;
                int n11 = MotionEventCompat.findPointerIndex((MotionEvent)motionEvent, (int)this.mActivePointerId);
                float f11 = MotionEventCompat.getY((MotionEvent)motionEvent, (int)n11);
                int n12 = (int)(f11 - this.mInitialMotionY);
                int n13 = this.determineTargetPage(n10, f10, n7, n12);
                this.setCurrentItemInternal(n13, true, true, n7);
                this.mActivePointerId = -1;
                this.endDrag();
                bl = this.mTopEdge.onRelease() | this.mBottomEdge.onRelease();
                break;
            }
            case 3: {
                if (!this.mIsBeingDragged) break;
                this.setCurrentItemInternal(this.mCurItem, true, true);
                this.mActivePointerId = -1;
                this.endDrag();
                bl = this.mTopEdge.onRelease() | this.mBottomEdge.onRelease();
                break;
            }
            case 5: {
                float f12;
                int n14 = MotionEventCompat.getActionIndex((MotionEvent)motionEvent);
                this.mLastMotionY = f12 = MotionEventCompat.getY((MotionEvent)motionEvent, (int)n14);
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)motionEvent, (int)n14);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(motionEvent);
                this.mLastMotionY = MotionEventCompat.getY((MotionEvent)motionEvent, (int)MotionEventCompat.findPointerIndex((MotionEvent)motionEvent, (int)this.mActivePointerId));
            }
        }
        if (bl) {
            this.invalidate();
        }
        return true;
    }

    private int determineTargetPage(int n2, float f2, int n3, int n4) {
        int n5 = Math.abs(n4) > this.mFlingDistance && Math.abs(n3) > this.mMinimumVelocity ? (n3 > 0 ? n2 : n2 + 1) : (int)((float)n2 + f2 + 0.5f);
        return n5;
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        boolean bl = false;
        int n2 = ViewCompat.getOverScrollMode((View)this);
        if (n2 == 0 || n2 == 1 && this.mAdapter != null && this.mAdapter.getCount() > 1) {
            int n3;
            int n4;
            if (!this.mTopEdge.isFinished()) {
                n4 = canvas.save();
                n3 = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
                canvas.rotate(270.0f);
                canvas.translate((float)(-n3 + this.getPaddingLeft()), 0.0f);
                this.mTopEdge.setSize(n3, this.getHeight());
                bl |= this.mTopEdge.draw(canvas);
                canvas.restoreToCount(n4);
            }
            if (!this.mBottomEdge.isFinished()) {
                n4 = canvas.save();
                n3 = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
                int n5 = this.getHeight();
                int n6 = this.mAdapter != null ? this.mAdapter.getCount() : 1;
                canvas.rotate(180.0f);
                canvas.translate((float)(-n3 + this.getPaddingLeft()), (float)(-n6 * (n5 + this.mPageMargin) + this.mPageMargin));
                this.mBottomEdge.setSize(n3, n5);
                bl |= this.mBottomEdge.draw(canvas);
                canvas.restoreToCount(n4);
            }
        } else {
            this.mTopEdge.finish();
            this.mBottomEdge.finish();
        }
        if (bl) {
            this.invalidate();
        }
    }

    protected void onDraw(Canvas canvas) {
        int n2;
        int n3;
        int n4;
        super.onDraw(canvas);
        if (this.mPageMargin > 0 && this.mMarginDrawable != null && (n4 = (n3 = this.getScrollY()) % ((n2 = this.getHeight()) + this.mPageMargin)) != 0) {
            int n5 = n3 - n4 + n2;
            this.mMarginDrawable.setBounds(this.mLeftPageBounds, n5, this.mRightPageBounds, n5 + this.mPageMargin);
            this.mMarginDrawable.draw(canvas);
        }
    }

    public boolean beginFakeDrag() {
        if (this.mIsBeingDragged) {
            return false;
        }
        this.mFakeDragging = true;
        this.setScrollState(1);
        this.mLastMotionY = 0.0f;
        this.mInitialMotionY = 0.0f;
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        } else {
            this.mVelocityTracker.clear();
        }
        long l2 = SystemClock.uptimeMillis();
        MotionEvent motionEvent = MotionEvent.obtain((long)l2, (long)l2, (int)0, (float)0.0f, (float)0.0f, (int)0);
        this.mVelocityTracker.addMovement(motionEvent);
        motionEvent.recycle();
        this.mFakeDragBeginTime = l2;
        return true;
    }

    public void endFakeDrag() {
        if (!this.mFakeDragging) {
            throw new IllegalStateException("No fake drag in progress. Call beginFakeDrag first.");
        }
        VelocityTracker velocityTracker = this.mVelocityTracker;
        velocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
        int n2 = (int)VelocityTrackerCompat.getXVelocity((VelocityTracker)velocityTracker, (int)this.mActivePointerId);
        this.mPopulatePending = true;
        int n3 = (int)(this.mLastMotionY - this.mInitialMotionY);
        int n4 = this.getScrollY();
        int n5 = this.getHeight() + this.mPageMargin;
        int n6 = n4 / n5;
        float f2 = (float)(n4 % n5) / (float)n5;
        int n7 = this.determineTargetPage(n6, f2, n2, n3);
        this.setCurrentItemInternal(n7, true, true, n2);
        this.endDrag();
        this.mFakeDragging = false;
    }

    public void fakeDragBy(float f2) {
        if (!this.mFakeDragging) {
            throw new IllegalStateException("No fake drag in progress. Call beginFakeDrag first.");
        }
        this.mLastMotionY += f2;
        float f3 = (float)this.getScrollY() - f2;
        int n2 = this.getHeight();
        int n3 = n2 + this.mPageMargin;
        float f4 = Math.max(0, (this.mCurItem - 1) * n3);
        float f5 = Math.min(this.mCurItem + 1, this.mAdapter.getCount() - 1) * n3;
        if (f3 < f4) {
            f3 = f4;
        } else if (f3 > f5) {
            f3 = f5;
        }
        this.mLastMotionY += f3 - (float)((int)f3);
        this.scrollTo(this.getScrollX(), (int)f3);
        this.pageScrolled((int)f3);
        long l2 = SystemClock.uptimeMillis();
        MotionEvent motionEvent = MotionEvent.obtain((long)this.mFakeDragBeginTime, (long)l2, (int)2, (float)0.0f, (float)this.mLastMotionY, (int)0);
        this.mVelocityTracker.addMovement(motionEvent);
        motionEvent.recycle();
    }

    public boolean isFakeDragging() {
        return this.mFakeDragging;
    }

    private void onSecondaryPointerUp(MotionEvent motionEvent) {
        int n2 = MotionEventCompat.getActionIndex((MotionEvent)motionEvent);
        int n3 = MotionEventCompat.getPointerId((MotionEvent)motionEvent, (int)n2);
        if (n3 == this.mActivePointerId) {
            int n4 = n2 == 0 ? 1 : 0;
            this.mLastMotionY = MotionEventCompat.getY((MotionEvent)motionEvent, (int)n4);
            this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)motionEvent, (int)n4);
            if (this.mVelocityTracker != null) {
                this.mVelocityTracker.clear();
            }
        }
    }

    private void endDrag() {
        this.mIsBeingDragged = false;
        this.mIsUnableToDrag = false;
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    private void setScrollingCacheEnabled(boolean bl) {
        if (this.mScrollingCacheEnabled != bl) {
            this.mScrollingCacheEnabled = bl;
        }
    }

    protected boolean canScroll(View view, boolean bl, int n2, int n3, int n4) {
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int n5 = view.getScrollX();
            int n6 = view.getScrollY();
            int n7 = viewGroup.getChildCount();
            for (int i2 = n7 - 1; i2 >= 0; --i2) {
                View view2 = viewGroup.getChildAt(i2);
                if (n3 + n5 < view2.getLeft() || n3 + n5 >= view2.getRight() || n4 + n6 < view2.getTop() || n4 + n6 >= view2.getBottom() || !this.canScroll(view2, true, n2, n3 + n5 - view2.getLeft(), n4 + n6 - view2.getTop())) continue;
                return true;
            }
        }
        return bl && ViewCompat.canScrollVertically((View)view, (int)(-n2));
    }

    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        return super.dispatchKeyEvent(keyEvent) || this.executeKeyEvent(keyEvent);
    }

    public boolean executeKeyEvent(KeyEvent keyEvent) {
        boolean bl = false;
        if (keyEvent.getAction() == 0) {
            switch (keyEvent.getKeyCode()) {
                case 19: {
                    bl = this.arrowScroll(33);
                    break;
                }
                case 20: {
                    bl = this.arrowScroll(130);
                    break;
                }
                case 61: {
                    if (Build.VERSION.SDK_INT < 11) break;
                    if (KeyEventCompat.hasNoModifiers((KeyEvent)keyEvent)) {
                        bl = this.arrowScroll(2);
                        break;
                    }
                    if (!KeyEventCompat.hasModifiers((KeyEvent)keyEvent, (int)1)) break;
                    bl = this.arrowScroll(1);
                }
            }
        }
        return bl;
    }

    public boolean arrowScroll(int n2) {
        View view = this.findFocus();
        if (view == this) {
            view = null;
        }
        boolean bl = false;
        View view2 = FocusFinder.getInstance().findNextFocus((ViewGroup)this, view, n2);
        if (view2 != null && view2 != view) {
            if (n2 == 33) {
                bl = view != null && view2.getTop() >= view.getTop() ? this.pageUp() : view2.requestFocus();
            } else if (n2 == 130) {
                bl = view != null && view2.getTop() <= view.getTop() ? this.pageDown() : view2.requestFocus();
            }
        } else if (n2 == 33 || n2 == 1) {
            bl = this.pageUp();
        } else if (n2 == 130 || n2 == 2) {
            bl = this.pageDown();
        }
        if (bl) {
            this.playSoundEffect(SoundEffectConstants.getContantForFocusDirection((int)n2));
        }
        return bl;
    }

    boolean pageUp() {
        if (this.mCurItem > 0) {
            this.setCurrentItem(this.mCurItem - 1, true);
            return true;
        }
        return false;
    }

    boolean pageDown() {
        if (this.mAdapter != null && this.mCurItem < this.mAdapter.getCount() - 1) {
            this.setCurrentItem(this.mCurItem + 1, true);
            return true;
        }
        return false;
    }

    public void addFocusables(ArrayList arrayList, int n2, int n3) {
        int n4 = arrayList.size();
        int n5 = this.getDescendantFocusability();
        if (n5 != 393216) {
            for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
                f f2;
                View view = this.getChildAt(i2);
                if (view.getVisibility() != 0 || (f2 = this.infoForChild(view)) == null || f2.b != this.mCurItem) continue;
                view.addFocusables(arrayList, n2, n3);
            }
        }
        if (n5 != 262144 || n4 == arrayList.size()) {
            if (!this.isFocusable()) {
                return;
            }
            if ((n3 & 1) == 1 && this.isInTouchMode() && !this.isFocusableInTouchMode()) {
                return;
            }
            if (arrayList != null) {
                arrayList.add(this);
            }
        }
    }

    public void addTouchables(ArrayList arrayList) {
        for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
            f f2;
            View view = this.getChildAt(i2);
            if (view.getVisibility() != 0 || (f2 = this.infoForChild(view)) == null || f2.b != this.mCurItem) continue;
            view.addTouchables(arrayList);
        }
    }

    protected boolean onRequestFocusInDescendants(int n2, Rect rect) {
        int n3;
        int n4;
        int n5;
        int n6 = this.getChildCount();
        if ((n2 & 2) != 0) {
            n5 = 0;
            n4 = 1;
            n3 = n6;
        } else {
            n5 = n6 - 1;
            n4 = -1;
            n3 = -1;
        }
        for (int i2 = n5; i2 != n3; i2 += n4) {
            f f2;
            View view = this.getChildAt(i2);
            if (view.getVisibility() != 0 || (f2 = this.infoForChild(view)) == null || f2.b != this.mCurItem || !view.requestFocus(n2, rect)) continue;
            return true;
        }
        return false;
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        int n2 = this.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            f f2;
            View view = this.getChildAt(i2);
            if (view.getVisibility() != 0 || (f2 = this.infoForChild(view)) == null || f2.b != this.mCurItem || !view.dispatchPopulateAccessibilityEvent(accessibilityEvent)) continue;
            return true;
        }
        return false;
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new VerticalViewPager$LayoutParams();
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return this.generateDefaultLayoutParams();
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof VerticalViewPager$LayoutParams && super.checkLayoutParams(layoutParams);
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new VerticalViewPager$LayoutParams(this.getContext(), attributeSet);
    }

    static /* synthetic */ int[] access$100() {
        return LAYOUT_ATTRS;
    }
}

