/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.tools.rewrite;

import com.xk72.charles.gui.lib.FormUtils;
import com.xk72.charles.gui.settings.SettingsException;
import com.xk72.charles.gui.settings.SettingsPanel;
import com.xk72.charles.tools.rewrite.RewriteRule;
import com.xk72.charles.tools.rewrite.e;
import com.xk72.charles.tools.rewrite.f;
import com.xk72.charles.tools.rewrite.g;
import com.xk72.charles.tools.rewrite.h;
import com.xk72.charles.tools.rewrite.i;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.io.Serializable;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;

class RewriteRulePanel
extends SettingsPanel {
    private final JCheckBox whereRequest;
    private final JCheckBox whereResponse;
    private final JRadioButton replaceFirst;
    private final JRadioButton replaceAll;
    private final JCheckBox regexHeader;
    private final JCheckBox regexValue;
    private final JCheckBox matchWholeValue;
    private final JCheckBox caseSensitive;
    private final JTextField matchHeader;
    private final JTextField matchValue;
    private final JTextField newHeader;
    private final JTextField newValue;
    private final JComboBox ruleType;
    private RewriteRule rule;
    private final JTextArea matchHelp;

    public RewriteRulePanel() {
        super("Rewrite Rule");
        Object object;
        this.setHelp(this.ctx.getBundle().getString("tools.Rewrite.editor.help"));
        this.ruleType = new JComboBox();
        String[] stringArray = RewriteRule.getRuleTypeNames();
        Object object2 = stringArray;
        object2 = stringArray;
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            object = object2[i2];
            this.ruleType.addItem(object);
        }
        this.whereRequest = new JCheckBox("Request");
        this.whereResponse = new JCheckBox("Response");
        object2 = new JLabel("Name:");
        this.matchHeader = new JTextField();
        this.matchValue = new JTextField();
        this.regexHeader = new JCheckBox("Regex");
        this.regexValue = new JCheckBox("Regex");
        this.matchWholeValue = new JCheckBox("Match whole value");
        this.caseSensitive = new JCheckBox("Case sensitive");
        this.matchHelp = FormUtils.f("");
        this.matchHelp.setForeground(Color.red);
        this.matchHelp.setVisible(false);
        JLabel jLabel = new JLabel("Name:");
        this.newHeader = new JTextField();
        this.newValue = new JTextField();
        Serializable serializable = new ButtonGroup();
        this.replaceFirst = new JRadioButton("Replace First");
        this.replaceAll = new JRadioButton("Replace All");
        ((ButtonGroup)serializable).add(this.replaceFirst);
        ((ButtonGroup)serializable).add(this.replaceAll);
        this.replaceAll.setSelected(true);
        this.matchHeader.getDocument().addDocumentListener(new e(this));
        this.matchValue.getDocument().addDocumentListener(new f(this));
        this.regexHeader.addItemListener(new g(this));
        this.regexValue.addItemListener(new h(this));
        this.setLayout(FormUtils.e());
        object = new JPanel((LayoutManager)new MigLayout("wrap,fill", "[][fill,grow]"));
        ((Container)object).add((Component)new JLabel("Type:"), "label");
        ((Container)object).add(this.ruleType);
        serializable = new JPanel((LayoutManager)new MigLayout("fill"));
        ((JComponent)serializable).setBorder(FormUtils.a("Where"));
        ((Container)serializable).add(this.whereRequest);
        ((Container)serializable).add(this.whereResponse);
        ((Container)object).add((Component)serializable, "span,grow");
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("wrap,fill", "[label][fill,grow][]"));
        jPanel.setBorder(FormUtils.a("Match"));
        jPanel.add((Component)FormUtils.c("Enter text to match or leave blank to match all."), "left,span,grow");
        jPanel.add((Component)object2);
        jPanel.add((Component)this.matchHeader, "width 200lp");
        jPanel.add(this.regexHeader);
        jPanel.add(new JLabel("Value:"));
        jPanel.add(this.matchValue);
        jPanel.add(this.regexValue);
        jPanel.add((Component)this.matchWholeValue, "skip 1,split 2,span");
        jPanel.add(this.caseSensitive);
        jPanel.add((Component)this.matchHelp, "left,span,grow");
        ((Container)object).add((Component)jPanel, "span,grow");
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("wrap,fill", "[label][fill,grow]"));
        jPanel2.setBorder(FormUtils.a("Replace"));
        jPanel2.add(jLabel);
        jPanel2.add(this.newHeader);
        jPanel2.add(new JLabel("Value:"));
        jPanel2.add(this.newValue);
        jPanel2.add((Component)this.replaceFirst, "skip 1,split 2,span");
        jPanel2.add(this.replaceAll);
        jPanel2.add((Component)FormUtils.c("Enter new values or leave blank for no change. If using regex matches you may enter references to groups, eg. $1"), "left,span,grow");
        ((Container)object).add((Component)jPanel2, "span,grow");
        this.add((Component)object);
        this.ruleType.addItemListener(new i(this, (JPanel)serializable, jPanel, jPanel2, (JLabel)object2, jLabel));
    }

    private void a() {
        if (this.regexHeader.isSelected()) {
            try {
                Pattern.compile(this.matchHeader.getText());
                this.matchHelp.setText(null);
                this.matchHelp.setVisible(false);
                return;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                this.matchHelp.setText(patternSyntaxException.getMessage());
                this.matchHelp.setVisible(true);
                return;
            }
        }
        this.matchHelp.setText(null);
        this.matchHelp.setVisible(false);
    }

    private void b() {
        if (this.regexValue.isSelected()) {
            try {
                Pattern.compile(this.matchValue.getText());
                this.matchHelp.setText(null);
                this.matchHelp.setVisible(false);
                return;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                this.matchHelp.setText(patternSyntaxException.getMessage());
                this.matchHelp.setVisible(true);
                return;
            }
        }
        this.matchHelp.setText(null);
        this.matchHelp.setVisible(false);
    }

    @Override
    public boolean preSave() {
        if (RewriteRule.ruleNameToType((String)this.ruleType.getSelectedItem()) == -1) {
            throw new SettingsException("Type", "Please choose the rule type");
        }
        if (this.regexHeader.isSelected()) {
            try {
                Pattern.compile(this.matchHeader.getText());
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new SettingsException("Match Header", "Invalid regular expression");
            }
        }
        if (this.regexValue.isSelected()) {
            try {
                Pattern.compile(this.matchValue.getText());
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new SettingsException("Match Value", "Invalid regular expression");
            }
        }
        return super.preSave();
    }

    @Override
    public boolean save() {
        this.rule.setRuleType(RewriteRule.ruleNameToType((String)this.ruleType.getSelectedItem()));
        this.rule.setMatchRequest(this.whereRequest.isEnabled() && this.whereRequest.isSelected());
        this.rule.setMatchResponse(this.whereResponse.isEnabled() && this.whereResponse.isSelected());
        this.rule.setMatchHeader(this.matchHeader.isEnabled() ? this.matchHeader.getText() : null);
        this.rule.setMatchValue(this.matchValue.isEnabled() ? this.matchValue.getText() : null);
        this.rule.setNewHeader(this.newHeader.isEnabled() ? this.newHeader.getText() : null);
        this.rule.setNewValue(this.newValue.isEnabled() ? this.newValue.getText() : null);
        this.rule.setMatchHeaderRegex(this.regexHeader.isEnabled() && this.regexHeader.isSelected());
        this.rule.setMatchValueRegex(this.regexValue.isEnabled() && this.regexValue.isSelected());
        this.rule.setMatchWholeValue(this.matchWholeValue.isEnabled() && this.matchWholeValue.isSelected());
        this.rule.setCaseSensitive(this.caseSensitive.isEnabled() && this.caseSensitive.isSelected());
        int n2 = this.replaceFirst.isEnabled() && this.replaceFirst.isSelected() ? 1 : 2;
        this.rule.setReplaceType(n2);
        return true;
    }

    public void setRule(RewriteRule rewriteRule) {
        this.rule = rewriteRule;
        this.ruleType.setSelectedItem(RewriteRule.ruleTypeToName(rewriteRule.getRuleType()));
        this.whereRequest.setSelected(rewriteRule.isMatchRequest());
        this.whereResponse.setSelected(rewriteRule.isMatchResponse());
        this.matchHeader.setText(rewriteRule.getMatchHeader());
        this.matchValue.setText(rewriteRule.getMatchValue());
        this.newHeader.setText(rewriteRule.getNewHeader());
        this.newValue.setText(rewriteRule.getNewValue());
        this.regexHeader.setSelected(rewriteRule.isMatchHeaderRegex());
        this.regexValue.setSelected(rewriteRule.isMatchValueRegex());
        this.matchWholeValue.setSelected(rewriteRule.isMatchWholeValue());
        this.caseSensitive.setSelected(rewriteRule.isCaseSensitive());
        this.replaceAll.setSelected(rewriteRule.getReplaceType() == 2);
        this.replaceFirst.setSelected(rewriteRule.getReplaceType() == 1);
    }

    public RewriteRule getRule() {
        return this.rule;
    }

    private void a(JPanel componentArray, boolean bl) {
        componentArray.setEnabled(bl);
        Component[] componentArray2 = componentArray.getComponents();
        componentArray = componentArray2;
        componentArray = componentArray2;
        int n2 = componentArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Component component = componentArray[i2];
            component.setEnabled(bl);
            if (!(component instanceof JPanel)) continue;
            this.a((JPanel)component, bl);
        }
    }

    static /* synthetic */ void a(RewriteRulePanel rewriteRulePanel) {
        if (rewriteRulePanel.regexHeader.isSelected()) {
            try {
                Pattern.compile(rewriteRulePanel.matchHeader.getText());
                rewriteRulePanel.matchHelp.setText(null);
                rewriteRulePanel.matchHelp.setVisible(false);
                return;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                rewriteRulePanel.matchHelp.setText(patternSyntaxException.getMessage());
                rewriteRulePanel.matchHelp.setVisible(true);
                return;
            }
        }
        rewriteRulePanel.matchHelp.setText(null);
        rewriteRulePanel.matchHelp.setVisible(false);
    }

    static /* synthetic */ void b(RewriteRulePanel rewriteRulePanel) {
        if (rewriteRulePanel.regexValue.isSelected()) {
            try {
                Pattern.compile(rewriteRulePanel.matchValue.getText());
                rewriteRulePanel.matchHelp.setText(null);
                rewriteRulePanel.matchHelp.setVisible(false);
                return;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                rewriteRulePanel.matchHelp.setText(patternSyntaxException.getMessage());
                rewriteRulePanel.matchHelp.setVisible(true);
                return;
            }
        }
        rewriteRulePanel.matchHelp.setText(null);
        rewriteRulePanel.matchHelp.setVisible(false);
    }

    static /* synthetic */ void a(RewriteRulePanel rewriteRulePanel, JPanel jPanel, boolean bl) {
        rewriteRulePanel.a(jPanel, bl);
    }

    static /* synthetic */ JTextField c(RewriteRulePanel rewriteRulePanel) {
        return rewriteRulePanel.matchHeader;
    }

    static /* synthetic */ JCheckBox d(RewriteRulePanel rewriteRulePanel) {
        return rewriteRulePanel.regexHeader;
    }

    static /* synthetic */ JTextField e(RewriteRulePanel rewriteRulePanel) {
        return rewriteRulePanel.newHeader;
    }
}

