/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.lib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;

public class SortedArrayList<E>
extends ArrayList<E> {
    private final Comparator<E> comparator;

    public SortedArrayList(Comparator<E> comparator) {
        this.comparator = comparator;
    }

    public Comparator<E> getComparator() {
        return this.comparator;
    }

    @Override
    public boolean add(E e2) {
        this.addSorted(e2);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        boolean bl = super.addAll(collection);
        if (bl) {
            Collections.sort(this, this.comparator);
        }
        return bl;
    }

    public int addSorted(E e2) {
        int n2 = this.a(e2, false);
        this.add(n2, e2);
        return n2;
    }

    @Override
    public boolean remove(Object object) {
        return this.remove(this.indexOf(object)) != null;
    }

    public int removeSorted(Object object) {
        int n2 = this.indexOf(object);
        if (n2 != -1) {
            this.remove(n2);
            return n2;
        }
        return -1;
    }

    @Override
    public int indexOf(Object object) {
        return this.a(object, true);
    }

    private int a(E e2, boolean n2) {
        int n3 = 0;
        int n4 = this.size();
        while (n3 < n4) {
            int n5 = n3 + (n4 - n3) / 2;
            Object e3 = this.get(n5);
            int n6 = this.comparator.compare(e2, e3);
            if (n6 < 0) {
                n4 = n5;
                continue;
            }
            if (n6 > 0) {
                n3 = n5 + 1;
                continue;
            }
            if (n2 != 0) {
                for (n2 = n3; n2 < n4; ++n2) {
                    Object e4 = this.get(n2);
                    if (!e4.equals(e2)) continue;
                    return n2;
                }
                return -1;
            }
            return n5;
        }
        if (n2 != 0) {
            return -1;
        }
        return n3;
    }
}

