/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.lib;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.xk72.charles.lib.IPRange$IPRangeFormatException;
import com.xk72.util.F;
import com.xk72.util.G;
import com.xk72.util.n;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.StringTokenizer;

@XStreamAlias(value="ipRange")
@F
@G
public class IPRange
implements n {
    private int[] ip;
    private int[] mask;

    public IPRange() {
    }

    public IPRange(String string) {
        Object object = new StringTokenizer(string, "/");
        int n2 = ((StringTokenizer)object).countTokens();
        int[] nArray = IPRange.ipToBytes(((StringTokenizer)object).nextToken());
        object = n2 == 2 ? (Object)IPRange.maskToBytes(((StringTokenizer)object).nextToken()) : (Object)IPRange.maskToBytes("32");
        if (nArray == null || object == null) {
            throw new IPRange$IPRangeFormatException(string);
        }
        this.setIp(nArray);
        this.setMask((int[])object);
    }

    public static IPRange parseRange(String string) {
        return new IPRange(string);
    }

    @Override
    public IPRange clone() {
        try {
            IPRange iPRange = (IPRange)super.clone();
            iPRange.setIp(Arrays.copyOf(this.ip, this.ip.length));
            iPRange.setMask(Arrays.copyOf(this.mask, this.mask.length));
            return iPRange;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean match(IPRange object) {
        object = ((IPRange)object).getIp();
        for (int i2 = 0; i2 < 4; ++i2) {
            if ((this.ip[i2] & this.mask[i2]) == (object[i2] & this.mask[i2])) continue;
            return false;
        }
        return true;
    }

    public boolean match(InetAddress object) {
        object = ((InetAddress)object).getAddress();
        for (int i2 = 0; i2 < 4; ++i2) {
            if (this.ip[i2] == (object[i2] & this.mask[i2])) continue;
            return false;
        }
        return true;
    }

    private static int[] ipToBytes(String object) {
        if (((StringTokenizer)(object = new StringTokenizer((String)object, "."))).countTokens() != 4) {
            return null;
        }
        int[] nArray = new int[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            nArray[i2] = Integer.parseInt(((StringTokenizer)object).nextToken());
        }
        return nArray;
    }

    private static int maskBytesToMask(int[] nArray) {
        long l2 = 0L;
        int n2 = nArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = nArray[i2];
            l2 <<= 8;
            l2 += (long)n3;
        }
        int n4 = 0;
        for (n2 = 32; n2 > 0; --n2) {
            if ((l2 & 1L) == 1L) {
                if (n4 == 0) {
                    n4 = n2;
                }
            } else if (n4 != 0) {
                return -1;
            }
            l2 >>>= 1;
        }
        return n4;
    }

    private static int[] maskToBytes(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n2 = stringTokenizer.countTokens();
        if (n2 == 4) {
            int[] nArray = new int[4];
            for (int i2 = 0; i2 < 4; ++i2) {
                nArray[i2] = Integer.parseInt(stringTokenizer.nextToken());
            }
            return nArray;
        }
        if (n2 == 1) {
            int[] nArray = new int[4];
            int n3 = Integer.parseInt(string);
            nArray[0] = n3 >= 8 ? 255 : (int)(256.0 - Math.pow(2.0, 8 - n3));
            if (n3 >= 16) {
                nArray[1] = 255;
            } else if (n3 > 8) {
                nArray[1] = (int)(256.0 - Math.pow(2.0, 16 - n3));
            }
            if (n3 >= 24) {
                nArray[2] = 255;
            } else if (n3 > 16) {
                nArray[2] = (int)(256.0 - Math.pow(2.0, 24 - n3));
            }
            if (n3 >= 32) {
                nArray[3] = 255;
            } else if (n3 > 24) {
                nArray[3] = (int)(256.0 - Math.pow(2.0, 32 - n3));
            }
            return nArray;
        }
        return null;
    }

    public void setIp(int[] nArray) {
        this.ip = nArray;
    }

    public void setMask(int[] nArray) {
        this.mask = nArray;
    }

    public int[] getIp() {
        return this.ip;
    }

    public int[] getMask() {
        return this.mask;
    }

    public String toString() {
        if (this.ip != null && this.mask != null) {
            int n2;
            StringBuffer stringBuffer = new StringBuffer();
            for (n2 = 0; n2 < this.ip.length; ++n2) {
                stringBuffer.append(this.ip[n2]);
                if (n2 >= this.ip.length - 1) continue;
                stringBuffer.append('.');
            }
            n2 = IPRange.maskBytesToMask(this.mask);
            if (n2 != -1) {
                if (n2 != 32) {
                    stringBuffer.append('/');
                    stringBuffer.append(n2);
                }
            } else {
                stringBuffer.append('/');
                for (n2 = 0; n2 < this.mask.length; ++n2) {
                    stringBuffer.append(this.mask[n2]);
                    if (n2 >= this.mask.length - 1) continue;
                    stringBuffer.append('.');
                }
            }
            return stringBuffer.toString();
        }
        return "0.0.0.0/0";
    }
}

