/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.gui.settings;

import com.xk72.charles.config.AbstractConfiguration;
import com.xk72.charles.config.ProtobufConfiguration;
import com.xk72.charles.config.UserInterfaceConfiguration;
import com.xk72.charles.gui.lib.EnableAwareJLabel;
import com.xk72.charles.gui.lib.FormUtils;
import com.xk72.charles.gui.settings.M;
import com.xk72.charles.gui.settings.SettingsException;
import com.xk72.charles.gui.settings.SettingsPanel;
import com.xk72.charles.gui.settings.ViewersSettingsPanel$1;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;

public class ViewersSettingsPanel
extends SettingsPanel {
    private final JCheckBox bShowLineNumbers = new JCheckBox("Show line numbers");
    private final JCheckBox bLineWrap = new JCheckBox("Line wrap");
    private final JRadioButton rSessionNavStructureHorizontal = new JRadioButton("Tall");
    private final JRadioButton rSessionNavStructureVertical = new JRadioButton("Wide");
    private final JRadioButton rSessionNavSequenceVertical = new JRadioButton("Wide");
    private final JCheckBox bCombineHeadersAndBodyViewers = new JCheckBox("Combine header and body viewers");
    private final JCheckBox bCombineRequestAndResponse = new JCheckBox("Combine request and response");
    private final JComboBox cTime;
    private final JComboBox cSpeed;
    private final JRadioButton rSessionNavSequenceHorizontal = new JRadioButton("Tall");
    private final JCheckBox bHideProtobufUnvaluedFields = new JCheckBox("Hide unspecified fields");
    private final JCheckBox bCacheProtobufDescriptors = new JCheckBox("Cache protobuf descriptors");
    private final JTextField fCacheTTL = new JTextField(7);

    public ViewersSettingsPanel() {
        super("Viewers");
        Object object = this.ctx.getConfiguration().getUserInterfaceConfiguration();
        this.bShowLineNumbers.setSelected(((UserInterfaceConfiguration)object).isShowLineNumbers());
        this.bLineWrap.setSelected(((UserInterfaceConfiguration)object).isLineWrap());
        Serializable serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add(this.rSessionNavStructureHorizontal);
        ((ButtonGroup)serializable).add(this.rSessionNavStructureVertical);
        this.rSessionNavStructureHorizontal.setSelected(((UserInterfaceConfiguration)object).getSessionNavStructureLayout() == 0);
        this.rSessionNavStructureVertical.setSelected(((UserInterfaceConfiguration)object).getSessionNavStructureLayout() == 1);
        serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add(this.rSessionNavSequenceHorizontal);
        ((ButtonGroup)serializable).add(this.rSessionNavSequenceVertical);
        this.rSessionNavSequenceHorizontal.setSelected(((UserInterfaceConfiguration)object).getSessionNavSequenceLayout() == 0);
        this.rSessionNavSequenceVertical.setSelected(((UserInterfaceConfiguration)object).getSessionNavSequenceLayout() == 1);
        this.bCombineHeadersAndBodyViewers.setSelected(((UserInterfaceConfiguration)object).isCombineHeadersAndBody());
        this.bCombineRequestAndResponse.setSelected(((UserInterfaceConfiguration)object).isCombineRequestAndResponse());
        this.cSpeed = new JComboBox();
        this.cSpeed.addItem("bytes / second");
        this.cSpeed.addItem("bits / second");
        this.cSpeed.setSelectedIndex(((UserInterfaceConfiguration)object).getUnitsSpeed());
        this.cTime = new JComboBox();
        this.cTime.addItem("seconds");
        this.cTime.addItem("milliseconds");
        this.cTime.setSelectedIndex(((UserInterfaceConfiguration)object).getUnitsTime());
        object = this.ctx.getConfiguration().getProtobufConfiguration();
        this.bHideProtobufUnvaluedFields.setSelected(((ProtobufConfiguration)object).isHideUnvaluedFields());
        this.bCacheProtobufDescriptors.setSelected(((ProtobufConfiguration)object).isCacheDescriptors());
        this.fCacheTTL.setText(String.valueOf(((ProtobufConfiguration)object).getHeuristicTTL() / 1000L));
        this.setLayout(FormUtils.b());
        object = new JPanel((LayoutManager)new MigLayout("wrap,fillx", "[][fill][fill,grow]", "[]u[]"));
        ((JComponent)object).setBorder(FormUtils.a("Layout"));
        ((Container)object).add((Component)this.bCombineHeadersAndBodyViewers, "span");
        ((Container)object).add((Component)this.bCombineRequestAndResponse, "span");
        ((Container)object).add((Component)new JLabel("Structure view:"), "label");
        ((Container)object).add(this.rSessionNavStructureHorizontal);
        ((Container)object).add(this.rSessionNavStructureVertical);
        ((Container)object).add((Component)new JLabel("Sequence view:"), "label");
        ((Container)object).add(this.rSessionNavSequenceHorizontal);
        ((Container)object).add(this.rSessionNavSequenceVertical);
        this.add((Component)object);
        object = new JPanel(FormUtils.b());
        ((JComponent)object).setBorder(FormUtils.a("Text"));
        ((Container)object).add(this.bShowLineNumbers);
        ((Container)object).add(this.bLineWrap);
        this.add((Component)object);
        object = new JPanel((LayoutManager)new MigLayout("wrap,fillx", "[label][fill,grow]"));
        ((JComponent)object).setBorder(FormUtils.a("Display Units"));
        ((Container)object).add(new JLabel("Speed:"));
        ((Container)object).add(this.cSpeed);
        ((Container)object).add(new JLabel("Time:"));
        ((Container)object).add(this.cTime);
        this.add((Component)object);
        object = new JPanel((LayoutManager)new MigLayout("wrap", "[][]"));
        ((JComponent)object).setBorder(FormUtils.a("Protocol Buffers"));
        ((Container)object).add((Component)this.bHideProtobufUnvaluedFields, "span");
        ((Container)object).add((Component)this.bCacheProtobufDescriptors, "span, gaptop u");
        ((Container)object).add((Component)new EnableAwareJLabel("Heuristic cache TTL (seconds):", this.fCacheTTL), "gapleft i");
        ((Container)object).add(this.fCacheTTL);
        JTextField jTextField = this.fCacheTTL;
        JCheckBox jCheckBox = this.bCacheProtobufDescriptors;
        serializable = this;
        ((Component)jTextField).setEnabled(((Component)serializable).isEnabled() && jCheckBox.isSelected());
        jCheckBox.addChangeListener(new M((ViewersSettingsPanel)serializable, jTextField, jCheckBox));
        serializable = new JButton("Clear Cached Resources");
        ((AbstractButton)serializable).addActionListener(new ViewersSettingsPanel$1(this));
        ((Container)object).add((Component)serializable, "span, gaptop u");
        this.add((Component)object);
    }

    private void a(JCheckBox jCheckBox, Component component) {
        component.setEnabled(this.isEnabled() && jCheckBox.isSelected());
        jCheckBox.addChangeListener(new M(this, component, jCheckBox));
    }

    public static void main(String[] stringArray) {
        new ViewersSettingsPanel().test();
    }

    @Override
    public boolean preSave() {
        int n2 = this.prefToInt("Heuristic Cache TTL", this.fCacheTTL.getText());
        if (n2 < 0) {
            throw new SettingsException("Heuristic Cache TTL", "Please enter a non-negative number.");
        }
        return super.preSave();
    }

    @Override
    public boolean save() {
        AbstractConfiguration abstractConfiguration = this.ctx.getConfiguration().getUserInterfaceConfiguration();
        ((UserInterfaceConfiguration)abstractConfiguration).setShowLineNumbers(this.bShowLineNumbers.isSelected());
        ((UserInterfaceConfiguration)abstractConfiguration).setLineWrap(this.bLineWrap.isSelected());
        ((UserInterfaceConfiguration)abstractConfiguration).setSessionNavStructureLayout(this.rSessionNavStructureHorizontal.isSelected() ? 0 : 1);
        ((UserInterfaceConfiguration)abstractConfiguration).setSessionNavSequenceLayout(this.rSessionNavSequenceHorizontal.isSelected() ? 0 : 1);
        ((UserInterfaceConfiguration)abstractConfiguration).setCombineHeadersAndBody(this.bCombineHeadersAndBodyViewers.isSelected());
        ((UserInterfaceConfiguration)abstractConfiguration).setCombineRequestAndResponse(this.bCombineRequestAndResponse.isSelected());
        ((UserInterfaceConfiguration)abstractConfiguration).setUnitsSpeed(this.cSpeed.getSelectedIndex());
        ((UserInterfaceConfiguration)abstractConfiguration).setUnitsTime(this.cTime.getSelectedIndex());
        abstractConfiguration = this.ctx.getConfiguration().getProtobufConfiguration();
        ((ProtobufConfiguration)abstractConfiguration).setHideUnvaluedFields(this.bHideProtobufUnvaluedFields.isSelected());
        ((ProtobufConfiguration)abstractConfiguration).setHeuristicTTL((long)this.prefToIntSafe(this.fCacheTTL.getText()) * 1000L);
        ((ProtobufConfiguration)abstractConfiguration).setCacheDescriptors(this.bCacheProtobufDescriptors.isSelected());
        return true;
    }
}

