/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.gui.settings;

import com.xk72.charles.config.UserInterfaceConfiguration;
import com.xk72.charles.gui.settings.SettingsPanel;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;

public class SequenceSettingsPanel
extends SettingsPanel {
    private final JCheckBox autoScroll = new JCheckBox("Auto scroll");
    private final JCheckBox filterRegex = new JCheckBox("Filter uses regex");
    private final JTextField maxTransactions = new JTextField(5);

    public SequenceSettingsPanel() {
        super("Sequence");
        UserInterfaceConfiguration userInterfaceConfiguration = this.ctx.getConfiguration().getUserInterfaceConfiguration();
        this.autoScroll.setSelected(userInterfaceConfiguration.isAutoScroll());
        this.filterRegex.setSelected(userInterfaceConfiguration.getBooleanProperty("sequence.filterRegex", false));
        int n2 = userInterfaceConfiguration.getIntProperty("sequence.maxTransactions", 0);
        this.maxTransactions.setText(n2 > 0 ? "" + n2 : "");
        try {
            Class.forName("java.util.regex.Pattern");
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.filterRegex.setEnabled(false);
            this.filterRegex.setSelected(false);
        }
        this.setLayout((LayoutManager)new MigLayout("wrap,fill", "[][fill,grow]"));
        this.add((Component)this.autoScroll, "span");
        this.add((Component)this.filterRegex, "span");
        this.add((Component)new JLabel("Max rows:"), "label");
        this.add(this.maxTransactions);
    }

    @Override
    public boolean save() {
        UserInterfaceConfiguration userInterfaceConfiguration = this.ctx.getConfiguration().getUserInterfaceConfiguration();
        userInterfaceConfiguration.setAutoScroll(this.autoScroll.isSelected());
        userInterfaceConfiguration.setBooleanProperty("sequence.filterRegex", this.filterRegex.isSelected());
        if (this.maxTransactions.getText().length() > 0) {
            try {
                userInterfaceConfiguration.setIntProperty("sequence.maxTransactions", Integer.parseInt(this.maxTransactions.getText()));
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            userInterfaceConfiguration.setIntProperty("sequence.maxTransactions", 0);
        }
        return true;
    }
}

