/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.gui.settings;

import com.xk72.charles.CharlesContext;
import com.xk72.charles.config.RecordingConfiguration;
import com.xk72.charles.gui.lib.EnableAwareJLabel;
import com.xk72.charles.gui.lib.ExtendedJOptionPane;
import com.xk72.charles.gui.lib.FormUtils;
import com.xk72.charles.gui.settings.RecordingSettingsPanel;
import com.xk72.charles.gui.settings.RecordingSettingsPanel$AbstractRecordingSettingsPanel;
import com.xk72.charles.gui.settings.SettingsException;
import com.xk72.charles.gui.settings.s;
import com.xk72.charles.gui.settings.t;
import com.xk72.charles.gui.settings.u;
import com.xk72.charles.gui.settings.v;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;

class RecordingSettingsPanel$LimitsPanel
extends RecordingSettingsPanel$AbstractRecordingSettingsPanel {
    private static final String a = "recording.limit.transactions";
    private static final String b = "recording.limit.messages";
    private final JCheckBox cbLimit;
    private boolean initialLimit;
    private final JCheckBox cbLimitMessages;
    private boolean initialLimitMessages;
    private final JTextField fLimit;
    private final JTextField fMaxTransactions;
    private final JTextField fMaxMessages;
    final /* synthetic */ RecordingSettingsPanel this$0;

    public RecordingSettingsPanel$LimitsPanel(RecordingSettingsPanel object) {
        this.this$0 = object;
        super((RecordingSettingsPanel)object, CharlesContext.getInstance().getBundle().getString("settings.recording.limits.name"));
        this.cbLimit = new JCheckBox("Limit recording history");
        this.initialLimit = false;
        this.cbLimitMessages = new JCheckBox("Limit WebSocket transaction history");
        this.initialLimitMessages = false;
        this.fLimit = new JTextField(4);
        this.fMaxTransactions = new JTextField(4);
        this.fMaxMessages = new JTextField(4);
        this.setHelp(CharlesContext.getInstance().getBundle().getString("settings.recording.limits.help"));
        this.cbLimit.addItemListener(new s(this, (RecordingSettingsPanel)object));
        this.fMaxTransactions.setEnabled(this.cbLimit.isSelected());
        this.cbLimitMessages.addItemListener(new t(this, (RecordingSettingsPanel)object));
        this.fMaxMessages.setEnabled(this.cbLimitMessages.isSelected());
        this.setLayout(FormUtils.e());
        object = new JPanel((LayoutManager)new MigLayout("wrap,fill", "[label][fill,grow]"));
        ((JComponent)object).setBorder(new TitledBorder("Recording Limits"));
        ((Container)object).add(new JLabel("Recording size limit (MB):"));
        ((Container)object).add(this.fLimit);
        ((Container)object).add((Component)this.cbLimit, "span,align left");
        ((Container)object).add(new EnableAwareJLabel("Max requests:", this.fMaxTransactions));
        ((Container)object).add(this.fMaxTransactions);
        ((Container)object).add((Component)this.cbLimitMessages, "span,align left");
        ((Container)object).add(new EnableAwareJLabel("Max messages:", this.fMaxMessages));
        ((Container)object).add(this.fMaxMessages);
        this.add((Component)object, "pushy 0");
    }

    @Override
    public boolean preSave() {
        int n2;
        if (this.cbLimit.isSelected()) {
            if (this.fMaxTransactions.getText().length() > 0) {
                n2 = this.prefToInt("Max Requests", this.fMaxTransactions.getText());
                if (n2 <= 0) {
                    throw new SettingsException("Max Requests", "Value must be greater than 0.");
                }
                if (!this.initialLimit && !CharlesContext.getInstance().getConfiguration().getUserInterfaceConfiguration().alreadyWarned(a)) {
                    ExtendedJOptionPane.a((Component)this, (Object)"A recording limit means that old requests will automatically be cleared from the session when the limit is reached. Please ensure that the limit is set high enough so that you do not unexpectedly lose data.", "Recording Limits", 1, new u(this));
                }
            } else {
                throw new SettingsException("Max Requests", "Value must be greater than 0.");
            }
        }
        this.prefToInt("Recording Size Limit", this.fLimit.getText());
        if (this.cbLimitMessages.isSelected()) {
            if (this.fMaxMessages.getText().length() > 0) {
                n2 = this.prefToInt("Max WebSocket Messages", this.fMaxMessages.getText());
                if (n2 < 0) {
                    throw new SettingsException("Max WebSocket Messages", "Value must be greater than or equal to 0.");
                }
                if (!this.initialLimitMessages && !CharlesContext.getInstance().getConfiguration().getUserInterfaceConfiguration().alreadyWarned(b)) {
                    ExtendedJOptionPane.a((Component)this, (Object)"A WebSocket transaction limit means that old WebSocket messages will automatically be cleared from the transaction when the limit is reached. Please ensure that the limit is set high enough so that you do not unexpectedly lose data.", "Recording Limits", 1, new v(this));
                }
            } else {
                throw new SettingsException("Max WebSocket Messages", "Value must be greater than or equal to 0.");
            }
        }
        return true;
    }

    @Override
    protected void getPanelConfiguration(RecordingConfiguration recordingConfiguration) {
        recordingConfiguration.setLimit(this.prefToIntSafe(this.fLimit.getText()));
        if (this.cbLimit.isSelected() && this.fMaxTransactions.getText().length() > 0) {
            int n2 = this.prefToIntSafe(this.fMaxTransactions.getText());
            recordingConfiguration.setMaxTransactions(n2);
        } else {
            recordingConfiguration.setMaxTransactions(0);
        }
        if (this.cbLimitMessages.isSelected() && this.fMaxMessages.getText().length() > 0) {
            recordingConfiguration.setMaxWebSocketMessages(this.prefToIntSafe(this.fMaxMessages.getText()));
            return;
        }
        recordingConfiguration.setMaxWebSocketMessages(-1);
    }

    @Override
    protected void setPanelConfiguration(RecordingConfiguration recordingConfiguration) {
        this.initialLimitMessages = recordingConfiguration.getMaxWebSocketMessages() >= 0;
        this.cbLimitMessages.setSelected(this.initialLimitMessages);
        this.fMaxMessages.setText(this.initialLimitMessages ? String.valueOf(recordingConfiguration.getMaxWebSocketMessages()) : "");
        this.fLimit.setText(String.valueOf(recordingConfiguration.getLimit()));
        this.initialLimit = recordingConfiguration.getMaxTransactions() > 0;
        this.cbLimit.setSelected(this.initialLimit);
        this.fMaxTransactions.setText(this.initialLimit ? String.valueOf(recordingConfiguration.getMaxTransactions()) : "");
    }

    static /* synthetic */ JCheckBox a(RecordingSettingsPanel$LimitsPanel recordingSettingsPanel$LimitsPanel) {
        return recordingSettingsPanel$LimitsPanel.cbLimit;
    }

    static /* synthetic */ JTextField b(RecordingSettingsPanel$LimitsPanel recordingSettingsPanel$LimitsPanel) {
        return recordingSettingsPanel$LimitsPanel.fMaxTransactions;
    }

    static /* synthetic */ JCheckBox c(RecordingSettingsPanel$LimitsPanel recordingSettingsPanel$LimitsPanel) {
        return recordingSettingsPanel$LimitsPanel.cbLimitMessages;
    }

    static /* synthetic */ JTextField d(RecordingSettingsPanel$LimitsPanel recordingSettingsPanel$LimitsPanel) {
        return recordingSettingsPanel$LimitsPanel.fMaxMessages;
    }
}

