/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.gui.lib;

import com.xk72.charles.gui.lib.F;
import com.xk72.charles.gui.lib.TableMap;
import com.xk72.charles.gui.lib.ao;
import com.xk72.charles.gui.lib.ap;
import java.awt.event.MouseListener;
import java.util.Date;
import java.util.EventListener;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableModel;

public class TableSorter
extends TableMap {
    private static final Logger a = Logger.getLogger("com.xk72.charles.gui.lib.TableSorter");
    private int[] indexes;
    private final Vector<Integer> sortingColumns = new Vector();
    private boolean ascending = true;
    private int compares;

    public TableSorter() {
        this.indexes = new int[0];
    }

    public TableSorter(TableModel tableModel) {
        this.setModel(tableModel);
    }

    @Override
    public void setModel(TableModel tableModel) {
        super.setModel(tableModel);
        this.reallocateIndexes();
    }

    public int compareRowsByColumn(int n2, int n3, int n4) {
        String string;
        Object object;
        Object object2;
        Object object3;
        Object object4 = this.model;
        if (object4 instanceof ap) {
            object3 = ((ap)object4).getComparableValueAt(n2, n4);
            object2 = ((ap)object4).getComparableValueAt(n3, n4);
            object = ((ap)object4).getComparableColumnClass(n4);
        } else {
            object3 = object4.getValueAt(n2, n4);
            object2 = object4.getValueAt(n3, n4);
            object = object4.getColumnClass(n4);
        }
        if (object3 == null && object2 == null) {
            return 0;
        }
        if (object3 == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        if (((Class)object).getSuperclass() == Number.class) {
            double d2;
            object = (Number)object3;
            double d3 = ((Number)object).doubleValue();
            if (d3 < (d2 = ((Number)(object = (Number)object2)).doubleValue())) {
                return -1;
            }
            if (d3 > d2) {
                return 1;
            }
            return 0;
        }
        if (object == Date.class) {
            long l2;
            object = (Date)object3;
            long l3 = ((Date)object).getTime();
            if (l3 < (l2 = ((Date)(object = (Date)object2)).getTime())) {
                return -1;
            }
            if (l3 > l2) {
                return 1;
            }
            return 0;
        }
        if (object == String.class) {
            object = (String)object3;
            String string2 = (String)object2;
            object4 = string2;
            Object object5 = object;
            object2 = this;
            object2 = TableSorter.a((String)object5);
            int n5 = object2 != null && (object5 = TableSorter.a((String)object4)) != null ? ((Double)object2).compareTo((Double)object5) : 0;
            if (n5 == 0) {
                n5 = ((String)object).compareTo(string2);
            }
            if (n5 < 0) {
                return -1;
            }
            if (n5 > 0) {
                return 1;
            }
            return 0;
        }
        if (object == Boolean.class) {
            Boolean bl;
            boolean bl2;
            object = (Boolean)object3;
            boolean bl3 = (Boolean)object;
            if (bl3 == (bl2 = (bl = (Boolean)object2).booleanValue())) {
                return 0;
            }
            if (bl3) {
                return 1;
            }
            return -1;
        }
        object = object3.toString();
        int n6 = ((String)object).compareTo(string = object2.toString());
        if (n6 < 0) {
            return -1;
        }
        if (n6 > 0) {
            return 1;
        }
        return 0;
    }

    private int a(String object, String object2) {
        if ((object = TableSorter.a((String)object)) != null && (object2 = TableSorter.a((String)object2)) != null) {
            return ((Double)object).compareTo((Double)object2);
        }
        return 0;
    }

    private static Double a(String string) {
        int n2 = string.length();
        while (n2 > 0) {
            try {
                return Double.parseDouble(string.substring(0, n2));
            }
            catch (NumberFormatException numberFormatException) {
                --n2;
            }
        }
        return null;
    }

    public int compare(int n2, int n3) {
        ++this.compares;
        for (int i2 = 0; i2 < this.sortingColumns.size(); ++i2) {
            Integer n4 = this.sortingColumns.elementAt(i2);
            int n5 = this.compareRowsByColumn(n2, n3, n4);
            if (n5 == 0) continue;
            if (this.ascending) {
                return n5;
            }
            return -n5;
        }
        return 0;
    }

    public void reallocateIndexes() {
        int n2 = this.model.getRowCount();
        this.indexes = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.indexes[i2] = i2;
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (a.isLoggable(Level.FINER)) {
            a.finer("Sorter: tableChanged");
        }
        this.reallocateIndexes();
        super.tableChanged(tableModelEvent);
    }

    public void checkModel() {
        if (this.indexes.length != this.model.getRowCount() && a.isLoggable(Level.WARNING)) {
            a.warning("Sorter not informed of a change in model.");
        }
    }

    public void sort(Object object) {
        this.checkModel();
        this.compares = 0;
        int n2 = this.indexes.length;
        if (this.model instanceof F) {
            n2 -= ((F)this.model).getFooterRows();
        }
        this.shuttlesort((int[])this.indexes.clone(), this.indexes, 0, n2);
        if (a.isLoggable(Level.FINER)) {
            a.finer("Compares: " + this.compares);
        }
    }

    public void n2sort() {
        for (int i2 = 0; i2 < this.getRowCount(); ++i2) {
            for (int i3 = i2 + 1; i3 < this.getRowCount(); ++i3) {
                if (this.compare(this.indexes[i2], this.indexes[i3]) != -1) continue;
                this.swap(i2, i3);
            }
        }
    }

    public void shuttlesort(int[] nArray, int[] nArray2, int n2, int n3) {
        if (n3 - n2 < 2) {
            return;
        }
        int n4 = (n2 + n3) / 2;
        this.shuttlesort(nArray2, nArray, n2, n4);
        this.shuttlesort(nArray2, nArray, n4, n3);
        int n5 = n2;
        int n6 = n4;
        if (n3 - n2 >= 4 && this.compare(nArray[n4 - 1], nArray[n4]) <= 0) {
            while (n2 < n3) {
                nArray2[n2] = nArray[n2];
                ++n2;
            }
            return;
        }
        while (n2 < n3) {
            nArray2[n2] = n6 >= n3 || n5 < n4 && this.compare(nArray[n5], nArray[n6]) <= 0 ? nArray[n5++] : nArray[n6++];
            ++n2;
        }
    }

    public void swap(int n2, int n3) {
        int n4 = this.indexes[n2];
        this.indexes[n2] = this.indexes[n3];
        this.indexes[n3] = n4;
    }

    @Override
    public Object getValueAt(int n2, int n3) {
        this.checkModel();
        if (n2 < this.indexes.length) {
            return this.model.getValueAt(this.indexes[n2], n3);
        }
        return null;
    }

    @Override
    public void setValueAt(Object object, int n2, int n3) {
        this.checkModel();
        if (n2 < this.indexes.length) {
            this.model.setValueAt(object, this.indexes[n2], n3);
        }
    }

    public void sortByColumn(int n2) {
        this.sortByColumn(n2, true);
    }

    public void sortByColumn(int n2, boolean bl) {
        this.ascending = bl;
        this.sortingColumns.removeAllElements();
        this.sortingColumns.addElement(new Integer(n2));
        this.sort(this);
        super.tableChanged(new TableModelEvent(this));
    }

    public void addMouseListenerToHeaderInTable(JTable jComponent) {
        EventListener eventListener = this;
        jComponent.setColumnSelectionAllowed(false);
        eventListener = new ao(this, (JTable)jComponent, (TableSorter)eventListener);
        jComponent = jComponent.getTableHeader();
        jComponent.addMouseListener((MouseListener)eventListener);
    }
}

