/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.gui.lib;

import com.xk72.charles.gui.lib.V;
import com.xk72.charles.gui.lib.v;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public abstract class AbstractRowsTableModel<T>
extends AbstractTableModel
implements V<T>,
v {
    protected boolean dirty;
    protected List<T> rows;

    public AbstractRowsTableModel() {
        this(new ArrayList());
    }

    public AbstractRowsTableModel(List<T> list) {
        this.rows = list;
    }

    @Override
    public final int getRowCount() {
        return this.rows.size();
    }

    @Override
    public abstract T newRow();

    @Override
    public final int addRow(T t2) {
        this.rows.add(t2);
        this.setDirty();
        this.fireTableRowsInserted(this.rows.size() - 1, this.rows.size() - 1);
        return this.rows.size() - 1;
    }

    @Override
    public boolean isRemovable(int n2) {
        return true;
    }

    @Override
    public final void removeRows(int[] nArray, int[] nArray2) {
        Arrays.sort(nArray2);
        for (int i2 = nArray2.length - 1; i2 >= 0; --i2) {
            int n2 = nArray2[i2];
            if (n2 < 0 || n2 >= this.rows.size()) continue;
            this.rows.remove(n2);
            this.setDirty();
            this.fireTableRowsDeleted(n2, n2);
        }
    }

    public final void removeRow(int n2) {
        this.rows.remove(n2);
        this.setDirty();
        this.fireTableRowsDeleted(n2, n2);
    }

    @Override
    public final List<T> getRows() {
        return this.rows;
    }

    @Override
    public final void setRows(List<T> list) {
        this.rows = list;
        this.setDirty();
        this.fireTableDataChanged();
    }

    @Override
    public final T getRowAt(int n2) {
        if (n2 < this.rows.size()) {
            return this.rows.get(n2);
        }
        return null;
    }

    @Override
    public void setRowAt(int n2, T t2) {
        if (n2 < this.rows.size()) {
            this.rows.set(n2, t2);
            this.setDirty();
            this.fireTableRowsUpdated(n2, n2);
        }
    }

    @Override
    public int[] moveRows(int[] nArray, int n2) {
        Arrays.sort(nArray);
        if (n2 < 0) {
            int n3;
            int n4;
            for (int i2 = 0; i2 < nArray.length && (n4 = Math.max((n3 = nArray[i2]) + n2, 0)) != n3; ++i2) {
                this.rows.add(n4, this.rows.remove(n3));
                nArray[i2] = n4;
            }
        } else {
            int n5;
            int n6;
            for (int i3 = nArray.length - 1; i3 >= 0 && (n6 = Math.min((n5 = nArray[i3]) + n2, this.rows.size() - 1)) != n5; --i3) {
                this.rows.add(n6, this.rows.remove(n5));
                nArray[i3] = n6;
            }
        }
        this.setDirty();
        this.fireTableDataChanged();
        return nArray;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    @Override
    public void setDirty() {
        this.setDirty(true);
    }
}

