/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.config;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.xk72.charles.config.AbstractConfiguration;
import com.xk72.util.q;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;

@XStreamAlias(value="gist")
public class GistIntegrationConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = Logger.getLogger("com.xk72.charles.config.GistIntegrationConfiguration");
    private static final int DEFAULT_MAX_PUBLISH_SIZE = 10;
    private int publishLimit = 10;
    private boolean secret = true;
    private transient String authToken = null;
    private String encryptedAuthToken = null;
    private boolean openGist = true;
    private boolean enterpriseGitHub = false;
    private String enterpriseURL = null;
    private transient URI enterpriseURI = null;

    public int getPublishLimit() {
        return this.publishLimit;
    }

    public void setPublishLimit(int n2) {
        this.publishLimit = n2;
    }

    public boolean isSecret() {
        return this.secret;
    }

    public void setSecret(boolean bl) {
        this.secret = bl;
    }

    public synchronized String getAuthToken() {
        if (this.encryptedAuthToken == null) {
            return null;
        }
        if (this.authToken == null) {
            try {
                this.authToken = q.b(this.encryptedAuthToken);
            }
            catch (RuntimeException runtimeException) {
                LOG.log(Level.WARNING, "Error decrypting saved OAuth token", runtimeException);
                this.authToken = null;
                this.encryptedAuthToken = null;
            }
        }
        return this.authToken;
    }

    public synchronized void setAuthToken(String string) {
        this.encryptedAuthToken = q.a(string);
        this.authToken = string;
    }

    public boolean isOpenGist() {
        return this.openGist;
    }

    public void setOpenGist(boolean bl) {
        this.openGist = bl;
    }

    public boolean isEnterpriseGitHub() {
        return this.enterpriseGitHub;
    }

    public void setEnterpriseGitHub(boolean bl) {
        this.enterpriseGitHub = bl;
    }

    public String getEnterpriseURL() {
        return this.enterpriseURL;
    }

    public void setEnterpriseURL(String string) {
        this.enterpriseURL = string;
        this.enterpriseURI = null;
    }

    public URI getEnterpriseURI() {
        if (this.enterpriseURL == null) {
            return null;
        }
        if (this.enterpriseURI == null) {
            try {
                this.enterpriseURI = GistIntegrationConfiguration.parseURL(this.enterpriseURL);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new RuntimeException(uRISyntaxException);
            }
        }
        return this.enterpriseURI;
    }

    public static URI parseURL(String string) {
        if (string.indexOf(58) >= 0 || string.indexOf(47) >= 0) {
            return new URI(string);
        }
        return new URI(null, string, null, null);
    }
}

